/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.EmptyByteBuf;
import io.netty.buffer.FixedCompositeByteBuf;
import io.netty.buffer.ReadOnlyByteBuf;
import io.netty.buffer.ReadOnlyByteBufferBuf;
import io.netty.buffer.ReadOnlyUnsafeDirectByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.buffer.UnpooledDirectByteBuf;
import io.netty.buffer.UnpooledHeapByteBuf;
import io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import io.netty.buffer.UnreleasableByteBuf;
import io.netty.buffer.WrappedUnpooledUnsafeDirectByteBuf;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

public final class Unpooled {
    private static final ByteBufAllocator ALLOC = UnpooledByteBufAllocator.DEFAULT;
    public static final ByteOrder BIG_ENDIAN = ByteOrder.BIG_ENDIAN;
    public static final ByteOrder LITTLE_ENDIAN = ByteOrder.LITTLE_ENDIAN;
    public static final ByteBuf EMPTY_BUFFER = ALLOC.buffer(0, 0);

    public static ByteBuf buffer() {
        return ALLOC.heapBuffer();
    }

    public static ByteBuf directBuffer() {
        return ALLOC.directBuffer();
    }

    public static ByteBuf buffer(int initialCapacity) {
        int n;
        return ALLOC.heapBuffer(n);
    }

    public static ByteBuf directBuffer(int initialCapacity) {
        int n;
        return ALLOC.directBuffer(n);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf buffer(int initialCapacity, int maxCapacity) {
        void var1_1;
        int n;
        return ALLOC.heapBuffer(n, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf directBuffer(int initialCapacity, int maxCapacity) {
        void var1_1;
        int n;
        return ALLOC.directBuffer(n, (int)var1_1);
    }

    public static ByteBuf wrappedBuffer(byte[] array) {
        byte[] byArray;
        if (array.length == 0) {
            return EMPTY_BUFFER;
        }
        return new UnpooledHeapByteBuf(ALLOC, byArray, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf wrappedBuffer(byte[] array, int offset, int length) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        if (length == 0) {
            return EMPTY_BUFFER;
        }
        if (offset == 0 && length == array.length) {
            return Unpooled.wrappedBuffer(array);
        }
        return Unpooled.wrappedBuffer(byArray).slice((int)var1_1, (int)var2_2);
    }

    public static ByteBuf wrappedBuffer(ByteBuffer buffer) {
        ByteBuffer byteBuffer;
        if (!buffer.hasRemaining()) {
            return EMPTY_BUFFER;
        }
        if (!buffer.isDirect() && buffer.hasArray()) {
            return Unpooled.wrappedBuffer(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining()).order(buffer.order());
        }
        if (PlatformDependent.hasUnsafe()) {
            if (buffer.isReadOnly()) {
                if (buffer.isDirect()) {
                    return new ReadOnlyUnsafeDirectByteBuf(ALLOC, buffer);
                }
                return new ReadOnlyByteBufferBuf(ALLOC, buffer);
            }
            ByteBuffer byteBuffer2 = buffer;
            return new UnpooledUnsafeDirectByteBuf(ALLOC, byteBuffer2, byteBuffer2.remaining());
        }
        if (buffer.isReadOnly()) {
            return new ReadOnlyByteBufferBuf(ALLOC, buffer);
        }
        ByteBuffer byteBuffer3 = byteBuffer;
        return new UnpooledDirectByteBuf(ALLOC, byteBuffer3, byteBuffer3.remaining());
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf wrappedBuffer(long memoryAddress, int size, boolean doFree) {
        void var3_2;
        void var2_1;
        long l;
        return new WrappedUnpooledUnsafeDirectByteBuf(ALLOC, l, (int)var2_1, (boolean)var3_2);
    }

    public static ByteBuf wrappedBuffer(ByteBuf buffer) {
        ByteBuf byteBuf;
        if (buffer.isReadable()) {
            return buffer.slice();
        }
        byteBuf.release();
        return EMPTY_BUFFER;
    }

    public static ByteBuf wrappedBuffer(byte[] ... arrays) {
        byte[][] byArray;
        return Unpooled.wrappedBuffer(arrays.length, byArray);
    }

    public static ByteBuf wrappedBuffer(ByteBuf ... buffers) {
        ByteBuf[] byteBufArray;
        return Unpooled.wrappedBuffer(buffers.length, byteBufArray);
    }

    public static ByteBuf wrappedBuffer(ByteBuffer ... buffers) {
        ByteBuffer[] byteBufferArray;
        return Unpooled.wrappedBuffer(buffers.length, byteBufferArray);
    }

    static <T> ByteBuf wrappedBuffer(int maxNumComponents, CompositeByteBuf.ByteWrapper<T> wrapper, T[] array) {
        switch (array.length) {
            case 0: {
                break;
            }
            case 1: {
                if (wrapper.isEmpty(array[0])) break;
                return wrapper.wrap(array[0]);
            }
            default: {
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    T bytes = array[i];
                    if (bytes == null) {
                        return EMPTY_BUFFER;
                    }
                    if (wrapper.isEmpty(bytes)) continue;
                    return new CompositeByteBuf(ALLOC, false, maxNumComponents, wrapper, array, i);
                }
            }
        }
        return EMPTY_BUFFER;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf wrappedBuffer(int maxNumComponents, byte[] ... arrays) {
        void var1_1;
        return Unpooled.wrappedBuffer(maxNumComponents, CompositeByteBuf.BYTE_ARRAY_WRAPPER, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf wrappedBuffer(int maxNumComponents, ByteBuf ... buffers) {
        switch (buffers.length) {
            case 0: {
                break;
            }
            case 1: {
                void var0_1;
                ByteBuf buffer = buffers[0];
                if (buffer.isReadable()) {
                    return Unpooled.wrappedBuffer(buffer.order(BIG_ENDIAN));
                }
                var0_1.release();
                break;
            }
            default: {
                for (int i = 0; i < buffers.length; ++i) {
                    void var3_4;
                    ByteBuf buf = buffers[i];
                    if (buf.isReadable()) {
                        int n;
                        return new CompositeByteBuf(ALLOC, false, n, buffers, i);
                    }
                    var3_4.release();
                }
            }
        }
        return EMPTY_BUFFER;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf wrappedBuffer(int maxNumComponents, ByteBuffer ... buffers) {
        void var1_1;
        return Unpooled.wrappedBuffer(maxNumComponents, CompositeByteBuf.BYTE_BUFFER_WRAPPER, var1_1);
    }

    public static CompositeByteBuf compositeBuffer() {
        return Unpooled.compositeBuffer(16);
    }

    public static CompositeByteBuf compositeBuffer(int maxNumComponents) {
        int n;
        return new CompositeByteBuf(ALLOC, false, n);
    }

    public static ByteBuf copiedBuffer(byte[] array) {
        byte[] byArray;
        if (array.length == 0) {
            return EMPTY_BUFFER;
        }
        return Unpooled.wrappedBuffer((byte[])byArray.clone());
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf copiedBuffer(byte[] array, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        byte[] byArray;
        if (length == 0) {
            return EMPTY_BUFFER;
        }
        byte[] copy = PlatformDependent.allocateUninitializedArray((int)length);
        System.arraycopy(byArray, (int)var1_1, copy, 0, (int)var2_2);
        return Unpooled.wrappedBuffer((byte[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf copiedBuffer(ByteBuffer buffer) {
        ByteBuffer byteBuffer;
        void var1_2;
        int length = buffer.remaining();
        if (length == 0) {
            return EMPTY_BUFFER;
        }
        byte[] copy = PlatformDependent.allocateUninitializedArray((int)length);
        ByteBuffer duplicate = buffer.duplicate();
        duplicate.get(copy);
        return Unpooled.wrappedBuffer((byte[])var1_2).order(byteBuffer.order());
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf copiedBuffer(ByteBuf buffer) {
        int readable = buffer.readableBytes();
        if (readable > 0) {
            void var2_2;
            void var1_1;
            ByteBuf byteBuf;
            ByteBuf copy = Unpooled.buffer(readable);
            ByteBuf byteBuf2 = byteBuf;
            copy.writeBytes(byteBuf2, byteBuf2.readerIndex(), (int)var1_1);
            return var2_2;
        }
        return EMPTY_BUFFER;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf copiedBuffer(byte[] ... arrays) {
        void var1_1;
        byte[] a;
        switch (arrays.length) {
            case 0: {
                return EMPTY_BUFFER;
            }
            case 1: {
                if (arrays[0].length == 0) {
                    return EMPTY_BUFFER;
                }
                return Unpooled.copiedBuffer(arrays[0]);
            }
        }
        int length = 0;
        byte[][] byArray = arrays;
        int n = arrays.length;
        for (int i = 0; i < n; ++i) {
            a = byArray[i];
            if (Integer.MAX_VALUE - length < a.length) {
                throw new IllegalArgumentException("The total length of the specified arrays is too big.");
            }
            length += a.length;
        }
        if (length == 0) {
            return EMPTY_BUFFER;
        }
        byte[] mergedArray = PlatformDependent.allocateUninitializedArray((int)var1_1);
        int j = 0;
        for (int i = 0; i < arrays.length; ++i) {
            a = arrays[i];
            System.arraycopy(a, 0, mergedArray, j, a.length);
            j += a.length;
        }
        return Unpooled.wrappedBuffer((byte[])byArray);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf copiedBuffer(ByteBuf ... buffers) {
        void var1_1;
        void var2_2;
        int bLen;
        ByteBuf b;
        switch (buffers.length) {
            case 0: {
                return EMPTY_BUFFER;
            }
            case 1: {
                return Unpooled.copiedBuffer(buffers[0]);
            }
        }
        ByteOrder order = null;
        int length = 0;
        ByteBuf[] byteBufArray = buffers;
        int n = buffers.length;
        for (int i = 0; i < n; ++i) {
            b = byteBufArray[i];
            bLen = b.readableBytes();
            if (bLen <= 0) continue;
            if (Integer.MAX_VALUE - length < bLen) {
                throw new IllegalArgumentException("The total length of the specified buffers is too big.");
            }
            length += bLen;
            if (order != null) {
                if (order.equals(b.order())) continue;
                throw new IllegalArgumentException("inconsistent byte order");
            }
            order = b.order();
        }
        if (length == 0) {
            return EMPTY_BUFFER;
        }
        byte[] mergedArray = PlatformDependent.allocateUninitializedArray((int)var2_2);
        int j = 0;
        for (int i = 0; i < buffers.length; ++i) {
            b = buffers[i];
            bLen = b.readableBytes();
            ByteBuf byteBuf = b;
            byteBuf.getBytes(byteBuf.readerIndex(), mergedArray, j, bLen);
            j += bLen;
        }
        return Unpooled.wrappedBuffer((byte[])byteBufArray).order((ByteOrder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf copiedBuffer(ByteBuffer ... buffers) {
        void var1_1;
        void var2_2;
        int bLen;
        ByteBuffer b;
        switch (buffers.length) {
            case 0: {
                return EMPTY_BUFFER;
            }
            case 1: {
                return Unpooled.copiedBuffer(buffers[0]);
            }
        }
        ByteOrder order = null;
        int length = 0;
        ByteBuffer[] byteBufferArray = buffers;
        int n = buffers.length;
        for (int i = 0; i < n; ++i) {
            b = byteBufferArray[i];
            bLen = b.remaining();
            if (bLen <= 0) continue;
            if (Integer.MAX_VALUE - length < bLen) {
                throw new IllegalArgumentException("The total length of the specified buffers is too big.");
            }
            length += bLen;
            if (order != null) {
                if (order.equals(b.order())) continue;
                throw new IllegalArgumentException("inconsistent byte order");
            }
            order = b.order();
        }
        if (length == 0) {
            return EMPTY_BUFFER;
        }
        byte[] mergedArray = PlatformDependent.allocateUninitializedArray((int)var2_2);
        int j = 0;
        for (int i = 0; i < buffers.length; ++i) {
            b = buffers[i].duplicate();
            bLen = b.remaining();
            b.get(mergedArray, j, bLen);
            j += bLen;
        }
        return Unpooled.wrappedBuffer((byte[])byteBufferArray).order((ByteOrder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf copiedBuffer(CharSequence string, Charset charset) {
        void var1_1;
        CharSequence charSequence;
        ObjectUtil.checkNotNull((Object)string, (String)"string");
        if (CharsetUtil.UTF_8.equals(charset)) {
            return Unpooled.copiedBufferUtf8(string);
        }
        if (CharsetUtil.US_ASCII.equals(charset)) {
            return Unpooled.copiedBufferAscii(string);
        }
        if (string instanceof CharBuffer) {
            return Unpooled.copiedBuffer((CharBuffer)string, charset);
        }
        return Unpooled.copiedBuffer(CharBuffer.wrap(charSequence), (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static ByteBuf copiedBufferUtf8(CharSequence string) {
        boolean release = true;
        ByteBuf buffer = ALLOC.heapBuffer(ByteBufUtil.utf8Bytes(string));
        try {
            ByteBuf byteBuf;
            ByteBufUtil.writeUtf8(buffer, (CharSequence)((Object)byteBuf));
            release = false;
            byteBuf = buffer;
            return byteBuf;
        }
        catch (Throwable throwable) {
            void var1_2;
            if (var1_2 != false) {
                void var2_3;
                var2_3.release();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static ByteBuf copiedBufferAscii(CharSequence string) {
        boolean release = true;
        ByteBuf buffer = ALLOC.heapBuffer(string.length());
        try {
            ByteBuf byteBuf;
            ByteBufUtil.writeAscii(buffer, (CharSequence)((Object)byteBuf));
            release = false;
            byteBuf = buffer;
            return byteBuf;
        }
        catch (Throwable throwable) {
            void var1_2;
            if (var1_2 != false) {
                void var2_3;
                var2_3.release();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf copiedBuffer(CharSequence string, int offset, int length, Charset charset) {
        void var3_3;
        void var2_2;
        void var1_1;
        CharSequence charSequence;
        ObjectUtil.checkNotNull((Object)string, (String)"string");
        if (length == 0) {
            return EMPTY_BUFFER;
        }
        if (string instanceof CharBuffer) {
            CharSequence buf = (CharBuffer)string;
            if (((CharBuffer)buf).hasArray()) {
                return Unpooled.copiedBuffer(((CharBuffer)buf).array(), ((CharBuffer)buf).arrayOffset() + ((Buffer)((Object)buf)).position() + offset, length, charset);
            }
            buf = ((CharBuffer)buf).slice();
            ((CharBuffer)buf).limit(length);
            ((CharBuffer)buf).position(offset);
            return Unpooled.copiedBuffer((CharBuffer)charSequence, charset);
        }
        void v0 = var1_1;
        return Unpooled.copiedBuffer(CharBuffer.wrap(charSequence, (int)v0, (int)(v0 + var2_2)), (Charset)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf copiedBuffer(char[] array, Charset charset) {
        void var1_1;
        char[] cArray;
        ObjectUtil.checkNotNull((Object)array, (String)"array");
        return Unpooled.copiedBuffer(array, 0, cArray.length, (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf copiedBuffer(char[] array, int offset, int length, Charset charset) {
        void var3_3;
        void var2_2;
        void var1_1;
        char[] cArray;
        ObjectUtil.checkNotNull((Object)array, (String)"array");
        if (length == 0) {
            return EMPTY_BUFFER;
        }
        return Unpooled.copiedBuffer(CharBuffer.wrap(cArray, (int)var1_1, (int)var2_2), (Charset)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static ByteBuf copiedBuffer(CharBuffer buffer, Charset charset) {
        void var1_1;
        CharBuffer charBuffer;
        return ByteBufUtil.encodeString0(ALLOC, true, charBuffer, (Charset)var1_1, 0);
    }

    @Deprecated
    public static ByteBuf unmodifiableBuffer(ByteBuf buffer) {
        ByteBuf byteBuf;
        ByteOrder byteOrder = buffer.order();
        if (byteOrder == BIG_ENDIAN) {
            return new ReadOnlyByteBuf(buffer);
        }
        return ((ByteBuf)new ReadOnlyByteBuf(byteBuf.order(BIG_ENDIAN))).order(LITTLE_ENDIAN);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf copyInt(int value) {
        void var1_1;
        int n;
        ByteBuf buf = Unpooled.buffer(4);
        buf.writeInt(n);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf copyInt(int ... values) {
        void var1_1;
        int[] nArray;
        if (values == null || values.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf buffer = Unpooled.buffer(values.length << 2);
        for (int v : nArray) {
            buffer.writeInt(v);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf copyShort(int value) {
        void var1_1;
        int n;
        ByteBuf buf = Unpooled.buffer(2);
        buf.writeShort(n);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf copyShort(short ... values) {
        void var1_1;
        short[] sArray;
        if (values == null || values.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf buffer = Unpooled.buffer(values.length << 1);
        for (short v : sArray) {
            buffer.writeShort(v);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf copyShort(int ... values) {
        void var1_1;
        int[] nArray;
        if (values == null || values.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf buffer = Unpooled.buffer(values.length << 1);
        for (int v : nArray) {
            buffer.writeShort(v);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf copyMedium(int value) {
        void var1_1;
        int n;
        ByteBuf buf = Unpooled.buffer(3);
        buf.writeMedium(n);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf copyMedium(int ... values) {
        void var1_1;
        int[] nArray;
        if (values == null || values.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf buffer = Unpooled.buffer(values.length * 3);
        for (int v : nArray) {
            buffer.writeMedium(v);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf copyLong(long value) {
        void var2_1;
        long l;
        ByteBuf buf = Unpooled.buffer(8);
        buf.writeLong(l);
        return var2_1;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf copyLong(long ... values) {
        void var1_1;
        long[] lArray;
        if (values == null || values.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf buffer = Unpooled.buffer(values.length << 3);
        for (long v : lArray) {
            buffer.writeLong(v);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf copyBoolean(boolean value) {
        void var1_1;
        boolean bl;
        ByteBuf buf = Unpooled.buffer(1);
        buf.writeBoolean(bl);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf copyBoolean(boolean ... values) {
        void var1_1;
        boolean[] blArray;
        if (values == null || values.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf buffer = Unpooled.buffer(values.length);
        for (boolean v : blArray) {
            buffer.writeBoolean(v);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf copyFloat(float value) {
        void var1_1;
        float f;
        ByteBuf buf = Unpooled.buffer(4);
        buf.writeFloat(f);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf copyFloat(float ... values) {
        void var1_1;
        float[] fArray;
        if (values == null || values.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf buffer = Unpooled.buffer(values.length << 2);
        for (float v : fArray) {
            buffer.writeFloat(v);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf copyDouble(double value) {
        void var2_1;
        double d;
        ByteBuf buf = Unpooled.buffer(8);
        buf.writeDouble(d);
        return var2_1;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf copyDouble(double ... values) {
        void var1_1;
        double[] dArray;
        if (values == null || values.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf buffer = Unpooled.buffer(values.length << 3);
        for (double v : dArray) {
            buffer.writeDouble(v);
        }
        return var1_1;
    }

    public static ByteBuf unreleasableBuffer(ByteBuf buf) {
        ByteBuf byteBuf;
        return new UnreleasableByteBuf(byteBuf);
    }

    @Deprecated
    public static ByteBuf unmodifiableBuffer(ByteBuf ... buffers) {
        ByteBuf[] byteBufArray;
        return Unpooled.wrappedUnmodifiableBuffer(true, byteBufArray);
    }

    public static ByteBuf wrappedUnmodifiableBuffer(ByteBuf ... buffers) {
        ByteBuf[] byteBufArray;
        return Unpooled.wrappedUnmodifiableBuffer(false, byteBufArray);
    }

    /*
     * WARNING - void declaration
     */
    private static ByteBuf wrappedUnmodifiableBuffer(boolean copy, ByteBuf ... buffers) {
        void var1_1;
        boolean bl;
        switch (buffers.length) {
            case 0: {
                return EMPTY_BUFFER;
            }
            case 1: {
                return buffers[0].asReadOnly();
            }
        }
        if (bl) {
            buffers = (ByteBuf[])Arrays.copyOf(buffers, buffers.length, ByteBuf[].class);
        }
        return new FixedCompositeByteBuf(ALLOC, (ByteBuf[])var1_1);
    }

    private Unpooled() {
    }

    static {
        assert (EMPTY_BUFFER instanceof EmptyByteBuf) : "EMPTY_BUFFER must be an EmptyByteBuf.";
    }
}

