/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

@Deprecated
public class SwappedByteBuf
extends ByteBuf {
    private final ByteBuf buf;
    private final ByteOrder order;

    /*
     * WARNING - void declaration
     */
    public SwappedByteBuf(ByteBuf buf) {
        void var1_1;
        this.buf = (ByteBuf)ObjectUtil.checkNotNull((Object)buf, (String)"buf");
        if (var1_1.order() == ByteOrder.BIG_ENDIAN) {
            this.order = ByteOrder.LITTLE_ENDIAN;
            return;
        }
        this.order = ByteOrder.BIG_ENDIAN;
    }

    @Override
    public ByteOrder order() {
        return this.order;
    }

    @Override
    public ByteBuf order(ByteOrder endianness) {
        if (ObjectUtil.checkNotNull((Object)endianness, (String)"endianness") == this.order) {
            return this;
        }
        return this.buf;
    }

    @Override
    public ByteBuf unwrap() {
        return this.buf;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.buf.alloc();
    }

    @Override
    public int capacity() {
        return this.buf.capacity();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf capacity(int newCapacity) {
        void var1_1;
        this.buf.capacity((int)var1_1);
        return this;
    }

    @Override
    public int maxCapacity() {
        return this.buf.maxCapacity();
    }

    @Override
    public boolean isReadOnly() {
        return this.buf.isReadOnly();
    }

    @Override
    public ByteBuf asReadOnly() {
        return Unpooled.unmodifiableBuffer((ByteBuf)this);
    }

    @Override
    public boolean isDirect() {
        return this.buf.isDirect();
    }

    @Override
    public int readerIndex() {
        return this.buf.readerIndex();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readerIndex(int readerIndex) {
        void var1_1;
        this.buf.readerIndex((int)var1_1);
        return this;
    }

    @Override
    public int writerIndex() {
        return this.buf.writerIndex();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writerIndex(int writerIndex) {
        void var1_1;
        this.buf.writerIndex((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setIndex(int readerIndex, int writerIndex) {
        void var2_2;
        void var1_1;
        this.buf.setIndex((int)var1_1, (int)var2_2);
        return this;
    }

    @Override
    public int readableBytes() {
        return this.buf.readableBytes();
    }

    @Override
    public int writableBytes() {
        return this.buf.writableBytes();
    }

    @Override
    public int maxWritableBytes() {
        return this.buf.maxWritableBytes();
    }

    @Override
    public int maxFastWritableBytes() {
        return this.buf.maxFastWritableBytes();
    }

    @Override
    public boolean isReadable() {
        return this.buf.isReadable();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isReadable(int size) {
        void var1_1;
        return this.buf.isReadable((int)var1_1);
    }

    @Override
    public boolean isWritable() {
        return this.buf.isWritable();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isWritable(int size) {
        void var1_1;
        return this.buf.isWritable((int)var1_1);
    }

    @Override
    public ByteBuf clear() {
        this.buf.clear();
        return this;
    }

    @Override
    public ByteBuf markReaderIndex() {
        this.buf.markReaderIndex();
        return this;
    }

    @Override
    public ByteBuf resetReaderIndex() {
        this.buf.resetReaderIndex();
        return this;
    }

    @Override
    public ByteBuf markWriterIndex() {
        this.buf.markWriterIndex();
        return this;
    }

    @Override
    public ByteBuf resetWriterIndex() {
        this.buf.resetWriterIndex();
        return this;
    }

    @Override
    public ByteBuf discardReadBytes() {
        this.buf.discardReadBytes();
        return this;
    }

    @Override
    public ByteBuf discardSomeReadBytes() {
        this.buf.discardSomeReadBytes();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf ensureWritable(int writableBytes) {
        void var1_1;
        this.buf.ensureWritable((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int ensureWritable(int minWritableBytes, boolean force) {
        void var2_2;
        void var1_1;
        return this.buf.ensureWritable((int)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean getBoolean(int index) {
        void var1_1;
        return this.buf.getBoolean((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte getByte(int index) {
        void var1_1;
        return this.buf.getByte((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public short getUnsignedByte(int index) {
        void var1_1;
        return this.buf.getUnsignedByte((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public short getShort(int index) {
        void var1_1;
        return ByteBufUtil.swapShort(this.buf.getShort((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public short getShortLE(int index) {
        void var1_1;
        return this.buf.getShortLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getUnsignedShort(int index) {
        void var1_1;
        return ((ByteBuf)this).getShort((int)var1_1) & 0xFFFF;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getUnsignedShortLE(int index) {
        void var1_1;
        return ((ByteBuf)this).getShortLE((int)var1_1) & 0xFFFF;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getMedium(int index) {
        void var1_1;
        return ByteBufUtil.swapMedium(this.buf.getMedium((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getMediumLE(int index) {
        void var1_1;
        return this.buf.getMediumLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getUnsignedMedium(int index) {
        void var1_1;
        return ((ByteBuf)this).getMedium((int)var1_1) & 0xFFFFFF;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getUnsignedMediumLE(int index) {
        void var1_1;
        return ((ByteBuf)this).getMediumLE((int)var1_1) & 0xFFFFFF;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getInt(int index) {
        void var1_1;
        return ByteBufUtil.swapInt(this.buf.getInt((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getIntLE(int index) {
        void var1_1;
        return this.buf.getIntLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getUnsignedInt(int index) {
        void var1_1;
        return (long)((ByteBuf)this).getInt((int)var1_1) & 0xFFFFFFFFL;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getUnsignedIntLE(int index) {
        void var1_1;
        return (long)((ByteBuf)this).getIntLE((int)var1_1) & 0xFFFFFFFFL;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getLong(int index) {
        void var1_1;
        return ByteBufUtil.swapLong(this.buf.getLong((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getLongLE(int index) {
        void var1_1;
        return this.buf.getLongLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public char getChar(int index) {
        void var1_1;
        return (char)((ByteBuf)this).getShort((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getFloat(int index) {
        void var1_1;
        return Float.intBitsToFloat(((ByteBuf)this).getInt((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double getDouble(int index) {
        void var1_1;
        return Double.longBitsToDouble(((ByteBuf)this).getLong((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getBytes(int index, ByteBuf dst) {
        void var2_2;
        void var1_1;
        this.buf.getBytes((int)var1_1, (ByteBuf)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getBytes(int index, ByteBuf dst, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.buf.getBytes((int)var1_1, (ByteBuf)var2_2, (int)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.buf.getBytes((int)var1_1, (ByteBuf)var2_2, (int)var3_3, length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getBytes(int index, byte[] dst) {
        void var2_2;
        void var1_1;
        this.buf.getBytes((int)var1_1, (byte[])var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.buf.getBytes((int)var1_1, (byte[])var2_2, (int)var3_3, length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getBytes(int index, ByteBuffer dst) {
        void var2_2;
        void var1_1;
        this.buf.getBytes((int)var1_1, (ByteBuffer)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.buf.getBytes((int)var1_1, (OutputStream)var2_2, (int)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.buf.getBytes((int)var1_1, (GatheringByteChannel)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.buf.getBytes((int)var1_1, (FileChannel)var2_2, (long)var3_3, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CharSequence getCharSequence(int index, int length, Charset charset) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.buf.getCharSequence((int)var1_1, (int)var2_2, (Charset)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setBoolean(int index, boolean value) {
        void var2_2;
        void var1_1;
        this.buf.setBoolean((int)var1_1, (boolean)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setByte(int index, int value) {
        void var2_2;
        void var1_1;
        this.buf.setByte((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setShort(int index, int value) {
        void var2_2;
        void var1_1;
        this.buf.setShort((int)var1_1, ByteBufUtil.swapShort((short)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setShortLE(int index, int value) {
        void var2_2;
        void var1_1;
        this.buf.setShortLE((int)var1_1, (short)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setMedium(int index, int value) {
        void var2_2;
        void var1_1;
        this.buf.setMedium((int)var1_1, ByteBufUtil.swapMedium((int)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setMediumLE(int index, int value) {
        void var2_2;
        void var1_1;
        this.buf.setMediumLE((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setInt(int index, int value) {
        void var2_2;
        void var1_1;
        this.buf.setInt((int)var1_1, ByteBufUtil.swapInt((int)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setIntLE(int index, int value) {
        void var2_2;
        void var1_1;
        this.buf.setIntLE((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setLong(int index, long value) {
        void var2_2;
        void var1_1;
        this.buf.setLong((int)var1_1, ByteBufUtil.swapLong((long)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setLongLE(int index, long value) {
        void var2_2;
        void var1_1;
        this.buf.setLongLE((int)var1_1, (long)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setChar(int index, int value) {
        void var2_2;
        void var1_1;
        ((ByteBuf)this).setShort((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setFloat(int index, float value) {
        void var2_2;
        void var1_1;
        ((ByteBuf)this).setInt((int)var1_1, Float.floatToRawIntBits((float)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setDouble(int index, double value) {
        void var2_2;
        void var1_1;
        ((ByteBuf)this).setLong((int)var1_1, Double.doubleToRawLongBits((double)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setBytes(int index, ByteBuf src) {
        void var2_2;
        void var1_1;
        this.buf.setBytes((int)var1_1, (ByteBuf)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setBytes(int index, ByteBuf src, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.buf.setBytes((int)var1_1, (ByteBuf)var2_2, (int)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.buf.setBytes((int)var1_1, (ByteBuf)var2_2, (int)var3_3, length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setBytes(int index, byte[] src) {
        void var2_2;
        void var1_1;
        this.buf.setBytes((int)var1_1, (byte[])var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.buf.setBytes((int)var1_1, (byte[])var2_2, (int)var3_3, length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setBytes(int index, ByteBuffer src) {
        void var2_2;
        void var1_1;
        this.buf.setBytes((int)var1_1, (ByteBuffer)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.buf.setBytes((int)var1_1, (InputStream)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.buf.setBytes((int)var1_1, (ScatteringByteChannel)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int setBytes(int index, FileChannel in, long position, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.buf.setBytes((int)var1_1, (FileChannel)var2_2, (long)var3_3, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setZero(int index, int length) {
        void var2_2;
        void var1_1;
        this.buf.setZero((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int setCharSequence(int index, CharSequence sequence, Charset charset) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.buf.setCharSequence((int)var1_1, (CharSequence)var2_2, (Charset)var3_3);
    }

    @Override
    public boolean readBoolean() {
        return this.buf.readBoolean();
    }

    @Override
    public byte readByte() {
        return this.buf.readByte();
    }

    @Override
    public short readUnsignedByte() {
        return this.buf.readUnsignedByte();
    }

    @Override
    public short readShort() {
        return ByteBufUtil.swapShort(this.buf.readShort());
    }

    @Override
    public short readShortLE() {
        return this.buf.readShortLE();
    }

    @Override
    public int readUnsignedShort() {
        return ((ByteBuf)this).readShort() & 0xFFFF;
    }

    @Override
    public int readUnsignedShortLE() {
        return ((ByteBuf)this).readShortLE() & 0xFFFF;
    }

    @Override
    public int readMedium() {
        return ByteBufUtil.swapMedium(this.buf.readMedium());
    }

    @Override
    public int readMediumLE() {
        return this.buf.readMediumLE();
    }

    @Override
    public int readUnsignedMedium() {
        return ((ByteBuf)this).readMedium() & 0xFFFFFF;
    }

    @Override
    public int readUnsignedMediumLE() {
        return ((ByteBuf)this).readMediumLE() & 0xFFFFFF;
    }

    @Override
    public int readInt() {
        return ByteBufUtil.swapInt(this.buf.readInt());
    }

    @Override
    public int readIntLE() {
        return this.buf.readIntLE();
    }

    @Override
    public long readUnsignedInt() {
        return (long)((ByteBuf)this).readInt() & 0xFFFFFFFFL;
    }

    @Override
    public long readUnsignedIntLE() {
        return (long)((ByteBuf)this).readIntLE() & 0xFFFFFFFFL;
    }

    @Override
    public long readLong() {
        return ByteBufUtil.swapLong(this.buf.readLong());
    }

    @Override
    public long readLongLE() {
        return this.buf.readLongLE();
    }

    @Override
    public char readChar() {
        return (char)((ByteBuf)this).readShort();
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(((ByteBuf)this).readInt());
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(((ByteBuf)this).readLong());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readBytes(int length) {
        void var1_1;
        return this.buf.readBytes((int)var1_1).order(((ByteBuf)this).order());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readSlice(int length) {
        void var1_1;
        return this.buf.readSlice((int)var1_1).order(this.order);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readRetainedSlice(int length) {
        void var1_1;
        return this.buf.readRetainedSlice((int)var1_1).order(this.order);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readBytes(ByteBuf dst) {
        void var1_1;
        this.buf.readBytes((ByteBuf)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readBytes(ByteBuf dst, int length) {
        void var2_2;
        void var1_1;
        this.buf.readBytes((ByteBuf)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readBytes(ByteBuf dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.buf.readBytes((ByteBuf)var1_1, (int)var2_2, (int)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readBytes(byte[] dst) {
        void var1_1;
        this.buf.readBytes((byte[])var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readBytes(byte[] dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.buf.readBytes((byte[])var1_1, (int)var2_2, (int)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readBytes(ByteBuffer dst) {
        void var1_1;
        this.buf.readBytes((ByteBuffer)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readBytes(OutputStream out, int length) throws IOException {
        void var2_2;
        void var1_1;
        this.buf.readBytes((OutputStream)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        void var2_2;
        void var1_1;
        return this.buf.readBytes((GatheringByteChannel)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readBytes(FileChannel out, long position, int length) throws IOException {
        void var2_2;
        void var1_1;
        return this.buf.readBytes((FileChannel)var1_1, (long)var2_2, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CharSequence readCharSequence(int length, Charset charset) {
        void var2_2;
        void var1_1;
        return this.buf.readCharSequence((int)var1_1, (Charset)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf skipBytes(int length) {
        void var1_1;
        this.buf.skipBytes((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeBoolean(boolean value) {
        void var1_1;
        this.buf.writeBoolean((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeByte(int value) {
        void var1_1;
        this.buf.writeByte((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeShort(int value) {
        void var1_1;
        this.buf.writeShort(ByteBufUtil.swapShort((short)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeShortLE(int value) {
        void var1_1;
        this.buf.writeShortLE((short)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeMedium(int value) {
        void var1_1;
        this.buf.writeMedium(ByteBufUtil.swapMedium((int)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeMediumLE(int value) {
        void var1_1;
        this.buf.writeMediumLE((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeInt(int value) {
        void var1_1;
        this.buf.writeInt(ByteBufUtil.swapInt((int)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeIntLE(int value) {
        void var1_1;
        this.buf.writeIntLE((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeLong(long value) {
        void var1_1;
        this.buf.writeLong(ByteBufUtil.swapLong((long)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeLongLE(long value) {
        void var1_1;
        this.buf.writeLongLE((long)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeChar(int value) {
        void var1_1;
        ((ByteBuf)this).writeShort((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeFloat(float value) {
        void var1_1;
        ((ByteBuf)this).writeInt(Float.floatToRawIntBits((float)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeDouble(double value) {
        void var1_1;
        ((ByteBuf)this).writeLong(Double.doubleToRawLongBits((double)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeBytes(ByteBuf src) {
        void var1_1;
        this.buf.writeBytes((ByteBuf)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeBytes(ByteBuf src, int length) {
        void var2_2;
        void var1_1;
        this.buf.writeBytes((ByteBuf)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeBytes(ByteBuf src, int srcIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.buf.writeBytes((ByteBuf)var1_1, (int)var2_2, (int)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeBytes(byte[] src) {
        void var1_1;
        this.buf.writeBytes((byte[])var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeBytes(byte[] src, int srcIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.buf.writeBytes((byte[])var1_1, (int)var2_2, (int)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeBytes(ByteBuffer src) {
        void var1_1;
        this.buf.writeBytes((ByteBuffer)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int writeBytes(InputStream in, int length) throws IOException {
        void var2_2;
        void var1_1;
        return this.buf.writeBytes((InputStream)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int writeBytes(ScatteringByteChannel in, int length) throws IOException {
        void var2_2;
        void var1_1;
        return this.buf.writeBytes((ScatteringByteChannel)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int writeBytes(FileChannel in, long position, int length) throws IOException {
        void var2_2;
        void var1_1;
        return this.buf.writeBytes((FileChannel)var1_1, (long)var2_2, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeZero(int length) {
        void var1_1;
        this.buf.writeZero((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int writeCharSequence(CharSequence sequence, Charset charset) {
        void var2_2;
        void var1_1;
        return this.buf.writeCharSequence((CharSequence)var1_1, (Charset)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int indexOf(int fromIndex, int toIndex, byte value) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.buf.indexOf((int)var1_1, (int)var2_2, (byte)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int bytesBefore(byte value) {
        void var1_1;
        return this.buf.bytesBefore((byte)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int bytesBefore(int length, byte value) {
        void var2_2;
        void var1_1;
        return this.buf.bytesBefore((int)var1_1, (byte)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int bytesBefore(int index, int length, byte value) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.buf.bytesBefore((int)var1_1, (int)var2_2, (byte)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int forEachByte(ByteProcessor processor) {
        void var1_1;
        return this.buf.forEachByte((ByteProcessor)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int forEachByte(int index, int length, ByteProcessor processor) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.buf.forEachByte((int)var1_1, (int)var2_2, (ByteProcessor)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int forEachByteDesc(ByteProcessor processor) {
        void var1_1;
        return this.buf.forEachByteDesc((ByteProcessor)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int forEachByteDesc(int index, int length, ByteProcessor processor) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.buf.forEachByteDesc((int)var1_1, (int)var2_2, (ByteProcessor)var3_3);
    }

    @Override
    public ByteBuf copy() {
        return this.buf.copy().order(this.order);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf copy(int index, int length) {
        void var2_2;
        void var1_1;
        return this.buf.copy((int)var1_1, (int)var2_2).order(this.order);
    }

    @Override
    public ByteBuf slice() {
        return this.buf.slice().order(this.order);
    }

    @Override
    public ByteBuf retainedSlice() {
        return this.buf.retainedSlice().order(this.order);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf slice(int index, int length) {
        void var2_2;
        void var1_1;
        return this.buf.slice((int)var1_1, (int)var2_2).order(this.order);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf retainedSlice(int index, int length) {
        void var2_2;
        void var1_1;
        return this.buf.retainedSlice((int)var1_1, (int)var2_2).order(this.order);
    }

    @Override
    public ByteBuf duplicate() {
        return this.buf.duplicate().order(this.order);
    }

    @Override
    public ByteBuf retainedDuplicate() {
        return this.buf.retainedDuplicate().order(this.order);
    }

    @Override
    public int nioBufferCount() {
        return this.buf.nioBufferCount();
    }

    @Override
    public ByteBuffer nioBuffer() {
        return this.buf.nioBuffer().order(this.order);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer nioBuffer(int index, int length) {
        void var2_2;
        void var1_1;
        return this.buf.nioBuffer((int)var1_1, (int)var2_2).order(this.order);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer internalNioBuffer(int index, int length) {
        void var2_2;
        void var1_1;
        return ((ByteBuf)this).nioBuffer((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer[] nioBuffers() {
        void var1_1;
        ByteBuffer[] nioBuffers = this.buf.nioBuffers();
        for (int i = 0; i < nioBuffers.length; ++i) {
            nioBuffers[i] = nioBuffers[i].order(this.order);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer[] nioBuffers(int index, int length) {
        void var1_2;
        ByteBuffer[] nioBuffers = this.buf.nioBuffers(index, length);
        for (int i = 0; i < nioBuffers.length; ++i) {
            nioBuffers[i] = nioBuffers[i].order(this.order);
        }
        return var1_2;
    }

    @Override
    public boolean hasArray() {
        return this.buf.hasArray();
    }

    @Override
    public byte[] array() {
        return this.buf.array();
    }

    @Override
    public int arrayOffset() {
        return this.buf.arrayOffset();
    }

    @Override
    public boolean hasMemoryAddress() {
        return this.buf.hasMemoryAddress();
    }

    @Override
    public boolean isContiguous() {
        return this.buf.isContiguous();
    }

    @Override
    public long memoryAddress() {
        return this.buf.memoryAddress();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString(Charset charset) {
        void var1_1;
        return this.buf.toString((Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString(int index, int length, Charset charset) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.buf.toString((int)var1_1, (int)var2_2, (Charset)var3_3);
    }

    public int refCnt() {
        return this.buf.refCnt();
    }

    @Override
    final boolean isAccessible() {
        return this.buf.isAccessible();
    }

    @Override
    public ByteBuf retain() {
        this.buf.retain();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf retain(int increment) {
        void var1_1;
        this.buf.retain((int)var1_1);
        return this;
    }

    @Override
    public ByteBuf touch() {
        this.buf.touch();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf touch(Object hint) {
        void var1_1;
        this.buf.touch(var1_1);
        return this;
    }

    public boolean release() {
        return this.buf.release();
    }

    /*
     * WARNING - void declaration
     */
    public boolean release(int decrement) {
        void var1_1;
        return this.buf.release((int)var1_1);
    }

    @Override
    public int hashCode() {
        return this.buf.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ByteBuf) {
            void var1_1;
            return ByteBufUtil.equals(this, (ByteBuf)var1_1);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(ByteBuf buffer) {
        void var1_1;
        return ByteBufUtil.compare(this, (ByteBuf)var1_1);
    }

    @Override
    public String toString() {
        return "Swapped(" + this.buf + ')';
    }
}

