/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.PoolThreadCache;
import io.netty.buffer.SizeClassesMetric;

final class SizeClasses
implements SizeClassesMetric {
    static final int LOG2_QUANTUM = 4;
    private static final int LOG2_SIZE_CLASS_GROUP = 2;
    private static final int LOG2_MAX_LOOKUP_SIZE = 12;
    private static final int LOG2GROUP_IDX = 1;
    private static final int LOG2DELTA_IDX = 2;
    private static final int NDELTA_IDX = 3;
    private static final int PAGESIZE_IDX = 4;
    private static final int SUBPAGE_IDX = 5;
    private static final int LOG2_DELTA_LOOKUP_IDX = 6;
    private static final byte no = 0;
    private static final byte yes = 1;
    final int pageSize;
    final int pageShifts;
    final int chunkSize;
    final int directMemoryCacheAlignment;
    final int nSizes;
    final int nSubpages;
    final int nPSizes;
    final int lookupMaxSize;
    final int smallMaxSizeIdx;
    private final int[] pageIdx2sizeTab;
    private final int[] sizeIdx2sizeTab;
    private final int[] size2idxTab;

    /*
     * WARNING - void declaration
     */
    SizeClasses(int pageSize, int pageShifts, int chunkSize, int directMemoryCacheAlignment) {
        void var3_3;
        void var2_2;
        void var1_1;
        int sizeClass22;
        int n = PoolThreadCache.log2(chunkSize) - 4 - 2 + 1;
        short[][] sizeClasses = new short[n << 2][7];
        int normalMaxSize = -1;
        int nSizes = 0;
        boolean size = false;
        int log2Group = 4;
        int log2Delta = 4;
        int nDelta = 0;
        while (nDelta < 4) {
            short[] sizeClass22 = SizeClasses.newSizeClass(nSizes, 4, 4, nDelta, pageShifts);
            sizeClasses[nSizes] = sizeClass22;
            sizeClass22 = SizeClasses.sizeOf(sizeClass22, directMemoryCacheAlignment);
            ++nDelta;
            ++nSizes;
        }
        log2Group += 2;
        while (sizeClass22 < chunkSize) {
            nDelta = 1;
            while (nDelta <= 4 && sizeClass22 < chunkSize) {
                short[] sizeClass = SizeClasses.newSizeClass(nSizes, log2Group, log2Delta, nDelta, pageShifts);
                sizeClasses[nSizes] = sizeClass;
                sizeClass22 = normalMaxSize = SizeClasses.sizeOf(sizeClass, directMemoryCacheAlignment);
                ++nDelta;
                ++nSizes;
            }
            ++log2Group;
            ++log2Delta;
        }
        assert (chunkSize == normalMaxSize);
        int smallMaxSizeIdx = 0;
        int lookupMaxSize = 0;
        int nPSizes = 0;
        int nSubpages = 0;
        for (int idx = 0; idx < nSizes; ++idx) {
            short[] sz = sizeClasses[idx];
            if (sz[4] == 1) {
                ++nPSizes;
            }
            if (sz[5] == 1) {
                ++nSubpages;
                smallMaxSizeIdx = idx;
            }
            if (sz[6] == 0) continue;
            lookupMaxSize = SizeClasses.sizeOf(sz, directMemoryCacheAlignment);
        }
        this.smallMaxSizeIdx = smallMaxSizeIdx;
        this.lookupMaxSize = lookupMaxSize;
        this.nPSizes = nPSizes;
        this.nSubpages = nSubpages;
        this.nSizes = nSizes;
        this.pageSize = var1_1;
        this.pageShifts = var2_2;
        this.chunkSize = var3_3;
        this.directMemoryCacheAlignment = directMemoryCacheAlignment;
        this.sizeIdx2sizeTab = SizeClasses.newIdx2SizeTab(sizeClasses, nSizes, directMemoryCacheAlignment);
        this.pageIdx2sizeTab = SizeClasses.newPageIdx2sizeTab(sizeClasses, nSizes, nPSizes, directMemoryCacheAlignment);
        this.size2idxTab = SizeClasses.newSize2idxTab(lookupMaxSize, sizeClasses);
    }

    /*
     * WARNING - void declaration
     */
    private static short[] newSizeClass(int index, int log2Group, int log2Delta, int nDelta, int pageShifts) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n;
        short s;
        if (log2Delta >= pageShifts) {
            s = 1;
        } else {
            int pageSize = 1 << pageShifts;
            int size = SizeClasses.calculateSize(log2Group, nDelta, log2Delta);
            s = size == size / pageSize * pageSize ? (short)1 : 0;
        }
        short isMultiPageSize = s;
        int log2Ndelta = nDelta == 0 ? 0 : PoolThreadCache.log2(nDelta);
        boolean remove = 1 << log2Ndelta < nDelta;
        int log2Size = log2Delta + log2Ndelta == log2Group ? log2Group + 1 : log2Group;
        if (log2Size == log2Group) {
            remove = true;
        }
        short isSubpage = log2Size < pageShifts + 2 ? (short)1 : 0;
        int log2DeltaLookup = log2Size < 12 || log2Size == 12 && !remove ? log2Delta : 0;
        return new short[]{(short)n, (short)var1_1, (short)var2_2, (short)var3_3, isMultiPageSize, isSubpage, (short)log2DeltaLookup};
    }

    /*
     * WARNING - void declaration
     */
    private static int[] newIdx2SizeTab(short[][] sizeClasses, int nSizes, int directMemoryCacheAlignment) {
        void var3_3;
        int[] sizeIdx2sizeTab = new int[nSizes];
        for (int i = 0; i < nSizes; ++i) {
            short[] sizeClass = sizeClasses[i];
            sizeIdx2sizeTab[i] = SizeClasses.sizeOf(sizeClass, directMemoryCacheAlignment);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static int calculateSize(int log2Group, int nDelta, int log2Delta) {
        void var2_2;
        void var1_1;
        int n;
        return (1 << n) + (var1_1 << var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static int sizeOf(short[] sizeClass, int directMemoryCacheAlignment) {
        void var1_2;
        void var3_4;
        int n;
        void var2_3;
        short log2Group = sizeClass[1];
        short log2Delta = sizeClass[2];
        short nDelta = sizeClass[3];
        n = SizeClasses.calculateSize((int)var2_3, n, (int)var3_4);
        return SizeClasses.alignSizeIfNeeded(n, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private static int[] newPageIdx2sizeTab(short[][] sizeClasses, int nSizes, int nPSizes, int directMemoryCacheAlignment) {
        void var2_3;
        int[] pageIdx2sizeTab = new int[nPSizes];
        int pageIdx = 0;
        for (int i = 0; i < nSizes; ++i) {
            short[] sizeClass = sizeClasses[i];
            if (sizeClass[4] != 1) continue;
            pageIdx2sizeTab[pageIdx++] = SizeClasses.sizeOf(sizeClass, directMemoryCacheAlignment);
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    private static int[] newSize2idxTab(int lookupMaxSize, short[][] sizeClasses) {
        void var2_2;
        int[] size2idxTab = new int[lookupMaxSize >> 4];
        int idx = 0;
        int size = 0;
        int i = 0;
        while (size <= lookupMaxSize) {
            short log2Delta = sizeClasses[i][2];
            int times = 1 << log2Delta - 4;
            while (size <= lookupMaxSize && times-- > 0) {
                size2idxTab[idx++] = i;
                size = idx + 1 << 4;
            }
            ++i;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int sizeIdx2size(int sizeIdx) {
        void var1_1;
        return this.sizeIdx2sizeTab[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int sizeIdx2sizeCompute(int sizeIdx) {
        void var1_1;
        void var3_3;
        void var2_2;
        int group = sizeIdx >> 2;
        int mod = sizeIdx & 3;
        int groupSize = group == 0 ? 0 : 32 << group;
        group = group == 0 ? 1 : group;
        int lgDelta = group + 4 - 1;
        int modSize = mod + 1 << var2_2;
        return (int)(var3_3 + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long pageIdx2size(int pageIdx) {
        void var1_1;
        return this.pageIdx2sizeTab[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long pageIdx2sizeCompute(int pageIdx) {
        void var1_1;
        void var2_2;
        int group = pageIdx >> 2;
        int mod = pageIdx & 3;
        long groupSize = group == 0 ? 0L : 1L << this.pageShifts + 2 - 1 << group;
        group = group == 0 ? 1 : group;
        int log2Delta = group + this.pageShifts - 1;
        int modSize = mod + 1 << var2_2;
        return groupSize + (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int size2SizeIdx(int size) {
        void var1_1;
        void var2_2;
        if (size == 0) {
            return 0;
        }
        if (size > this.chunkSize) {
            return this.nSizes;
        }
        if ((size = SizeClasses.alignSizeIfNeeded(size, this.directMemoryCacheAlignment)) <= this.lookupMaxSize) {
            return this.size2idxTab[size - 1 >> 4];
        }
        int x = PoolThreadCache.log2((size << 1) - 1);
        int n = x < 7 ? 0 : x - 6;
        int group = n << 2;
        int log2Delta = x < 7 ? 4 : x - 2 - 1;
        int mod = size - 1 >> var2_2 & 3;
        return n + var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int pages2pageIdx(int pages) {
        void var1_1;
        return this.pages2pageIdxCompute((int)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int pages2pageIdxFloor(int pages) {
        void var1_1;
        return this.pages2pageIdxCompute((int)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    private int pages2pageIdxCompute(int pages, boolean floor) {
        void var3_3;
        void var1_1;
        void var2_2;
        int pageSize = pages << this.pageShifts;
        if (pageSize > this.chunkSize) {
            return this.nPSizes;
        }
        int x = PoolThreadCache.log2((pageSize << 1) - 1);
        int n = x < 2 + this.pageShifts ? 0 : x - (2 + this.pageShifts);
        int group = n << 2;
        int log2Delta = x < 2 + this.pageShifts + 1 ? this.pageShifts : x - 2 - 1;
        int mod = pageSize - 1 >> log2Delta & 3;
        int pageIdx = group + mod;
        if (var2_2 != false && this.pageIdx2sizeTab[pageIdx] > var1_1 << this.pageShifts) {
            --pageIdx;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static int alignSizeIfNeeded(int size, int directMemoryCacheAlignment) {
        void var2_2;
        void var1_1;
        int n;
        if (directMemoryCacheAlignment <= 0) {
            return size;
        }
        int delta = size & directMemoryCacheAlignment - 1;
        if (delta == 0) {
            return size;
        }
        return n + var1_1 - var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int normalizeSize(int size) {
        void var1_1;
        if (size == 0) {
            return this.sizeIdx2sizeTab[0];
        }
        if ((size = SizeClasses.alignSizeIfNeeded(size, this.directMemoryCacheAlignment)) <= this.lookupMaxSize) {
            void var2_2;
            int ret = this.sizeIdx2sizeTab[this.size2idxTab[size - 1 >> 4]];
            assert (ret == SizeClasses.normalizeSizeCompute(size));
            return (int)var2_2;
        }
        return SizeClasses.normalizeSizeCompute((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static int normalizeSizeCompute(int size) {
        void var1_1;
        int n;
        int x = PoolThreadCache.log2((size << 1) - 1);
        int log2Delta = x < 7 ? 4 : x - 2 - 1;
        log2Delta = 1 << log2Delta;
        int delta_mask = log2Delta - 1;
        return n + delta_mask & ~var1_1;
    }
}

