/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.SimpleLeakAwareByteBuf;
import io.netty.buffer.WrappedCompositeByteBuf;
import io.netty.util.ResourceLeakTracker;
import io.netty.util.internal.ObjectUtil;
import java.nio.ByteOrder;

class SimpleLeakAwareCompositeByteBuf
extends WrappedCompositeByteBuf {
    final ResourceLeakTracker<ByteBuf> leak;

    /*
     * WARNING - void declaration
     */
    SimpleLeakAwareCompositeByteBuf(CompositeByteBuf wrapped, ResourceLeakTracker<ByteBuf> leak) {
        super((CompositeByteBuf)var1_1);
        void var2_2;
        void var1_1;
        this.leak = (ResourceLeakTracker)ObjectUtil.checkNotNull((Object)var2_2, (String)"leak");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean release() {
        ByteBuf unwrapped = ((ByteBuf)this).unwrap();
        if (super.release()) {
            void var1_1;
            this.closeLeak((ByteBuf)var1_1);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean release(int decrement) {
        void var1_1;
        ByteBuf unwrapped = ((ByteBuf)this).unwrap();
        if (super.release((int)var1_1)) {
            void var2_2;
            this.closeLeak((ByteBuf)var2_2);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void closeLeak(ByteBuf trackedByteBuf) {
        void var1_2;
        boolean closed = this.leak.close((Object)trackedByteBuf);
        assert (var1_2 != false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf order(ByteOrder endianness) {
        void var1_1;
        if (((ByteBuf)this).order() == endianness) {
            return this;
        }
        SimpleLeakAwareCompositeByteBuf simpleLeakAwareCompositeByteBuf = this;
        return simpleLeakAwareCompositeByteBuf.newLeakAwareByteBuf(super.order((ByteOrder)var1_1));
    }

    @Override
    public ByteBuf slice() {
        SimpleLeakAwareCompositeByteBuf simpleLeakAwareCompositeByteBuf = this;
        return simpleLeakAwareCompositeByteBuf.newLeakAwareByteBuf(super.slice());
    }

    @Override
    public ByteBuf retainedSlice() {
        SimpleLeakAwareCompositeByteBuf simpleLeakAwareCompositeByteBuf = this;
        return simpleLeakAwareCompositeByteBuf.newLeakAwareByteBuf(super.retainedSlice());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf slice(int index, int length) {
        void var2_2;
        void var1_1;
        SimpleLeakAwareCompositeByteBuf simpleLeakAwareCompositeByteBuf = this;
        return simpleLeakAwareCompositeByteBuf.newLeakAwareByteBuf(super.slice((int)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf retainedSlice(int index, int length) {
        void var2_2;
        void var1_1;
        SimpleLeakAwareCompositeByteBuf simpleLeakAwareCompositeByteBuf = this;
        return simpleLeakAwareCompositeByteBuf.newLeakAwareByteBuf(super.retainedSlice((int)var1_1, (int)var2_2));
    }

    @Override
    public ByteBuf duplicate() {
        SimpleLeakAwareCompositeByteBuf simpleLeakAwareCompositeByteBuf = this;
        return simpleLeakAwareCompositeByteBuf.newLeakAwareByteBuf(super.duplicate());
    }

    @Override
    public ByteBuf retainedDuplicate() {
        SimpleLeakAwareCompositeByteBuf simpleLeakAwareCompositeByteBuf = this;
        return simpleLeakAwareCompositeByteBuf.newLeakAwareByteBuf(super.retainedDuplicate());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readSlice(int length) {
        void var1_1;
        SimpleLeakAwareCompositeByteBuf simpleLeakAwareCompositeByteBuf = this;
        return simpleLeakAwareCompositeByteBuf.newLeakAwareByteBuf(super.readSlice((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readRetainedSlice(int length) {
        void var1_1;
        SimpleLeakAwareCompositeByteBuf simpleLeakAwareCompositeByteBuf = this;
        return simpleLeakAwareCompositeByteBuf.newLeakAwareByteBuf(super.readRetainedSlice((int)var1_1));
    }

    @Override
    public ByteBuf asReadOnly() {
        SimpleLeakAwareCompositeByteBuf simpleLeakAwareCompositeByteBuf = this;
        return simpleLeakAwareCompositeByteBuf.newLeakAwareByteBuf(super.asReadOnly());
    }

    /*
     * WARNING - void declaration
     */
    private SimpleLeakAwareByteBuf newLeakAwareByteBuf(ByteBuf wrapped) {
        void var1_1;
        return this.newLeakAwareByteBuf((ByteBuf)var1_1, ((ByteBuf)this).unwrap(), this.leak);
    }

    /*
     * WARNING - void declaration
     */
    protected SimpleLeakAwareByteBuf newLeakAwareByteBuf(ByteBuf wrapped, ByteBuf trackedByteBuf, ResourceLeakTracker<ByteBuf> leakTracker) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new SimpleLeakAwareByteBuf((ByteBuf)var1_1, (ByteBuf)var2_2, (ResourceLeakTracker<ByteBuf>)var3_3);
    }
}

