/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractPooledDerivedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.WrappedByteBuf;
import io.netty.util.ResourceLeakTracker;
import io.netty.util.internal.ObjectUtil;
import java.nio.ByteOrder;

class SimpleLeakAwareByteBuf
extends WrappedByteBuf {
    private final ByteBuf trackedByteBuf;
    final ResourceLeakTracker<ByteBuf> leak;

    /*
     * WARNING - void declaration
     */
    SimpleLeakAwareByteBuf(ByteBuf wrapped, ByteBuf trackedByteBuf, ResourceLeakTracker<ByteBuf> leak) {
        super((ByteBuf)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        this.trackedByteBuf = (ByteBuf)ObjectUtil.checkNotNull((Object)var2_2, (String)"trackedByteBuf");
        this.leak = (ResourceLeakTracker)ObjectUtil.checkNotNull((Object)var3_3, (String)"leak");
    }

    /*
     * WARNING - void declaration
     */
    SimpleLeakAwareByteBuf(ByteBuf wrapped, ResourceLeakTracker<ByteBuf> leak) {
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        this((ByteBuf)v0, (ByteBuf)v0, (ResourceLeakTracker<ByteBuf>)var2_2);
    }

    @Override
    public ByteBuf slice() {
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.newSharedLeakAwareByteBuf(super.slice());
    }

    @Override
    public ByteBuf retainedSlice() {
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.unwrappedDerived(super.retainedSlice());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf retainedSlice(int index, int length) {
        void var2_2;
        void var1_1;
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.unwrappedDerived(super.retainedSlice((int)var1_1, (int)var2_2));
    }

    @Override
    public ByteBuf retainedDuplicate() {
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.unwrappedDerived(super.retainedDuplicate());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readRetainedSlice(int length) {
        void var1_1;
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.unwrappedDerived(super.readRetainedSlice((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf slice(int index, int length) {
        void var2_2;
        void var1_1;
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.newSharedLeakAwareByteBuf(super.slice((int)var1_1, (int)var2_2));
    }

    @Override
    public ByteBuf duplicate() {
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.newSharedLeakAwareByteBuf(super.duplicate());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readSlice(int length) {
        void var1_1;
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.newSharedLeakAwareByteBuf(super.readSlice((int)var1_1));
    }

    @Override
    public ByteBuf asReadOnly() {
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.newSharedLeakAwareByteBuf(super.asReadOnly());
    }

    @Override
    public ByteBuf touch() {
        return this;
    }

    @Override
    public ByteBuf touch(Object hint) {
        return this;
    }

    @Override
    public boolean release() {
        if (super.release()) {
            this.closeLeak();
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean release(int decrement) {
        void var1_1;
        if (super.release((int)var1_1)) {
            this.closeLeak();
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void closeLeak() {
        void var1_1;
        boolean closed = this.leak.close((Object)this.trackedByteBuf);
        assert (var1_1 != false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf order(ByteOrder endianness) {
        void var1_1;
        if (((ByteBuf)this).order() == endianness) {
            return this;
        }
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.newSharedLeakAwareByteBuf(super.order((ByteOrder)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuf unwrappedDerived(ByteBuf derived) {
        void var1_1;
        ByteBuf unwrappedDerived = SimpleLeakAwareByteBuf.unwrapSwapped(derived);
        if (unwrappedDerived instanceof AbstractPooledDerivedByteBuf) {
            void var2_2;
            ((AbstractPooledDerivedByteBuf)var2_2).parent(this);
            return this.newLeakAwareByteBuf(derived, (ResourceLeakTracker<ByteBuf>)AbstractByteBuf.leakDetector.trackForcibly((Object)derived));
        }
        return this.newSharedLeakAwareByteBuf((ByteBuf)var1_1);
    }

    private static ByteBuf unwrapSwapped(ByteBuf buf) {
        ByteBuf byteBuf;
        if (buf instanceof SwappedByteBuf) {
            while ((buf = buf.unwrap()) instanceof SwappedByteBuf) {
            }
            return buf;
        }
        return byteBuf;
    }

    /*
     * WARNING - void declaration
     */
    private SimpleLeakAwareByteBuf newSharedLeakAwareByteBuf(ByteBuf wrapped) {
        void var1_1;
        return this.newLeakAwareByteBuf((ByteBuf)var1_1, this.trackedByteBuf, this.leak);
    }

    /*
     * WARNING - void declaration
     */
    private SimpleLeakAwareByteBuf newLeakAwareByteBuf(ByteBuf wrapped, ResourceLeakTracker<ByteBuf> leakTracker) {
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        return this.newLeakAwareByteBuf((ByteBuf)v0, (ByteBuf)v0, (ResourceLeakTracker<ByteBuf>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected SimpleLeakAwareByteBuf newLeakAwareByteBuf(ByteBuf buf, ByteBuf trackedByteBuf, ResourceLeakTracker<ByteBuf> leakTracker) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new SimpleLeakAwareByteBuf((ByteBuf)var1_1, (ByteBuf)var2_2, (ResourceLeakTracker<ByteBuf>)var3_3);
    }
}

