/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ReadOnlyByteBufferBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

final class ReadOnlyUnsafeDirectByteBuf
extends ReadOnlyByteBufferBuf {
    private final long memoryAddress;

    /*
     * WARNING - void declaration
     */
    ReadOnlyUnsafeDirectByteBuf(ByteBufAllocator allocator, ByteBuffer byteBuffer) {
        super((ByteBufAllocator)var1_1, (ByteBuffer)var2_2);
        void var2_2;
        void var1_1;
        this.memoryAddress = PlatformDependent.directBufferAddress((ByteBuffer)this.buffer);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final byte _getByte(int index) {
        void var1_1;
        return UnsafeByteBufUtil.getByte(this.addr((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final short _getShort(int index) {
        void var1_1;
        return UnsafeByteBufUtil.getShort(this.addr((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int _getUnsignedMedium(int index) {
        void var1_1;
        return UnsafeByteBufUtil.getUnsignedMedium(this.addr((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int _getInt(int index) {
        void var1_1;
        return UnsafeByteBufUtil.getInt(this.addr((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final long _getLong(int index) {
        void var1_1;
        return UnsafeByteBufUtil.getLong(this.addr((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length, boolean internal) {
        this.checkIndex(index, length);
        ObjectUtil.checkNotNull((Object)dst, (String)"dst");
        if (dstIndex < 0 || dstIndex > dst.capacity() - length) {
            throw new IndexOutOfBoundsException("dstIndex: " + dstIndex);
        }
        if (dst.hasMemoryAddress()) {
            PlatformDependent.copyMemory((long)this.addr(index), (long)(dst.memoryAddress() + (long)dstIndex), (long)length);
        } else if (dst.hasArray()) {
            PlatformDependent.copyMemory((long)this.addr(index), (byte[])dst.array(), (int)(dst.arrayOffset() + dstIndex), (long)length);
        } else {
            void var1_1;
            void var3_3;
            void var2_2;
            var2_2.setBytes((int)var3_3, this, (int)var1_1, length);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length, boolean internal) {
        this.checkIndex(index, length);
        ObjectUtil.checkNotNull((Object)dst, (String)"dst");
        if (dstIndex < 0 || dstIndex > dst.length - length) {
            throw new IndexOutOfBoundsException(String.format("dstIndex: %d, length: %d (expected: range(0, %d))", dstIndex, length, dst.length));
        }
        if (length != 0) {
            void var3_3;
            void var2_2;
            void var1_1;
            PlatformDependent.copyMemory((long)this.addr((int)var1_1), (byte[])var2_2, (int)var3_3, (long)length);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf copy(int index, int length) {
        void var3_3;
        this.checkIndex(index, length);
        ByteBuf copy = ((ByteBuf)this).alloc().directBuffer(length, ((ByteBuf)this).maxCapacity());
        if (length != 0) {
            if (copy.hasMemoryAddress()) {
                PlatformDependent.copyMemory((long)this.addr(index), (long)copy.memoryAddress(), (long)length);
                copy.setIndex(0, length);
            } else {
                void var2_2;
                void var1_1;
                copy.writeBytes(this, (int)var1_1, (int)var2_2);
            }
        }
        return var3_3;
    }

    @Override
    public final boolean hasMemoryAddress() {
        return true;
    }

    @Override
    public final long memoryAddress() {
        return this.memoryAddress;
    }

    /*
     * WARNING - void declaration
     */
    private long addr(int index) {
        void var1_1;
        return this.memoryAddress + (long)var1_1;
    }
}

