/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.DuplicatedByteBuf;
import io.netty.buffer.SlicedByteBuf;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

class ReadOnlyByteBufferBuf
extends AbstractReferenceCountedByteBuf {
    protected final ByteBuffer buffer;
    private final ByteBufAllocator allocator;
    private ByteBuffer tmpNioBuf;

    /*
     * WARNING - void declaration
     */
    ReadOnlyByteBufferBuf(ByteBufAllocator allocator, ByteBuffer buffer) {
        super(buffer.remaining());
        void var2_2;
        void var1_1;
        if (!buffer.isReadOnly()) {
            throw new IllegalArgumentException("must be a readonly buffer: " + StringUtil.simpleClassName((Object)buffer));
        }
        this.allocator = var1_1;
        this.buffer = var2_2.slice().order(ByteOrder.BIG_ENDIAN);
        ReadOnlyByteBufferBuf readOnlyByteBufferBuf = this;
        ((ByteBuf)readOnlyByteBufferBuf).writerIndex(readOnlyByteBufferBuf.buffer.limit());
    }

    @Override
    protected void deallocate() {
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isWritable(int numBytes) {
        return false;
    }

    @Override
    public ByteBuf ensureWritable(int minWritableBytes) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int ensureWritable(int minWritableBytes, boolean force) {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte getByte(int index) {
        void var1_1;
        this.ensureAccessible();
        return this._getByte((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected byte _getByte(int index) {
        void var1_1;
        return this.buffer.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public short getShort(int index) {
        void var1_1;
        this.ensureAccessible();
        return this._getShort((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected short _getShort(int index) {
        void var1_1;
        return this.buffer.getShort((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public short getShortLE(int index) {
        void var1_1;
        this.ensureAccessible();
        return this._getShortLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected short _getShortLE(int index) {
        void var1_1;
        return ByteBufUtil.swapShort(this.buffer.getShort((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getUnsignedMedium(int index) {
        void var1_1;
        this.ensureAccessible();
        return this._getUnsignedMedium((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getUnsignedMedium(int index) {
        void var1_1;
        return (((ByteBuf)this).getByte(index) & 0xFF) << 16 | (((ByteBuf)this).getByte(index + 1) & 0xFF) << 8 | ((ByteBuf)this).getByte((int)(var1_1 + 2)) & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getUnsignedMediumLE(int index) {
        void var1_1;
        this.ensureAccessible();
        return this._getUnsignedMediumLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getUnsignedMediumLE(int index) {
        void var1_1;
        return ((ByteBuf)this).getByte(index) & 0xFF | (((ByteBuf)this).getByte(index + 1) & 0xFF) << 8 | (((ByteBuf)this).getByte((int)(var1_1 + 2)) & 0xFF) << 16;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getInt(int index) {
        void var1_1;
        this.ensureAccessible();
        return this._getInt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getInt(int index) {
        void var1_1;
        return this.buffer.getInt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getIntLE(int index) {
        void var1_1;
        this.ensureAccessible();
        return this._getIntLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getIntLE(int index) {
        void var1_1;
        return ByteBufUtil.swapInt(this.buffer.getInt((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getLong(int index) {
        void var1_1;
        this.ensureAccessible();
        return this._getLong((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected long _getLong(int index) {
        void var1_1;
        return this.buffer.getLong((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getLongLE(int index) {
        void var1_1;
        this.ensureAccessible();
        return this._getLongLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected long _getLongLE(int index) {
        void var1_1;
        return ByteBufUtil.swapLong(this.buffer.getLong((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getBytes((int)var1_1, (ByteBuf)var2_2, (int)var3_3, length, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readBytes(ByteBuf dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkReadableBytes(length);
        ReadOnlyByteBufferBuf readOnlyByteBufferBuf = this;
        readOnlyByteBufferBuf.getBytes(readOnlyByteBufferBuf.readerIndex, (ByteBuf)var1_1, (int)var2_2, length, true);
        this.readerIndex += var3_3;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    protected ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length, boolean internal) {
        this.checkDstIndex(index, length, dstIndex, dst.capacity());
        if (dst.hasArray()) {
            ((ByteBuf)this).getBytes(index, dst.array(), dst.arrayOffset() + dstIndex, length);
        } else if (dst.nioBufferCount() > 0) {
            for (ByteBuffer bb : dst.nioBuffers(dstIndex, length)) {
                int bbLen = bb.remaining();
                this.getBytes(index, bb, internal);
                index += bbLen;
            }
        } else {
            void var1_1;
            void var3_3;
            void var2_2;
            var2_2.setBytes((int)var3_3, this, (int)var1_1, length);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getBytes((int)var1_1, (byte[])var2_2, (int)var3_3, length, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readBytes(byte[] dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkReadableBytes(length);
        ReadOnlyByteBufferBuf readOnlyByteBufferBuf = this;
        readOnlyByteBufferBuf.getBytes(readOnlyByteBufferBuf.readerIndex, (byte[])var1_1, (int)var2_2, length, true);
        this.readerIndex += var3_3;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    protected ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length, boolean internal) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkDstIndex(index, length, dstIndex, dst.length);
        ByteBuffer tmpBuf = this.nioBuffer(internal);
        tmpBuf.clear().position(index).limit((int)(var1_1 + length));
        tmpBuf.get((byte[])var2_2, (int)var3_3, length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getBytes(int index, ByteBuffer dst) {
        void var2_2;
        void var1_1;
        return this.getBytes((int)var1_1, (ByteBuffer)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readBytes(ByteBuffer dst) {
        void var2_2;
        void var1_1;
        int length = dst.remaining();
        this.checkReadableBytes(length);
        ReadOnlyByteBufferBuf readOnlyByteBufferBuf = this;
        readOnlyByteBufferBuf.getBytes(readOnlyByteBufferBuf.readerIndex, (ByteBuffer)var1_1, true);
        this.readerIndex += var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuf getBytes(int index, ByteBuffer dst, boolean internal) {
        void var3_4;
        void var2_2;
        void var1_1;
        this.checkIndex(index, dst.remaining());
        ByteBuffer tmpBuf = this.nioBuffer(internal);
        tmpBuf.clear().position(index).limit((int)(var1_1 + dst.remaining()));
        var2_2.put((ByteBuffer)var3_4);
        return this;
    }

    @Override
    public ByteBuf setByte(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setByte(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setShort(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setShort(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setShortLE(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setShortLE(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setMedium(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setMedium(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setMediumLE(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setMediumLE(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setInt(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setInt(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setIntLE(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setIntLE(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setLong(int index, long value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setLong(int index, long value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setLongLE(int index, long value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setLongLE(int index, long value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int capacity() {
        return ((ByteBuf)this).maxCapacity();
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.allocator;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return this.buffer.isReadOnly();
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getBytes((int)var1_1, (OutputStream)var2_2, (int)var3_3, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readBytes(OutputStream out, int length) throws IOException {
        void var2_2;
        void var1_1;
        this.checkReadableBytes(length);
        ReadOnlyByteBufferBuf readOnlyByteBufferBuf = this;
        readOnlyByteBufferBuf.getBytes(readOnlyByteBufferBuf.readerIndex, (OutputStream)var1_1, length, true);
        this.readerIndex += var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuf getBytes(int index, OutputStream out, int length, boolean internal) throws IOException {
        this.ensureAccessible();
        if (length == 0) {
            return this;
        }
        if (this.buffer.hasArray()) {
            out.write(this.buffer.array(), index + this.buffer.arrayOffset(), length);
        } else {
            void var3_3;
            void var2_2;
            void var1_1;
            byte[] tmp = ByteBufUtil.threadLocalTempArray(length);
            ByteBuffer tmpBuf = this.nioBuffer(internal);
            tmpBuf.clear().position((int)var1_1);
            tmpBuf.get(tmp, 0, length);
            var2_2.write(tmp, 0, (int)var3_3);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getBytes((int)var1_1, (GatheringByteChannel)var2_2, (int)var3_3, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        void var1_2;
        void var2_3;
        this.checkReadableBytes(length);
        ReadOnlyByteBufferBuf readOnlyByteBufferBuf = this;
        int readBytes = readOnlyByteBufferBuf.getBytes(readOnlyByteBufferBuf.readerIndex, out, (int)var2_3, true);
        this.readerIndex += readBytes;
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private int getBytes(int index, GatheringByteChannel out, int length, boolean internal) throws IOException {
        void var2_2;
        void var3_3;
        void var1_1;
        this.ensureAccessible();
        if (length == 0) {
            return 0;
        }
        ByteBuffer tmpBuf = this.nioBuffer(internal);
        tmpBuf.clear().position(index).limit((int)(var1_1 + var3_3));
        return var2_2.write(tmpBuf);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getBytes((int)var1_1, (FileChannel)var2_2, (long)var3_3, length, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readBytes(FileChannel out, long position, int length) throws IOException {
        void var1_2;
        void var2_3;
        this.checkReadableBytes(length);
        ReadOnlyByteBufferBuf readOnlyByteBufferBuf = this;
        int readBytes = readOnlyByteBufferBuf.getBytes(readOnlyByteBufferBuf.readerIndex, out, (long)var2_3, length, true);
        this.readerIndex += readBytes;
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private int getBytes(int index, FileChannel out, long position, int length, boolean internal) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.ensureAccessible();
        if (length == 0) {
            return 0;
        }
        ByteBuffer tmpBuf = this.nioBuffer(internal);
        tmpBuf.clear().position(index).limit((int)(var1_1 + length));
        return var2_2.write(tmpBuf, (long)var3_3);
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int index, FileChannel in, long position, int length) throws IOException {
        throw new ReadOnlyBufferException();
    }

    /*
     * WARNING - void declaration
     */
    protected final ByteBuffer internalNioBuffer() {
        void var1_1;
        ByteBuffer tmpNioBuf = this.tmpNioBuf;
        if (tmpNioBuf == null) {
            this.tmpNioBuf = tmpNioBuf = this.buffer.duplicate();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf copy(int index, int length) {
        void var1_2;
        void var3_4;
        void var2_3;
        ByteBuffer src;
        this.ensureAccessible();
        try {
            src = (ByteBuffer)this.buffer.duplicate().clear().position(index).limit(index + length);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException("Too many bytes to read - Need " + (index + length));
        }
        ByteBuf dst = src.isDirect() ? ((ByteBuf)this).alloc().directBuffer(length) : ((ByteBuf)this).alloc().heapBuffer((int)var2_3);
        dst.writeBytes((ByteBuffer)var3_4);
        return var1_2;
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer[] nioBuffers(int index, int length) {
        void var2_2;
        void var1_1;
        return new ByteBuffer[]{((ByteBuf)this).nioBuffer((int)var1_1, (int)var2_2)};
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer nioBuffer(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, length);
        return (ByteBuffer)this.buffer.duplicate().position(index).limit((int)(var1_1 + var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer internalNioBuffer(int index, int length) {
        void var2_2;
        void var1_1;
        this.ensureAccessible();
        return (ByteBuffer)this.internalNioBuffer().clear().position(index).limit((int)(var1_1 + var2_2));
    }

    @Override
    public final boolean isContiguous() {
        return true;
    }

    @Override
    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    private ByteBuffer nioBuffer(boolean internal) {
        if (internal) {
            return this.internalNioBuffer();
        }
        return this.buffer.duplicate();
    }

    @Override
    public ByteBuf duplicate() {
        return new ReadOnlyDuplicatedByteBuf(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf slice(int index, int length) {
        void var2_2;
        void var1_1;
        return new ReadOnlySlicedByteBuf(this, (int)var1_1, (int)var2_2);
    }

    @Override
    public ByteBuf asReadOnly() {
        return this;
    }

    private static final class ReadOnlyDuplicatedByteBuf
    extends DuplicatedByteBuf {
        /*
         * WARNING - void declaration
         */
        ReadOnlyDuplicatedByteBuf(ByteBuf buffer) {
            super((ByteBuf)var1_1);
            void var1_1;
        }

        @Override
        public final ByteBuf asReadOnly() {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteBuf slice(int index, int length) {
            void var2_2;
            void var1_1;
            return new ReadOnlySlicedByteBuf(this, (int)var1_1, (int)var2_2);
        }

        @Override
        public final ByteBuf duplicate() {
            return new ReadOnlyDuplicatedByteBuf(this);
        }

        @Override
        public final boolean isWritable() {
            return false;
        }

        @Override
        public final boolean isWritable(int numBytes) {
            return false;
        }

        @Override
        public final int ensureWritable(int minWritableBytes, boolean force) {
            return 1;
        }
    }

    private static final class ReadOnlySlicedByteBuf
    extends SlicedByteBuf {
        /*
         * WARNING - void declaration
         */
        ReadOnlySlicedByteBuf(ByteBuf buffer, int index, int length) {
            super((ByteBuf)var1_1, (int)var2_2, (int)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final ByteBuf asReadOnly() {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteBuf slice(int index, int length) {
            void var2_2;
            void var1_1;
            return new ReadOnlySlicedByteBuf(this, (int)var1_1, (int)var2_2);
        }

        @Override
        public final ByteBuf duplicate() {
            return ((ByteBuf)this).slice(0, ((ByteBuf)this).capacity()).setIndex(((ByteBuf)this).readerIndex(), ((ByteBuf)this).writerIndex());
        }

        @Override
        public final boolean isWritable() {
            return false;
        }

        @Override
        public final boolean isWritable(int numBytes) {
            return false;
        }

        @Override
        public final int ensureWritable(int minWritableBytes, boolean force) {
            return 1;
        }
    }
}

