/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PoolChunk;
import io.netty.buffer.PoolThreadCache;
import io.netty.buffer.PooledByteBuf;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.buffer.UnsafeDirectSwappedByteBuf;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

final class PooledUnsafeDirectByteBuf
extends PooledByteBuf<ByteBuffer> {
    private static final ObjectPool<PooledUnsafeDirectByteBuf> RECYCLER = ObjectPool.newPool((ObjectPool.ObjectCreator)new ObjectPool.ObjectCreator<PooledUnsafeDirectByteBuf>(){

        /*
         * WARNING - void declaration
         */
        public final PooledUnsafeDirectByteBuf newObject(ObjectPool.Handle<PooledUnsafeDirectByteBuf> handle) {
            void var1_1;
            return new PooledUnsafeDirectByteBuf((ObjectPool.Handle)var1_1, 0);
        }
    });
    private long memoryAddress;

    /*
     * WARNING - void declaration
     */
    static PooledUnsafeDirectByteBuf newInstance(int maxCapacity) {
        void var1_1;
        int n;
        PooledUnsafeDirectByteBuf buf = (PooledUnsafeDirectByteBuf)RECYCLER.get();
        buf.reuse(n);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private PooledUnsafeDirectByteBuf(ObjectPool.Handle<PooledUnsafeDirectByteBuf> recyclerHandle, int maxCapacity) {
        super(var1_1, (int)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void init(PoolChunk<ByteBuffer> chunk, ByteBuffer nioBuffer, long handle, int offset, int length, int maxLength, PoolThreadCache cache) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.init(var1_1, (ByteBuffer)var2_2, (long)var3_3, offset, length, maxLength, cache);
        this.initMemoryAddress();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void initUnpooled(PoolChunk<ByteBuffer> chunk, int length) {
        void var2_2;
        void var1_1;
        super.initUnpooled(var1_1, (int)var2_2);
        this.initMemoryAddress();
    }

    private void initMemoryAddress() {
        this.memoryAddress = PlatformDependent.directBufferAddress((ByteBuffer)((ByteBuffer)this.memory)) + (long)this.offset;
    }

    @Override
    protected final ByteBuffer newInternalNioBuffer(ByteBuffer memory) {
        return memory.duplicate();
    }

    @Override
    public final boolean isDirect() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final byte _getByte(int index) {
        void var1_1;
        return UnsafeByteBufUtil.getByte(this.addr((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final short _getShort(int index) {
        void var1_1;
        return UnsafeByteBufUtil.getShort(this.addr((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final short _getShortLE(int index) {
        void var1_1;
        return UnsafeByteBufUtil.getShortLE(this.addr((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int _getUnsignedMedium(int index) {
        void var1_1;
        return UnsafeByteBufUtil.getUnsignedMedium(this.addr((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int _getUnsignedMediumLE(int index) {
        void var1_1;
        return UnsafeByteBufUtil.getUnsignedMediumLE(this.addr((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int _getInt(int index) {
        void var1_1;
        return UnsafeByteBufUtil.getInt(this.addr((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int _getIntLE(int index) {
        void var1_1;
        return UnsafeByteBufUtil.getIntLE(this.addr((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final long _getLong(int index) {
        void var1_1;
        return UnsafeByteBufUtil.getLong(this.addr((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final long _getLongLE(int index) {
        void var1_1;
        return UnsafeByteBufUtil.getLongLE(this.addr((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(index), (int)var1_1, (ByteBuf)var2_2, (int)var3_3, length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(index), (int)var1_1, (byte[])var2_2, (int)var3_3, length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, ByteBuffer dst) {
        void var2_2;
        void var1_1;
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes(pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(index), (int)var1_1, (ByteBuffer)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes(pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(index), (int)var1_1, (OutputStream)var2_2, (int)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void _setByte(int index, int value) {
        void var2_2;
        void var1_1;
        UnsafeByteBufUtil.setByte(this.addr((int)var1_1), (byte)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void _setShort(int index, int value) {
        void var2_2;
        void var1_1;
        UnsafeByteBufUtil.setShort(this.addr((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void _setShortLE(int index, int value) {
        void var2_2;
        void var1_1;
        UnsafeByteBufUtil.setShortLE(this.addr((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void _setMedium(int index, int value) {
        void var2_2;
        void var1_1;
        UnsafeByteBufUtil.setMedium(this.addr((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void _setMediumLE(int index, int value) {
        void var2_2;
        void var1_1;
        UnsafeByteBufUtil.setMediumLE(this.addr((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void _setInt(int index, int value) {
        void var2_2;
        void var1_1;
        UnsafeByteBufUtil.setInt(this.addr((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void _setIntLE(int index, int value) {
        void var2_2;
        void var1_1;
        UnsafeByteBufUtil.setIntLE(this.addr((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void _setLong(int index, long value) {
        void var2_2;
        void var1_1;
        UnsafeByteBufUtil.setLong(this.addr((int)var1_1), (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void _setLongLE(int index, long value) {
        void var2_2;
        void var1_1;
        UnsafeByteBufUtil.setLongLE(this.addr((int)var1_1), (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(index), (int)var1_1, (ByteBuf)var2_2, (int)var3_3, length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(index), (int)var1_1, (byte[])var2_2, (int)var3_3, length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setBytes(int index, ByteBuffer src) {
        void var2_2;
        void var1_1;
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.setBytes(pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(index), (int)var1_1, (ByteBuffer)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int setBytes(int index, InputStream in, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        return UnsafeByteBufUtil.setBytes(pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(index), (int)var1_1, (InputStream)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf copy(int index, int length) {
        void var2_2;
        void var1_1;
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        return UnsafeByteBufUtil.copy(pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(index), (int)var1_1, (int)var2_2);
    }

    @Override
    public final boolean hasArray() {
        return false;
    }

    @Override
    public final byte[] array() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public final int arrayOffset() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public final boolean hasMemoryAddress() {
        return true;
    }

    @Override
    public final long memoryAddress() {
        this.ensureAccessible();
        return this.memoryAddress;
    }

    /*
     * WARNING - void declaration
     */
    private long addr(int index) {
        void var1_1;
        return this.memoryAddress + (long)var1_1;
    }

    @Override
    protected final SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeDirectSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setZero(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, length);
        UnsafeByteBufUtil.setZero(this.addr((int)var1_1), (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeZero(int length) {
        void var1_1;
        void var2_2;
        ((ByteBuf)this).ensureWritable(length);
        int wIndex = this.writerIndex;
        UnsafeByteBufUtil.setZero(this.addr(wIndex), length);
        this.writerIndex = var2_2 + var1_1;
        return this;
    }
}

