/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractPooledDerivedByteBuf;
import io.netty.buffer.AbstractUnpooledSlicedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.ObjectPool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

final class PooledSlicedByteBuf
extends AbstractPooledDerivedByteBuf {
    private static final ObjectPool<PooledSlicedByteBuf> RECYCLER = ObjectPool.newPool((ObjectPool.ObjectCreator)new ObjectPool.ObjectCreator<PooledSlicedByteBuf>(){

        /*
         * WARNING - void declaration
         */
        public final PooledSlicedByteBuf newObject(ObjectPool.Handle<PooledSlicedByteBuf> handle) {
            void var1_1;
            return new PooledSlicedByteBuf((ObjectPool.Handle)var1_1);
        }
    });
    int adjustment;

    /*
     * WARNING - void declaration
     */
    static PooledSlicedByteBuf newInstance(AbstractByteBuf unwrapped, ByteBuf wrapped, int index, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        AbstractByteBuf abstractByteBuf;
        AbstractUnpooledSlicedByteBuf.checkSliceOutOfBounds(index, length, unwrapped);
        return PooledSlicedByteBuf.newInstance0(abstractByteBuf, (ByteBuf)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static PooledSlicedByteBuf newInstance0(AbstractByteBuf unwrapped, ByteBuf wrapped, int adjustment, int length) {
        void var2_2;
        void var1_1;
        AbstractByteBuf abstractByteBuf;
        void var3_3;
        PooledSlicedByteBuf slice = (PooledSlicedByteBuf)RECYCLER.get();
        void v0 = var3_3;
        slice.init(abstractByteBuf, (ByteBuf)var1_1, 0, (int)v0, (int)v0);
        slice.discardMarks();
        slice.adjustment = var2_2;
        return slice;
    }

    /*
     * WARNING - void declaration
     */
    private PooledSlicedByteBuf(ObjectPool.Handle<PooledSlicedByteBuf> handle) {
        super((ObjectPool.Handle<? extends AbstractPooledDerivedByteBuf>)var1_1);
        void var1_1;
    }

    @Override
    public final int capacity() {
        return ((ByteBuf)this).maxCapacity();
    }

    @Override
    public final ByteBuf capacity(int newCapacity) {
        throw new UnsupportedOperationException("sliced buffer");
    }

    @Override
    public final int arrayOffset() {
        PooledSlicedByteBuf pooledSlicedByteBuf = this;
        return pooledSlicedByteBuf.idx(pooledSlicedByteBuf.unwrap().arrayOffset());
    }

    @Override
    public final long memoryAddress() {
        return this.unwrap().memoryAddress() + (long)this.adjustment;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuffer nioBuffer(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        return this.unwrap().nioBuffer(this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuffer[] nioBuffers(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        return this.unwrap().nioBuffers(this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf copy(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        return this.unwrap().copy(this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf slice(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        PooledSlicedByteBuf pooledSlicedByteBuf = this;
        return super.slice(pooledSlicedByteBuf.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf retainedSlice(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        PooledSlicedByteBuf pooledSlicedByteBuf = this;
        return PooledSlicedByteBuf.newInstance0(this.unwrap(), pooledSlicedByteBuf, pooledSlicedByteBuf.idx((int)var1_1), (int)var2_2);
    }

    @Override
    public final ByteBuf duplicate() {
        return ((ByteBuf)this).slice(0, ((ByteBuf)this).capacity()).setIndex(((ByteBuf)this).readerIndex(), ((ByteBuf)this).writerIndex());
    }

    @Override
    public final ByteBuf retainedDuplicate() {
        return ((ByteBuf)this).retainedSlice(0, ((ByteBuf)this).capacity()).setIndex(((ByteBuf)this).readerIndex(), ((ByteBuf)this).writerIndex());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final byte getByte(int index) {
        void var1_1;
        this.checkIndex0(index, 1);
        return ((ByteBuf)this.unwrap()).getByte(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final byte _getByte(int index) {
        void var1_1;
        return this.unwrap()._getByte(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final short getShort(int index) {
        void var1_1;
        this.checkIndex0(index, 2);
        return ((ByteBuf)this.unwrap()).getShort(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final short _getShort(int index) {
        void var1_1;
        return this.unwrap()._getShort(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final short getShortLE(int index) {
        void var1_1;
        this.checkIndex0(index, 2);
        return ((ByteBuf)this.unwrap()).getShortLE(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final short _getShortLE(int index) {
        void var1_1;
        return this.unwrap()._getShortLE(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getUnsignedMedium(int index) {
        void var1_1;
        this.checkIndex0(index, 3);
        return ((ByteBuf)this.unwrap()).getUnsignedMedium(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int _getUnsignedMedium(int index) {
        void var1_1;
        return this.unwrap()._getUnsignedMedium(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getUnsignedMediumLE(int index) {
        void var1_1;
        this.checkIndex0(index, 3);
        return ((ByteBuf)this.unwrap()).getUnsignedMediumLE(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int _getUnsignedMediumLE(int index) {
        void var1_1;
        return this.unwrap()._getUnsignedMediumLE(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getInt(int index) {
        void var1_1;
        this.checkIndex0(index, 4);
        return ((ByteBuf)this.unwrap()).getInt(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int _getInt(int index) {
        void var1_1;
        return this.unwrap()._getInt(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getIntLE(int index) {
        void var1_1;
        this.checkIndex0(index, 4);
        return ((ByteBuf)this.unwrap()).getIntLE(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int _getIntLE(int index) {
        void var1_1;
        return this.unwrap()._getIntLE(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long getLong(int index) {
        void var1_1;
        this.checkIndex0(index, 8);
        return ((ByteBuf)this.unwrap()).getLong(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final long _getLong(int index) {
        void var1_1;
        return this.unwrap()._getLong(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long getLongLE(int index) {
        void var1_1;
        this.checkIndex0(index, 8);
        return ((ByteBuf)this.unwrap()).getLongLE(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final long _getLongLE(int index) {
        void var1_1;
        return this.unwrap()._getLongLE(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        this.unwrap().getBytes(this.idx((int)var1_1), (ByteBuf)var2_2, (int)var3_3, length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        this.unwrap().getBytes(this.idx((int)var1_1), (byte[])var2_2, (int)var3_3, length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, ByteBuffer dst) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, dst.remaining());
        this.unwrap().getBytes(this.idx((int)var1_1), (ByteBuffer)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setByte(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, 1);
        ((ByteBuf)this.unwrap()).setByte(this.idx((int)var1_1), (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void _setByte(int index, int value) {
        void var2_2;
        void var1_1;
        this.unwrap()._setByte(this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setShort(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, 2);
        ((ByteBuf)this.unwrap()).setShort(this.idx((int)var1_1), (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void _setShort(int index, int value) {
        void var2_2;
        void var1_1;
        this.unwrap()._setShort(this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setShortLE(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, 2);
        ((ByteBuf)this.unwrap()).setShortLE(this.idx((int)var1_1), (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void _setShortLE(int index, int value) {
        void var2_2;
        void var1_1;
        this.unwrap()._setShortLE(this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setMedium(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, 3);
        ((ByteBuf)this.unwrap()).setMedium(this.idx((int)var1_1), (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void _setMedium(int index, int value) {
        void var2_2;
        void var1_1;
        this.unwrap()._setMedium(this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setMediumLE(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, 3);
        ((ByteBuf)this.unwrap()).setMediumLE(this.idx((int)var1_1), (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void _setMediumLE(int index, int value) {
        void var2_2;
        void var1_1;
        this.unwrap()._setMediumLE(this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setInt(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, 4);
        ((ByteBuf)this.unwrap()).setInt(this.idx((int)var1_1), (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void _setInt(int index, int value) {
        void var2_2;
        void var1_1;
        this.unwrap()._setInt(this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setIntLE(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, 4);
        ((ByteBuf)this.unwrap()).setIntLE(this.idx((int)var1_1), (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void _setIntLE(int index, int value) {
        void var2_2;
        void var1_1;
        this.unwrap()._setIntLE(this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setLong(int index, long value) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, 8);
        ((ByteBuf)this.unwrap()).setLong(this.idx((int)var1_1), (long)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void _setLong(int index, long value) {
        void var2_2;
        void var1_1;
        this.unwrap()._setLong(this.idx((int)var1_1), (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setLongLE(int index, long value) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, 8);
        ((ByteBuf)this.unwrap()).setLongLE(this.idx((int)var1_1), (long)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void _setLongLE(int index, long value) {
        void var2_2;
        void var1_1;
        ((ByteBuf)this.unwrap()).setLongLE(this.idx((int)var1_1), (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        this.unwrap().setBytes(this.idx((int)var1_1), (byte[])var2_2, (int)var3_3, length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        this.unwrap().setBytes(this.idx((int)var1_1), (ByteBuf)var2_2, (int)var3_3, length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setBytes(int index, ByteBuffer src) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, src.remaining());
        this.unwrap().setBytes(this.idx((int)var1_1), (ByteBuffer)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        this.unwrap().getBytes(this.idx((int)var1_1), (OutputStream)var2_2, (int)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        return this.unwrap().getBytes(this.idx((int)var1_1), (GatheringByteChannel)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        return this.unwrap().getBytes(this.idx((int)var1_1), (FileChannel)var2_2, (long)var3_3, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int setBytes(int index, InputStream in, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        return this.unwrap().setBytes(this.idx((int)var1_1), (InputStream)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        return this.unwrap().setBytes(this.idx((int)var1_1), (ScatteringByteChannel)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int setBytes(int index, FileChannel in, long position, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        return this.unwrap().setBytes(this.idx((int)var1_1), (FileChannel)var2_2, (long)var3_3, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int forEachByte(int index, int length, ByteProcessor processor) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.checkIndex0(index, length);
        int ret = ((ByteBuf)this.unwrap()).forEachByte(this.idx(index), (int)var2_2, (ByteProcessor)var3_3);
        if (ret < this.adjustment) {
            return -1;
        }
        return (int)(var1_1 - this.adjustment);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int forEachByteDesc(int index, int length, ByteProcessor processor) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.checkIndex0(index, length);
        int ret = ((ByteBuf)this.unwrap()).forEachByteDesc(this.idx(index), (int)var2_2, (ByteProcessor)var3_3);
        if (ret < this.adjustment) {
            return -1;
        }
        return (int)(var1_1 - this.adjustment);
    }

    private int idx(int index) {
        return index + this.adjustment;
    }
}

