/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.HeapByteBufUtil;
import io.netty.buffer.PooledByteBuf;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

class PooledHeapByteBuf
extends PooledByteBuf<byte[]> {
    private static final ObjectPool<PooledHeapByteBuf> RECYCLER = ObjectPool.newPool((ObjectPool.ObjectCreator)new ObjectPool.ObjectCreator<PooledHeapByteBuf>(){

        /*
         * WARNING - void declaration
         */
        public final PooledHeapByteBuf newObject(ObjectPool.Handle<PooledHeapByteBuf> handle) {
            void var1_1;
            return new PooledHeapByteBuf((ObjectPool.Handle<? extends PooledHeapByteBuf>)var1_1, 0);
        }
    });

    /*
     * WARNING - void declaration
     */
    static PooledHeapByteBuf newInstance(int maxCapacity) {
        void var1_1;
        int n;
        PooledHeapByteBuf buf = (PooledHeapByteBuf)RECYCLER.get();
        buf.reuse(n);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    PooledHeapByteBuf(ObjectPool.Handle<? extends PooledHeapByteBuf> recyclerHandle, int maxCapacity) {
        super(var1_1, (int)var2_2);
        void var2_2;
        void var1_1;
    }

    @Override
    public final boolean isDirect() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected byte _getByte(int index) {
        void var1_1;
        return HeapByteBufUtil.getByte((byte[])this.memory, this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected short _getShort(int index) {
        void var1_1;
        return HeapByteBufUtil.getShort((byte[])this.memory, this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected short _getShortLE(int index) {
        void var1_1;
        return HeapByteBufUtil.getShortLE((byte[])this.memory, this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getUnsignedMedium(int index) {
        void var1_1;
        return HeapByteBufUtil.getUnsignedMedium((byte[])this.memory, this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getUnsignedMediumLE(int index) {
        void var1_1;
        return HeapByteBufUtil.getUnsignedMediumLE((byte[])this.memory, this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getInt(int index) {
        void var1_1;
        return HeapByteBufUtil.getInt((byte[])this.memory, this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getIntLE(int index) {
        void var1_1;
        return HeapByteBufUtil.getIntLE((byte[])this.memory, this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected long _getLong(int index) {
        void var1_1;
        return HeapByteBufUtil.getLong((byte[])this.memory, this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected long _getLongLE(int index) {
        void var1_1;
        return HeapByteBufUtil.getLongLE((byte[])this.memory, this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.checkDstIndex(index, length, dstIndex, dst.capacity());
        if (dst.hasMemoryAddress()) {
            PlatformDependent.copyMemory((byte[])((byte[])this.memory), (int)this.idx(index), (long)(dst.memoryAddress() + (long)dstIndex), (long)length);
        } else if (dst.hasArray()) {
            ((ByteBuf)this).getBytes(index, dst.array(), dst.arrayOffset() + dstIndex, length);
        } else {
            void var1_1;
            void var3_3;
            void var2_2;
            var2_2.setBytes((int)var3_3, (byte[])this.memory, this.idx((int)var1_1), length);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkDstIndex(index, length, dstIndex, dst.length);
        System.arraycopy(this.memory, this.idx((int)var1_1), var2_2, (int)var3_3, length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, ByteBuffer dst) {
        void var3_3;
        void var1_1;
        void var2_2;
        int length = dst.remaining();
        this.checkIndex(index, length);
        var2_2.put((byte[])this.memory, this.idx((int)var1_1), (int)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        this.checkIndex(index, length);
        var2_2.write((byte[])this.memory, this.idx((int)var1_1), (int)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setByte(int index, int value) {
        void var2_2;
        void var1_1;
        HeapByteBufUtil.setByte((byte[])this.memory, this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setShort(int index, int value) {
        void var2_2;
        void var1_1;
        HeapByteBufUtil.setShort((byte[])this.memory, this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setShortLE(int index, int value) {
        void var2_2;
        void var1_1;
        HeapByteBufUtil.setShortLE((byte[])this.memory, this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setMedium(int index, int value) {
        void var2_2;
        void var1_1;
        HeapByteBufUtil.setMedium((byte[])this.memory, this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setMediumLE(int index, int value) {
        void var2_2;
        void var1_1;
        HeapByteBufUtil.setMediumLE((byte[])this.memory, this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setInt(int index, int value) {
        void var2_2;
        void var1_1;
        HeapByteBufUtil.setInt((byte[])this.memory, this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setIntLE(int index, int value) {
        void var2_2;
        void var1_1;
        HeapByteBufUtil.setIntLE((byte[])this.memory, this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setLong(int index, long value) {
        void var2_2;
        void var1_1;
        HeapByteBufUtil.setLong((byte[])this.memory, this.idx((int)var1_1), (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setLongLE(int index, long value) {
        void var2_2;
        void var1_1;
        HeapByteBufUtil.setLongLE((byte[])this.memory, this.idx((int)var1_1), (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.checkSrcIndex(index, length, srcIndex, src.capacity());
        if (src.hasMemoryAddress()) {
            PlatformDependent.copyMemory((long)(src.memoryAddress() + (long)srcIndex), (byte[])((byte[])this.memory), (int)this.idx(index), (long)length);
        } else if (src.hasArray()) {
            ((ByteBuf)this).setBytes(index, src.array(), src.arrayOffset() + srcIndex, length);
        } else {
            void var1_1;
            void var3_3;
            void var2_2;
            var2_2.getBytes((int)var3_3, (byte[])this.memory, this.idx((int)var1_1), length);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.checkSrcIndex(index, length, srcIndex, src.length);
        System.arraycopy(var2_2, (int)var3_3, this.memory, this.idx((int)var1_1), length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setBytes(int index, ByteBuffer src) {
        void var3_3;
        void var1_1;
        void var2_2;
        int length = src.remaining();
        this.checkIndex(index, length);
        var2_2.get((byte[])this.memory, this.idx((int)var1_1), (int)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int setBytes(int index, InputStream in, int length) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        this.checkIndex(index, length);
        return var2_2.read((byte[])this.memory, this.idx((int)var1_1), (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf copy(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, length);
        ByteBuf byteBuf = ((ByteBuf)this).alloc().heapBuffer(length, ((ByteBuf)this).maxCapacity());
        return byteBuf.writeBytes((byte[])this.memory, this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final ByteBuffer duplicateInternalNioBuffer(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, length);
        return ByteBuffer.wrap((byte[])this.memory, this.idx((int)var1_1), (int)var2_2).slice();
    }

    @Override
    public final boolean hasArray() {
        return true;
    }

    @Override
    public final byte[] array() {
        this.ensureAccessible();
        return (byte[])this.memory;
    }

    @Override
    public final int arrayOffset() {
        return this.offset;
    }

    @Override
    public final boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public final long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final ByteBuffer newInternalNioBuffer(byte[] memory) {
        return ByteBuffer.wrap(memory);
    }
}

