/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.PooledByteBuf;
import io.netty.util.internal.ObjectPool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

final class PooledDirectByteBuf
extends PooledByteBuf<ByteBuffer> {
    private static final ObjectPool<PooledDirectByteBuf> RECYCLER = ObjectPool.newPool((ObjectPool.ObjectCreator)new ObjectPool.ObjectCreator<PooledDirectByteBuf>(){

        /*
         * WARNING - void declaration
         */
        public final PooledDirectByteBuf newObject(ObjectPool.Handle<PooledDirectByteBuf> handle) {
            void var1_1;
            return new PooledDirectByteBuf((ObjectPool.Handle)var1_1, 0);
        }
    });

    /*
     * WARNING - void declaration
     */
    static PooledDirectByteBuf newInstance(int maxCapacity) {
        void var1_1;
        int n;
        PooledDirectByteBuf buf = (PooledDirectByteBuf)RECYCLER.get();
        buf.reuse(n);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private PooledDirectByteBuf(ObjectPool.Handle<PooledDirectByteBuf> recyclerHandle, int maxCapacity) {
        super(var1_1, (int)var2_2);
        void var2_2;
        void var1_1;
    }

    @Override
    protected final ByteBuffer newInternalNioBuffer(ByteBuffer memory) {
        return memory.duplicate();
    }

    @Override
    public final boolean isDirect() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final byte _getByte(int index) {
        void var1_1;
        return ((ByteBuffer)this.memory).get(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final short _getShort(int index) {
        void var1_1;
        return ((ByteBuffer)this.memory).getShort(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final short _getShortLE(int index) {
        void var1_1;
        return ByteBufUtil.swapShort(this._getShort((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int _getUnsignedMedium(int index) {
        void var1_1;
        index = this.idx(index);
        return (((ByteBuffer)this.memory).get(index) & 0xFF) << 16 | (((ByteBuffer)this.memory).get(index + 1) & 0xFF) << 8 | ((ByteBuffer)this.memory).get((int)(var1_1 + 2)) & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int _getUnsignedMediumLE(int index) {
        void var1_1;
        index = this.idx(index);
        return ((ByteBuffer)this.memory).get(index) & 0xFF | (((ByteBuffer)this.memory).get(index + 1) & 0xFF) << 8 | (((ByteBuffer)this.memory).get((int)(var1_1 + 2)) & 0xFF) << 16;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int _getInt(int index) {
        void var1_1;
        return ((ByteBuffer)this.memory).getInt(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int _getIntLE(int index) {
        void var1_1;
        return ByteBufUtil.swapInt(this._getInt((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final long _getLong(int index) {
        void var1_1;
        return ((ByteBuffer)this.memory).getLong(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final long _getLongLE(int index) {
        void var1_1;
        return ByteBufUtil.swapLong(this._getLong((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.checkDstIndex(index, length, dstIndex, dst.capacity());
        if (dst.hasArray()) {
            ((ByteBuf)this).getBytes(index, dst.array(), dst.arrayOffset() + dstIndex, length);
        } else if (dst.nioBufferCount() > 0) {
            for (ByteBuffer bb : dst.nioBuffers(dstIndex, length)) {
                int bbLen = bb.remaining();
                ((ByteBuf)this).getBytes(index, bb);
                index += bbLen;
            }
        } else {
            void var1_1;
            void var3_3;
            void var2_2;
            var2_2.setBytes((int)var3_3, this, (int)var1_1, length);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkDstIndex(index, length, dstIndex, dst.length);
        this._internalNioBuffer((int)var1_1, length, true).get((byte[])var2_2, (int)var3_3, length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf readBytes(byte[] dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkDstIndex(length, dstIndex, dst.length);
        PooledDirectByteBuf pooledDirectByteBuf = this;
        pooledDirectByteBuf._internalNioBuffer(pooledDirectByteBuf.readerIndex, length, false).get((byte[])var1_1, (int)var2_2, length);
        this.readerIndex += var3_3;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, ByteBuffer dst) {
        void var2_2;
        void var1_1;
        dst.put(this.duplicateInternalNioBuffer((int)var1_1, var2_2.remaining()));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf readBytes(ByteBuffer dst) {
        void var2_2;
        void var1_1;
        int length = dst.remaining();
        this.checkReadableBytes(length);
        PooledDirectByteBuf pooledDirectByteBuf = this;
        var1_1.put(pooledDirectByteBuf._internalNioBuffer(pooledDirectByteBuf.readerIndex, length, false));
        this.readerIndex += var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.getBytes((int)var1_1, (OutputStream)var2_2, (int)var3_3, false);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void getBytes(int index, OutputStream out, int length, boolean internal) throws IOException {
        void var2_2;
        void var3_3;
        void var1_1;
        this.checkIndex(index, length);
        if (length == 0) {
            return;
        }
        ByteBufUtil.readBytes(((ByteBuf)this).alloc(), internal ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate(), this.idx((int)var1_1), (int)var3_3, (OutputStream)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf readBytes(OutputStream out, int length) throws IOException {
        void var2_2;
        void var1_1;
        this.checkReadableBytes(length);
        PooledDirectByteBuf pooledDirectByteBuf = this;
        pooledDirectByteBuf.getBytes(pooledDirectByteBuf.readerIndex, (OutputStream)var1_1, length, true);
        this.readerIndex += var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void _setByte(int index, int value) {
        void var2_2;
        void var1_1;
        ((ByteBuffer)this.memory).put(this.idx((int)var1_1), (byte)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void _setShort(int index, int value) {
        void var2_2;
        void var1_1;
        ((ByteBuffer)this.memory).putShort(this.idx((int)var1_1), (short)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void _setShortLE(int index, int value) {
        void var2_2;
        void var1_1;
        this._setShort((int)var1_1, ByteBufUtil.swapShort((short)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void _setMedium(int index, int value) {
        void var2_2;
        void var1_1;
        index = this.idx(index);
        ((ByteBuffer)this.memory).put(index, (byte)(value >>> 16));
        ((ByteBuffer)this.memory).put(index + 1, (byte)(value >>> 8));
        ((ByteBuffer)this.memory).put((int)(var1_1 + 2), (byte)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void _setMediumLE(int index, int value) {
        void var2_2;
        void var1_1;
        index = this.idx(index);
        ((ByteBuffer)this.memory).put(index, (byte)value);
        ((ByteBuffer)this.memory).put(index + 1, (byte)(value >>> 8));
        ((ByteBuffer)this.memory).put((int)(var1_1 + 2), (byte)(var2_2 >>> 16));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void _setInt(int index, int value) {
        void var2_2;
        void var1_1;
        ((ByteBuffer)this.memory).putInt(this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void _setIntLE(int index, int value) {
        void var2_2;
        void var1_1;
        this._setInt((int)var1_1, ByteBufUtil.swapInt((int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void _setLong(int index, long value) {
        void var2_2;
        void var1_1;
        ((ByteBuffer)this.memory).putLong(this.idx((int)var1_1), (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void _setLongLE(int index, long value) {
        void var2_2;
        void var1_1;
        this._setLong((int)var1_1, ByteBufUtil.swapLong((long)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.checkSrcIndex(index, length, srcIndex, src.capacity());
        if (src.hasArray()) {
            ((ByteBuf)this).setBytes(index, src.array(), src.arrayOffset() + srcIndex, length);
        } else if (src.nioBufferCount() > 0) {
            for (ByteBuffer bb : src.nioBuffers(srcIndex, length)) {
                int bbLen = bb.remaining();
                ((ByteBuf)this).setBytes(index, bb);
                index += bbLen;
            }
        } else {
            void var1_1;
            void var3_3;
            void var2_2;
            var2_2.getBytes((int)var3_3, this, (int)var1_1, length);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkSrcIndex(index, length, srcIndex, src.length);
        this._internalNioBuffer((int)var1_1, length, false).put((byte[])var2_2, (int)var3_3, length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setBytes(int index, ByteBuffer src) {
        void var2_2;
        void var1_1;
        void var3_3;
        int length = src.remaining();
        this.checkIndex(index, length);
        ByteBuffer tmpBuf = this.internalNioBuffer();
        if (src == tmpBuf) {
            src = src.duplicate();
        }
        index = this.idx(index);
        tmpBuf.limit(index + var3_3).position((int)var1_1);
        tmpBuf.put((ByteBuffer)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int setBytes(int index, InputStream in, int length) throws IOException {
        void var2_3;
        void var3_5;
        void var1_1;
        this.checkIndex(index, length);
        byte[] tmp = ByteBufUtil.threadLocalTempArray(length);
        int readBytes = in.read(tmp, 0, length);
        if (readBytes <= 0) {
            return readBytes;
        }
        ByteBuffer tmpBuf = this.internalNioBuffer();
        tmpBuf.position(this.idx((int)var1_1));
        var3_5.put(tmp, 0, readBytes);
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf copy(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, length);
        ByteBuf byteBuf = ((ByteBuf)this).alloc().directBuffer(length, ((ByteBuf)this).maxCapacity());
        return byteBuf.writeBytes(this, (int)var1_1, (int)var2_2);
    }

    @Override
    public final boolean hasArray() {
        return false;
    }

    @Override
    public final byte[] array() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public final int arrayOffset() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public final boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public final long memoryAddress() {
        throw new UnsupportedOperationException();
    }
}

