/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufAllocatorMetricProvider;
import io.netty.buffer.PoolArena;
import io.netty.buffer.PoolArenaMetric;
import io.netty.buffer.PoolThreadCache;
import io.netty.buffer.PooledByteBufAllocatorMetric;
import io.netty.buffer.SizeClasses;
import io.netty.buffer.UnpooledDirectByteBuf;
import io.netty.buffer.UnpooledHeapByteBuf;
import io.netty.buffer.UnpooledUnsafeHeapByteBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThreadExecutorMap;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class PooledByteBufAllocator
extends AbstractByteBufAllocator
implements ByteBufAllocatorMetricProvider {
    private static final InternalLogger logger;
    private static final int DEFAULT_NUM_HEAP_ARENA;
    private static final int DEFAULT_NUM_DIRECT_ARENA;
    private static final int DEFAULT_PAGE_SIZE;
    private static final int DEFAULT_MAX_ORDER;
    private static final int DEFAULT_SMALL_CACHE_SIZE;
    private static final int DEFAULT_NORMAL_CACHE_SIZE;
    static final int DEFAULT_MAX_CACHED_BUFFER_CAPACITY;
    private static final int DEFAULT_CACHE_TRIM_INTERVAL;
    private static final long DEFAULT_CACHE_TRIM_INTERVAL_MILLIS;
    private static final boolean DEFAULT_USE_CACHE_FOR_ALL_THREADS;
    private static final int DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT;
    static final int DEFAULT_MAX_CACHED_BYTEBUFFERS_PER_CHUNK;
    private static final boolean DEFAULT_DISABLE_CACHE_FINALIZERS_FOR_FAST_THREAD_LOCAL_THREADS;
    private static final int MIN_PAGE_SIZE = 4096;
    private static final int MAX_CHUNK_SIZE = 0x40000000;
    private static final int CACHE_NOT_USED = 0;
    private final Runnable trimTask = new Runnable(this){
        final /* synthetic */ PooledByteBufAllocator this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public void run() {
            this.this$0.trimCurrentThreadCache();
        }
    };
    public static final PooledByteBufAllocator DEFAULT;
    private final PoolArena<byte[]>[] heapArenas;
    private final PoolArena<ByteBuffer>[] directArenas;
    private final int smallCacheSize;
    private final int normalCacheSize;
    private final List<PoolArenaMetric> heapArenaMetrics;
    private final List<PoolArenaMetric> directArenaMetrics;
    private final PoolThreadLocalCache threadCache;
    private final int chunkSize;
    private final PooledByteBufAllocatorMetric metric;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PooledByteBufAllocator() {
        this(false);
    }

    /*
     * WARNING - void declaration
     */
    public PooledByteBufAllocator(boolean preferDirect) {
        this((boolean)var1_1, DEFAULT_NUM_HEAP_ARENA, DEFAULT_NUM_DIRECT_ARENA, DEFAULT_PAGE_SIZE, DEFAULT_MAX_ORDER);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PooledByteBufAllocator(int nHeapArena, int nDirectArena, int pageSize, int maxOrder) {
        this(false, (int)var1_1, (int)var2_2, (int)var3_3, maxOrder);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public PooledByteBufAllocator(boolean preferDirect, int nHeapArena, int nDirectArena, int pageSize, int maxOrder) {
        this((boolean)var1_1, (int)var2_2, (int)var3_3, pageSize, maxOrder, 0, DEFAULT_SMALL_CACHE_SIZE, DEFAULT_NORMAL_CACHE_SIZE);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public PooledByteBufAllocator(boolean preferDirect, int nHeapArena, int nDirectArena, int pageSize, int maxOrder, int tinyCacheSize, int smallCacheSize, int normalCacheSize) {
        this((boolean)var1_1, (int)var2_2, (int)var3_3, pageSize, maxOrder, smallCacheSize, normalCacheSize, DEFAULT_USE_CACHE_FOR_ALL_THREADS, DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public PooledByteBufAllocator(boolean preferDirect, int nHeapArena, int nDirectArena, int pageSize, int maxOrder, int tinyCacheSize, int smallCacheSize, int normalCacheSize, boolean useCacheForAllThreads) {
        this((boolean)var1_1, (int)var2_2, (int)var3_3, pageSize, maxOrder, smallCacheSize, normalCacheSize, useCacheForAllThreads);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PooledByteBufAllocator(boolean preferDirect, int nHeapArena, int nDirectArena, int pageSize, int maxOrder, int smallCacheSize, int normalCacheSize, boolean useCacheForAllThreads) {
        this((boolean)var1_1, (int)var2_2, (int)var3_3, pageSize, maxOrder, smallCacheSize, normalCacheSize, useCacheForAllThreads, DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public PooledByteBufAllocator(boolean preferDirect, int nHeapArena, int nDirectArena, int pageSize, int maxOrder, int tinyCacheSize, int smallCacheSize, int normalCacheSize, boolean useCacheForAllThreads, int directMemoryCacheAlignment) {
        this((boolean)var1_1, (int)var2_2, (int)var3_3, pageSize, maxOrder, smallCacheSize, normalCacheSize, useCacheForAllThreads, directMemoryCacheAlignment);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PooledByteBufAllocator(boolean preferDirect, int nHeapArena, int nDirectArena, int pageSize, int maxOrder, int smallCacheSize, int normalCacheSize, boolean useCacheForAllThreads, int directMemoryCacheAlignment) {
        super(preferDirect);
        int i;
        this.threadCache = new PoolThreadLocalCache(useCacheForAllThreads);
        this.smallCacheSize = smallCacheSize;
        this.normalCacheSize = normalCacheSize;
        if (directMemoryCacheAlignment != 0) {
            if (!PlatformDependent.hasAlignDirectByteBuffer()) {
                throw new UnsupportedOperationException("Buffer alignment is not supported. Either Unsafe or ByteBuffer.alignSlice() must be available.");
            }
            pageSize = (int)PlatformDependent.align((long)pageSize, (int)directMemoryCacheAlignment);
        }
        this.chunkSize = PooledByteBufAllocator.validateAndCalculateChunkSize(pageSize, maxOrder);
        ObjectUtil.checkPositiveOrZero((int)nHeapArena, (String)"nHeapArena");
        ObjectUtil.checkPositiveOrZero((int)nDirectArena, (String)"nDirectArena");
        ObjectUtil.checkPositiveOrZero((int)directMemoryCacheAlignment, (String)"directMemoryCacheAlignment");
        if (directMemoryCacheAlignment > 0 && !PooledByteBufAllocator.isDirectMemoryCacheAlignmentSupported()) {
            throw new IllegalArgumentException("directMemoryCacheAlignment is not supported");
        }
        int n = directMemoryCacheAlignment;
        if ((n & -n) != directMemoryCacheAlignment) {
            throw new IllegalArgumentException("directMemoryCacheAlignment: " + directMemoryCacheAlignment + " (expected: power of two)");
        }
        int pageShifts = PooledByteBufAllocator.validateAndCalculatePageShifts(pageSize, directMemoryCacheAlignment);
        if (nHeapArena > 0) {
            this.heapArenas = PooledByteBufAllocator.newArenaArray(nHeapArena);
            ArrayList<PoolArena.HeapArena> metrics = new ArrayList<PoolArena.HeapArena>(this.heapArenas.length);
            SizeClasses sizeClasses = new SizeClasses(pageSize, pageShifts, this.chunkSize, 0);
            for (i = 0; i < this.heapArenas.length; ++i) {
                PoolArena.HeapArena arena;
                this.heapArenas[i] = arena = new PoolArena.HeapArena(this, sizeClasses);
                metrics.add(arena);
            }
            this.heapArenaMetrics = Collections.unmodifiableList(metrics);
        } else {
            this.heapArenas = null;
            this.heapArenaMetrics = Collections.emptyList();
        }
        if (nDirectArena > 0) {
            void var2_4;
            void var1_1;
            void var3_5;
            this.directArenas = PooledByteBufAllocator.newArenaArray((int)var3_5);
            ArrayList<PoolArena.DirectArena> metrics = new ArrayList<PoolArena.DirectArena>(this.directArenas.length);
            SizeClasses sizeClasses = new SizeClasses(pageSize, (int)var1_1, this.chunkSize, directMemoryCacheAlignment);
            for (i = 0; i < this.directArenas.length; ++i) {
                PoolArena.DirectArena arena;
                this.directArenas[i] = arena = new PoolArena.DirectArena(this, sizeClasses);
                metrics.add(arena);
            }
            this.directArenaMetrics = Collections.unmodifiableList(var2_4);
        } else {
            this.directArenas = null;
            this.directArenaMetrics = Collections.emptyList();
        }
        this.metric = new PooledByteBufAllocatorMetric(this);
    }

    private static <T> PoolArena<T>[] newArenaArray(int size) {
        return new PoolArena[size];
    }

    /*
     * WARNING - void declaration
     */
    private static int validateAndCalculatePageShifts(int pageSize, int alignment) {
        int n;
        if (pageSize < 4096) {
            throw new IllegalArgumentException("pageSize: " + pageSize + " (expected: 4096" + ')');
        }
        int n2 = pageSize;
        if ((n2 & n2 - 1) != 0) {
            throw new IllegalArgumentException("pageSize: " + pageSize + " (expected: power of 2)");
        }
        if (pageSize < alignment) {
            void var1_1;
            throw new IllegalArgumentException("Alignment cannot be greater than page size. Alignment: " + (int)var1_1 + ", page size: " + pageSize + '.');
        }
        return 31 - Integer.numberOfLeadingZeros(n);
    }

    /*
     * WARNING - void declaration
     */
    private static int validateAndCalculateChunkSize(int pageSize, int maxOrder) {
        void var2_2;
        if (maxOrder > 14) {
            throw new IllegalArgumentException("maxOrder: " + maxOrder + " (expected: 0-14)");
        }
        int chunkSize = pageSize;
        for (int i = maxOrder; i > 0; --i) {
            if (chunkSize > 0x20000000) {
                throw new IllegalArgumentException(String.format("pageSize (%d) << maxOrder (%d) must not exceed %d", pageSize, maxOrder, 0x40000000));
            }
            chunkSize <<= 1;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected ByteBuf newHeapBuffer(int initialCapacity, int maxCapacity) {
        void var2_3;
        void var1_1;
        void var3_4;
        PoolThreadCache cache = (PoolThreadCache)this.threadCache.get();
        PoolArena<byte[]> heapArena = cache.heapArena;
        AbstractReferenceCountedByteBuf abstractReferenceCountedByteBuf = heapArena != null ? heapArena.allocate((PoolThreadCache)var3_4, initialCapacity, maxCapacity) : (PlatformDependent.hasUnsafe() ? new UnpooledUnsafeHeapByteBuf((ByteBufAllocator)this, initialCapacity, maxCapacity) : new UnpooledHeapByteBuf((ByteBufAllocator)this, (int)var1_1, (int)var2_3));
        return PooledByteBufAllocator.toLeakAwareBuffer(abstractReferenceCountedByteBuf);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected ByteBuf newDirectBuffer(int initialCapacity, int maxCapacity) {
        void var2_3;
        void var1_1;
        void var3_4;
        PoolThreadCache cache = (PoolThreadCache)this.threadCache.get();
        PoolArena<ByteBuffer> directArena = cache.directArena;
        AbstractReferenceCountedByteBuf abstractReferenceCountedByteBuf = directArena != null ? directArena.allocate((PoolThreadCache)var3_4, initialCapacity, maxCapacity) : (PlatformDependent.hasUnsafe() ? UnsafeByteBufUtil.newUnsafeDirectByteBuf(this, initialCapacity, maxCapacity) : new UnpooledDirectByteBuf((ByteBufAllocator)this, (int)var1_1, (int)var2_3));
        return PooledByteBufAllocator.toLeakAwareBuffer(abstractReferenceCountedByteBuf);
    }

    public static int defaultNumHeapArena() {
        return DEFAULT_NUM_HEAP_ARENA;
    }

    public static int defaultNumDirectArena() {
        return DEFAULT_NUM_DIRECT_ARENA;
    }

    public static int defaultPageSize() {
        return DEFAULT_PAGE_SIZE;
    }

    public static int defaultMaxOrder() {
        return DEFAULT_MAX_ORDER;
    }

    public static boolean defaultDisableCacheFinalizersForFastThreadLocalThreads() {
        return DEFAULT_DISABLE_CACHE_FINALIZERS_FOR_FAST_THREAD_LOCAL_THREADS;
    }

    public static boolean defaultUseCacheForAllThreads() {
        return DEFAULT_USE_CACHE_FOR_ALL_THREADS;
    }

    public static boolean defaultPreferDirect() {
        return PlatformDependent.directBufferPreferred();
    }

    @Deprecated
    public static int defaultTinyCacheSize() {
        return 0;
    }

    public static int defaultSmallCacheSize() {
        return DEFAULT_SMALL_CACHE_SIZE;
    }

    public static int defaultNormalCacheSize() {
        return DEFAULT_NORMAL_CACHE_SIZE;
    }

    public static boolean isDirectMemoryCacheAlignmentSupported() {
        return PlatformDependent.hasUnsafe();
    }

    @Override
    public boolean isDirectBufferPooled() {
        return this.directArenas != null;
    }

    @Deprecated
    public boolean hasThreadLocalCache() {
        return this.threadCache.isSet();
    }

    @Deprecated
    public void freeThreadLocalCache() {
        this.threadCache.remove();
    }

    private static boolean useCacheFinalizers(Thread current) {
        Thread thread;
        if (!PooledByteBufAllocator.defaultDisableCacheFinalizersForFastThreadLocalThreads()) {
            return true;
        }
        return current instanceof FastThreadLocalThread && ((FastThreadLocalThread)thread).willCleanupFastThreadLocals();
    }

    @Override
    public PooledByteBufAllocatorMetric metric() {
        return this.metric;
    }

    @Deprecated
    public int numHeapArenas() {
        return this.heapArenaMetrics.size();
    }

    @Deprecated
    public int numDirectArenas() {
        return this.directArenaMetrics.size();
    }

    @Deprecated
    public List<PoolArenaMetric> heapArenas() {
        return this.heapArenaMetrics;
    }

    @Deprecated
    public List<PoolArenaMetric> directArenas() {
        return this.directArenaMetrics;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public int numThreadLocalCaches() {
        void var2_2;
        void var1_1;
        PoolArena<Object>[] arenas = this.heapArenas != null ? this.heapArenas : this.directArenas;
        if (arenas == null) {
            return 0;
        }
        int total = 0;
        for (void arena : var1_1) {
            total += arena.numThreadCaches.get();
        }
        return (int)var2_2;
    }

    @Deprecated
    public int tinyCacheSize() {
        return 0;
    }

    @Deprecated
    public int smallCacheSize() {
        return this.smallCacheSize;
    }

    @Deprecated
    public int normalCacheSize() {
        return this.normalCacheSize;
    }

    @Deprecated
    public final int chunkSize() {
        return this.chunkSize;
    }

    final long usedHeapMemory() {
        return PooledByteBufAllocator.usedMemory(this.heapArenas);
    }

    final long usedDirectMemory() {
        return PooledByteBufAllocator.usedMemory(this.directArenas);
    }

    /*
     * WARNING - void declaration
     */
    private static long usedMemory(PoolArena<?>[] arenas) {
        void var1_1;
        PoolArena<?>[] poolArenaArray;
        if (arenas == null) {
            return -1L;
        }
        long used = 0L;
        for (PoolArena<?> arena : poolArenaArray) {
            if ((used += arena.numActiveBytes()) >= 0L) continue;
            return Long.MAX_VALUE;
        }
        return (long)var1_1;
    }

    public final long pinnedHeapMemory() {
        return PooledByteBufAllocator.pinnedMemory(this.heapArenas);
    }

    public final long pinnedDirectMemory() {
        return PooledByteBufAllocator.pinnedMemory(this.directArenas);
    }

    /*
     * WARNING - void declaration
     */
    private static long pinnedMemory(PoolArena<?>[] arenas) {
        void var1_1;
        PoolArena<?>[] poolArenaArray;
        if (arenas == null) {
            return -1L;
        }
        long used = 0L;
        for (PoolArena<?> arena : poolArenaArray) {
            if ((used += arena.numPinnedBytes()) >= 0L) continue;
            return Long.MAX_VALUE;
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final PoolThreadCache threadCache() {
        void var1_1;
        PoolThreadCache cache = (PoolThreadCache)this.threadCache.get();
        if (!$assertionsDisabled && cache == null) {
            throw new AssertionError();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean trimCurrentThreadCache() {
        PoolThreadCache cache = (PoolThreadCache)this.threadCache.getIfExists();
        if (cache != null) {
            void var1_1;
            var1_1.trim();
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public String dumpStats() {
        void var2_4;
        int n;
        int heapArenasLen2 = this.heapArenas == null ? 0 : this.heapArenas.length;
        StringBuilder buf = new StringBuilder(512).append(heapArenasLen2).append(" heap arena(s):").append(StringUtil.NEWLINE);
        if (heapArenasLen2 > 0) {
            PoolArena<byte[]>[] heapArenasLen2 = this.heapArenas;
            int n2 = this.heapArenas.length;
            for (n = 0; n < n2; ++n) {
                PoolArena<byte[]> a = heapArenasLen2[n];
                buf.append(a);
            }
        }
        int directArenasLen = this.directArenas == null ? 0 : this.directArenas.length;
        buf.append(directArenasLen).append(" direct arena(s):").append(StringUtil.NEWLINE);
        if (directArenasLen > 0) {
            PoolArena<ByteBuffer>[] poolArenaArray = this.directArenas;
            n = this.directArenas.length;
            for (int i = 0; i < n; ++i) {
                void var1_3;
                PoolArena<ByteBuffer> a = poolArenaArray[i];
                buf.append(var1_3);
            }
        }
        return var2_4.toString();
    }

    /*
     * Unable to fully structure code
     */
    static {
        PooledByteBufAllocator.$assertionsDisabled = PooledByteBufAllocator.class.desiredAssertionStatus() == false;
        PooledByteBufAllocator.logger = InternalLoggerFactory.getInstance(PooledByteBufAllocator.class);
        defaultAlignment = SystemPropertyUtil.getInt((String)"io.netty.allocator.directMemoryCacheAlignment", (int)0);
        defaultPageSize = SystemPropertyUtil.getInt((String)"io.netty.allocator.pageSize", (int)8192);
        pageSizeFallbackCause = null;
        try {
            PooledByteBufAllocator.validateAndCalculatePageShifts(defaultPageSize, defaultAlignment);
        }
        catch (Throwable v0) {
            defaultAlignment = v0;
            pageSizeFallbackCause = v0;
            defaultPageSize = 8192;
            defaultAlignment = 0;
        }
        PooledByteBufAllocator.DEFAULT_PAGE_SIZE = defaultPageSize;
        PooledByteBufAllocator.DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT = defaultAlignment;
        defaultMaxOrder = SystemPropertyUtil.getInt((String)"io.netty.allocator.maxOrder", (int)9);
        maxOrderFallbackCause = null;
        try {
            PooledByteBufAllocator.validateAndCalculateChunkSize(PooledByteBufAllocator.DEFAULT_PAGE_SIZE, defaultMaxOrder);
        }
        catch (Throwable v1) {
            defaultMaxOrder = v1;
            maxOrderFallbackCause = v1;
            defaultMaxOrder = 9;
        }
        PooledByteBufAllocator.DEFAULT_MAX_ORDER = defaultMaxOrder;
        runtime = Runtime.getRuntime();
        defaultMinNumArena = NettyRuntime.availableProcessors() << 1;
        defaultChunkSize = PooledByteBufAllocator.DEFAULT_PAGE_SIZE << PooledByteBufAllocator.DEFAULT_MAX_ORDER;
        PooledByteBufAllocator.DEFAULT_NUM_HEAP_ARENA = Math.max(0, SystemPropertyUtil.getInt((String)"io.netty.allocator.numHeapArenas", (int)((int)Math.min((long)defaultMinNumArena, var0_3.maxMemory() / (long)defaultChunkSize / 2L / 3L))));
        PooledByteBufAllocator.DEFAULT_NUM_DIRECT_ARENA = Math.max(0, SystemPropertyUtil.getInt((String)"io.netty.allocator.numDirectArenas", (int)((int)Math.min((long)var3_7, PlatformDependent.maxDirectMemory() / (long)defaultChunkSize / 2L / 3L))));
        PooledByteBufAllocator.DEFAULT_SMALL_CACHE_SIZE = SystemPropertyUtil.getInt((String)"io.netty.allocator.smallCacheSize", (int)256);
        PooledByteBufAllocator.DEFAULT_NORMAL_CACHE_SIZE = SystemPropertyUtil.getInt((String)"io.netty.allocator.normalCacheSize", (int)64);
        PooledByteBufAllocator.DEFAULT_MAX_CACHED_BUFFER_CAPACITY = SystemPropertyUtil.getInt((String)"io.netty.allocator.maxCachedBufferCapacity", (int)32768);
        PooledByteBufAllocator.DEFAULT_CACHE_TRIM_INTERVAL = SystemPropertyUtil.getInt((String)"io.netty.allocator.cacheTrimInterval", (int)8192);
        if (!SystemPropertyUtil.contains((String)"io.netty.allocation.cacheTrimIntervalMillis")) ** GOTO lbl-1000
        PooledByteBufAllocator.logger.warn("-Dio.netty.allocation.cacheTrimIntervalMillis is deprecated, use -Dio.netty.allocator.cacheTrimIntervalMillis");
        if (!SystemPropertyUtil.contains((String)"io.netty.allocator.cacheTrimIntervalMillis")) {
            PooledByteBufAllocator.DEFAULT_CACHE_TRIM_INTERVAL_MILLIS = SystemPropertyUtil.getLong((String)"io.netty.allocation.cacheTrimIntervalMillis", (long)0L);
        } else lbl-1000:
        // 2 sources

        {
            PooledByteBufAllocator.DEFAULT_CACHE_TRIM_INTERVAL_MILLIS = SystemPropertyUtil.getLong((String)"io.netty.allocator.cacheTrimIntervalMillis", (long)0L);
        }
        PooledByteBufAllocator.DEFAULT_USE_CACHE_FOR_ALL_THREADS = SystemPropertyUtil.getBoolean((String)"io.netty.allocator.useCacheForAllThreads", (boolean)false);
        PooledByteBufAllocator.DEFAULT_DISABLE_CACHE_FINALIZERS_FOR_FAST_THREAD_LOCAL_THREADS = SystemPropertyUtil.getBoolean((String)"io.netty.allocator.disableCacheFinalizersForFastThreadLocalThreads", (boolean)false);
        PooledByteBufAllocator.DEFAULT_MAX_CACHED_BYTEBUFFERS_PER_CHUNK = SystemPropertyUtil.getInt((String)"io.netty.allocator.maxCachedByteBuffersPerChunk", (int)1023);
        if (PooledByteBufAllocator.logger.isDebugEnabled()) {
            PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.numHeapArenas: {}", (Object)PooledByteBufAllocator.DEFAULT_NUM_HEAP_ARENA);
            PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.numDirectArenas: {}", (Object)PooledByteBufAllocator.DEFAULT_NUM_DIRECT_ARENA);
            if (pageSizeFallbackCause == null) {
                PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.pageSize: {}", (Object)PooledByteBufAllocator.DEFAULT_PAGE_SIZE);
            } else {
                PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.pageSize: {}", (Object)PooledByteBufAllocator.DEFAULT_PAGE_SIZE, (Object)var2_6);
            }
            if (maxOrderFallbackCause == null) {
                PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.maxOrder: {}", (Object)PooledByteBufAllocator.DEFAULT_MAX_ORDER);
            } else {
                PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.maxOrder: {}", (Object)PooledByteBufAllocator.DEFAULT_MAX_ORDER, (Object)var1_5);
            }
            PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.chunkSize: {}", (Object)(PooledByteBufAllocator.DEFAULT_PAGE_SIZE << PooledByteBufAllocator.DEFAULT_MAX_ORDER));
            PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.smallCacheSize: {}", (Object)PooledByteBufAllocator.DEFAULT_SMALL_CACHE_SIZE);
            PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.normalCacheSize: {}", (Object)PooledByteBufAllocator.DEFAULT_NORMAL_CACHE_SIZE);
            PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.maxCachedBufferCapacity: {}", (Object)PooledByteBufAllocator.DEFAULT_MAX_CACHED_BUFFER_CAPACITY);
            PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.cacheTrimInterval: {}", (Object)PooledByteBufAllocator.DEFAULT_CACHE_TRIM_INTERVAL);
            PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.cacheTrimIntervalMillis: {}", (Object)PooledByteBufAllocator.DEFAULT_CACHE_TRIM_INTERVAL_MILLIS);
            PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.useCacheForAllThreads: {}", (Object)PooledByteBufAllocator.DEFAULT_USE_CACHE_FOR_ALL_THREADS);
            PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.maxCachedByteBuffersPerChunk: {}", (Object)PooledByteBufAllocator.DEFAULT_MAX_CACHED_BYTEBUFFERS_PER_CHUNK);
            PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.disableCacheFinalizersForFastThreadLocalThreads: {}", (Object)PooledByteBufAllocator.DEFAULT_DISABLE_CACHE_FINALIZERS_FOR_FAST_THREAD_LOCAL_THREADS);
        }
        PooledByteBufAllocator.DEFAULT = new PooledByteBufAllocator(PlatformDependent.directBufferPreferred());
    }

    private final class PoolThreadLocalCache
    extends FastThreadLocal<PoolThreadCache> {
        private final boolean useCacheForAllThreads;

        /*
         * WARNING - void declaration
         */
        PoolThreadLocalCache(boolean useCacheForAllThreads) {
            void var2_2;
            this.useCacheForAllThreads = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        protected final synchronized PoolThreadCache initialValue() {
            void var2_2;
            void var1_1;
            PoolThreadLocalCache poolThreadLocalCache = this;
            PoolArena<byte[]> heapArena = poolThreadLocalCache.leastUsedArena(poolThreadLocalCache.PooledByteBufAllocator.this.heapArenas);
            PoolThreadLocalCache poolThreadLocalCache2 = this;
            PoolArena<ByteBuffer> directArena = poolThreadLocalCache2.leastUsedArena(poolThreadLocalCache2.PooledByteBufAllocator.this.directArenas);
            Thread current = Thread.currentThread();
            EventExecutor executor = ThreadExecutorMap.currentExecutor();
            if (this.useCacheForAllThreads || current instanceof FastThreadLocalThread || executor != null) {
                void var3_3;
                PoolThreadCache cache = new PoolThreadCache(heapArena, directArena, PooledByteBufAllocator.this.smallCacheSize, PooledByteBufAllocator.this.normalCacheSize, DEFAULT_MAX_CACHED_BUFFER_CAPACITY, DEFAULT_CACHE_TRIM_INTERVAL, PooledByteBufAllocator.useCacheFinalizers((Thread)var3_3));
                if (DEFAULT_CACHE_TRIM_INTERVAL_MILLIS > 0L && executor != null) {
                    executor.scheduleAtFixedRate(PooledByteBufAllocator.this.trimTask, DEFAULT_CACHE_TRIM_INTERVAL_MILLIS, DEFAULT_CACHE_TRIM_INTERVAL_MILLIS, TimeUnit.MILLISECONDS);
                }
                return var1_1;
            }
            return new PoolThreadCache((PoolArena<byte[]>)var1_1, (PoolArena<ByteBuffer>)var2_2, 0, 0, 0, 0, false);
        }

        protected final void onRemoval(PoolThreadCache threadCache) {
            threadCache.free(false);
        }

        /*
         * WARNING - void declaration
         */
        private <T> PoolArena<T> leastUsedArena(PoolArena<T>[] arenas) {
            void var2_2;
            if (arenas == null || arenas.length == 0) {
                return null;
            }
            PoolArena<T> minArena = arenas[0];
            if (minArena.numThreadCaches.get() == 0) {
                return minArena;
            }
            for (int i = 1; i < arenas.length; ++i) {
                PoolArena<T> arena = arenas[i];
                if (arena.numThreadCaches.get() >= minArena.numThreadCaches.get()) continue;
                minArena = arena;
            }
            return var2_2;
        }
    }
}

