/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PoolChunk;
import io.netty.buffer.PoolThreadCache;
import io.netty.buffer.PooledDuplicatedByteBuf;
import io.netty.buffer.PooledSlicedByteBuf;
import io.netty.util.Recycler;
import io.netty.util.internal.ObjectPool;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

abstract class PooledByteBuf<T>
extends AbstractReferenceCountedByteBuf {
    private final Recycler.EnhancedHandle<PooledByteBuf<T>> recyclerHandle;
    protected PoolChunk<T> chunk;
    protected long handle;
    protected T memory;
    protected int offset;
    protected int length;
    int maxLength;
    PoolThreadCache cache;
    ByteBuffer tmpNioBuf;
    private ByteBufAllocator allocator;

    /*
     * WARNING - void declaration
     */
    protected PooledByteBuf(ObjectPool.Handle<? extends PooledByteBuf<T>> recyclerHandle, int maxCapacity) {
        super((int)var2_2);
        void var1_1;
        void var2_2;
        this.recyclerHandle = (Recycler.EnhancedHandle)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    void init(PoolChunk<T> chunk, ByteBuffer nioBuffer, long handle, int offset, int length, int maxLength, PoolThreadCache cache) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.init0((PoolChunk<T>)var1_1, (ByteBuffer)var2_2, (long)var3_3, offset, length, maxLength, cache);
    }

    /*
     * WARNING - void declaration
     */
    void initUnpooled(PoolChunk<T> chunk, int length) {
        void var1_1;
        void var2_2;
        void v0 = var2_2;
        this.init0((PoolChunk<T>)var1_1, null, 0L, 0, (int)v0, (int)v0, null);
    }

    /*
     * WARNING - void declaration
     */
    private void init0(PoolChunk<T> chunk, ByteBuffer nioBuffer, long handle, int offset, int length, int maxLength, PoolThreadCache cache) {
        void var3_3;
        void var1_1;
        void var2_2;
        assert (handle >= 0L);
        assert (chunk != null);
        assert (!PoolChunk.isSubpage(handle) || chunk.arena.sizeClass.size2SizeIdx(maxLength) <= chunk.arena.sizeClass.smallMaxSizeIdx) : "Allocated small sub-page handle for a buffer size that isn't \"small.\"";
        chunk.incrementPinnedMemory(maxLength);
        this.chunk = chunk;
        this.memory = chunk.memory;
        this.tmpNioBuf = var2_2;
        this.allocator = var1_1.arena.parent;
        this.cache = cache;
        this.handle = var3_3;
        this.offset = offset;
        this.length = length;
        this.maxLength = maxLength;
    }

    /*
     * WARNING - void declaration
     */
    final void reuse(int maxCapacity) {
        void var1_1;
        this.maxCapacity((int)var1_1);
        this.resetRefCnt();
        this.setIndex0(0, 0);
        this.discardMarks();
    }

    @Override
    public final int capacity() {
        return this.length;
    }

    @Override
    public int maxFastWritableBytes() {
        return Math.min(this.maxLength, ((ByteBuf)this).maxCapacity()) - this.writerIndex;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf capacity(int newCapacity) {
        void var1_1;
        if (newCapacity == this.length) {
            this.ensureAccessible();
            return this;
        }
        this.checkNewCapacity(newCapacity);
        if (!this.chunk.unpooled) {
            if (newCapacity > this.length) {
                if (newCapacity <= this.maxLength) {
                    this.length = newCapacity;
                    return this;
                }
            } else if (newCapacity > this.maxLength >>> 1 && (this.maxLength > 512 || newCapacity > this.maxLength - 16)) {
                this.length = newCapacity;
                this.trimIndicesToCapacity(newCapacity);
                return this;
            }
        }
        this.chunk.arena.reallocate(this, (int)var1_1);
        return this;
    }

    @Override
    public final ByteBufAllocator alloc() {
        return this.allocator;
    }

    @Override
    public final ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public final ByteBuf unwrap() {
        return null;
    }

    @Override
    public final ByteBuf retainedDuplicate() {
        PooledByteBuf pooledByteBuf = this;
        return PooledDuplicatedByteBuf.newInstance(pooledByteBuf, pooledByteBuf, ((ByteBuf)this).readerIndex(), ((ByteBuf)this).writerIndex());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf retainedSlice() {
        void var1_1;
        int index = ((ByteBuf)this).readerIndex();
        return ((ByteBuf)this).retainedSlice(index, ((ByteBuf)this).writerIndex() - var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf retainedSlice(int index, int length) {
        void var2_2;
        void var1_1;
        PooledByteBuf pooledByteBuf = this;
        return PooledSlicedByteBuf.newInstance(pooledByteBuf, pooledByteBuf, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected final ByteBuffer internalNioBuffer() {
        void var1_1;
        ByteBuffer tmpNioBuf = this.tmpNioBuf;
        if (tmpNioBuf == null) {
            this.tmpNioBuf = tmpNioBuf = this.newInternalNioBuffer(this.memory);
        } else {
            tmpNioBuf.clear();
        }
        return var1_1;
    }

    protected abstract ByteBuffer newInternalNioBuffer(T var1);

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void deallocate() {
        if (this.handle >= 0L) {
            void var1_1;
            long handle = this.handle;
            this.handle = -1L;
            this.memory = null;
            this.chunk.arena.free(this.chunk, this.tmpNioBuf, (long)var1_1, this.maxLength, this.cache);
            this.tmpNioBuf = null;
            this.chunk = null;
            this.cache = null;
            this.recyclerHandle.unguardedRecycle((Object)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final int idx(int index) {
        void var1_1;
        return this.offset + var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final ByteBuffer _internalNioBuffer(int index, int length, boolean duplicate) {
        void var3_4;
        void var1_1;
        void var2_2;
        ByteBuffer byteBuffer;
        index = this.idx(index);
        if (duplicate) {
            PooledByteBuf pooledByteBuf = this;
            byteBuffer = pooledByteBuf.newInternalNioBuffer(pooledByteBuf.memory);
        } else {
            byteBuffer = this.internalNioBuffer();
        }
        ByteBuffer buffer = byteBuffer;
        byteBuffer.limit(index + var2_2).position((int)var1_1);
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    ByteBuffer duplicateInternalNioBuffer(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, length);
        return this._internalNioBuffer((int)var1_1, (int)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuffer internalNioBuffer(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, length);
        return this._internalNioBuffer((int)var1_1, (int)var2_2, false);
    }

    @Override
    public final int nioBufferCount() {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuffer nioBuffer(int index, int length) {
        void var2_2;
        void var1_1;
        return this.duplicateInternalNioBuffer((int)var1_1, (int)var2_2).slice();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuffer[] nioBuffers(int index, int length) {
        void var2_2;
        void var1_1;
        return new ByteBuffer[]{((ByteBuf)this).nioBuffer((int)var1_1, (int)var2_2)};
    }

    @Override
    public final boolean isContiguous() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        void var3_3;
        void var1_1;
        return out.write(this.duplicateInternalNioBuffer((int)var1_1, (int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int readBytes(GatheringByteChannel out, int length) throws IOException {
        void var1_2;
        void var2_3;
        this.checkReadableBytes(length);
        PooledByteBuf pooledByteBuf = this;
        int readBytes = out.write(pooledByteBuf._internalNioBuffer(pooledByteBuf.readerIndex, (int)var2_3, false));
        this.readerIndex += readBytes;
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        void var3_3;
        void var1_1;
        return out.write(this.duplicateInternalNioBuffer((int)var1_1, length), (long)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int readBytes(FileChannel out, long position, int length) throws IOException {
        void var1_2;
        void var2_3;
        this.checkReadableBytes(length);
        PooledByteBuf pooledByteBuf = this;
        int readBytes = out.write(pooledByteBuf._internalNioBuffer(pooledByteBuf.readerIndex, length, false), (long)var2_3);
        this.readerIndex += readBytes;
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        try {
            void var3_3;
            void var1_1;
            return in.read(((ByteBuf)this).internalNioBuffer((int)var1_1, (int)var3_3));
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int setBytes(int index, FileChannel in, long position, int length) throws IOException {
        try {
            void var3_3;
            void var1_1;
            return in.read(((ByteBuf)this).internalNioBuffer((int)var1_1, length), (long)var3_3);
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }
}

