/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.PoolArena;
import io.netty.buffer.PoolChunk;
import io.netty.buffer.PooledByteBuf;
import io.netty.util.Recycler;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;

final class PoolThreadCache {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PoolThreadCache.class);
    private static final int INTEGER_SIZE_MINUS_ONE = 31;
    final PoolArena<byte[]> heapArena;
    final PoolArena<ByteBuffer> directArena;
    private final MemoryRegionCache<byte[]>[] smallSubPageHeapCaches;
    private final MemoryRegionCache<ByteBuffer>[] smallSubPageDirectCaches;
    private final MemoryRegionCache<byte[]>[] normalHeapCaches;
    private final MemoryRegionCache<ByteBuffer>[] normalDirectCaches;
    private final int freeSweepAllocationThreshold;
    private final AtomicBoolean freed = new AtomicBoolean();
    private final FreeOnFinalize freeOnFinalize;
    private int allocations;

    /*
     * WARNING - void declaration
     */
    PoolThreadCache(PoolArena<byte[]> heapArena, PoolArena<ByteBuffer> directArena, int smallCacheSize, int normalCacheSize, int maxCachedBufferCapacity, int freeSweepAllocationThreshold, boolean useFinalizer) {
        ObjectUtil.checkPositiveOrZero((int)maxCachedBufferCapacity, (String)"maxCachedBufferCapacity");
        this.freeSweepAllocationThreshold = freeSweepAllocationThreshold;
        this.heapArena = heapArena;
        this.directArena = directArena;
        if (directArena != null) {
            void var2_2;
            this.smallSubPageDirectCaches = PoolThreadCache.createSubPageCaches(smallCacheSize, directArena.sizeClass.nSubpages);
            this.normalDirectCaches = PoolThreadCache.createNormalCaches(normalCacheSize, maxCachedBufferCapacity, directArena);
            var2_2.numThreadCaches.getAndIncrement();
        } else {
            this.smallSubPageDirectCaches = null;
            this.normalDirectCaches = null;
        }
        if (heapArena != null) {
            void var1_1;
            void var3_3;
            this.smallSubPageHeapCaches = PoolThreadCache.createSubPageCaches((int)var3_3, heapArena.sizeClass.nSubpages);
            this.normalHeapCaches = PoolThreadCache.createNormalCaches(normalCacheSize, maxCachedBufferCapacity, heapArena);
            var1_1.numThreadCaches.getAndIncrement();
        } else {
            this.smallSubPageHeapCaches = null;
            this.normalHeapCaches = null;
        }
        if ((this.smallSubPageDirectCaches != null || this.normalDirectCaches != null || this.smallSubPageHeapCaches != null || this.normalHeapCaches != null) && freeSweepAllocationThreshold <= 0) {
            throw new IllegalArgumentException("freeSweepAllocationThreshold: " + freeSweepAllocationThreshold + " (expected: > 0)");
        }
        this.freeOnFinalize = useFinalizer ? new FreeOnFinalize(this) : null;
    }

    /*
     * WARNING - void declaration
     */
    private static <T> MemoryRegionCache<T>[] createSubPageCaches(int cacheSize, int numCaches) {
        if (cacheSize > 0 && numCaches > 0) {
            void var1_2;
            MemoryRegionCache[] cache = new MemoryRegionCache[numCaches];
            for (int i = 0; i < cache.length; ++i) {
                cache[i] = new SubPageMemoryRegionCache(cacheSize);
            }
            return var1_2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static <T> MemoryRegionCache<T>[] createNormalCaches(int cacheSize, int maxCachedBufferCapacity, PoolArena<T> area) {
        if (cacheSize > 0 && maxCachedBufferCapacity > 0) {
            void var3_3;
            int max = Math.min(area.sizeClass.chunkSize, maxCachedBufferCapacity);
            ArrayList cache = new ArrayList();
            for (int idx = area.sizeClass.nSubpages; idx < area.sizeClass.nSizes && area.sizeClass.sizeIdx2size(idx) <= max; ++idx) {
                cache.add(new NormalMemoryRegionCache(cacheSize));
            }
            return var3_3.toArray(new MemoryRegionCache[0]);
        }
        return null;
    }

    static int log2(int val) {
        int n;
        return 31 - Integer.numberOfLeadingZeros(n);
    }

    /*
     * WARNING - void declaration
     */
    final boolean allocateSmall(PoolArena<?> area, PooledByteBuf<?> buf, int reqCapacity, int sizeIdx) {
        void var3_3;
        void var2_2;
        void var1_1;
        PoolThreadCache poolThreadCache = this;
        return poolThreadCache.allocate(poolThreadCache.cacheForSmall((PoolArena<?>)var1_1, sizeIdx), (PooledByteBuf)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    final boolean allocateNormal(PoolArena<?> area, PooledByteBuf<?> buf, int reqCapacity, int sizeIdx) {
        void var3_3;
        void var2_2;
        void var1_1;
        PoolThreadCache poolThreadCache = this;
        return poolThreadCache.allocate(poolThreadCache.cacheForNormal((PoolArena<?>)var1_1, sizeIdx), (PooledByteBuf)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private boolean allocate(MemoryRegionCache<?> cache, PooledByteBuf buf, int reqCapacity) {
        void var1_2;
        void var3_4;
        void var2_3;
        if (cache == null) {
            return false;
        }
        boolean allocated = cache.allocate((PooledByteBuf<?>)var2_3, (int)var3_4, this);
        if (++this.allocations >= this.freeSweepAllocationThreshold) {
            this.allocations = 0;
            this.trim();
        }
        return (boolean)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    final boolean add(PoolArena<?> area, PoolChunk chunk, ByteBuffer nioBuffer, long handle, int normCapacity, PoolArena.SizeClass sizeClass) {
        void var3_3;
        void var2_2;
        void var1_1;
        int sizeIdx = area.sizeClass.size2SizeIdx(normCapacity);
        MemoryRegionCache<?> cache = this.cache(area, sizeIdx, sizeClass);
        if (cache == null) {
            return false;
        }
        if (this.freed.get()) {
            return false;
        }
        return var1_1.add(var2_2, (ByteBuffer)var3_3, handle, normCapacity);
    }

    /*
     * WARNING - void declaration
     */
    private MemoryRegionCache<?> cache(PoolArena<?> area, int sizeIdx, PoolArena.SizeClass sizeClass) {
        void var3_3;
        switch (1.$SwitchMap$io$netty$buffer$PoolArena$SizeClass[var3_3.ordinal()]) {
            case 1: {
                return this.cacheForNormal(area, sizeIdx);
            }
            case 2: {
                void var2_2;
                void var1_1;
                return this.cacheForSmall((PoolArena<?>)var1_1, (int)var2_2);
            }
        }
        throw new Error();
    }

    /*
     * WARNING - void declaration
     */
    final void free(boolean finalizer) {
        if (this.freed.compareAndSet(false, true)) {
            int numFreed;
            if (this.freeOnFinalize != null) {
                FreeOnFinalize.access$102(this.freeOnFinalize, null);
            }
            if ((numFreed = PoolThreadCache.free(this.smallSubPageDirectCaches, finalizer) + PoolThreadCache.free(this.normalDirectCaches, finalizer) + PoolThreadCache.free(this.smallSubPageHeapCaches, finalizer) + PoolThreadCache.free(this.normalHeapCaches, finalizer)) > 0 && logger.isDebugEnabled()) {
                void var1_1;
                logger.debug("Freed {} thread-local buffer(s) from thread: {}", (Object)((int)var1_1), (Object)Thread.currentThread().getName());
            }
            if (this.directArena != null) {
                this.directArena.numThreadCaches.getAndDecrement();
            }
            if (this.heapArena != null) {
                this.heapArena.numThreadCaches.getAndDecrement();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static int free(MemoryRegionCache<?>[] caches, boolean finalizer) {
        void var2_2;
        MemoryRegionCache<?>[] memoryRegionCacheArray;
        if (caches == null) {
            return 0;
        }
        int numFreed = 0;
        for (MemoryRegionCache<?> c : memoryRegionCacheArray) {
            numFreed += PoolThreadCache.free(c, finalizer);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static int free(MemoryRegionCache<?> cache, boolean finalizer) {
        void var1_1;
        MemoryRegionCache<?> memoryRegionCache;
        if (cache == null) {
            return 0;
        }
        return memoryRegionCache.free((boolean)var1_1);
    }

    final void trim() {
        PoolThreadCache.trim(this.smallSubPageDirectCaches);
        PoolThreadCache.trim(this.normalDirectCaches);
        PoolThreadCache.trim(this.smallSubPageHeapCaches);
        PoolThreadCache.trim(this.normalHeapCaches);
    }

    private static void trim(MemoryRegionCache<?>[] caches) {
        MemoryRegionCache<?>[] memoryRegionCacheArray;
        if (caches == null) {
            return;
        }
        for (MemoryRegionCache<?> memoryRegionCache : memoryRegionCacheArray) {
            PoolThreadCache.trim(memoryRegionCache);
        }
    }

    private static void trim(MemoryRegionCache<?> cache) {
        MemoryRegionCache<?> memoryRegionCache;
        if (cache == null) {
            return;
        }
        memoryRegionCache.trim();
    }

    /*
     * WARNING - void declaration
     */
    private MemoryRegionCache<?> cacheForSmall(PoolArena<?> area, int sizeIdx) {
        void var2_2;
        if (area.isDirect()) {
            return PoolThreadCache.cache(this.smallSubPageDirectCaches, sizeIdx);
        }
        return PoolThreadCache.cache(this.smallSubPageHeapCaches, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private MemoryRegionCache<?> cacheForNormal(PoolArena<?> area, int sizeIdx) {
        void var2_2;
        void var1_1;
        int idx = sizeIdx - area.sizeClass.nSubpages;
        if (var1_1.isDirect()) {
            return PoolThreadCache.cache(this.normalDirectCaches, idx);
        }
        return PoolThreadCache.cache(this.normalHeapCaches, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static <T> MemoryRegionCache<T> cache(MemoryRegionCache<T>[] cache, int sizeIdx) {
        void var1_1;
        MemoryRegionCache<T>[] memoryRegionCacheArray;
        if (cache == null || sizeIdx > cache.length - 1) {
            return null;
        }
        return memoryRegionCacheArray[var1_1];
    }

    private static final class FreeOnFinalize {
        private volatile PoolThreadCache cache;

        /*
         * WARNING - void declaration
         */
        private FreeOnFinalize(PoolThreadCache cache) {
            void var1_1;
            this.cache = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        protected final void finalize() throws Throwable {
            try {
                super.finalize();
                PoolThreadCache cache = this.cache;
                this.cache = null;
                if (cache != null) {
                    void var1_1;
                    var1_1.free(true);
                }
                return;
            }
            catch (Throwable throwable) {
                PoolThreadCache cache = this.cache;
                this.cache = null;
                if (cache != null) {
                    void var2_3;
                    var2_3.free(true);
                }
                throw throwable;
            }
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ PoolThreadCache access$102(FreeOnFinalize x0, PoolThreadCache x1) {
            void var1_1;
            x0.cache = var1_1;
            return x0.cache;
        }
    }

    private static abstract class MemoryRegionCache<T> {
        private final int size;
        private final Queue<Entry<T>> queue;
        private final PoolArena.SizeClass sizeClass;
        private int allocations;
        private static final ObjectPool<Entry> RECYCLER = ObjectPool.newPool((ObjectPool.ObjectCreator)new ObjectPool.ObjectCreator<Entry>(){

            /*
             * WARNING - void declaration
             */
            public final Entry newObject(ObjectPool.Handle<Entry> handle) {
                void var1_1;
                return new Entry((ObjectPool.Handle<Entry<?>>)var1_1);
            }
        });

        /*
         * WARNING - void declaration
         */
        MemoryRegionCache(int size, PoolArena.SizeClass sizeClass) {
            void var2_2;
            void var1_1;
            this.size = MathUtil.safeFindNextPositivePowerOfTwo((int)var1_1);
            this.queue = PlatformDependent.newFixedMpscQueue((int)this.size);
            this.sizeClass = var2_2;
        }

        protected abstract void initBuf(PoolChunk<T> var1, ByteBuffer var2, long var3, PooledByteBuf<T> var5, int var6, PoolThreadCache var7);

        /*
         * WARNING - void declaration
         */
        public final boolean add(PoolChunk<T> chunk, ByteBuffer nioBuffer, long handle, int normCapacity) {
            void var2_3;
            void var3_4;
            Entry entry = MemoryRegionCache.newEntry(chunk, nioBuffer, (long)var3_4, normCapacity);
            boolean queued = this.queue.offer(entry);
            if (!queued) {
                void var1_1;
                var1_1.unguardedRecycle();
            }
            return (boolean)var2_3;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean allocate(PooledByteBuf<T> buf, int reqCapacity, PoolThreadCache threadCache) {
            void var3_3;
            void var2_2;
            void var1_1;
            Entry<T> entry = this.queue.poll();
            if (entry == null) {
                return false;
            }
            this.initBuf(entry.chunk, entry.nioBuffer, entry.handle, (PooledByteBuf<T>)var1_1, (int)var2_2, (PoolThreadCache)var3_3);
            entry.unguardedRecycle();
            ++this.allocations;
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public final int free(boolean finalizer) {
            void var1_1;
            return this.free(Integer.MAX_VALUE, (boolean)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private int free(int max, boolean finalizer) {
            void var3_3;
            for (int numFreed = 0; numFreed < max; ++numFreed) {
                Entry<T> entry = this.queue.poll();
                if (entry == null) {
                    return numFreed;
                }
                this.freeEntry(entry, finalizer);
            }
            return (int)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public final void trim() {
            int free = this.size - this.allocations;
            this.allocations = 0;
            if (free > 0) {
                void var1_1;
                this.free((int)var1_1, false);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void freeEntry(Entry entry, boolean finalizer) {
            void var2_2;
            void var3_3;
            PoolChunk chunk = entry.chunk;
            long handle = entry.handle;
            ByteBuffer nioBuffer = entry.nioBuffer;
            int normCapacity = entry.normCapacity;
            if (!finalizer) {
                void var1_1;
                var1_1.recycle();
            }
            chunk.arena.freeChunk(var3_3, handle, normCapacity, this.sizeClass, nioBuffer, (boolean)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private static Entry newEntry(PoolChunk<?> chunk, ByteBuffer nioBuffer, long handle, int normCapacity) {
            void var2_2;
            void var1_1;
            PoolChunk<?> poolChunk;
            Entry entry = (Entry)RECYCLER.get();
            ((Entry)RECYCLER.get()).chunk = poolChunk;
            entry.nioBuffer = var1_1;
            entry.handle = var2_2;
            entry.normCapacity = normCapacity;
            return entry;
        }

        static final class Entry<T> {
            final Recycler.EnhancedHandle<Entry<?>> recyclerHandle;
            PoolChunk<T> chunk;
            ByteBuffer nioBuffer;
            long handle = -1L;
            int normCapacity;

            /*
             * WARNING - void declaration
             */
            Entry(ObjectPool.Handle<Entry<?>> recyclerHandle) {
                void var1_1;
                this.recyclerHandle = (Recycler.EnhancedHandle)var1_1;
            }

            final void recycle() {
                this.chunk = null;
                this.nioBuffer = null;
                this.handle = -1L;
                this.recyclerHandle.recycle((Object)this);
            }

            final void unguardedRecycle() {
                this.chunk = null;
                this.nioBuffer = null;
                this.handle = -1L;
                this.recyclerHandle.unguardedRecycle((Object)this);
            }
        }
    }

    private static final class NormalMemoryRegionCache<T>
    extends MemoryRegionCache<T> {
        /*
         * WARNING - void declaration
         */
        NormalMemoryRegionCache(int size) {
            super((int)var1_1, PoolArena.SizeClass.Normal);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void initBuf(PoolChunk<T> chunk, ByteBuffer nioBuffer, long handle, PooledByteBuf<T> buf, int reqCapacity, PoolThreadCache threadCache) {
            void var3_3;
            void var2_2;
            chunk.initBuf(buf, (ByteBuffer)var2_2, (long)var3_3, reqCapacity, threadCache);
        }
    }

    private static final class SubPageMemoryRegionCache<T>
    extends MemoryRegionCache<T> {
        /*
         * WARNING - void declaration
         */
        SubPageMemoryRegionCache(int size) {
            super((int)var1_1, PoolArena.SizeClass.Small);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void initBuf(PoolChunk<T> chunk, ByteBuffer nioBuffer, long handle, PooledByteBuf<T> buf, int reqCapacity, PoolThreadCache threadCache) {
            void var3_3;
            void var2_2;
            chunk.initBufWithSubpage(buf, (ByteBuffer)var2_2, (long)var3_3, reqCapacity, threadCache);
        }
    }
}

