/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.PoolChunk;
import io.netty.buffer.PoolSubpageMetric;
import java.util.concurrent.locks.ReentrantLock;

final class PoolSubpage<T>
implements PoolSubpageMetric {
    final PoolChunk<T> chunk;
    final int elemSize;
    private final int pageShifts;
    private final int runOffset;
    private final int runSize;
    private final long[] bitmap;
    private final int bitmapLength;
    private final int maxNumElems;
    final int headIndex;
    PoolSubpage<T> prev;
    PoolSubpage<T> next;
    boolean doNotDestroy;
    private int nextAvail;
    private int numAvail;
    final ReentrantLock lock;

    /*
     * WARNING - void declaration
     */
    PoolSubpage(int headIndex) {
        void var1_1;
        this.chunk = null;
        this.lock = new ReentrantLock();
        this.pageShifts = -1;
        this.runOffset = -1;
        this.elemSize = -1;
        this.runSize = -1;
        this.bitmap = null;
        this.bitmapLength = -1;
        this.maxNumElems = 0;
        this.headIndex = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    PoolSubpage(PoolSubpage<T> head, PoolChunk<T> chunk, int pageShifts, int runOffset, int runSize, int elemSize) {
        void var1_1;
        void var2_3;
        void var3_4;
        this.headIndex = head.headIndex;
        this.chunk = chunk;
        this.pageShifts = var3_4;
        this.runOffset = runOffset;
        this.runSize = runSize;
        this.elemSize = elemSize;
        this.doNotDestroy = true;
        PoolSubpage poolSubpage = this;
        poolSubpage.maxNumElems = poolSubpage.numAvail = runSize / elemSize;
        int bitmapLength = this.maxNumElems >>> 6;
        if ((this.maxNumElems & 0x3F) != 0) {
            ++bitmapLength;
        }
        this.bitmapLength = bitmapLength;
        this.bitmap = new long[var2_3];
        this.nextAvail = 0;
        this.lock = null;
        this.addToPool((PoolSubpage<T>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final long allocate() {
        void var1_1;
        void var3_3;
        void var2_2;
        if (this.numAvail == 0 || !this.doNotDestroy) {
            return -1L;
        }
        int bitmapIdx = this.getNextAvail();
        if (bitmapIdx < 0) {
            this.removeFromPool();
            throw new AssertionError((Object)("No next available bitmap index found (bitmapIdx = " + bitmapIdx + "), even though there are supposed to be (numAvail = " + this.numAvail + ") out of (maxNumElems = " + this.maxNumElems + ") available indexes."));
        }
        int q = bitmapIdx >>> 6;
        int r = bitmapIdx & 0x3F;
        assert ((this.bitmap[q] >>> r & 1L) == 0L);
        void v0 = var2_2;
        this.bitmap[v0] = this.bitmap[v0] | 1L << var3_3;
        if (--this.numAvail == 0) {
            this.removeFromPool();
        }
        return this.toHandle((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final boolean free(PoolSubpage<T> head, int bitmapIdx) {
        void var2_2;
        void var3_3;
        int q = bitmapIdx >>> 6;
        int r = bitmapIdx & 0x3F;
        assert ((this.bitmap[q] >>> r & 1L) != 0L);
        void v0 = var3_3;
        this.bitmap[v0] = this.bitmap[v0] ^ 1L << r;
        this.setNextAvail((int)var2_2);
        if (this.numAvail++ == 0) {
            void var1_1;
            this.addToPool((PoolSubpage<T>)var1_1);
            if (this.maxNumElems > 1) {
                return true;
            }
        }
        if (this.numAvail != this.maxNumElems) {
            return true;
        }
        if (this.prev == this.next) {
            return true;
        }
        this.doNotDestroy = false;
        this.removeFromPool();
        return false;
    }

    private void addToPool(PoolSubpage<T> head) {
        assert (this.prev == null && this.next == null);
        this.prev = head;
        this.next = head.next;
        this.next.prev = this;
        var1_1.next = this;
    }

    private void removeFromPool() {
        assert (this.prev != null && this.next != null);
        this.prev.next = this.next;
        this.next.prev = this.prev;
        this.next = null;
        this.prev = null;
    }

    /*
     * WARNING - void declaration
     */
    private void setNextAvail(int bitmapIdx) {
        void var1_1;
        this.nextAvail = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int getNextAvail() {
        int nextAvail = this.nextAvail;
        if (nextAvail >= 0) {
            void var1_1;
            this.nextAvail = -1;
            return (int)var1_1;
        }
        return this.findNextAvail();
    }

    /*
     * WARNING - void declaration
     */
    private int findNextAvail() {
        for (int i = 0; i < this.bitmapLength; ++i) {
            void var2_2;
            long bits = this.bitmap[i];
            if ((bits ^ 0xFFFFFFFFFFFFFFFFL) == 0L) continue;
            return this.findNextAvail0(i, (long)var2_2);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private int findNextAvail0(int i, long bits) {
        int baseVal = i << 6;
        for (int j = 0; j < 64; ++j) {
            if ((bits & 1L) == 0L) {
                void var1_1;
                int val = baseVal | j;
                if (val >= this.maxNumElems) break;
                return (int)var1_1;
            }
            bits >>>= 1;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private long toHandle(int bitmapIdx) {
        void var1_1;
        void var2_2;
        int pages = this.runSize >> this.pageShifts;
        return (long)this.runOffset << 49 | (long)var2_2 << 34 | 0x200000000L | 0x100000000L | (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        int numAvail;
        if (this.chunk == null) {
            numAvail = 0;
        } else {
            void var2_4;
            PoolSubpage head = this.chunk.arena.smallSubpagePools[this.headIndex];
            head.lock();
            try {
                boolean doNotDestroy = this.doNotDestroy;
                numAvail = this.numAvail;
                head.unlock();
            }
            catch (Throwable numAvail2) {
                void var3_3;
                var3_3.unlock();
                throw numAvail2;
            }
            if (var2_4 == false) {
                return "(" + this.runOffset + ": not in use)";
            }
        }
        return "(" + this.runOffset + ": " + (this.maxNumElems - var1_1) + '/' + this.maxNumElems + ", offset: " + this.runOffset + ", length: " + this.runSize + ", elemSize: " + this.elemSize + ')';
    }

    @Override
    public final int maxNumElements() {
        return this.maxNumElems;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int numAvailable() {
        if (this.chunk == null) {
            return 0;
        }
        PoolSubpage head = this.chunk.arena.smallSubpagePools[this.headIndex];
        head.lock();
        try {
            int n = this.numAvail;
            head.unlock();
            return n;
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.unlock();
            throw throwable;
        }
    }

    @Override
    public final int elementSize() {
        return this.elemSize;
    }

    @Override
    public final int pageSize() {
        return 1 << this.pageShifts;
    }

    /*
     * WARNING - void declaration
     */
    final boolean isDoNotDestroy() {
        if (this.chunk == null) {
            return true;
        }
        PoolSubpage head = this.chunk.arena.smallSubpagePools[this.headIndex];
        head.lock();
        try {
            boolean bl = this.doNotDestroy;
            head.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.unlock();
            throw throwable;
        }
    }

    final void destroy() {
        if (this.chunk != null) {
            this.chunk.destroy();
        }
    }

    final void lock() {
        this.lock.lock();
    }

    final void unlock() {
        this.lock.unlock();
    }
}

