/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.PoolArena;
import io.netty.buffer.PoolChunk;
import io.netty.buffer.PoolChunkListMetric;
import io.netty.buffer.PoolChunkMetric;
import io.netty.buffer.PoolThreadCache;
import io.netty.buffer.PooledByteBuf;
import io.netty.util.internal.StringUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

final class PoolChunkList<T>
implements PoolChunkListMetric {
    private static final Iterator<PoolChunkMetric> EMPTY_METRICS = Collections.emptyList().iterator();
    private final PoolArena<T> arena;
    private final PoolChunkList<T> nextList;
    private final int minUsage;
    private final int maxUsage;
    private final int maxCapacity;
    private PoolChunk<T> head;
    private final int freeMinThreshold;
    private final int freeMaxThreshold;
    private PoolChunkList<T> prevList;

    /*
     * WARNING - void declaration
     */
    PoolChunkList(PoolArena<T> arena, PoolChunkList<T> nextList, int minUsage, int maxUsage, int chunkSize) {
        void var3_3;
        void var2_2;
        void var1_1;
        assert (minUsage <= maxUsage);
        this.arena = var1_1;
        this.nextList = var2_2;
        this.minUsage = minUsage;
        this.maxUsage = maxUsage;
        this.maxCapacity = PoolChunkList.calculateMaxCapacity(minUsage, chunkSize);
        this.freeMinThreshold = maxUsage == 100 ? 0 : (int)((double)chunkSize * (100.0 - (double)maxUsage + 0.99999999) / 100.0);
        this.freeMaxThreshold = minUsage == 100 ? 0 : (int)((double)chunkSize * (100.0 - (double)var3_3 + 0.99999999) / 100.0);
    }

    /*
     * WARNING - void declaration
     */
    private static int calculateMaxCapacity(int minUsage, int chunkSize) {
        int n;
        void var1_1;
        if ((minUsage = PoolChunkList.minUsage0(minUsage)) == 100) {
            return 0;
        }
        return (int)((long)var1_1 * (100L - (long)n) / 100L);
    }

    /*
     * WARNING - void declaration
     */
    final void prevList(PoolChunkList<T> prevList) {
        void var1_1;
        assert (this.prevList == null);
        this.prevList = var1_1;
    }

    final boolean allocate(PooledByteBuf<T> buf, int reqCapacity, int sizeIdx, PoolThreadCache threadCache) {
        int n = this.arena.sizeClass.sizeIdx2size(sizeIdx);
        if (n > this.maxCapacity) {
            return false;
        }
        PoolChunk<T> cur = this.head;
        while (cur != null) {
            if (cur.allocate(buf, reqCapacity, sizeIdx, threadCache)) {
                if (cur.freeBytes <= this.freeMinThreshold) {
                    this.remove(cur);
                    this.nextList.add(cur);
                }
                return true;
            }
            cur = cur.next;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    final boolean free(PoolChunk<T> chunk, long handle, int normCapacity, ByteBuffer nioBuffer) {
        void var2_2;
        chunk.free((long)var2_2, normCapacity, nioBuffer);
        if (chunk.freeBytes > this.freeMaxThreshold) {
            void var1_1;
            this.remove(chunk);
            return this.move0((PoolChunk<T>)var1_1);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean move(PoolChunk<T> chunk) {
        void var1_1;
        assert (chunk.usage() < this.maxUsage);
        if (chunk.freeBytes > this.freeMaxThreshold) {
            return this.move0(chunk);
        }
        this.add0((PoolChunk<T>)var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean move0(PoolChunk<T> chunk) {
        void var1_1;
        if (this.prevList == null) {
            assert (chunk.usage() == 0);
            return false;
        }
        return super.move((PoolChunk<T>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void add(PoolChunk<T> chunk) {
        void var1_1;
        while (chunk.freeBytes <= this_.freeMinThreshold) {
            PoolChunkList<T> this_ = this_.nextList;
        }
        this_.add0((PoolChunk<T>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void add0(PoolChunk<T> chunk) {
        void var1_1;
        chunk.parent = this;
        if (this.head == null) {
            this.head = chunk;
            chunk.prev = null;
            chunk.next = null;
            return;
        }
        chunk.prev = null;
        chunk.next = this.head;
        this.head.prev = chunk;
        this.head = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void remove(PoolChunk<T> cur) {
        if (cur == this.head) {
            this.head = cur.next;
            if (this.head != null) {
                this.head.prev = null;
                return;
            }
        } else {
            PoolChunk next;
            cur.prev.next = next = cur.next;
            if (next != null) {
                void var1_1;
                var2_2.prev = var1_1.prev;
            }
        }
    }

    @Override
    public final int minUsage() {
        return PoolChunkList.minUsage0(this.minUsage);
    }

    @Override
    public final int maxUsage() {
        return Math.min(this.maxUsage, 100);
    }

    private static int minUsage0(int value) {
        int n;
        return Math.max(1, n);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Iterator<PoolChunkMetric> iterator() {
        this.arena.lock();
        try {
            void var1_2;
            if (this.head == null) {
                Iterator<PoolChunkMetric> iterator = EMPTY_METRICS;
                return iterator;
            }
            ArrayList<PoolChunk<T>> metrics = new ArrayList<PoolChunk<T>>();
            PoolChunk<T> cur = this.head;
            do {
                metrics.add(cur);
            } while ((cur = cur.next) != null);
            Iterator<PoolChunkMetric> iterator = var1_2.iterator();
            return iterator;
        }
        finally {
            this.arena.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder buf = new StringBuilder();
        this.arena.lock();
        try {
            if (this.head == null) {
                String string = "none";
                return string;
            }
            PoolChunk<T> cur = this.head;
            while (true) {
                buf.append(cur);
                cur = cur.next;
                if (cur != null) {
                    buf.append(StringUtil.NEWLINE);
                    continue;
                }
                break;
            }
        }
        finally {
            this.arena.unlock();
        }
        return var1_1.toString();
    }

    final void destroy(PoolArena<T> arena) {
        PoolChunk<T> chunk = this.head;
        while (chunk != null) {
            arena.destroyChunk(chunk);
            chunk = chunk.next;
        }
        this.head = null;
    }
}

