/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.IntPriorityQueue;
import io.netty.buffer.LongLongHashMap;
import io.netty.buffer.PoolArena;
import io.netty.buffer.PoolChunkList;
import io.netty.buffer.PoolChunkMetric;
import io.netty.buffer.PoolSubpage;
import io.netty.buffer.PoolThreadCache;
import io.netty.buffer.PooledByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.util.internal.LongCounter;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.locks.ReentrantLock;

final class PoolChunk<T>
implements PoolChunkMetric {
    private static final int SIZE_BIT_LENGTH = 15;
    private static final int INUSED_BIT_LENGTH = 1;
    private static final int SUBPAGE_BIT_LENGTH = 1;
    private static final int BITMAP_IDX_BIT_LENGTH = 32;
    static final int IS_SUBPAGE_SHIFT = 32;
    static final int IS_USED_SHIFT = 33;
    static final int SIZE_SHIFT = 34;
    static final int RUN_OFFSET_SHIFT = 49;
    final PoolArena<T> arena;
    final Object base;
    final T memory;
    final boolean unpooled;
    private final LongLongHashMap runsAvailMap;
    private final IntPriorityQueue[] runsAvail;
    private final ReentrantLock runsAvailLock;
    private final PoolSubpage<T>[] subpages;
    private final LongCounter pinnedBytes = PlatformDependent.newLongCounter();
    final int pageSize;
    final int pageShifts;
    final int chunkSize;
    final int maxPageIdx;
    private final Deque<ByteBuffer> cachedNioBuffers;
    int freeBytes;
    PoolChunkList<T> parent;
    PoolChunk<T> prev;
    PoolChunk<T> next;

    /*
     * WARNING - void declaration
     */
    PoolChunk(PoolArena<T> arena, Object base, T memory, int pageSize, int pageShifts, int chunkSize, int maxPageIdx) {
        void var1_2;
        void var3_4;
        void var2_3;
        this.unpooled = false;
        this.arena = arena;
        this.base = var2_3;
        this.memory = var3_4;
        this.pageSize = pageSize;
        this.pageShifts = pageShifts;
        this.chunkSize = chunkSize;
        this.maxPageIdx = maxPageIdx;
        this.freeBytes = chunkSize;
        this.runsAvail = PoolChunk.newRunsAvailqueueArray(maxPageIdx);
        this.runsAvailLock = new ReentrantLock();
        this.runsAvailMap = new LongLongHashMap(-1L);
        this.subpages = new PoolSubpage[chunkSize >> pageShifts];
        int pages = chunkSize >> pageShifts;
        long initHandle = (long)pages << 34;
        this.insertAvailRun(0, (int)var1_2, initHandle);
        this.cachedNioBuffers = new ArrayDeque<ByteBuffer>(8);
    }

    /*
     * WARNING - void declaration
     */
    PoolChunk(PoolArena<T> arena, Object base, T memory, int size) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.unpooled = true;
        this.arena = var1_1;
        this.base = var2_2;
        this.memory = var3_3;
        this.pageSize = 0;
        this.pageShifts = 0;
        this.maxPageIdx = 0;
        this.runsAvailMap = null;
        this.runsAvail = null;
        this.runsAvailLock = null;
        this.subpages = null;
        this.chunkSize = size;
        this.cachedNioBuffers = null;
    }

    /*
     * WARNING - void declaration
     */
    private static IntPriorityQueue[] newRunsAvailqueueArray(int size) {
        void var0_1;
        IntPriorityQueue[] queueArray = new IntPriorityQueue[size];
        for (int i = 0; i < queueArray.length; ++i) {
            queueArray[i] = new IntPriorityQueue();
        }
        return var0_1;
    }

    /*
     * WARNING - void declaration
     */
    private void insertAvailRun(int runOffset, int pages, long handle) {
        int pageIdxFloor = this.arena.sizeClass.pages2pageIdxFloor(pages);
        IntPriorityQueue queue = this.runsAvail[pageIdxFloor];
        assert (PoolChunk.isRun(handle));
        queue.offer((int)(handle >> 32));
        this.insertAvailRun0(runOffset, handle);
        if (pages > 1) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.insertAvailRun0(PoolChunk.lastPage((int)var1_1, (int)var2_2), (long)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void insertAvailRun0(int runOffset, long handle) {
        void var2_2;
        void var1_1;
        long pre = this.runsAvailMap.put((long)var1_1, (long)var2_2);
        assert (pre == -1L);
    }

    /*
     * WARNING - void declaration
     */
    private void removeAvailRun(long handle) {
        void var1_1;
        void var3_2;
        int pageIdxFloor = this.arena.sizeClass.pages2pageIdxFloor(PoolChunk.runPages(handle));
        this.runsAvail[var3_2].remove((int)(handle >> 32));
        this.removeAvailRun0((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void removeAvailRun0(long handle) {
        int runOffset = PoolChunk.runOffset(handle);
        int pages = PoolChunk.runPages(handle);
        this.runsAvailMap.remove(runOffset);
        if (pages > 1) {
            void var1_2;
            void var3_3;
            this.runsAvailMap.remove(PoolChunk.lastPage((int)var3_3, (int)var1_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static int lastPage(int runOffset, int pages) {
        void var1_1;
        return runOffset + var1_1 - 1;
    }

    /*
     * WARNING - void declaration
     */
    private long getAvailRunByOffset(int runOffset) {
        void var1_1;
        return this.runsAvailMap.get((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int usage() {
        void var1_1;
        int freeBytes;
        if (this.unpooled) {
            freeBytes = this.freeBytes;
        } else {
            this.runsAvailLock.lock();
            try {
                freeBytes = this.freeBytes;
            }
            finally {
                this.runsAvailLock.unlock();
            }
        }
        return this.usage((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private int usage(int freeBytes) {
        void var1_1;
        if (freeBytes == 0) {
            return 100;
        }
        int freePercentage = (int)((long)freeBytes * 100L / (long)this.chunkSize);
        if (freePercentage == 0) {
            return 99;
        }
        return 100 - var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final boolean allocate(PooledByteBuf<T> buf, int reqCapacity, int sizeIdx, PoolThreadCache cache) {
        void var2_3;
        void var1_1;
        long handle;
        block14: {
            void var3_4;
            if (sizeIdx <= this.arena.sizeClass.smallMaxSizeIdx) {
                PoolSubpage head = this.arena.smallSubpagePools[sizeIdx];
                head.lock();
                try {
                    PoolSubpage nextSub = head.next;
                    if (nextSub != head) {
                        assert (nextSub.doNotDestroy && nextSub.elemSize == this.arena.sizeClass.sizeIdx2size(sizeIdx)) : "doNotDestroy=" + nextSub.doNotDestroy + ", elemSize=" + nextSub.elemSize + ", sizeIdx=" + sizeIdx;
                        long handle2 = nextSub.allocate();
                        assert (handle2 >= 0L);
                        assert (PoolChunk.isSubpage(handle2));
                        nextSub.chunk.initBufWithSubpage(buf, null, handle2, reqCapacity, cache);
                        return true;
                    }
                    handle = this.allocateSubpage(sizeIdx, head);
                    if (handle < 0L) {
                        return false;
                    }
                    assert (PoolChunk.isSubpage(handle));
                    break block14;
                }
                finally {
                    head.unlock();
                }
            }
            int runSize = this.arena.sizeClass.sizeIdx2size((int)var3_4);
            handle = this.allocateRun(runSize);
            if (handle < 0L) {
                return false;
            }
            assert (!PoolChunk.isSubpage(handle));
        }
        ByteBuffer nioBuffer = this.cachedNioBuffers != null ? this.cachedNioBuffers.pollLast() : null;
        this.initBuf((PooledByteBuf<T>)var1_1, nioBuffer, handle, (int)var2_3, cache);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private long allocateRun(int runSize) {
        int pages = runSize >> this.pageShifts;
        int pageIdx = this.arena.sizeClass.pages2pageIdx(pages);
        this.runsAvailLock.lock();
        try {
            void var1_1;
            void var2_3;
            int queueIdx = this.runFirstBestFit(pageIdx);
            if (queueIdx == -1) {
                return -1L;
            }
            IntPriorityQueue intPriorityQueue = this.runsAvail[var2_3];
            long handle = intPriorityQueue.poll();
            assert (handle != -1L);
            assert (!PoolChunk.isUsed(handle <<= 32)) : "invalid handle: " + handle;
            this.removeAvailRun0(handle);
            handle = this.splitLargeRun(handle, pages);
            int pinnedSize = PoolChunk.runSize(this.pageShifts, handle);
            this.freeBytes -= var1_1;
            long l = handle;
            return l;
        }
        finally {
            this.runsAvailLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private int calculateRunSize(int sizeIdx) {
        void var3_3;
        void var1_1;
        int nElements;
        int maxElements = 1 << this.pageShifts - 4;
        int runSize = 0;
        int elemSize = this.arena.sizeClass.sizeIdx2size(sizeIdx);
        while ((nElements = (runSize += this.pageSize) / elemSize) < maxElements && runSize != nElements * elemSize) {
        }
        while (nElements > maxElements) {
            nElements = (runSize -= this.pageSize) / elemSize;
        }
        assert (var1_1 > 0);
        assert (runSize <= this.chunkSize);
        assert (runSize >= elemSize);
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private int runFirstBestFit(int pageIdx) {
        void i;
        if (this.freeBytes == this.chunkSize) {
            return this.arena.sizeClass.nPSizes - 1;
        }
        while (i < this.arena.sizeClass.nPSizes) {
            void var2_2;
            IntPriorityQueue queue = this.runsAvail[i];
            if (queue != null && !var2_2.isEmpty()) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private long splitLargeRun(long handle, int needPages) {
        assert (needPages > 0);
        int totalPages = PoolChunk.runPages(handle);
        assert (needPages <= totalPages);
        int remPages = totalPages - needPages;
        if (remPages > 0) {
            void var3_3;
            void var1_2;
            void var2_5;
            int runOffset = PoolChunk.runOffset(handle);
            int availOffset = runOffset + needPages;
            long availRun = PoolChunk.toRunHandle(availOffset, remPages, 0);
            this.insertAvailRun((int)var2_5, remPages, availRun);
            return PoolChunk.toRunHandle((int)var1_2, (int)var3_3, 1);
        }
        return (long)(var1_1 |= 0x200000000L);
    }

    /*
     * WARNING - void declaration
     */
    private long allocateSubpage(int sizeIdx, PoolSubpage<T> head) {
        void var1_2;
        void var2_3;
        int runSize = this.calculateRunSize(sizeIdx);
        long runHandle = this.allocateRun(runSize);
        if (runHandle < 0L) {
            return -1L;
        }
        int runOffset = PoolChunk.runOffset(runHandle);
        assert (this.subpages[runOffset] == null);
        int elemSize = this.arena.sizeClass.sizeIdx2size(sizeIdx);
        PoolChunk poolChunk = this;
        PoolSubpage subpage = new PoolSubpage(var2_3, poolChunk, poolChunk.pageShifts, runOffset, PoolChunk.runSize(this.pageShifts, runHandle), elemSize);
        this.subpages[var3_4] = subpage;
        return var1_2.allocate();
    }

    /*
     * WARNING - void declaration
     */
    final void free(long handle, int normCapacity, ByteBuffer nioBuffer) {
        if (PoolChunk.isSubpage(handle)) {
            int sIdx = PoolChunk.runOffset(handle);
            PoolSubpage subpage = this.subpages[sIdx];
            assert (subpage != null);
            PoolSubpage head = subpage.chunk.arena.smallSubpagePools[subpage.headIndex];
            head.lock();
            try {
                assert (subpage.doNotDestroy);
                if (subpage.free(head, PoolChunk.bitmapIdx(handle))) {
                    return;
                }
                assert (!subpage.doNotDestroy);
                this.subpages[sIdx] = null;
            }
            finally {
                head.unlock();
            }
        }
        int runSize = PoolChunk.runSize(this.pageShifts, handle);
        this.runsAvailLock.lock();
        try {
            void var3_4;
            void var1_1;
            long subpage = this.collapseRuns((long)var1_1);
            long finalRun = (subpage &= 0xFFFFFFFDFFFFFFFFL) & 0xFFFFFFFEFFFFFFFFL;
            this.insertAvailRun(PoolChunk.runOffset(finalRun), PoolChunk.runPages(finalRun), finalRun);
            this.freeBytes += var3_4;
        }
        finally {
            this.runsAvailLock.unlock();
        }
        if (nioBuffer != null && this.cachedNioBuffers != null && this.cachedNioBuffers.size() < PooledByteBufAllocator.DEFAULT_MAX_CACHED_BYTEBUFFERS_PER_CHUNK) {
            this.cachedNioBuffers.offer(nioBuffer);
        }
    }

    /*
     * WARNING - void declaration
     */
    private long collapseRuns(long handle) {
        void var1_1;
        PoolChunk poolChunk = this;
        return poolChunk.collapseNext(poolChunk.collapsePast((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private long collapsePast(long handle) {
        void var1_1;
        while (true) {
            void var3_2;
            int runOffset = PoolChunk.runOffset(handle);
            int runPages = PoolChunk.runPages(handle);
            long pastRun = this.getAvailRunByOffset(runOffset - 1);
            if (pastRun == -1L) {
                return handle;
            }
            int pastOffset = PoolChunk.runOffset(pastRun);
            int pastPages = PoolChunk.runPages(pastRun);
            if (pastRun == handle || pastOffset + pastPages != var3_2) break;
            this.removeAvailRun(pastRun);
            handle = PoolChunk.toRunHandle(pastOffset, pastPages + runPages, 0);
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private long collapseNext(long handle) {
        void var1_1;
        while (true) {
            void var3_2;
            int runPages;
            int runOffset;
            long nextRun;
            if ((nextRun = this.getAvailRunByOffset((runOffset = PoolChunk.runOffset(handle)) + (runPages = PoolChunk.runPages(handle)))) == -1L) {
                return handle;
            }
            int nextOffset = PoolChunk.runOffset(nextRun);
            int nextPages = PoolChunk.runPages(nextRun);
            if (nextRun == handle || runOffset + runPages != nextOffset) break;
            this.removeAvailRun(nextRun);
            handle = PoolChunk.toRunHandle((int)var3_2, runPages + nextPages, 0);
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static long toRunHandle(int runOffset, int runPages, int inUsed) {
        void var2_2;
        void var1_1;
        return (long)runOffset << 49 | (long)var1_1 << 34 | (long)var2_2 << 33;
    }

    /*
     * WARNING - void declaration
     */
    final void initBuf(PooledByteBuf<T> buf, ByteBuffer nioBuffer, long handle, int reqCapacity, PoolThreadCache threadCache) {
        void var2_2;
        void var1_1;
        void var3_3;
        if (PoolChunk.isSubpage(handle)) {
            this.initBufWithSubpage(buf, nioBuffer, handle, reqCapacity, threadCache);
            return;
        }
        int maxLength = PoolChunk.runSize(this.pageShifts, handle);
        void v0 = var3_3;
        var1_1.init(this, (ByteBuffer)var2_2, (long)v0, PoolChunk.runOffset((long)v0) << this.pageShifts, reqCapacity, maxLength, this.arena.parent.threadCache());
    }

    /*
     * WARNING - void declaration
     */
    final void initBufWithSubpage(PooledByteBuf<T> buf, ByteBuffer nioBuffer, long handle, int reqCapacity, PoolThreadCache threadCache) {
        void var3_3;
        void var2_2;
        void var1_1;
        int runOffset = PoolChunk.runOffset(handle);
        int bitmapIdx = PoolChunk.bitmapIdx(handle);
        PoolSubpage<T> s = this.subpages[runOffset];
        assert (s.isDoNotDestroy());
        assert (reqCapacity <= s.elemSize) : reqCapacity + "<=" + s.elemSize;
        int offset = (runOffset << this.pageShifts) + bitmapIdx * s.elemSize;
        var1_1.init(this, (ByteBuffer)var2_2, (long)var3_3, offset, reqCapacity, s.elemSize, threadCache);
    }

    /*
     * WARNING - void declaration
     */
    final void incrementPinnedMemory(int delta) {
        void var1_1;
        assert (delta > 0);
        this.pinnedBytes.add((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void decrementPinnedMemory(int delta) {
        void var1_1;
        assert (delta > 0);
        this.pinnedBytes.add((long)(-var1_1));
    }

    @Override
    public final int chunkSize() {
        return this.chunkSize;
    }

    @Override
    public final int freeBytes() {
        if (this.unpooled) {
            return this.freeBytes;
        }
        this.runsAvailLock.lock();
        try {
            int n = this.freeBytes;
            return n;
        }
        finally {
            this.runsAvailLock.unlock();
        }
    }

    public final int pinnedBytes() {
        return (int)this.pinnedBytes.value();
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        int freeBytes;
        if (this.unpooled) {
            freeBytes = this.freeBytes;
        } else {
            this.runsAvailLock.lock();
            try {
                freeBytes = this.freeBytes;
            }
            finally {
                this.runsAvailLock.unlock();
            }
        }
        return "Chunk(" + Integer.toHexString(System.identityHashCode(this)) + ": " + this.usage(freeBytes) + "%, " + (this.chunkSize - var1_1) + '/' + this.chunkSize + ')';
    }

    final void destroy() {
        this.arena.destroyChunk(this);
    }

    static int runOffset(long handle) {
        return (int)(handle >> 49);
    }

    static int runSize(int pageShifts, long handle) {
        int n;
        return PoolChunk.runPages(handle) << n;
    }

    static int runPages(long handle) {
        return (int)(handle >> 34 & 0x7FFFL);
    }

    static boolean isUsed(long handle) {
        return (handle >> 33 & 1L) == 1L;
    }

    static boolean isRun(long handle) {
        return !PoolChunk.isSubpage(handle);
    }

    static boolean isSubpage(long handle) {
        return (handle >> 32 & 1L) == 1L;
    }

    static int bitmapIdx(long handle) {
        return (int)handle;
    }
}

