/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PoolArenaMetric;
import io.netty.buffer.PoolChunk;
import io.netty.buffer.PoolChunkList;
import io.netty.buffer.PoolChunkListMetric;
import io.netty.buffer.PoolChunkMetric;
import io.netty.buffer.PoolSubpage;
import io.netty.buffer.PoolSubpageMetric;
import io.netty.buffer.PoolThreadCache;
import io.netty.buffer.PooledByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.PooledDirectByteBuf;
import io.netty.buffer.PooledHeapByteBuf;
import io.netty.buffer.PooledUnsafeDirectByteBuf;
import io.netty.buffer.PooledUnsafeHeapByteBuf;
import io.netty.buffer.SizeClasses;
import io.netty.util.internal.LongCounter;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;

abstract class PoolArena<T>
implements PoolArenaMetric {
    private static final boolean HAS_UNSAFE = PlatformDependent.hasUnsafe();
    final PooledByteBufAllocator parent;
    final PoolSubpage<T>[] smallSubpagePools;
    private final PoolChunkList<T> q050;
    private final PoolChunkList<T> q025;
    private final PoolChunkList<T> q000;
    private final PoolChunkList<T> qInit;
    private final PoolChunkList<T> q075;
    private final PoolChunkList<T> q100;
    private final List<PoolChunkListMetric> chunkListMetrics;
    private long allocationsNormal;
    private final LongCounter allocationsSmall = PlatformDependent.newLongCounter();
    private final LongCounter allocationsHuge = PlatformDependent.newLongCounter();
    private final LongCounter activeBytesHuge = PlatformDependent.newLongCounter();
    private long deallocationsSmall;
    private long deallocationsNormal;
    private final LongCounter deallocationsHuge = PlatformDependent.newLongCounter();
    final AtomicInteger numThreadCaches = new AtomicInteger();
    private final ReentrantLock lock = new ReentrantLock();
    final SizeClasses sizeClass;

    /*
     * WARNING - void declaration
     */
    protected PoolArena(PooledByteBufAllocator parent, SizeClasses sizeClass) {
        void var1_3;
        void var2_4;
        assert (sizeClass != null);
        this.parent = parent;
        this.sizeClass = sizeClass;
        this.smallSubpagePools = this.newSubpagePoolArray(sizeClass.nSubpages);
        for (int i = 0; i < this.smallSubpagePools.length; ++i) {
            this.smallSubpagePools[i] = this.newSubpagePoolHead(i);
        }
        this.q100 = new PoolChunkList(this, null, 100, Integer.MAX_VALUE, sizeClass.chunkSize);
        PoolArena poolArena = this;
        this.q075 = new PoolChunkList<T>(poolArena, poolArena.q100, 75, 100, sizeClass.chunkSize);
        PoolArena poolArena2 = this;
        this.q050 = new PoolChunkList<T>(poolArena2, poolArena2.q075, 50, 100, sizeClass.chunkSize);
        PoolArena poolArena3 = this;
        this.q025 = new PoolChunkList<T>(poolArena3, poolArena3.q050, 25, 75, sizeClass.chunkSize);
        PoolArena poolArena4 = this;
        this.q000 = new PoolChunkList<T>(poolArena4, poolArena4.q025, 1, 50, sizeClass.chunkSize);
        PoolArena poolArena5 = this;
        this.qInit = new PoolChunkList<T>(poolArena5, poolArena5.q000, Integer.MIN_VALUE, 25, var2_4.chunkSize);
        this.q100.prevList(this.q075);
        this.q075.prevList(this.q050);
        this.q050.prevList(this.q025);
        this.q025.prevList(this.q000);
        this.q000.prevList(null);
        this.qInit.prevList(this.qInit);
        ArrayList<PoolChunkList<T>> metrics = new ArrayList<PoolChunkList<T>>(6);
        metrics.add(this.qInit);
        metrics.add(this.q000);
        metrics.add(this.q025);
        metrics.add(this.q050);
        metrics.add(this.q075);
        metrics.add(this.q100);
        this.chunkListMetrics = Collections.unmodifiableList(var1_3);
    }

    /*
     * WARNING - void declaration
     */
    private PoolSubpage<T> newSubpagePoolHead(int index) {
        void var1_2;
        PoolSubpage head = new PoolSubpage(index);
        new PoolSubpage(index).prev = head;
        head.next = head;
        return var1_2;
    }

    private PoolSubpage<T>[] newSubpagePoolArray(int size) {
        return new PoolSubpage[size];
    }

    abstract boolean isDirect();

    /*
     * WARNING - void declaration
     */
    PooledByteBuf<T> allocate(PoolThreadCache cache, int reqCapacity, int maxCapacity) {
        void var3_4;
        void var2_2;
        void var1_1;
        PooledByteBuf<T> buf = this.newByteBuf(maxCapacity);
        this.allocate((PoolThreadCache)var1_1, buf, (int)var2_2);
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private void allocate(PoolThreadCache cache, PooledByteBuf<T> buf, int reqCapacity) {
        void var1_2;
        void var2_3;
        void var3_4;
        int sizeIdx = this.sizeClass.size2SizeIdx(reqCapacity);
        if (sizeIdx <= this.sizeClass.smallMaxSizeIdx) {
            this.tcacheAllocateSmall(cache, buf, reqCapacity, sizeIdx);
            return;
        }
        if (sizeIdx < this.sizeClass.nSizes) {
            this.tcacheAllocateNormal(cache, buf, reqCapacity, sizeIdx);
            return;
        }
        void normCapacity = this.sizeClass.directMemoryCacheAlignment > 0 ? this.sizeClass.normalizeSize(reqCapacity) : var3_4;
        this.allocateHuge((PooledByteBuf<T>)var2_3, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private void tcacheAllocateSmall(PoolThreadCache cache, PooledByteBuf<T> buf, int reqCapacity, int sizeIdx) {
        boolean needsNormalAllocation;
        if (cache.allocateSmall(this, buf, reqCapacity, sizeIdx)) {
            return;
        }
        PoolSubpage<T> head = this.smallSubpagePools[sizeIdx];
        head.lock();
        try {
            PoolSubpage s = head.next;
            needsNormalAllocation = s == head;
            if (!needsNormalAllocation) {
                assert (s.doNotDestroy && s.elemSize == this.sizeClass.sizeIdx2size(sizeIdx)) : "doNotDestroy=" + s.doNotDestroy + ", elemSize=" + s.elemSize + ", sizeIdx=" + sizeIdx;
                long handle = s.allocate();
                assert (handle >= 0L);
                s.chunk.initBufWithSubpage(buf, null, handle, reqCapacity, cache);
            }
        }
        finally {
            head.unlock();
        }
        if (needsNormalAllocation) {
            this.lock();
            try {
                void var1_1;
                void var3_5;
                void var2_4;
                this.allocateNormal((PooledByteBuf<T>)var2_4, (int)var3_5, sizeIdx, (PoolThreadCache)var1_1);
            }
            finally {
                this.unlock();
            }
        }
        this.incSmallAllocation();
    }

    /*
     * WARNING - void declaration
     */
    private void tcacheAllocateNormal(PoolThreadCache cache, PooledByteBuf<T> buf, int reqCapacity, int sizeIdx) {
        if (cache.allocateNormal(this, buf, reqCapacity, sizeIdx)) {
            return;
        }
        this.lock();
        try {
            void var1_1;
            void var3_4;
            void var2_3;
            this.allocateNormal((PooledByteBuf<T>)var2_3, (int)var3_4, sizeIdx, (PoolThreadCache)var1_1);
            ++this.allocationsNormal;
            return;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void allocateNormal(PooledByteBuf<T> buf, int reqCapacity, int sizeIdx, PoolThreadCache threadCache) {
        void var1_2;
        void var3_4;
        void var2_3;
        assert (this.lock.isHeldByCurrentThread());
        if (this.q050.allocate(buf, reqCapacity, sizeIdx, threadCache) || this.q025.allocate(buf, reqCapacity, sizeIdx, threadCache) || this.q000.allocate(buf, reqCapacity, sizeIdx, threadCache) || this.qInit.allocate(buf, reqCapacity, sizeIdx, threadCache) || this.q075.allocate(buf, reqCapacity, sizeIdx, threadCache)) {
            return;
        }
        PoolArena poolArena = this;
        PoolChunk<T> c = poolArena.newChunk(poolArena.sizeClass.pageSize, this.sizeClass.nPSizes, this.sizeClass.pageShifts, this.sizeClass.chunkSize);
        boolean success = c.allocate(buf, (int)var2_3, (int)var3_4, threadCache);
        assert (var1_2 != false);
        this.qInit.add(c);
    }

    private void incSmallAllocation() {
        this.allocationsSmall.increment();
    }

    /*
     * WARNING - void declaration
     */
    private void allocateHuge(PooledByteBuf<T> buf, int reqCapacity) {
        void var2_2;
        void var3_3;
        void var1_1;
        PoolChunk<T> chunk = this.newUnpooledChunk(reqCapacity);
        this.activeBytesHuge.add((long)chunk.chunkSize());
        var1_1.initUnpooled(var3_3, (int)var2_2);
        this.allocationsHuge.increment();
    }

    /*
     * WARNING - void declaration
     */
    void free(PoolChunk<T> chunk, ByteBuffer nioBuffer, long handle, int normCapacity, PoolThreadCache cache) {
        void var2_2;
        void var3_3;
        void var1_1;
        chunk.decrementPinnedMemory(normCapacity);
        if (chunk.unpooled) {
            int size = chunk.chunkSize();
            this.destroyChunk(chunk);
            this.activeBytesHuge.add((long)(-size));
            this.deallocationsHuge.increment();
            return;
        }
        SizeClass sizeClass = PoolArena.sizeClass(handle);
        if (cache != null && cache.add(this, chunk, nioBuffer, handle, normCapacity, sizeClass)) {
            return;
        }
        this.freeChunk((PoolChunk<T>)var1_1, (long)var3_3, normCapacity, sizeClass, (ByteBuffer)var2_2, false);
    }

    private static SizeClass sizeClass(long handle) {
        if (PoolChunk.isSubpage(handle)) {
            return SizeClass.Small;
        }
        return SizeClass.Normal;
    }

    /*
     * WARNING - void declaration
     */
    void freeChunk(PoolChunk<T> chunk, long handle, int normCapacity, SizeClass sizeClass, ByteBuffer nioBuffer, boolean finalizer) {
        void var2_4;
        this.lock();
        try {
            if (!finalizer) {
                switch (sizeClass) {
                    case Normal: {
                        ++this.deallocationsNormal;
                        break;
                    }
                    case Small: {
                        ++this.deallocationsSmall;
                        break;
                    }
                    default: {
                        throw new Error();
                    }
                }
            }
            boolean destroyChunk = !chunk.parent.free(chunk, handle, normCapacity, nioBuffer);
        }
        finally {
            this.unlock();
        }
        if (var2_4 != false) {
            void var1_1;
            this.destroyChunk((PoolChunk<T>)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    void reallocate(PooledByteBuf<T> buf, int newCapacity) {
        void var1_1;
        void bytesToCopy;
        PoolThreadCache oldCache;
        int oldMaxLength;
        int oldOffset;
        Object oldMemory;
        long oldHandle;
        ByteBuffer oldNioBuffer;
        PoolChunk oldChunk;
        int oldCapacity;
        assert (newCapacity >= 0 && newCapacity <= ((ByteBuf)buf).maxCapacity());
        PooledByteBuf<T> pooledByteBuf = buf;
        synchronized (pooledByteBuf) {
            oldCapacity = buf.length;
            if (oldCapacity == newCapacity) {
                return;
            }
            oldChunk = buf.chunk;
            oldNioBuffer = buf.tmpNioBuf;
            oldHandle = buf.handle;
            oldMemory = buf.memory;
            oldOffset = buf.offset;
            oldMaxLength = buf.maxLength;
            oldCache = buf.cache;
            PoolArena poolArena = this;
            poolArena.allocate(poolArena.parent.threadCache(), buf, newCapacity);
        }
        if (newCapacity > oldCapacity) {
            void var3_6;
            bytesToCopy = var3_6;
        } else {
            void var2_3;
            buf.trimIndicesToCapacity(newCapacity);
            bytesToCopy = var2_3;
        }
        this.memoryCopy(oldMemory, oldOffset, (PooledByteBuf<T>)var1_1, (int)bytesToCopy);
        this.free(oldChunk, oldNioBuffer, oldHandle, oldMaxLength, oldCache);
    }

    @Override
    public int numThreadCaches() {
        return this.numThreadCaches.get();
    }

    @Override
    public int numTinySubpages() {
        return 0;
    }

    @Override
    public int numSmallSubpages() {
        return this.smallSubpagePools.length;
    }

    @Override
    public int numChunkLists() {
        return this.chunkListMetrics.size();
    }

    @Override
    public List<PoolSubpageMetric> tinySubpages() {
        return Collections.emptyList();
    }

    @Override
    public List<PoolSubpageMetric> smallSubpages() {
        return PoolArena.subPageMetricList(this.smallSubpagePools);
    }

    @Override
    public List<PoolChunkListMetric> chunkLists() {
        return this.chunkListMetrics;
    }

    /*
     * WARNING - void declaration
     */
    private static List<PoolSubpageMetric> subPageMetricList(PoolSubpage<?>[] pages) {
        void var1_1;
        PoolSubpage<?>[] poolSubpageArray;
        ArrayList metrics = new ArrayList();
        for (PoolSubpage<?> head : poolSubpageArray) {
            if (head.next == head) continue;
            PoolSubpage s = head.next;
            do {
                metrics.add(s);
            } while ((s = s.next) != head);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long numAllocations() {
        void var1_1;
        this.lock();
        try {
            long allocsNormal = this.allocationsNormal;
        }
        finally {
            this.unlock();
        }
        return this.allocationsSmall.value() + var1_1 + this.allocationsHuge.value();
    }

    @Override
    public long numTinyAllocations() {
        return 0L;
    }

    @Override
    public long numSmallAllocations() {
        return this.allocationsSmall.value();
    }

    @Override
    public long numNormalAllocations() {
        this.lock();
        try {
            long l = this.allocationsNormal;
            return l;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long numDeallocations() {
        void var1_1;
        this.lock();
        try {
            long deallocs = this.deallocationsSmall + this.deallocationsNormal;
        }
        finally {
            this.unlock();
        }
        return (long)(var1_1 + this.deallocationsHuge.value());
    }

    @Override
    public long numTinyDeallocations() {
        return 0L;
    }

    @Override
    public long numSmallDeallocations() {
        this.lock();
        try {
            long l = this.deallocationsSmall;
            return l;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public long numNormalDeallocations() {
        this.lock();
        try {
            long l = this.deallocationsNormal;
            return l;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public long numHugeAllocations() {
        return this.allocationsHuge.value();
    }

    @Override
    public long numHugeDeallocations() {
        return this.deallocationsHuge.value();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long numActiveAllocations() {
        void var1_1;
        long val = this.allocationsSmall.value() + this.allocationsHuge.value() - this.deallocationsHuge.value();
        this.lock();
        try {
            val += this.allocationsNormal - (this.deallocationsSmall + this.deallocationsNormal);
        }
        finally {
            this.unlock();
        }
        return Math.max((long)var1_1, 0L);
    }

    @Override
    public long numActiveTinyAllocations() {
        return 0L;
    }

    @Override
    public long numActiveSmallAllocations() {
        return Math.max(this.numSmallAllocations() - this.numSmallDeallocations(), 0L);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long numActiveNormalAllocations() {
        void var1_1;
        this.lock();
        try {
            long val = this.allocationsNormal - this.deallocationsNormal;
        }
        finally {
            this.unlock();
        }
        return Math.max((long)var1_1, 0L);
    }

    @Override
    public long numActiveHugeAllocations() {
        return Math.max(this.numHugeAllocations() - this.numHugeDeallocations(), 0L);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long numActiveBytes() {
        void var1_1;
        long val = this.activeBytesHuge.value();
        this.lock();
        try {
            for (int i = 0; i < this.chunkListMetrics.size(); ++i) {
                for (PoolChunkMetric m : this.chunkListMetrics.get(i)) {
                    val += (long)m.chunkSize();
                }
            }
        }
        finally {
            this.unlock();
        }
        return Math.max(0L, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public long numPinnedBytes() {
        void var1_1;
        long val = this.activeBytesHuge.value();
        for (int i = 0; i < this.chunkListMetrics.size(); ++i) {
            for (PoolChunkMetric m : this.chunkListMetrics.get(i)) {
                val += (long)((PoolChunk)m).pinnedBytes();
            }
        }
        return Math.max(0L, (long)var1_1);
    }

    protected abstract PoolChunk<T> newChunk(int var1, int var2, int var3, int var4);

    protected abstract PoolChunk<T> newUnpooledChunk(int var1);

    protected abstract PooledByteBuf<T> newByteBuf(int var1);

    protected abstract void memoryCopy(T var1, int var2, PooledByteBuf<T> var3, int var4);

    protected abstract void destroyChunk(PoolChunk<T> var1);

    public String toString() {
        this.lock();
        try {
            String string;
            StringBuilder buf = new StringBuilder("Chunk(s) at 0~25%:").append(StringUtil.NEWLINE).append(this.qInit).append(StringUtil.NEWLINE).append("Chunk(s) at 0~50%:").append(StringUtil.NEWLINE).append(this.q000).append(StringUtil.NEWLINE).append("Chunk(s) at 25~75%:").append(StringUtil.NEWLINE).append(this.q025).append(StringUtil.NEWLINE).append("Chunk(s) at 50~100%:").append(StringUtil.NEWLINE).append(this.q050).append(StringUtil.NEWLINE).append("Chunk(s) at 75~100%:").append(StringUtil.NEWLINE).append(this.q075).append(StringUtil.NEWLINE).append("Chunk(s) at 100%:").append(StringUtil.NEWLINE).append(this.q100).append(StringUtil.NEWLINE).append("small subpages:");
            PoolArena.appendPoolSubPages(buf, this.smallSubpagePools);
            buf.append(StringUtil.NEWLINE);
            string = ((StringBuilder)((Object)string)).toString();
            return string;
        }
        finally {
            this.unlock();
        }
    }

    private static void appendPoolSubPages(StringBuilder buf, PoolSubpage<?>[] subpages) {
        for (int i = 0; i < subpages.length; ++i) {
            PoolSubpage<?> head = subpages[i];
            if (head.next == head || head.next == null) continue;
            buf.append(StringUtil.NEWLINE).append(i).append(": ");
            PoolSubpage s = head.next;
            while (s != null) {
                buf.append(s);
                s = s.next;
                if (s != head) continue;
            }
        }
    }

    protected final void finalize() throws Throwable {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            PoolArena.destroyPoolSubPages(this.smallSubpagePools);
            this.destroyPoolChunkLists(this.qInit, this.q000, this.q025, this.q050, this.q075, this.q100);
            throw throwable;
        }
        PoolArena.destroyPoolSubPages(this.smallSubpagePools);
        this.destroyPoolChunkLists(this.qInit, this.q000, this.q025, this.q050, this.q075, this.q100);
    }

    private static void destroyPoolSubPages(PoolSubpage<?>[] pages) {
        PoolSubpage<?>[] poolSubpageArray = pages;
        int n = pages.length;
        for (int i = 0; i < n; ++i) {
            PoolSubpage<?> poolSubpage = poolSubpageArray[i];
            poolSubpage.destroy();
        }
    }

    private void destroyPoolChunkLists(PoolChunkList<T> ... chunkLists) {
        PoolChunkList<T>[] poolChunkListArray = chunkLists;
        int n = chunkLists.length;
        for (int i = 0; i < n; ++i) {
            PoolChunkList<T> poolChunkList = poolChunkListArray[i];
            poolChunkList.destroy(this);
        }
    }

    void lock() {
        this.lock.lock();
    }

    void unlock() {
        this.lock.unlock();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int sizeIdx2size(int sizeIdx) {
        void var1_1;
        return this.sizeClass.sizeIdx2size((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int sizeIdx2sizeCompute(int sizeIdx) {
        void var1_1;
        return this.sizeClass.sizeIdx2sizeCompute((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long pageIdx2size(int pageIdx) {
        void var1_1;
        return this.sizeClass.pageIdx2size((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long pageIdx2sizeCompute(int pageIdx) {
        void var1_1;
        return this.sizeClass.pageIdx2sizeCompute((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int size2SizeIdx(int size) {
        void var1_1;
        return this.sizeClass.size2SizeIdx((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int pages2pageIdx(int pages) {
        void var1_1;
        return this.sizeClass.pages2pageIdx((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int pages2pageIdxFloor(int pages) {
        void var1_1;
        return this.sizeClass.pages2pageIdxFloor((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int normalizeSize(int size) {
        void var1_1;
        return this.sizeClass.normalizeSize((int)var1_1);
    }

    static final class DirectArena
    extends PoolArena<ByteBuffer> {
        /*
         * WARNING - void declaration
         */
        DirectArena(PooledByteBufAllocator parent, SizeClasses sizeClass) {
            super((PooledByteBufAllocator)var1_1, (SizeClasses)var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        final boolean isDirect() {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final PoolChunk<ByteBuffer> newChunk(int pageSize, int maxPageIdx, int pageShifts, int chunkSize) {
            void var2_2;
            void var3_3;
            void var1_1;
            if (this.sizeClass.directMemoryCacheAlignment == 0) {
                ByteBuffer memory;
                ByteBuffer byteBuffer = memory = DirectArena.allocateDirect(chunkSize);
                return new PoolChunk<ByteBuffer>(this, byteBuffer, byteBuffer, pageSize, pageShifts, chunkSize, maxPageIdx);
            }
            ByteBuffer base = DirectArena.allocateDirect(chunkSize + this.sizeClass.directMemoryCacheAlignment);
            ByteBuffer memory = PlatformDependent.alignDirectBuffer((ByteBuffer)base, (int)this.sizeClass.directMemoryCacheAlignment);
            return new PoolChunk<ByteBuffer>(this, base, memory, (int)var1_1, (int)var3_3, chunkSize, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final PoolChunk<ByteBuffer> newUnpooledChunk(int capacity) {
            void var1_1;
            void var3_4;
            void var2_3;
            if (this.sizeClass.directMemoryCacheAlignment == 0) {
                ByteBuffer memory;
                ByteBuffer byteBuffer = memory = DirectArena.allocateDirect(capacity);
                return new PoolChunk<ByteBuffer>(this, byteBuffer, byteBuffer, capacity);
            }
            ByteBuffer base = DirectArena.allocateDirect(capacity + this.sizeClass.directMemoryCacheAlignment);
            ByteBuffer memory = PlatformDependent.alignDirectBuffer((ByteBuffer)base, (int)this.sizeClass.directMemoryCacheAlignment);
            return new PoolChunk<void>(this, var2_3, var3_4, (int)var1_1);
        }

        private static ByteBuffer allocateDirect(int capacity) {
            int n;
            if (PlatformDependent.useDirectBufferNoCleaner()) {
                return PlatformDependent.allocateDirectNoCleaner((int)capacity);
            }
            return ByteBuffer.allocateDirect(n);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void destroyChunk(PoolChunk<ByteBuffer> chunk) {
            void var1_1;
            if (PlatformDependent.useDirectBufferNoCleaner()) {
                PlatformDependent.freeDirectNoCleaner((ByteBuffer)((ByteBuffer)chunk.base));
                return;
            }
            PlatformDependent.freeDirectBuffer((ByteBuffer)((ByteBuffer)var1_1.base));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final PooledByteBuf<ByteBuffer> newByteBuf(int maxCapacity) {
            void var1_1;
            if (HAS_UNSAFE) {
                return PooledUnsafeDirectByteBuf.newInstance(maxCapacity);
            }
            return PooledDirectByteBuf.newInstance((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void memoryCopy(ByteBuffer src, int srcOffset, PooledByteBuf<ByteBuffer> dstBuf, int length) {
            void var1_1;
            void var3_3;
            void var2_2;
            if (length == 0) {
                return;
            }
            if (HAS_UNSAFE) {
                PlatformDependent.copyMemory((long)(PlatformDependent.directBufferAddress((ByteBuffer)src) + (long)srcOffset), (long)(PlatformDependent.directBufferAddress((ByteBuffer)((ByteBuffer)dstBuf.memory)) + (long)dstBuf.offset), (long)length);
                return;
            }
            src = src.duplicate();
            ByteBuffer dst = dstBuf.internalNioBuffer();
            src.position(srcOffset).limit((int)(var2_2 + length));
            dst.position(var3_3.offset);
            dst.put((ByteBuffer)var1_1);
        }
    }

    static final class HeapArena
    extends PoolArena<byte[]> {
        private final AtomicReference<PoolChunk<byte[]>> lastDestroyedChunk = new AtomicReference();

        /*
         * WARNING - void declaration
         */
        HeapArena(PooledByteBufAllocator parent, SizeClasses sizeClass) {
            super((PooledByteBufAllocator)var1_1, (SizeClasses)var2_2);
            void var2_2;
            void var1_1;
        }

        private static byte[] newByteArray(int size) {
            return PlatformDependent.allocateUninitializedArray((int)size);
        }

        @Override
        final boolean isDirect() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final PoolChunk<byte[]> newChunk(int pageSize, int maxPageIdx, int pageShifts, int chunkSize) {
            void var2_2;
            void var3_3;
            void var1_1;
            PoolChunk chunk = this.lastDestroyedChunk.getAndSet(null);
            if (chunk != null) {
                assert (chunk.chunkSize == chunkSize && chunk.pageSize == pageSize && chunk.maxPageIdx == maxPageIdx && chunk.pageShifts == pageShifts);
                return chunk;
            }
            return new PoolChunk<byte[]>(this, null, HeapArena.newByteArray(chunkSize), (int)var1_1, (int)var3_3, chunkSize, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final PoolChunk<byte[]> newUnpooledChunk(int capacity) {
            void var1_1;
            return new PoolChunk<byte[]>(this, null, HeapArena.newByteArray(capacity), (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void destroyChunk(PoolChunk<byte[]> chunk) {
            if (!chunk.unpooled && this.lastDestroyedChunk.get() == null) {
                void var1_1;
                this.lastDestroyedChunk.set((PoolChunk<byte[]>)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final PooledByteBuf<byte[]> newByteBuf(int maxCapacity) {
            void var1_1;
            if (HAS_UNSAFE) {
                return PooledUnsafeHeapByteBuf.newUnsafeInstance(maxCapacity);
            }
            return PooledHeapByteBuf.newInstance((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void memoryCopy(byte[] src, int srcOffset, PooledByteBuf<byte[]> dst, int length) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (length == 0) {
                return;
            }
            System.arraycopy(var1_1, (int)var2_2, dst.memory, var3_3.offset, length);
        }
    }

    static enum SizeClass {
        Small,
        Normal;

    }
}

