/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

final class LongLongHashMap {
    private static final int MASK_TEMPLATE = -2;
    private int mask;
    private long[] array;
    private int maxProbe;
    private long zeroVal;
    private final long emptyVal;

    /*
     * WARNING - void declaration
     */
    LongLongHashMap(long emptyVal) {
        void var1_1;
        this.emptyVal = emptyVal;
        this.zeroVal = var1_1;
        this.array = new long[32];
        this.mask = 31;
        this.computeMaskAndProbe();
    }

    public final long put(long key, long value) {
        if (key == 0L) {
            long prev = this.zeroVal;
            this.zeroVal = value;
            return prev;
        }
        while (true) {
            int index = this.index(key);
            for (int i = 0; i < this.maxProbe; ++i) {
                long existing = this.array[index];
                if (existing == key || existing == 0L) {
                    long prev = existing == 0L ? this.emptyVal : this.array[index + 1];
                    this.array[index] = key;
                    this.array[index + 1] = value;
                    while (i < this.maxProbe) {
                        if (this.array[index = index + 2 & this.mask] == key) {
                            this.array[index] = 0L;
                            prev = this.array[index + 1];
                            break;
                        }
                        ++i;
                    }
                    return prev;
                }
                index = index + 2 & this.mask;
            }
            this.expand();
        }
    }

    public final void remove(long key) {
        if (key == 0L) {
            this.zeroVal = this.emptyVal;
            return;
        }
        int index = this.index(key);
        for (int i = 0; i < this.maxProbe; ++i) {
            long l = this.array[index];
            if (l == key) {
                this.array[index] = 0L;
                return;
            }
            index = index + 2 & this.mask;
        }
    }

    public final long get(long key) {
        if (key == 0L) {
            return this.zeroVal;
        }
        int index = this.index(key);
        for (int i = 0; i < this.maxProbe; ++i) {
            long l = this.array[index];
            if (l == key) {
                return this.array[index + 1];
            }
            index = index + 2 & this.mask;
        }
        return this.emptyVal;
    }

    private int index(long key) {
        long l;
        long l2 = key;
        key = l2 ^ l2 >>> 33;
        key *= -49064778989728563L;
        key ^= key >>> 33;
        l = (key *= -4265267296055464877L) ^ l >>> 33;
        return (int)l & this.mask;
    }

    /*
     * WARNING - void declaration
     */
    private void expand() {
        long[] prev = this.array;
        this.array = new long[prev.length << 1];
        this.computeMaskAndProbe();
        for (int i = 0; i < prev.length; i += 2) {
            void var3_3;
            long key = prev[i];
            if (key == 0L) continue;
            long val = prev[i + 1];
            this.put((long)var3_3, val);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void computeMaskAndProbe() {
        void var1_1;
        int length = this.array.length;
        this.mask = length - 1 & 0xFFFFFFFE;
        this.maxProbe = (int)Math.log((double)var1_1);
    }
}

