/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import java.util.Arrays;

final class IntPriorityQueue {
    public static final int NO_VALUE = -1;
    private int[] array = new int[9];
    private int size;

    IntPriorityQueue() {
    }

    /*
     * WARNING - void declaration
     */
    public final void offer(int handle) {
        void var1_1;
        if (handle == -1) {
            throw new IllegalArgumentException("The NO_VALUE (-1) cannot be added to the queue.");
        }
        ++this.size;
        if (this.size == this.array.length) {
            this.array = Arrays.copyOf(this.array, 1 + (this.array.length - 1 << 1));
        }
        this.array[this.size] = var1_1;
        IntPriorityQueue intPriorityQueue = this;
        intPriorityQueue.lift(intPriorityQueue.size);
    }

    public final void remove(int value) {
        for (int i = 1; i <= this.size; ++i) {
            if (this.array[i] != value) continue;
            this.array[i] = this.array[this.size--];
            this.lift(i);
            this.sink(i);
            return;
        }
    }

    public final int peek() {
        if (this.size == 0) {
            return -1;
        }
        return this.array[1];
    }

    /*
     * WARNING - void declaration
     */
    public final int poll() {
        void var1_1;
        if (this.size == 0) {
            return -1;
        }
        int val = this.array[1];
        this.array[1] = this.array[this.size];
        this.array[this.size] = 0;
        --this.size;
        this.sink(1);
        return (int)var1_1;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    /*
     * WARNING - void declaration
     */
    private void lift(int index) {
        int parentIndex;
        while (index > 1 && this.subord(parentIndex = index >> 1, index)) {
            void var2_2;
            this.swap(index, parentIndex);
            index = var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sink(int index) {
        int child;
        while ((child = index << 1) <= this.size) {
            void var2_2;
            if (child < this.size) {
                int n = child++;
                if (this.subord(n, n + 1)) {
                    // empty if block
                }
            }
            if (!this.subord(index, child)) break;
            this.swap(index, child);
            index = var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean subord(int a, int b) {
        void var2_2;
        void var1_1;
        return this.array[var1_1] > this.array[var2_2];
    }

    /*
     * WARNING - void declaration
     */
    private void swap(int a, int b) {
        void var3_3;
        int value = this.array[a];
        this.array[var1_1] = this.array[b];
        this.array[var2_2] = var3_3;
    }
}

