/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.WrappedByteBuf;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.RecyclableArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.Collections;

final class FixedCompositeByteBuf
extends AbstractReferenceCountedByteBuf {
    private static final ByteBuf[] EMPTY = new ByteBuf[]{Unpooled.EMPTY_BUFFER};
    private final int nioBufferCount;
    private final int capacity;
    private final ByteBufAllocator allocator;
    private final ByteOrder order;
    private final ByteBuf[] buffers;
    private final boolean direct;

    /*
     * WARNING - void declaration
     */
    FixedCompositeByteBuf(ByteBufAllocator allocator, ByteBuf ... buffers) {
        super(Integer.MAX_VALUE);
        void var1_1;
        if (buffers.length == 0) {
            this.buffers = EMPTY;
            this.order = ByteOrder.BIG_ENDIAN;
            this.nioBufferCount = 1;
            this.capacity = 0;
            this.direct = Unpooled.EMPTY_BUFFER.isDirect();
        } else {
            ByteBuf b = buffers[0];
            this.buffers = buffers;
            boolean direct = true;
            int nioBufferCount = b.nioBufferCount();
            int capacity = b.readableBytes();
            this.order = b.order();
            for (int i = 1; i < buffers.length; ++i) {
                void var3_3;
                b = buffers[i];
                if (buffers[i].order() != this.order) {
                    throw new IllegalArgumentException("All ByteBufs need to have same ByteOrder");
                }
                nioBufferCount += b.nioBufferCount();
                capacity += b.readableBytes();
                if (var3_3.isDirect()) continue;
                direct = false;
            }
            this.nioBufferCount = nioBufferCount;
            this.capacity = capacity;
            this.direct = direct;
        }
        ((ByteBuf)this).setIndex(0, ((ByteBuf)this).capacity());
        this.allocator = var1_1;
    }

    @Override
    public final boolean isWritable() {
        return false;
    }

    @Override
    public final boolean isWritable(int size) {
        return false;
    }

    @Override
    public final ByteBuf discardReadBytes() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBuf setBytes(int index, ByteBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBuf setByte(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected final void _setByte(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBuf setShort(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected final void _setShort(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected final void _setShortLE(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBuf setMedium(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected final void _setMedium(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected final void _setMediumLE(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBuf setInt(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected final void _setInt(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected final void _setIntLE(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBuf setLong(int index, long value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected final void _setLong(int index, long value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected final void _setLongLE(int index, long value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final int setBytes(int index, InputStream in, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final int setBytes(int index, ScatteringByteChannel in, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final int setBytes(int index, FileChannel in, long position, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final int capacity() {
        return this.capacity;
    }

    @Override
    public final int maxCapacity() {
        return this.capacity;
    }

    @Override
    public final ByteBuf capacity(int newCapacity) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBufAllocator alloc() {
        return this.allocator;
    }

    @Override
    public final ByteOrder order() {
        return this.order;
    }

    @Override
    public final ByteBuf unwrap() {
        return null;
    }

    @Override
    public final boolean isDirect() {
        return this.direct;
    }

    private Component findComponent(int index) {
        int readable = 0;
        for (int i = 0; i < this.buffers.length; ++i) {
            Component comp = null;
            ByteBuf b = this.buffers[i];
            if (b instanceof Component) {
                comp = (Component)b;
                b = comp.buf;
            }
            if (index >= (readable += b.readableBytes())) continue;
            if (comp == null) {
                comp = new Component(i, readable - b.readableBytes(), b);
                this.buffers[i] = comp;
            }
            return comp;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuf buffer(int i) {
        void var1_2;
        ByteBuf b = this.buffers[i];
        if (b instanceof Component) {
            return ((Component)b).buf;
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final byte getByte(int index) {
        void var1_1;
        return this._getByte((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final byte _getByte(int index) {
        void var2_2;
        void var1_1;
        Component c = this.findComponent(index);
        return c.buf.getByte((int)(var1_1 - ((Component)var2_2).offset));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final short _getShort(int index) {
        void var1_1;
        Component c = this.findComponent(index);
        if (index + 2 <= c.endOffset) {
            void var2_2;
            return c.buf.getShort(index - ((Component)var2_2).offset);
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return (short)((this._getByte(index) & 0xFF) << 8 | this._getByte(index + 1) & 0xFF);
        }
        return (short)(this._getByte(index) & 0xFF | (this._getByte((int)(var1_1 + true)) & 0xFF) << 8);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final short _getShortLE(int index) {
        void var1_1;
        Component c = this.findComponent(index);
        if (index + 2 <= c.endOffset) {
            void var2_2;
            return c.buf.getShortLE(index - ((Component)var2_2).offset);
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return (short)(this._getByte(index) & 0xFF | (this._getByte(index + 1) & 0xFF) << 8);
        }
        return (short)((this._getByte(index) & 0xFF) << 8 | this._getByte((int)(var1_1 + true)) & 0xFF);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int _getUnsignedMedium(int index) {
        void var1_1;
        Component c = this.findComponent(index);
        if (index + 3 <= c.endOffset) {
            void var2_2;
            return c.buf.getUnsignedMedium(index - ((Component)var2_2).offset);
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return (this._getShort(index) & 0xFFFF) << 8 | this._getByte(index + 2) & 0xFF;
        }
        return this._getShort(index) & 0xFFFF | (this._getByte((int)(var1_1 + 2)) & 0xFF) << 16;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int _getUnsignedMediumLE(int index) {
        void var1_1;
        Component c = this.findComponent(index);
        if (index + 3 <= c.endOffset) {
            void var2_2;
            return c.buf.getUnsignedMediumLE(index - ((Component)var2_2).offset);
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return this._getShortLE(index) & 0xFFFF | (this._getByte(index + 2) & 0xFF) << 16;
        }
        return (this._getShortLE(index) & 0xFFFF) << 8 | this._getByte((int)(var1_1 + 2)) & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int _getInt(int index) {
        void var1_1;
        Component c = this.findComponent(index);
        if (index + 4 <= c.endOffset) {
            void var2_2;
            return c.buf.getInt(index - ((Component)var2_2).offset);
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return (this._getShort(index) & 0xFFFF) << 16 | this._getShort(index + 2) & 0xFFFF;
        }
        return this._getShort(index) & 0xFFFF | (this._getShort((int)(var1_1 + 2)) & 0xFFFF) << 16;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int _getIntLE(int index) {
        void var1_1;
        Component c = this.findComponent(index);
        if (index + 4 <= c.endOffset) {
            void var2_2;
            return c.buf.getIntLE(index - ((Component)var2_2).offset);
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return this._getShortLE(index) & 0xFFFF | (this._getShortLE(index + 2) & 0xFFFF) << 16;
        }
        return (this._getShortLE(index) & 0xFFFF) << 16 | this._getShortLE((int)(var1_1 + 2)) & 0xFFFF;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final long _getLong(int index) {
        void var1_1;
        Component c = this.findComponent(index);
        if (index + 8 <= c.endOffset) {
            void var2_2;
            return c.buf.getLong(index - ((Component)var2_2).offset);
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return ((long)this._getInt(index) & 0xFFFFFFFFL) << 32 | (long)this._getInt(index + 4) & 0xFFFFFFFFL;
        }
        return (long)this._getInt(index) & 0xFFFFFFFFL | ((long)this._getInt((int)(var1_1 + 4)) & 0xFFFFFFFFL) << 32;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final long _getLongLE(int index) {
        void var1_1;
        Component c = this.findComponent(index);
        if (index + 8 <= c.endOffset) {
            void var2_2;
            return c.buf.getLongLE(index - ((Component)var2_2).offset);
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return (long)this._getIntLE(index) & 0xFFFFFFFFL | ((long)this._getIntLE(index + 4) & 0xFFFFFFFFL) << 32;
        }
        return ((long)this._getIntLE(index) & 0xFFFFFFFFL) << 32 | (long)this._getIntLE((int)(var1_1 + 4)) & 0xFFFFFFFFL;
    }

    @Override
    public final ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.checkDstIndex(index, length, dstIndex, dst.length);
        if (length == 0) {
            return this;
        }
        Component c = this.findComponent(index);
        int i = c.index;
        int adjustment = c.offset;
        ByteBuf s = c.buf;
        while (true) {
            int localLength = Math.min(length, s.readableBytes() - (index - adjustment));
            s.getBytes(index - adjustment, dst, dstIndex, localLength);
            index += localLength;
            dstIndex += localLength;
            adjustment += s.readableBytes();
            if ((length -= localLength) <= 0) break;
            s = this.buffer(++i);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, ByteBuffer dst) {
        int limit = dst.limit();
        int length = dst.remaining();
        this.checkIndex(index, length);
        if (length == 0) {
            return this;
        }
        try {
            Component c = this.findComponent(index);
            int i = c.index;
            int adjustment = c.offset;
            ByteBuf s = c.buf;
            while (true) {
                int localLength = Math.min(length, s.readableBytes() - (index - adjustment));
                ByteBuffer byteBuffer = dst;
                byteBuffer.limit(byteBuffer.position() + localLength);
                s.getBytes(index - adjustment, dst);
                index += localLength;
                adjustment += s.readableBytes();
                if ((length -= localLength) <= 0) break;
                s = this.buffer(++i);
            }
            dst.limit(limit);
        }
        catch (Throwable throwable) {
            void var3_4;
            void var2_3;
            var2_3.limit((int)var3_4);
            throw throwable;
        }
        return this;
    }

    @Override
    public final ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.checkDstIndex(index, length, dstIndex, dst.capacity());
        if (length == 0) {
            return this;
        }
        Component c = this.findComponent(index);
        int i = c.index;
        int adjustment = c.offset;
        ByteBuf s = c.buf;
        while (true) {
            int localLength = Math.min(length, s.readableBytes() - (index - adjustment));
            s.getBytes(index - adjustment, dst, dstIndex, localLength);
            index += localLength;
            dstIndex += localLength;
            adjustment += s.readableBytes();
            if ((length -= localLength) <= 0) break;
            s = this.buffer(++i);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        int n = ((ByteBuf)this).nioBufferCount();
        if (n == 1) {
            return out.write(((ByteBuf)this).internalNioBuffer(index, length));
        }
        long writtenBytes = var2_2.write(((ByteBuf)this).nioBuffers((int)var1_1, (int)var3_3));
        if (writtenBytes > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)writtenBytes;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        void var1_1;
        int n = ((ByteBuf)this).nioBufferCount();
        if (n == 1) {
            return out.write(((ByteBuf)this).internalNioBuffer(index, length), position);
        }
        long writtenBytes = 0L;
        for (ByteBuffer buf : ((ByteBuf)this).nioBuffers((int)var1_1, length)) {
            writtenBytes += (long)out.write(buf, position + writtenBytes);
        }
        if (writtenBytes > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)writtenBytes;
    }

    @Override
    public final ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        this.checkIndex(index, length);
        if (length == 0) {
            return this;
        }
        Component c = this.findComponent(index);
        int i = c.index;
        int adjustment = c.offset;
        ByteBuf s = c.buf;
        while (true) {
            int localLength = Math.min(length, s.readableBytes() - (index - adjustment));
            s.getBytes(index - adjustment, out, localLength);
            index += localLength;
            adjustment += s.readableBytes();
            if ((length -= localLength) <= 0) break;
            s = this.buffer(++i);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf copy(int index, int length) {
        this.checkIndex(index, length);
        boolean release = true;
        ByteBuf buf = ((ByteBuf)this).alloc().buffer(length);
        try {
            void var2_4;
            void var1_1;
            buf.writeBytes(this, (int)var1_1, (int)var2_4);
            release = false;
            ByteBuf byteBuf = buf;
            return byteBuf;
        }
        catch (Throwable throwable) {
            void var3_5;
            if (var3_5 != false) {
                buf.release();
            }
            throw throwable;
        }
    }

    @Override
    public final int nioBufferCount() {
        return this.nioBufferCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuffer nioBuffer(int index, int length) {
        void var3_4;
        ByteBuf buf;
        this.checkIndex(index, length);
        if (this.buffers.length == 1 && (buf = this.buffer(0)).nioBufferCount() == 1) {
            return buf.nioBuffer(index, length);
        }
        ByteBuffer merged = ByteBuffer.allocate(length).order(((ByteBuf)this).order());
        ByteBuffer[] buffers = ((ByteBuf)this).nioBuffers(index, length);
        for (int i = 0; i < buffers.length; ++i) {
            merged.put(buffers[i]);
        }
        merged.flip();
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuffer internalNioBuffer(int index, int length) {
        if (this.buffers.length == 1) {
            void var2_2;
            void var1_1;
            return this.buffer(0).internalNioBuffer((int)var1_1, (int)var2_2);
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuffer[] nioBuffers(int index, int length) {
        ByteBuffer[] byteBufferArray;
        this.checkIndex(index, length);
        if (length == 0) {
            return EmptyArrays.EMPTY_BYTE_BUFFERS;
        }
        RecyclableArrayList array = RecyclableArrayList.newInstance((int)this.buffers.length);
        try {
            Component c = this.findComponent(index);
            int i = c.index;
            int adjustment = c.offset;
            ByteBuf s = c.buf;
            while (true) {
                int localLength = Math.min(length, s.readableBytes() - (index - adjustment));
                switch (s.nioBufferCount()) {
                    case 0: {
                        throw new UnsupportedOperationException();
                    }
                    case 1: {
                        array.add((Object)s.nioBuffer(index - adjustment, localLength));
                        break;
                    }
                    default: {
                        Collections.addAll(array, s.nioBuffers(index - adjustment, localLength));
                    }
                }
                index += localLength;
                adjustment += s.readableBytes();
                if ((length -= localLength) <= 0) break;
                s = this.buffer(++i);
            }
            byteBufferArray = (ByteBuffer[])array.toArray((Object[])EmptyArrays.EMPTY_BYTE_BUFFERS);
        }
        catch (Throwable throwable) {
            void var3_4;
            var3_4.recycle();
            throw throwable;
        }
        array.recycle();
        return byteBufferArray;
    }

    @Override
    public final boolean hasArray() {
        switch (this.buffers.length) {
            case 0: {
                return true;
            }
            case 1: {
                return this.buffer(0).hasArray();
            }
        }
        return false;
    }

    @Override
    public final byte[] array() {
        switch (this.buffers.length) {
            case 0: {
                return EmptyArrays.EMPTY_BYTES;
            }
            case 1: {
                return this.buffer(0).array();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public final int arrayOffset() {
        switch (this.buffers.length) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.buffer(0).arrayOffset();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean hasMemoryAddress() {
        switch (this.buffers.length) {
            case 0: {
                return Unpooled.EMPTY_BUFFER.hasMemoryAddress();
            }
            case 1: {
                return this.buffer(0).hasMemoryAddress();
            }
        }
        return false;
    }

    @Override
    public final long memoryAddress() {
        switch (this.buffers.length) {
            case 0: {
                return Unpooled.EMPTY_BUFFER.memoryAddress();
            }
            case 1: {
                return this.buffer(0).memoryAddress();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected final void deallocate() {
        for (int i = 0; i < this.buffers.length; ++i) {
            this.buffer(i).release();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString() {
        void var1_1;
        String result = super.toString();
        result = result.substring(0, result.length() - 1);
        return (String)var1_1 + ", components=" + this.buffers.length + ')';
    }

    private static final class Component
    extends WrappedByteBuf {
        private final int index;
        private final int offset;
        private final int endOffset;

        /*
         * WARNING - void declaration
         */
        Component(int index, int offset, ByteBuf buf) {
            super(buf);
            void var3_3;
            void var2_2;
            void var1_1;
            this.index = var1_1;
            this.offset = offset;
            this.endOffset = var2_2 + var3_3.readableBytes();
        }
    }
}

