/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

public final class EmptyByteBuf
extends ByteBuf {
    static final int EMPTY_BYTE_BUF_HASH_CODE = 1;
    private static final ByteBuffer EMPTY_BYTE_BUFFER;
    private static final long EMPTY_BYTE_BUFFER_ADDRESS;
    private final ByteBufAllocator alloc;
    private final ByteOrder order;
    private final String str;
    private EmptyByteBuf swapped;

    /*
     * WARNING - void declaration
     */
    public EmptyByteBuf(ByteBufAllocator alloc) {
        this((ByteBufAllocator)var1_1, ByteOrder.BIG_ENDIAN);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private EmptyByteBuf(ByteBufAllocator alloc, ByteOrder order) {
        void var2_2;
        void var1_1;
        this.alloc = (ByteBufAllocator)ObjectUtil.checkNotNull((Object)var1_1, (String)"alloc");
        this.order = order;
        this.str = StringUtil.simpleClassName((Object)this) + (var2_2 == ByteOrder.BIG_ENDIAN ? "BE" : "LE");
    }

    @Override
    public final int capacity() {
        return 0;
    }

    @Override
    public final ByteBuf capacity(int newCapacity) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBufAllocator alloc() {
        return this.alloc;
    }

    @Override
    public final ByteOrder order() {
        return this.order;
    }

    @Override
    public final ByteBuf unwrap() {
        return null;
    }

    @Override
    public final ByteBuf asReadOnly() {
        return Unpooled.unmodifiableBuffer((ByteBuf)this);
    }

    @Override
    public final boolean isReadOnly() {
        return false;
    }

    @Override
    public final boolean isDirect() {
        return true;
    }

    @Override
    public final int maxCapacity() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf order(ByteOrder endianness) {
        void var2_2;
        void var1_1;
        if (ObjectUtil.checkNotNull((Object)endianness, (String)"endianness") == ((ByteBuf)this).order()) {
            return this;
        }
        EmptyByteBuf swapped = this.swapped;
        if (swapped != null) {
            return swapped;
        }
        this.swapped = swapped = new EmptyByteBuf(((ByteBuf)this).alloc(), (ByteOrder)var1_1);
        return var2_2;
    }

    @Override
    public final int readerIndex() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf readerIndex(int readerIndex) {
        void var1_1;
        return this.checkIndex((int)var1_1);
    }

    @Override
    public final int writerIndex() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writerIndex(int writerIndex) {
        void var1_1;
        return this.checkIndex((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setIndex(int readerIndex, int writerIndex) {
        void var2_2;
        void var1_1;
        this.checkIndex((int)var1_1);
        this.checkIndex((int)var2_2);
        return this;
    }

    @Override
    public final int readableBytes() {
        return 0;
    }

    @Override
    public final int writableBytes() {
        return 0;
    }

    @Override
    public final int maxWritableBytes() {
        return 0;
    }

    @Override
    public final boolean isReadable() {
        return false;
    }

    @Override
    public final boolean isWritable() {
        return false;
    }

    @Override
    public final ByteBuf clear() {
        return this;
    }

    @Override
    public final ByteBuf markReaderIndex() {
        return this;
    }

    @Override
    public final ByteBuf resetReaderIndex() {
        return this;
    }

    @Override
    public final ByteBuf markWriterIndex() {
        return this;
    }

    @Override
    public final ByteBuf resetWriterIndex() {
        return this;
    }

    @Override
    public final ByteBuf discardReadBytes() {
        return this;
    }

    @Override
    public final ByteBuf discardSomeReadBytes() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf ensureWritable(int minWritableBytes) {
        void var1_1;
        ObjectUtil.checkPositiveOrZero((int)minWritableBytes, (String)"minWritableBytes");
        if (var1_1 != false) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int ensureWritable(int minWritableBytes, boolean force) {
        void var1_1;
        ObjectUtil.checkPositiveOrZero((int)minWritableBytes, (String)"minWritableBytes");
        if (var1_1 == false) {
            return 0;
        }
        return 1;
    }

    @Override
    public final boolean getBoolean(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final byte getByte(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final short getUnsignedByte(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final short getShort(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final short getShortLE(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int getUnsignedShort(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int getUnsignedShortLE(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int getMedium(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int getMediumLE(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int getUnsignedMedium(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int getUnsignedMediumLE(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int getInt(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int getIntLE(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final long getUnsignedInt(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final long getUnsignedIntLE(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final long getLong(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final long getLongLE(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final char getChar(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final float getFloat(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final double getDouble(int index) {
        throw new IndexOutOfBoundsException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, ByteBuf dst) {
        void var2_2;
        void var1_1;
        return this.checkIndex((int)var1_1, var2_2.writableBytes());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, ByteBuf dst, int length) {
        void var3_3;
        void var1_1;
        return this.checkIndex((int)var1_1, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        void var1_1;
        return this.checkIndex((int)var1_1, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, byte[] dst) {
        void var2_2;
        void var1_1;
        return this.checkIndex((int)var1_1, ((void)var2_2).length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        void var1_1;
        return this.checkIndex((int)var1_1, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, ByteBuffer dst) {
        void var2_2;
        void var1_1;
        return this.checkIndex((int)var1_1, var2_2.remaining());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, OutputStream out, int length) {
        void var3_3;
        void var1_1;
        return this.checkIndex((int)var1_1, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getBytes(int index, GatheringByteChannel out, int length) {
        void var3_3;
        void var1_1;
        this.checkIndex((int)var1_1, (int)var3_3);
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getBytes(int index, FileChannel out, long position, int length) {
        void var1_1;
        this.checkIndex((int)var1_1, length);
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CharSequence getCharSequence(int index, int length, Charset charset) {
        void var2_2;
        void var1_1;
        this.checkIndex((int)var1_1, (int)var2_2);
        return null;
    }

    @Override
    public final ByteBuf setBoolean(int index, boolean value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setByte(int index, int value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setShort(int index, int value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setShortLE(int index, int value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setMedium(int index, int value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setMediumLE(int index, int value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setInt(int index, int value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setIntLE(int index, int value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setLong(int index, long value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setLongLE(int index, long value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setChar(int index, int value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setFloat(int index, float value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setDouble(int index, double value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setBytes(int index, ByteBuf src) {
        throw new IndexOutOfBoundsException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setBytes(int index, ByteBuf src, int length) {
        void var3_3;
        void var1_1;
        return this.checkIndex((int)var1_1, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        void var1_1;
        return this.checkIndex((int)var1_1, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setBytes(int index, byte[] src) {
        void var2_2;
        void var1_1;
        return this.checkIndex((int)var1_1, ((void)var2_2).length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        void var1_1;
        return this.checkIndex((int)var1_1, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setBytes(int index, ByteBuffer src) {
        void var2_2;
        void var1_1;
        return this.checkIndex((int)var1_1, var2_2.remaining());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int setBytes(int index, InputStream in, int length) {
        void var3_3;
        void var1_1;
        this.checkIndex((int)var1_1, (int)var3_3);
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int setBytes(int index, ScatteringByteChannel in, int length) {
        void var3_3;
        void var1_1;
        this.checkIndex((int)var1_1, (int)var3_3);
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int setBytes(int index, FileChannel in, long position, int length) {
        void var1_1;
        this.checkIndex((int)var1_1, length);
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setZero(int index, int length) {
        void var2_2;
        void var1_1;
        return this.checkIndex((int)var1_1, (int)var2_2);
    }

    @Override
    public final int setCharSequence(int index, CharSequence sequence, Charset charset) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final boolean readBoolean() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final byte readByte() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final short readUnsignedByte() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final short readShort() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final short readShortLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int readUnsignedShort() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int readUnsignedShortLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int readMedium() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int readMediumLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int readUnsignedMedium() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int readUnsignedMediumLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int readInt() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int readIntLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final long readUnsignedInt() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final long readUnsignedIntLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final long readLong() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final long readLongLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final char readChar() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final float readFloat() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final double readDouble() {
        throw new IndexOutOfBoundsException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf readBytes(int length) {
        void var1_1;
        return this.checkLength((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf readSlice(int length) {
        void var1_1;
        return this.checkLength((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf readRetainedSlice(int length) {
        void var1_1;
        return this.checkLength((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf readBytes(ByteBuf dst) {
        void var1_1;
        return this.checkLength(var1_1.writableBytes());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf readBytes(ByteBuf dst, int length) {
        void var2_2;
        return this.checkLength((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf readBytes(ByteBuf dst, int dstIndex, int length) {
        void var3_3;
        return this.checkLength((int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf readBytes(byte[] dst) {
        void var1_1;
        return this.checkLength(((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf readBytes(byte[] dst, int dstIndex, int length) {
        void var3_3;
        return this.checkLength((int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf readBytes(ByteBuffer dst) {
        void var1_1;
        return this.checkLength(var1_1.remaining());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf readBytes(OutputStream out, int length) {
        void var2_2;
        return this.checkLength((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int readBytes(GatheringByteChannel out, int length) {
        void var2_2;
        this.checkLength((int)var2_2);
        return 0;
    }

    @Override
    public final int readBytes(FileChannel out, long position, int length) {
        this.checkLength(length);
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CharSequence readCharSequence(int length, Charset charset) {
        void var1_1;
        this.checkLength((int)var1_1);
        return "";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf skipBytes(int length) {
        void var1_1;
        return this.checkLength((int)var1_1);
    }

    @Override
    public final ByteBuf writeBoolean(boolean value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeByte(int value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeShort(int value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeShortLE(int value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeMedium(int value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeMediumLE(int value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeInt(int value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeIntLE(int value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeLong(long value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeLongLE(long value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeChar(int value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeFloat(float value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeDouble(double value) {
        throw new IndexOutOfBoundsException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeBytes(ByteBuf src) {
        void var1_1;
        return this.checkLength(var1_1.readableBytes());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeBytes(ByteBuf src, int length) {
        void var2_2;
        return this.checkLength((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeBytes(ByteBuf src, int srcIndex, int length) {
        void var3_3;
        return this.checkLength((int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeBytes(byte[] src) {
        void var1_1;
        return this.checkLength(((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeBytes(byte[] src, int srcIndex, int length) {
        void var3_3;
        return this.checkLength((int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeBytes(ByteBuffer src) {
        void var1_1;
        return this.checkLength(var1_1.remaining());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int writeBytes(InputStream in, int length) {
        void var2_2;
        this.checkLength((int)var2_2);
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int writeBytes(ScatteringByteChannel in, int length) {
        void var2_2;
        this.checkLength((int)var2_2);
        return 0;
    }

    @Override
    public final int writeBytes(FileChannel in, long position, int length) {
        this.checkLength(length);
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeZero(int length) {
        void var1_1;
        return this.checkLength((int)var1_1);
    }

    @Override
    public final int writeCharSequence(CharSequence sequence, Charset charset) {
        throw new IndexOutOfBoundsException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int indexOf(int fromIndex, int toIndex, byte value) {
        void var2_2;
        void var1_1;
        this.checkIndex((int)var1_1);
        this.checkIndex((int)var2_2);
        return -1;
    }

    @Override
    public final int bytesBefore(byte value) {
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int bytesBefore(int length, byte value) {
        void var1_1;
        this.checkLength((int)var1_1);
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int bytesBefore(int index, int length, byte value) {
        void var2_2;
        void var1_1;
        this.checkIndex((int)var1_1, (int)var2_2);
        return -1;
    }

    @Override
    public final int forEachByte(ByteProcessor processor) {
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int forEachByte(int index, int length, ByteProcessor processor) {
        void var2_2;
        void var1_1;
        this.checkIndex((int)var1_1, (int)var2_2);
        return -1;
    }

    @Override
    public final int forEachByteDesc(ByteProcessor processor) {
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int forEachByteDesc(int index, int length, ByteProcessor processor) {
        void var2_2;
        void var1_1;
        this.checkIndex((int)var1_1, (int)var2_2);
        return -1;
    }

    @Override
    public final ByteBuf copy() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf copy(int index, int length) {
        void var2_2;
        void var1_1;
        return this.checkIndex((int)var1_1, (int)var2_2);
    }

    @Override
    public final ByteBuf slice() {
        return this;
    }

    @Override
    public final ByteBuf retainedSlice() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf slice(int index, int length) {
        void var2_2;
        void var1_1;
        return this.checkIndex((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf retainedSlice(int index, int length) {
        void var2_2;
        void var1_1;
        return this.checkIndex((int)var1_1, (int)var2_2);
    }

    @Override
    public final ByteBuf duplicate() {
        return this;
    }

    @Override
    public final ByteBuf retainedDuplicate() {
        return this;
    }

    @Override
    public final int nioBufferCount() {
        return 1;
    }

    @Override
    public final ByteBuffer nioBuffer() {
        return EMPTY_BYTE_BUFFER;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuffer nioBuffer(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex((int)var1_1, (int)var2_2);
        return ((ByteBuf)this).nioBuffer();
    }

    @Override
    public final ByteBuffer[] nioBuffers() {
        return new ByteBuffer[]{EMPTY_BYTE_BUFFER};
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuffer[] nioBuffers(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex((int)var1_1, (int)var2_2);
        return ((ByteBuf)this).nioBuffers();
    }

    @Override
    public final ByteBuffer internalNioBuffer(int index, int length) {
        return EMPTY_BYTE_BUFFER;
    }

    @Override
    public final boolean hasArray() {
        return true;
    }

    @Override
    public final byte[] array() {
        return EmptyArrays.EMPTY_BYTES;
    }

    @Override
    public final int arrayOffset() {
        return 0;
    }

    @Override
    public final boolean hasMemoryAddress() {
        return EMPTY_BYTE_BUFFER_ADDRESS != 0L;
    }

    @Override
    public final long memoryAddress() {
        if (((ByteBuf)this).hasMemoryAddress()) {
            return EMPTY_BYTE_BUFFER_ADDRESS;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean isContiguous() {
        return true;
    }

    @Override
    public final String toString(Charset charset) {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString(int index, int length, Charset charset) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkIndex((int)var1_1, (int)var2_2);
        return ((ByteBuf)this).toString((Charset)var3_3);
    }

    @Override
    public final int hashCode() {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object obj) {
        void var1_1;
        return obj instanceof ByteBuf && !((ByteBuf)var1_1).isReadable();
    }

    @Override
    public final int compareTo(ByteBuf buffer) {
        if (buffer.isReadable()) {
            return -1;
        }
        return 0;
    }

    @Override
    public final String toString() {
        return this.str;
    }

    @Override
    public final boolean isReadable(int size) {
        return false;
    }

    @Override
    public final boolean isWritable(int size) {
        return false;
    }

    public final int refCnt() {
        return 1;
    }

    @Override
    public final ByteBuf retain() {
        return this;
    }

    @Override
    public final ByteBuf retain(int increment) {
        return this;
    }

    @Override
    public final ByteBuf touch() {
        return this;
    }

    @Override
    public final ByteBuf touch(Object hint) {
        return this;
    }

    public final boolean release() {
        return false;
    }

    public final boolean release(int decrement) {
        return false;
    }

    private ByteBuf checkIndex(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuf checkIndex(int index, int length) {
        void var2_2;
        void var1_1;
        ObjectUtil.checkPositiveOrZero((int)length, (String)"length");
        if (var1_1 != false || var2_2 != false) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuf checkLength(int length) {
        void var1_1;
        ObjectUtil.checkPositiveOrZero((int)length, (String)"length");
        if (var1_1 != false) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        EMPTY_BYTE_BUFFER = ByteBuffer.allocateDirect(0);
        long emptyByteBufferAddress = 0L;
        try {
            if (PlatformDependent.hasUnsafe()) {
                emptyByteBufferAddress = PlatformDependent.directBufferAddress((ByteBuffer)EMPTY_BYTE_BUFFER);
            }
        }
        catch (Throwable throwable) {}
        EMPTY_BYTE_BUFFER_ADDRESS = var0;
    }
}

