/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.AbstractUnpooledSlicedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.DuplicatedByteBuf;
import io.netty.buffer.PooledDuplicatedByteBuf;
import io.netty.buffer.PooledSlicedByteBuf;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.WrappedByteBuf;
import io.netty.buffer.WrappedCompositeByteBuf;
import io.netty.util.ByteProcessor;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.RecyclableArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class CompositeByteBuf
extends AbstractReferenceCountedByteBuf
implements Iterable<ByteBuf> {
    private static final ByteBuffer EMPTY_NIO_BUFFER = Unpooled.EMPTY_BUFFER.nioBuffer();
    private static final Iterator<ByteBuf> EMPTY_ITERATOR = Collections.emptyList().iterator();
    private final ByteBufAllocator alloc;
    private final boolean direct;
    private final int maxNumComponents;
    private int componentCount;
    private Component[] components;
    private boolean freed;
    static final ByteWrapper<byte[]> BYTE_ARRAY_WRAPPER = new ByteWrapper<byte[]>(){

        @Override
        public final ByteBuf wrap(byte[] bytes) {
            return Unpooled.wrappedBuffer(bytes);
        }

        @Override
        public final boolean isEmpty(byte[] bytes) {
            return bytes.length == 0;
        }
    };
    static final ByteWrapper<ByteBuffer> BYTE_BUFFER_WRAPPER = new ByteWrapper<ByteBuffer>(){

        @Override
        public final ByteBuf wrap(ByteBuffer bytes) {
            return Unpooled.wrappedBuffer(bytes);
        }

        @Override
        public final boolean isEmpty(ByteBuffer bytes) {
            return !bytes.hasRemaining();
        }
    };
    private Component lastAccessed;

    /*
     * WARNING - void declaration
     */
    private CompositeByteBuf(ByteBufAllocator alloc, boolean direct, int maxNumComponents, int initSize) {
        super(Integer.MAX_VALUE);
        void var3_3;
        void var2_2;
        void var1_1;
        this.alloc = (ByteBufAllocator)ObjectUtil.checkNotNull((Object)var1_1, (String)"alloc");
        if (maxNumComponents <= 0) {
            throw new IllegalArgumentException("maxNumComponents: " + maxNumComponents + " (expected: >= 1)");
        }
        this.direct = var2_2;
        this.maxNumComponents = maxNumComponents;
        this.components = CompositeByteBuf.newCompArray(initSize, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public CompositeByteBuf(ByteBufAllocator alloc, boolean direct, int maxNumComponents) {
        this((ByteBufAllocator)var1_1, (boolean)var2_2, (int)var3_3, 0);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CompositeByteBuf(ByteBufAllocator alloc, boolean direct, int maxNumComponents, ByteBuf ... buffers) {
        this((ByteBufAllocator)var1_1, (boolean)var2_2, (int)var3_3, buffers, 0);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    CompositeByteBuf(ByteBufAllocator alloc, boolean direct, int maxNumComponents, ByteBuf[] buffers, int offset) {
        this((ByteBufAllocator)var1_1, (boolean)var2_2, (int)var3_3, buffers.length - offset);
        void var3_3;
        void var2_2;
        void var1_1;
        this.addComponents0(false, 0, buffers, offset);
        this.consolidateIfNeeded();
        this.setIndex0(0, ((ByteBuf)this).capacity());
    }

    /*
     * WARNING - void declaration
     */
    public CompositeByteBuf(ByteBufAllocator alloc, boolean direct, int maxNumComponents, Iterable<ByteBuf> buffers) {
        this((ByteBufAllocator)var1_1, (boolean)var2_2, (int)var3_3, buffers instanceof Collection ? ((Collection)buffers).size() : 0);
        void var3_3;
        void var2_2;
        void var1_1;
        this.addComponents(false, 0, buffers);
        this.setIndex(0, ((ByteBuf)this).capacity());
    }

    /*
     * WARNING - void declaration
     */
    <T> CompositeByteBuf(ByteBufAllocator alloc, boolean direct, int maxNumComponents, ByteWrapper<T> wrapper, T[] buffers, int offset) {
        this((ByteBufAllocator)var1_1, (boolean)var2_2, (int)var3_3, buffers.length - offset);
        void var3_3;
        void var2_2;
        void var1_1;
        this.addComponents0(false, 0, wrapper, buffers, offset);
        this.consolidateIfNeeded();
        this.setIndex(0, ((ByteBuf)this).capacity());
    }

    /*
     * WARNING - void declaration
     */
    private static Component[] newCompArray(int initComponents, int maxNumComponents) {
        void var1_1;
        int n;
        int capacityGuess = Math.min(16, maxNumComponents);
        return new Component[Math.max(n, (int)var1_1)];
    }

    /*
     * WARNING - void declaration
     */
    CompositeByteBuf(ByteBufAllocator alloc) {
        super(Integer.MAX_VALUE);
        void var1_1;
        this.alloc = var1_1;
        this.direct = false;
        this.maxNumComponents = 0;
        this.components = null;
    }

    /*
     * WARNING - void declaration
     */
    public CompositeByteBuf addComponent(ByteBuf buffer) {
        void var1_1;
        return this.addComponent(false, (ByteBuf)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public CompositeByteBuf addComponents(ByteBuf ... buffers) {
        void var1_1;
        return this.addComponents(false, (ByteBuf[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public CompositeByteBuf addComponents(Iterable<ByteBuf> buffers) {
        void var1_1;
        return this.addComponents(false, (Iterable<ByteBuf>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public CompositeByteBuf addComponent(int cIndex, ByteBuf buffer) {
        void var2_2;
        void var1_1;
        return this.addComponent(false, (int)var1_1, (ByteBuf)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public CompositeByteBuf addComponent(boolean increaseWriterIndex, ByteBuf buffer) {
        void var2_2;
        void var1_1;
        return this.addComponent((boolean)var1_1, this.componentCount, (ByteBuf)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public CompositeByteBuf addComponents(boolean increaseWriterIndex, ByteBuf ... buffers) {
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull((Object)buffers, (String)"buffers");
        this.addComponents0((boolean)var1_1, this.componentCount, (ByteBuf[])var2_2, 0);
        this.consolidateIfNeeded();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public CompositeByteBuf addComponents(boolean increaseWriterIndex, Iterable<ByteBuf> buffers) {
        void var2_2;
        void var1_1;
        return this.addComponents((boolean)var1_1, this.componentCount, (Iterable<ByteBuf>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public CompositeByteBuf addComponent(boolean increaseWriterIndex, int cIndex, ByteBuf buffer) {
        void var3_3;
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull((Object)buffer, (String)"buffer");
        this.addComponent0((boolean)var1_1, (int)var2_2, (ByteBuf)var3_3);
        this.consolidateIfNeeded();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private static void checkForOverflow(int capacity, int readableBytes) {
        if (capacity + readableBytes < 0) {
            int n;
            void var1_1;
            throw new IllegalArgumentException("Can't increase by " + (int)var1_1 + " as capacity(" + n + ") would overflow 2147483647");
        }
    }

    /*
     * WARNING - void declaration
     */
    private int addComponent0(boolean increaseWriterIndex, int cIndex, ByteBuf buffer) {
        assert (buffer != null);
        boolean wasAdded = false;
        try {
            void var2_3;
            void var1_1;
            this.checkComponentIndex(cIndex);
            Component c = this.newComponent(CompositeByteBuf.ensureAccessible(buffer), 0);
            int readableBytes = c.length();
            CompositeByteBuf.checkForOverflow(((ByteBuf)this).capacity(), readableBytes);
            this.addComp(cIndex, c);
            wasAdded = true;
            if (readableBytes > 0 && cIndex < this.componentCount - 1) {
                this.updateComponentOffsets(cIndex);
            } else if (cIndex > 0) {
                c.reposition(this.components[cIndex - 1].endOffset);
            }
            if (var1_1 != false) {
                this.writerIndex += readableBytes;
            }
            var1_1 = var2_3;
            return (int)var1_1;
        }
        catch (Throwable throwable) {
            if (!wasAdded) {
                void var3_4;
                var3_4.release();
            }
            throw throwable;
        }
    }

    private static ByteBuf ensureAccessible(ByteBuf buf) {
        ByteBuf byteBuf;
        if (checkAccessible && !buf.isAccessible()) {
            throw new IllegalReferenceCountException(0);
        }
        return byteBuf;
    }

    /*
     * WARNING - void declaration
     */
    private Component newComponent(ByteBuf buf, int offset) {
        void var2_2;
        void var3_3;
        void var1_1;
        int unwrappedIndex;
        ByteBuf unwrapped;
        int len;
        block6: {
            block4: {
                block5: {
                    block3: {
                        int srcIndex = buf.readerIndex();
                        len = buf.readableBytes();
                        unwrapped = buf;
                        unwrappedIndex = srcIndex;
                        while (unwrapped instanceof WrappedByteBuf || unwrapped instanceof SwappedByteBuf) {
                            unwrapped = unwrapped.unwrap();
                        }
                        if (!(unwrapped instanceof AbstractUnpooledSlicedByteBuf)) break block3;
                        unwrappedIndex += ((AbstractUnpooledSlicedByteBuf)unwrapped).idx(0);
                        break block4;
                    }
                    if (!(unwrapped instanceof PooledSlicedByteBuf)) break block5;
                    unwrappedIndex += ((PooledSlicedByteBuf)unwrapped).adjustment;
                    break block4;
                }
                if (!(unwrapped instanceof DuplicatedByteBuf) && !(unwrapped instanceof PooledDuplicatedByteBuf)) break block6;
            }
            unwrapped = unwrapped.unwrap();
        }
        ByteBuf slice = buf.capacity() == len ? buf : null;
        return new Component(var1_1.order(ByteOrder.BIG_ENDIAN), (int)var3_3, unwrapped.order(ByteOrder.BIG_ENDIAN), unwrappedIndex, (int)var2_2, len, slice);
    }

    /*
     * WARNING - void declaration
     */
    public CompositeByteBuf addComponents(int cIndex, ByteBuf ... buffers) {
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull((Object)buffers, (String)"buffers");
        this.addComponents0(false, (int)var1_1, (ByteBuf[])var2_2, 0);
        this.consolidateIfNeeded();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private CompositeByteBuf addComponents0(boolean increaseWriterIndex, int cIndex, ByteBuf[] buffers, int arrOffset) {
        CompositeByteBuf compositeByteBuf;
        int ci;
        block10: {
            block11: {
                ByteBuf b;
                int len = buffers.length;
                int count = len - arrOffset;
                int readableBytes = 0;
                int capacity = ((ByteBuf)this).capacity();
                for (int i = arrOffset; i < buffers.length && (b = buffers[i]) != null; ++i) {
                    CompositeByteBuf.checkForOverflow(capacity, readableBytes += b.readableBytes());
                }
                ci = Integer.MAX_VALUE;
                try {
                    ByteBuf b2;
                    this.checkComponentIndex(cIndex);
                    this.shiftComps(cIndex, count);
                    int nextOffset = cIndex > 0 ? this.components[cIndex - 1].endOffset : 0;
                    ci = cIndex;
                    while (arrOffset < len && (b2 = buffers[arrOffset]) != null) {
                        Component c;
                        this.components[ci] = c = this.newComponent(CompositeByteBuf.ensureAccessible(b2), nextOffset);
                        nextOffset = c.endOffset;
                        ++arrOffset;
                        ++ci;
                    }
                    compositeByteBuf = this;
                    if (ci >= this.componentCount) break block10;
                    if (ci >= cIndex + count) break block11;
                    this.removeCompRange(ci, cIndex + count);
                }
                catch (Throwable throwable) {
                    void var1_1;
                    if (ci < this.componentCount) {
                        if (ci < cIndex + count) {
                            this.removeCompRange(ci, cIndex + count);
                            while (arrOffset < len) {
                                ReferenceCountUtil.safeRelease((Object)buffers[arrOffset]);
                                ++arrOffset;
                            }
                        }
                        this.updateComponentOffsets(ci);
                    }
                    if (var1_1 != false && ci > cIndex && ci <= this.componentCount) {
                        void var2_2;
                        this.writerIndex += this.components[ci - 1].endOffset - this.components[var2_2].offset;
                    }
                    throw throwable;
                }
                while (arrOffset < len) {
                    ReferenceCountUtil.safeRelease((Object)buffers[arrOffset]);
                    ++arrOffset;
                }
            }
            this.updateComponentOffsets(ci);
        }
        if (increaseWriterIndex && ci > cIndex && ci <= this.componentCount) {
            this.writerIndex += this.components[ci - 1].endOffset - this.components[cIndex].offset;
        }
        return compositeByteBuf;
    }

    /*
     * WARNING - void declaration
     */
    private <T> int addComponents0(boolean increaseWriterIndex, int cIndex, ByteWrapper<T> wrapper, T[] buffers, int offset) {
        void var2_2;
        T b;
        this.checkComponentIndex(cIndex);
        int len = buffers.length;
        for (int i = offset; i < len && (b = buffers[i]) != null; ++i) {
            int size;
            if (wrapper.isEmpty(b) || (cIndex = this.addComponent0(increaseWriterIndex, cIndex, wrapper.wrap(b)) + 1) <= (size = this.componentCount)) continue;
            cIndex = size;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public CompositeByteBuf addComponents(int cIndex, Iterable<ByteBuf> buffers) {
        void var2_2;
        void var1_1;
        return this.addComponents(false, (int)var1_1, (Iterable<ByteBuf>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public CompositeByteBuf addFlattenedComponents(boolean increaseWriterIndex, ByteBuf buffer) {
        ObjectUtil.checkNotNull((Object)buffer, (String)"buffer");
        int ridx = buffer.readerIndex();
        int widx = buffer.writerIndex();
        if (ridx == widx) {
            buffer.release();
            return this;
        }
        if (!(buffer instanceof CompositeByteBuf)) {
            this.addComponent0(increaseWriterIndex, this.componentCount, buffer);
            this.consolidateIfNeeded();
            return this;
        }
        CompositeByteBuf from = buffer instanceof WrappedCompositeByteBuf ? (CompositeByteBuf)buffer.unwrap() : (CompositeByteBuf)buffer;
        from.checkIndex(ridx, widx - ridx);
        Component[] fromComponents = from.components;
        int compCountBefore = this.componentCount;
        int writerIndexBefore = this.writerIndex;
        try {
            int cidx = from.toComponentIndex0(ridx);
            int newOffset = ((ByteBuf)this).capacity();
            while (true) {
                Component component = fromComponents[cidx];
                int compOffset = component.offset;
                int fromIdx = Math.max(ridx, compOffset);
                int toIdx = Math.min(widx, component.endOffset);
                int len = toIdx - fromIdx;
                if (len > 0) {
                    CompositeByteBuf compositeByteBuf = this;
                    compositeByteBuf.addComp(compositeByteBuf.componentCount, new Component(component.srcBuf.retain(), component.srcIdx(fromIdx), component.buf, component.idx(fromIdx), newOffset, len, null));
                }
                if (widx == toIdx) break;
                newOffset += len;
                ++cidx;
            }
            if (increaseWriterIndex) {
                void var3_3;
                this.writerIndex = writerIndexBefore + (widx - var3_3);
            }
            this.consolidateIfNeeded();
            buffer.release();
            buffer = null;
            CompositeByteBuf compositeByteBuf = this;
            return compositeByteBuf;
        }
        catch (Throwable throwable) {
            void var2_2;
            if (var2_2 != null) {
                if (increaseWriterIndex) {
                    this.writerIndex = writerIndexBefore;
                }
                for (int cidx = this.componentCount - 1; cidx >= compCountBefore; --cidx) {
                    this.components[cidx].free();
                    this.removeComp(cidx);
                }
            }
            throw throwable;
        }
    }

    private CompositeByteBuf addComponents(boolean increaseIndex, int cIndex, Iterable<ByteBuf> buffers) {
        if (buffers instanceof ByteBuf) {
            return this.addComponent(increaseIndex, cIndex, (ByteBuf)((Object)buffers));
        }
        ObjectUtil.checkNotNull(buffers, (String)"buffers");
        Iterator<ByteBuf> it = buffers.iterator();
        try {
            ByteBuf b;
            this.checkComponentIndex(cIndex);
            while (it.hasNext() && (b = it.next()) != null) {
                cIndex = this.addComponent0(increaseIndex, cIndex, b) + 1;
                cIndex = Math.min(cIndex, this.componentCount);
            }
        }
        finally {
            while (it.hasNext()) {
                ReferenceCountUtil.safeRelease((Object)it.next());
            }
        }
        this.consolidateIfNeeded();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void consolidateIfNeeded() {
        int size = this.componentCount;
        if (size > this.maxNumComponents) {
            void var1_1;
            this.consolidate0(0, (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkComponentIndex(int cIndex) {
        this.ensureAccessible();
        if (cIndex < 0 || cIndex > this.componentCount) {
            void var1_1;
            throw new IndexOutOfBoundsException(String.format("cIndex: %d (expected: >= 0 && <= numComponents(%d))", (int)var1_1, this.componentCount));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkComponentIndex(int cIndex, int numComponents) {
        this.ensureAccessible();
        if (cIndex < 0 || cIndex + numComponents > this.componentCount) {
            void var2_2;
            void var1_1;
            throw new IndexOutOfBoundsException(String.format("cIndex: %d, numComponents: %d (expected: cIndex >= 0 && cIndex + numComponents <= totalNumComponents(%d))", (int)var1_1, (int)var2_2, this.componentCount));
        }
    }

    private void updateComponentOffsets(int cIndex) {
        int nextIndex;
        int size = this.componentCount;
        if (size <= cIndex) {
            return;
        }
        int n = nextIndex = cIndex > 0 ? this.components[cIndex - 1].endOffset : 0;
        while (cIndex < size) {
            Component c = this.components[cIndex];
            c.reposition(nextIndex);
            nextIndex = c.endOffset;
            ++cIndex;
        }
    }

    /*
     * WARNING - void declaration
     */
    public CompositeByteBuf removeComponent(int cIndex) {
        void var2_2;
        this.checkComponentIndex(cIndex);
        Component comp = this.components[cIndex];
        if (this.lastAccessed == comp) {
            this.lastAccessed = null;
        }
        comp.free();
        this.removeComp(cIndex);
        if (var2_2.length() > 0) {
            void var1_1;
            this.updateComponentOffsets((int)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public CompositeByteBuf removeComponents(int cIndex, int numComponents) {
        void var3_3;
        void var2_2;
        this.checkComponentIndex(cIndex, numComponents);
        if (numComponents == 0) {
            return this;
        }
        int endIndex = cIndex + numComponents;
        boolean needsUpdate = false;
        for (int i = cIndex; i < endIndex; ++i) {
            Component c = this.components[i];
            if (c.length() > 0) {
                needsUpdate = true;
            }
            if (this.lastAccessed == c) {
                this.lastAccessed = null;
            }
            c.free();
        }
        this.removeCompRange(cIndex, (int)var2_2);
        if (var3_3 != false) {
            void var1_1;
            this.updateComponentOffsets((int)var1_1);
        }
        return this;
    }

    @Override
    public Iterator<ByteBuf> iterator() {
        this.ensureAccessible();
        if (this.componentCount == 0) {
            return EMPTY_ITERATOR;
        }
        return new CompositeByteBufIterator();
    }

    @Override
    protected int forEachByteAsc0(int start, int end, ByteProcessor processor) throws Exception {
        if (end <= start) {
            return -1;
        }
        int i = this.toComponentIndex0(start);
        int length = end - start;
        while (length > 0) {
            Component c = this.components[i];
            if (c.offset != c.endOffset) {
                int result;
                int n;
                ByteBuf s = c.buf;
                int localStart = c.idx(start);
                int localLength = Math.min(length, c.endOffset - start);
                if (s instanceof AbstractByteBuf) {
                    int n2 = localStart;
                    n = ((AbstractByteBuf)s).forEachByteAsc0(n2, n2 + localLength, processor);
                } else {
                    n = result = s.forEachByte(localStart, localLength, processor);
                }
                if (n != -1) {
                    return result - c.adjustment;
                }
                start += localLength;
                length -= localLength;
            }
            ++i;
        }
        return -1;
    }

    @Override
    protected int forEachByteDesc0(int rStart, int rEnd, ByteProcessor processor) throws Exception {
        if (rEnd > rStart) {
            return -1;
        }
        int i = this.toComponentIndex0(rStart);
        int length = rStart + 1 - rEnd;
        while (length > 0) {
            Component c = this.components[i];
            if (c.offset != c.endOffset) {
                ByteBuf s = c.buf;
                int localRStart = c.idx(length + rEnd);
                int localLength = Math.min(length, localRStart);
                int localIndex = localRStart - localLength;
                int result = s instanceof AbstractByteBuf ? ((AbstractByteBuf)s).forEachByteDesc0(localRStart - 1, localIndex, processor) : s.forEachByteDesc(localIndex, localLength, processor);
                if (result != -1) {
                    return result - c.adjustment;
                }
                length -= localLength;
            }
            --i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public List<ByteBuf> decompose(int offset, int length) {
        ByteBuf byteBuf;
        void bytesToSlice;
        ByteBuf slice;
        this.checkIndex(offset, length);
        if (length == 0) {
            return Collections.emptyList();
        }
        int componentId = this.toComponentIndex0(offset);
        Component firstC = this.components[componentId];
        if ((bytesToSlice -= (slice = firstC.srcBuf.slice(firstC.srcIdx(offset), Math.min(firstC.endOffset - offset, (int)bytesToSlice))).readableBytes()) == false) {
            return Collections.singletonList(slice);
        }
        ArrayList<ByteBuf> sliceList = new ArrayList<ByteBuf>(this.componentCount - componentId);
        sliceList.add(slice);
        do {
            Component component;
            Component component2 = component = this.components[++componentId];
            byteBuf = component.srcBuf.slice(component2.srcIdx(component2.offset), Math.min(((Component)((Object)byteBuf)).length(), (int)bytesToSlice));
            sliceList.add(byteBuf);
        } while ((bytesToSlice -= byteBuf.readableBytes()) > 0);
        return sliceList;
    }

    @Override
    public boolean isDirect() {
        int size = this.componentCount;
        if (size == 0) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (this.components[i].buf.isDirect()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasArray() {
        switch (this.componentCount) {
            case 0: {
                return true;
            }
            case 1: {
                return this.components[0].buf.hasArray();
            }
        }
        return false;
    }

    @Override
    public byte[] array() {
        switch (this.componentCount) {
            case 0: {
                return EmptyArrays.EMPTY_BYTES;
            }
            case 1: {
                return this.components[0].buf.array();
            }
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int arrayOffset() {
        switch (this.componentCount) {
            case 0: {
                return 0;
            }
            case 1: {
                void var1_1;
                Component c = this.components[0];
                return c.idx(var1_1.buf.arrayOffset());
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasMemoryAddress() {
        switch (this.componentCount) {
            case 0: {
                return Unpooled.EMPTY_BUFFER.hasMemoryAddress();
            }
            case 1: {
                return this.components[0].buf.hasMemoryAddress();
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long memoryAddress() {
        switch (this.componentCount) {
            case 0: {
                return Unpooled.EMPTY_BUFFER.memoryAddress();
            }
            case 1: {
                void var1_1;
                Component c = this.components[0];
                return c.buf.memoryAddress() + (long)var1_1.adjustment;
            }
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int capacity() {
        int size = this.componentCount;
        if (size > 0) {
            void var1_1;
            return this.components[var1_1 - true].endOffset;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf capacity(int newCapacity) {
        void padding2;
        this.checkNewCapacity(newCapacity);
        int size = this.componentCount;
        int oldCapacity = ((ByteBuf)this).capacity();
        if (newCapacity > oldCapacity) {
            int paddingLength = newCapacity - oldCapacity;
            ByteBuf padding2 = this.allocBuffer(paddingLength).setIndex(0, paddingLength);
            this.addComponent0(false, size, padding2);
            if (this.componentCount >= this.maxNumComponents) {
                this.consolidateIfNeeded();
            }
        } else if (newCapacity < padding2) {
            void var2_2;
            int i;
            this.lastAccessed = null;
            void bytesToTrim = padding2 - newCapacity;
            for (i = size - 1; i >= 0; --i) {
                Component c = this.components[i];
                int cLength = c.length();
                if (bytesToTrim < cLength) {
                    void var3_5;
                    c.endOffset -= bytesToTrim;
                    ByteBuf slice = c.slice;
                    if (slice == null) break;
                    Component.access$102(c, var3_5.slice(0, c.length()));
                    break;
                }
                c.free();
                var3_3 -= cLength;
            }
            this.removeCompRange(i + 1, (int)var2_2);
            if (((ByteBuf)this).readerIndex() > newCapacity) {
                int n = newCapacity;
                this.setIndex0(n, n);
            } else if (this.writerIndex > newCapacity) {
                void var1_1;
                this.writerIndex = var1_1;
            }
        }
        return this;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    public int numComponents() {
        return this.componentCount;
    }

    public int maxNumComponents() {
        return this.maxNumComponents;
    }

    /*
     * WARNING - void declaration
     */
    public int toComponentIndex(int offset) {
        void var1_1;
        this.checkIndex(offset);
        return this.toComponentIndex0((int)var1_1);
    }

    private int toComponentIndex0(int offset) {
        int high;
        int size = this.componentCount;
        if (offset == 0) {
            for (int i = 0; i < size; ++i) {
                if (this.components[i].endOffset <= 0) continue;
                return i;
            }
        }
        if (size <= 2) {
            if (size == 1 || offset < this.components[0].endOffset) {
                return 0;
            }
            return 1;
        }
        int low = 0;
        while (low <= high) {
            int mid = low + high >>> 1;
            Component c = this.components[mid];
            if (offset >= c.endOffset) {
                low = mid + 1;
                continue;
            }
            if (offset < c.offset) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        throw new Error("should not reach here");
    }

    /*
     * WARNING - void declaration
     */
    public int toByteIndex(int cIndex) {
        void var1_1;
        this.checkComponentIndex(cIndex);
        return this.components[var1_1].offset;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte getByte(int index) {
        void var1_1;
        void var2_2;
        Component c = this.findComponent(index);
        return c.buf.getByte(var2_2.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected byte _getByte(int index) {
        void var1_1;
        void var2_2;
        Component c = this.findComponent0(index);
        return c.buf.getByte(var2_2.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected short _getShort(int index) {
        void var1_1;
        Component c = this.findComponent0(index);
        if (index + 2 <= c.endOffset) {
            void var2_2;
            return c.buf.getShort(var2_2.idx(index));
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return (short)((this._getByte(index) & 0xFF) << 8 | this._getByte(index + 1) & 0xFF);
        }
        return (short)(this._getByte(index) & 0xFF | (this._getByte((int)(var1_1 + true)) & 0xFF) << 8);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected short _getShortLE(int index) {
        void var1_1;
        Component c = this.findComponent0(index);
        if (index + 2 <= c.endOffset) {
            void var2_2;
            return c.buf.getShortLE(var2_2.idx(index));
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return (short)(this._getByte(index) & 0xFF | (this._getByte(index + 1) & 0xFF) << 8);
        }
        return (short)((this._getByte(index) & 0xFF) << 8 | this._getByte((int)(var1_1 + true)) & 0xFF);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getUnsignedMedium(int index) {
        void var1_1;
        Component c = this.findComponent0(index);
        if (index + 3 <= c.endOffset) {
            void var2_2;
            return c.buf.getUnsignedMedium(var2_2.idx(index));
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return (this._getShort(index) & 0xFFFF) << 8 | this._getByte(index + 2) & 0xFF;
        }
        return this._getShort(index) & 0xFFFF | (this._getByte((int)(var1_1 + 2)) & 0xFF) << 16;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getUnsignedMediumLE(int index) {
        void var1_1;
        Component c = this.findComponent0(index);
        if (index + 3 <= c.endOffset) {
            void var2_2;
            return c.buf.getUnsignedMediumLE(var2_2.idx(index));
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return this._getShortLE(index) & 0xFFFF | (this._getByte(index + 2) & 0xFF) << 16;
        }
        return (this._getShortLE(index) & 0xFFFF) << 8 | this._getByte((int)(var1_1 + 2)) & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getInt(int index) {
        void var1_1;
        Component c = this.findComponent0(index);
        if (index + 4 <= c.endOffset) {
            void var2_2;
            return c.buf.getInt(var2_2.idx(index));
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return (this._getShort(index) & 0xFFFF) << 16 | this._getShort(index + 2) & 0xFFFF;
        }
        return this._getShort(index) & 0xFFFF | (this._getShort((int)(var1_1 + 2)) & 0xFFFF) << 16;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getIntLE(int index) {
        void var1_1;
        Component c = this.findComponent0(index);
        if (index + 4 <= c.endOffset) {
            void var2_2;
            return c.buf.getIntLE(var2_2.idx(index));
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return this._getShortLE(index) & 0xFFFF | (this._getShortLE(index + 2) & 0xFFFF) << 16;
        }
        return (this._getShortLE(index) & 0xFFFF) << 16 | this._getShortLE((int)(var1_1 + 2)) & 0xFFFF;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected long _getLong(int index) {
        void var1_1;
        Component c = this.findComponent0(index);
        if (index + 8 <= c.endOffset) {
            void var2_2;
            return c.buf.getLong(var2_2.idx(index));
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return ((long)this._getInt(index) & 0xFFFFFFFFL) << 32 | (long)this._getInt(index + 4) & 0xFFFFFFFFL;
        }
        return (long)this._getInt(index) & 0xFFFFFFFFL | ((long)this._getInt((int)(var1_1 + 4)) & 0xFFFFFFFFL) << 32;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected long _getLongLE(int index) {
        void var1_1;
        Component c = this.findComponent0(index);
        if (index + 8 <= c.endOffset) {
            void var2_2;
            return c.buf.getLongLE(var2_2.idx(index));
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return (long)this._getIntLE(index) & 0xFFFFFFFFL | ((long)this._getIntLE(index + 4) & 0xFFFFFFFFL) << 32;
        }
        return ((long)this._getIntLE(index) & 0xFFFFFFFFL) << 32 | (long)this._getIntLE((int)(var1_1 + 4)) & 0xFFFFFFFFL;
    }

    @Override
    public CompositeByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.checkDstIndex(index, length, dstIndex, dst.length);
        if (length == 0) {
            return this;
        }
        int i = this.toComponentIndex0(index);
        while (length > 0) {
            Component c = this.components[i];
            int localLength = Math.min(length, c.endOffset - index);
            c.buf.getBytes(c.idx(index), dst, dstIndex, localLength);
            index += localLength;
            dstIndex += localLength;
            length -= localLength;
            ++i;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf getBytes(int index, ByteBuffer dst) {
        int limit = dst.limit();
        int length = dst.remaining();
        this.checkIndex(index, length);
        if (length == 0) {
            return this;
        }
        int i = this.toComponentIndex0(index);
        try {
            while (length > 0) {
                Component c = this.components[i];
                int localLength = Math.min(length, c.endOffset - index);
                ByteBuffer byteBuffer = dst;
                byteBuffer.limit(byteBuffer.position() + localLength);
                c.buf.getBytes(c.idx(index), dst);
                index += localLength;
                length -= localLength;
                ++i;
            }
            dst.limit(limit);
        }
        catch (Throwable throwable) {
            void var3_4;
            void var2_3;
            var2_3.limit((int)var3_4);
            throw throwable;
        }
        return this;
    }

    @Override
    public CompositeByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.checkDstIndex(index, length, dstIndex, dst.capacity());
        if (length == 0) {
            return this;
        }
        int i = this.toComponentIndex0(index);
        while (length > 0) {
            Component c = this.components[i];
            int localLength = Math.min(length, c.endOffset - index);
            c.buf.getBytes(c.idx(index), dst, dstIndex, localLength);
            index += localLength;
            dstIndex += localLength;
            length -= localLength;
            ++i;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        int n = ((ByteBuf)this).nioBufferCount();
        if (n == 1) {
            return out.write(((ByteBuf)this).internalNioBuffer(index, length));
        }
        long writtenBytes = var2_2.write(((ByteBuf)this).nioBuffers((int)var1_1, (int)var3_3));
        if (writtenBytes > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)writtenBytes;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        void var1_1;
        int n = ((ByteBuf)this).nioBufferCount();
        if (n == 1) {
            return out.write(((ByteBuf)this).internalNioBuffer(index, length), position);
        }
        long writtenBytes = 0L;
        for (ByteBuffer buf : ((ByteBuf)this).nioBuffers((int)var1_1, length)) {
            writtenBytes += (long)out.write(buf, position + writtenBytes);
        }
        if (writtenBytes > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)writtenBytes;
    }

    @Override
    public CompositeByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        this.checkIndex(index, length);
        if (length == 0) {
            return this;
        }
        int i = this.toComponentIndex0(index);
        while (length > 0) {
            Component c = this.components[i];
            int localLength = Math.min(length, c.endOffset - index);
            c.buf.getBytes(c.idx(index), out, localLength);
            index += localLength;
            length -= localLength;
            ++i;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf setByte(int index, int value) {
        void var2_2;
        void var1_1;
        void var3_3;
        Component c = this.findComponent(index);
        c.buf.setByte(var3_3.idx((int)var1_1), (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setByte(int index, int value) {
        void var2_2;
        void var1_1;
        void var3_3;
        Component c = this.findComponent0(index);
        c.buf.setByte(var3_3.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf setShort(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, 2);
        this._setShort((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setShort(int index, int value) {
        void var2_2;
        void var1_1;
        Component c = this.findComponent0(index);
        if (index + 2 <= c.endOffset) {
            void var3_3;
            c.buf.setShort(var3_3.idx(index), value);
            return;
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            this._setByte(index, (byte)(value >>> 8));
            this._setByte(index + 1, (byte)value);
            return;
        }
        this._setByte(index, (byte)value);
        this._setByte((int)(var1_1 + true), (byte)(var2_2 >>> 8));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setShortLE(int index, int value) {
        void var2_2;
        void var1_1;
        Component c = this.findComponent0(index);
        if (index + 2 <= c.endOffset) {
            void var3_3;
            c.buf.setShortLE(var3_3.idx(index), value);
            return;
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            this._setByte(index, (byte)value);
            this._setByte(index + 1, (byte)(value >>> 8));
            return;
        }
        this._setByte(index, (byte)(value >>> 8));
        this._setByte((int)(var1_1 + true), (byte)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf setMedium(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, 3);
        this._setMedium((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setMedium(int index, int value) {
        void var2_2;
        void var1_1;
        Component c = this.findComponent0(index);
        if (index + 3 <= c.endOffset) {
            void var3_3;
            c.buf.setMedium(var3_3.idx(index), value);
            return;
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            this._setShort(index, (short)(value >> 8));
            this._setByte(index + 2, (byte)value);
            return;
        }
        this._setShort(index, (short)value);
        this._setByte((int)(var1_1 + 2), (byte)(var2_2 >>> 16));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setMediumLE(int index, int value) {
        void var2_2;
        void var1_1;
        Component c = this.findComponent0(index);
        if (index + 3 <= c.endOffset) {
            void var3_3;
            c.buf.setMediumLE(var3_3.idx(index), value);
            return;
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            this._setShortLE(index, (short)value);
            this._setByte(index + 2, (byte)(value >>> 16));
            return;
        }
        this._setShortLE(index, (short)(value >> 8));
        this._setByte((int)(var1_1 + 2), (byte)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf setInt(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, 4);
        this._setInt((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setInt(int index, int value) {
        void var2_2;
        void var1_1;
        Component c = this.findComponent0(index);
        if (index + 4 <= c.endOffset) {
            void var3_3;
            c.buf.setInt(var3_3.idx(index), value);
            return;
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            this._setShort(index, (short)(value >>> 16));
            this._setShort(index + 2, (short)value);
            return;
        }
        this._setShort(index, (short)value);
        this._setShort((int)(var1_1 + 2), (short)(var2_2 >>> 16));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setIntLE(int index, int value) {
        void var2_2;
        void var1_1;
        Component c = this.findComponent0(index);
        if (index + 4 <= c.endOffset) {
            void var3_3;
            c.buf.setIntLE(var3_3.idx(index), value);
            return;
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            this._setShortLE(index, (short)value);
            this._setShortLE(index + 2, (short)(value >>> 16));
            return;
        }
        this._setShortLE(index, (short)(value >>> 16));
        this._setShortLE((int)(var1_1 + 2), (short)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf setLong(int index, long value) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, 8);
        this._setLong((int)var1_1, (long)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setLong(int index, long value) {
        void var2_2;
        void var1_1;
        Component c = this.findComponent0(index);
        if (index + 8 <= c.endOffset) {
            c.buf.setLong(c.idx(index), value);
            return;
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            this._setInt(index, (int)(value >>> 32));
            this._setInt(index + 4, (int)value);
            return;
        }
        this._setInt(index, (int)value);
        this._setInt((int)(var1_1 + 4), (int)(var2_2 >>> 32));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setLongLE(int index, long value) {
        void var2_2;
        void var1_1;
        Component c = this.findComponent0(index);
        if (index + 8 <= c.endOffset) {
            c.buf.setLongLE(c.idx(index), value);
            return;
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            this._setIntLE(index, (int)value);
            this._setIntLE(index + 4, (int)(value >>> 32));
            return;
        }
        this._setIntLE(index, (int)(value >>> 32));
        this._setIntLE((int)(var1_1 + 4), (int)var2_2);
    }

    @Override
    public CompositeByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        this.checkSrcIndex(index, length, srcIndex, src.length);
        if (length == 0) {
            return this;
        }
        int i = this.toComponentIndex0(index);
        while (length > 0) {
            Component c = this.components[i];
            int localLength = Math.min(length, c.endOffset - index);
            c.buf.setBytes(c.idx(index), src, srcIndex, localLength);
            index += localLength;
            srcIndex += localLength;
            length -= localLength;
            ++i;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf setBytes(int index, ByteBuffer src) {
        int limit = src.limit();
        int length = src.remaining();
        this.checkIndex(index, length);
        if (length == 0) {
            return this;
        }
        int i = this.toComponentIndex0(index);
        try {
            while (length > 0) {
                Component c = this.components[i];
                int localLength = Math.min(length, c.endOffset - index);
                ByteBuffer byteBuffer = src;
                byteBuffer.limit(byteBuffer.position() + localLength);
                c.buf.setBytes(c.idx(index), src);
                index += localLength;
                length -= localLength;
                ++i;
            }
            src.limit(limit);
        }
        catch (Throwable throwable) {
            void var3_4;
            void var2_3;
            var2_3.limit((int)var3_4);
            throw throwable;
        }
        return this;
    }

    @Override
    public CompositeByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.checkSrcIndex(index, length, srcIndex, src.capacity());
        if (length == 0) {
            return this;
        }
        int i = this.toComponentIndex0(index);
        while (length > 0) {
            Component c = this.components[i];
            int localLength = Math.min(length, c.endOffset - index);
            c.buf.setBytes(c.idx(index), src, srcIndex, localLength);
            index += localLength;
            srcIndex += localLength;
            length -= localLength;
            ++i;
        }
        return this;
    }

    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        this.checkIndex(index, length);
        if (length == 0) {
            return in.read(EmptyArrays.EMPTY_BYTES);
        }
        int i = this.toComponentIndex0(index);
        int readBytes = 0;
        do {
            Component c = this.components[i];
            int localLength = Math.min(length, c.endOffset - index);
            if (localLength == 0) {
                ++i;
                continue;
            }
            int localReadBytes = c.buf.setBytes(c.idx(index), in, localLength);
            if (localReadBytes < 0) {
                if (readBytes != 0) break;
                return -1;
            }
            index += localReadBytes;
            length -= localReadBytes;
            readBytes += localReadBytes;
            if (localReadBytes != localLength) continue;
            ++i;
        } while (length > 0);
        return readBytes;
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        this.checkIndex(index, length);
        if (length == 0) {
            return in.read(EMPTY_NIO_BUFFER);
        }
        int i = this.toComponentIndex0(index);
        int readBytes = 0;
        do {
            Component c = this.components[i];
            int localLength = Math.min(length, c.endOffset - index);
            if (localLength == 0) {
                ++i;
                continue;
            }
            int localReadBytes = c.buf.setBytes(c.idx(index), in, localLength);
            if (localReadBytes == 0) break;
            if (localReadBytes < 0) {
                if (readBytes != 0) break;
                return -1;
            }
            index += localReadBytes;
            length -= localReadBytes;
            readBytes += localReadBytes;
            if (localReadBytes != localLength) continue;
            ++i;
        } while (length > 0);
        return readBytes;
    }

    @Override
    public int setBytes(int index, FileChannel in, long position, int length) throws IOException {
        this.checkIndex(index, length);
        if (length == 0) {
            return in.read(EMPTY_NIO_BUFFER, position);
        }
        int i = this.toComponentIndex0(index);
        int readBytes = 0;
        do {
            Component c = this.components[i];
            int localLength = Math.min(length, c.endOffset - index);
            if (localLength == 0) {
                ++i;
                continue;
            }
            int localReadBytes = c.buf.setBytes(c.idx(index), in, position + (long)readBytes, localLength);
            if (localReadBytes == 0) break;
            if (localReadBytes < 0) {
                if (readBytes != 0) break;
                return -1;
            }
            index += localReadBytes;
            length -= localReadBytes;
            readBytes += localReadBytes;
            if (localReadBytes != localLength) continue;
            ++i;
        } while (length > 0);
        return readBytes;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf copy(int index, int length) {
        void var3_3;
        this.checkIndex(index, length);
        ByteBuf dst = this.allocBuffer(length);
        if (length != 0) {
            void var1_1;
            void var2_2;
            this.copyTo(index, (int)var2_2, this.toComponentIndex0((int)var1_1), dst);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private void copyTo(int index, int length, int componentId, ByteBuf dst) {
        int dstIndex = 0;
        while (length > 0) {
            void i;
            Component c = this.components[i];
            int localLength = Math.min(length, c.endOffset - index);
            c.buf.getBytes(c.idx(index), dst, dstIndex, localLength);
            index += localLength;
            dstIndex += localLength;
            length -= localLength;
            ++i;
        }
        ByteBuf byteBuf = dst;
        byteBuf.writerIndex(byteBuf.capacity());
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuf component(int cIndex) {
        void var1_1;
        this.checkComponentIndex(cIndex);
        return this.components[var1_1].duplicate();
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuf componentAtOffset(int offset) {
        void var1_1;
        return this.findComponent((int)var1_1).duplicate();
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuf internalComponent(int cIndex) {
        void var1_1;
        this.checkComponentIndex(cIndex);
        return this.components[var1_1].slice();
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuf internalComponentAtOffset(int offset) {
        void var1_1;
        return this.findComponent((int)var1_1).slice();
    }

    /*
     * WARNING - void declaration
     */
    private Component findComponent(int offset) {
        void var1_1;
        Component la = this.lastAccessed;
        if (la != null && offset >= la.offset && offset < la.endOffset) {
            void var2_2;
            this.ensureAccessible();
            return var2_2;
        }
        this.checkIndex(offset);
        return this.findIt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private Component findComponent0(int offset) {
        void var1_1;
        Component la = this.lastAccessed;
        if (la != null && offset >= la.offset && offset < la.endOffset) {
            void var2_2;
            return var2_2;
        }
        return this.findIt((int)var1_1);
    }

    private Component findIt(int offset) {
        int low = 0;
        int high = this.componentCount;
        while (low <= high) {
            int mid = low + high >>> 1;
            Component c = this.components[mid];
            if (c == null) {
                throw new IllegalStateException("No component found for offset. Composite buffer layout might be outdated, e.g. from a discardReadBytes call.");
            }
            if (offset >= c.endOffset) {
                low = mid + 1;
                continue;
            }
            if (offset < c.offset) {
                high = mid - 1;
                continue;
            }
            this.lastAccessed = c;
            return c;
        }
        throw new Error("should not reach here");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int nioBufferCount() {
        void var2_2;
        int size = this.componentCount;
        switch (size) {
            case 0: {
                return 1;
            }
            case 1: {
                return this.components[0].buf.nioBufferCount();
            }
        }
        int count = 0;
        for (int i = 0; i < size; ++i) {
            count += this.components[i].buf.nioBufferCount();
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer internalNioBuffer(int index, int length) {
        switch (this.componentCount) {
            case 0: {
                return EMPTY_NIO_BUFFER;
            }
            case 1: {
                void var2_2;
                void var1_1;
                return this.components[0].internalNioBuffer((int)var1_1, (int)var2_2);
            }
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer nioBuffer(int index, int length) {
        void var3_4;
        int n;
        void var1_1;
        this.checkIndex(index, length);
        switch (this.componentCount) {
            case 0: {
                return EMPTY_NIO_BUFFER;
            }
            case 1: {
                Component c = this.components[0];
                ByteBuf buf = c.buf;
                if (buf.nioBufferCount() != 1) break;
                return buf.nioBuffer(c.idx(index), length);
            }
        }
        ByteBuffer[] buffers = ((ByteBuf)this).nioBuffers((int)var1_1, length);
        if (buffers.length == 1) {
            return buffers[0];
        }
        ByteBuffer merged = ByteBuffer.allocate(n).order(((ByteBuf)this).order());
        for (void buf : var3_4) {
            merged.put((ByteBuffer)buf);
        }
        merged.flip();
        return merged;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer[] nioBuffers(int index, int length) {
        ByteBuffer[] byteBufferArray;
        this.checkIndex(index, length);
        if (length == 0) {
            return new ByteBuffer[]{EMPTY_NIO_BUFFER};
        }
        RecyclableArrayList buffers = RecyclableArrayList.newInstance((int)this.componentCount);
        try {
            int i = this.toComponentIndex0(index);
            while (length > 0) {
                Component c = this.components[i];
                ByteBuf s = c.buf;
                int localLength = Math.min(length, c.endOffset - index);
                switch (s.nioBufferCount()) {
                    case 0: {
                        throw new UnsupportedOperationException();
                    }
                    case 1: {
                        buffers.add((Object)s.nioBuffer(c.idx(index), localLength));
                        break;
                    }
                    default: {
                        Collections.addAll(buffers, s.nioBuffers(c.idx(index), localLength));
                    }
                }
                index += localLength;
                length -= localLength;
                ++i;
            }
            byteBufferArray = (ByteBuffer[])buffers.toArray((Object[])EmptyArrays.EMPTY_BYTE_BUFFERS);
        }
        catch (Throwable throwable) {
            void var3_4;
            var3_4.recycle();
            throw throwable;
        }
        buffers.recycle();
        return byteBufferArray;
    }

    public CompositeByteBuf consolidate() {
        this.ensureAccessible();
        this.consolidate0(0, this.componentCount);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public CompositeByteBuf consolidate(int cIndex, int numComponents) {
        void var2_2;
        void var1_1;
        this.checkComponentIndex(cIndex, numComponents);
        this.consolidate0((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void consolidate0(int cIndex, int numComponents) {
        void var2_2;
        void var3_3;
        if (numComponents <= 1) {
            return;
        }
        int endCIndex = cIndex + numComponents;
        int startOffset = cIndex != 0 ? this.components[cIndex].offset : 0;
        int capacity = this.components[endCIndex - 1].endOffset - startOffset;
        ByteBuf consolidated = this.allocBuffer(capacity);
        for (int i = cIndex; i < endCIndex; ++i) {
            this.components[i].transferTo(consolidated);
        }
        this.lastAccessed = null;
        this.removeCompRange(cIndex + 1, (int)var3_3);
        this.components[cIndex] = this.newComponent(consolidated, 0);
        if (cIndex != 0 || var2_2 != this.componentCount) {
            void var1_1;
            this.updateComponentOffsets((int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public CompositeByteBuf discardReadComponents() {
        void var3_4;
        void var2_2;
        void var1_1;
        int firstComponentId;
        this.ensureAccessible();
        int readerIndex = ((ByteBuf)this).readerIndex();
        if (readerIndex == 0) {
            return this;
        }
        int writerIndex = ((ByteBuf)this).writerIndex();
        if (readerIndex == writerIndex && writerIndex == ((ByteBuf)this).capacity()) {
            int size = this.componentCount;
            for (int i = 0; i < size; ++i) {
                this.components[i].free();
            }
            this.lastAccessed = null;
            this.clearComps();
            this.setIndex(0, 0);
            this.adjustMarkers(readerIndex);
            return this;
        }
        Component c = null;
        int size = this.componentCount;
        for (firstComponentId = 0; firstComponentId < size; ++firstComponentId) {
            c = this.components[firstComponentId];
            if (c.endOffset > readerIndex) break;
            c.free();
        }
        if (firstComponentId == 0) {
            return this;
        }
        Component la = this.lastAccessed;
        if (la != null && la.endOffset <= readerIndex) {
            this.lastAccessed = null;
        }
        this.removeCompRange(0, firstComponentId);
        int offset = c.offset;
        this.updateComponentOffsets(0);
        this.setIndex((int)(var1_1 - offset), (int)(var2_2 - offset));
        this.adjustMarkers((int)var3_4);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf discardReadBytes() {
        void var1_1;
        void var2_2;
        void var3_4;
        Component la;
        this.ensureAccessible();
        int readerIndex = ((ByteBuf)this).readerIndex();
        if (readerIndex == 0) {
            return this;
        }
        int writerIndex = ((ByteBuf)this).writerIndex();
        if (readerIndex == writerIndex && writerIndex == ((ByteBuf)this).capacity()) {
            int size = this.componentCount;
            for (int i = 0; i < size; ++i) {
                this.components[i].free();
            }
            this.lastAccessed = null;
            this.clearComps();
            this.setIndex(0, 0);
            this.adjustMarkers(readerIndex);
            return this;
        }
        Component c = null;
        int size = this.componentCount;
        for (int firstComponentId = 0; firstComponentId < size; ++firstComponentId) {
            c = this.components[firstComponentId];
            if (c.endOffset > readerIndex) break;
            c.free();
        }
        int trimmedBytes = readerIndex - c.offset;
        c.offset = 0;
        c.endOffset -= readerIndex;
        c.srcAdjustment += readerIndex;
        c.adjustment += readerIndex;
        ByteBuf slice = c.slice;
        if (slice != null) {
            Component.access$102(c, slice.slice(trimmedBytes, c.length()));
        }
        if ((la = this.lastAccessed) != null && la.endOffset <= readerIndex) {
            this.lastAccessed = null;
        }
        this.removeCompRange(0, (int)var3_4);
        this.updateComponentOffsets(0);
        this.setIndex(0, (int)(var2_2 - readerIndex));
        this.adjustMarkers((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuf allocBuffer(int capacity) {
        void var1_1;
        if (this.direct) {
            return ((ByteBuf)this).alloc().directBuffer(capacity);
        }
        return ((ByteBuf)this).alloc().heapBuffer((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString() {
        void var1_1;
        String result = super.toString();
        result = result.substring(0, result.length() - 1);
        return (String)var1_1 + ", components=" + this.componentCount + ')';
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf readerIndex(int readerIndex) {
        void var1_1;
        super.readerIndex((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf writerIndex(int writerIndex) {
        void var1_1;
        super.writerIndex((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf setIndex(int readerIndex, int writerIndex) {
        void var2_2;
        void var1_1;
        super.setIndex((int)var1_1, (int)var2_2);
        return this;
    }

    @Override
    public CompositeByteBuf clear() {
        super.clear();
        return this;
    }

    @Override
    public CompositeByteBuf markReaderIndex() {
        super.markReaderIndex();
        return this;
    }

    @Override
    public CompositeByteBuf resetReaderIndex() {
        super.resetReaderIndex();
        return this;
    }

    @Override
    public CompositeByteBuf markWriterIndex() {
        super.markWriterIndex();
        return this;
    }

    @Override
    public CompositeByteBuf resetWriterIndex() {
        super.resetWriterIndex();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf ensureWritable(int minWritableBytes) {
        void var1_1;
        super.ensureWritable((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf getBytes(int index, ByteBuf dst) {
        void var1_1;
        void var2_2;
        void v0 = var2_2;
        return this.getBytes((int)var1_1, (ByteBuf)v0, v0.writableBytes());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf getBytes(int index, ByteBuf dst, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        ByteBuf byteBuf = dst;
        this.getBytes((int)var1_1, byteBuf, byteBuf.writerIndex(), length);
        void v1 = var2_2;
        v1.writerIndex(v1.writerIndex() + var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf getBytes(int index, byte[] dst) {
        void var2_2;
        void var1_1;
        return this.getBytes((int)var1_1, dst, 0, ((void)var2_2).length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf setBoolean(int index, boolean value) {
        void var2_2;
        void var1_1;
        return this.setByte((int)var1_1, var2_2 != false ? 1 : 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf setChar(int index, int value) {
        void var2_2;
        void var1_1;
        return this.setShort((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf setFloat(int index, float value) {
        void var2_2;
        void var1_1;
        return this.setInt((int)var1_1, Float.floatToRawIntBits((float)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf setDouble(int index, double value) {
        void var2_2;
        void var1_1;
        return this.setLong((int)var1_1, Double.doubleToRawLongBits((double)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf setBytes(int index, ByteBuf src) {
        void var1_1;
        void var2_2;
        void v0 = var2_2;
        super.setBytes((int)var1_1, (ByteBuf)v0, v0.readableBytes());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf setBytes(int index, ByteBuf src, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.setBytes((int)var1_1, (ByteBuf)var2_2, (int)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf setBytes(int index, byte[] src) {
        void var2_2;
        void var1_1;
        return this.setBytes((int)var1_1, src, 0, ((void)var2_2).length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf setZero(int index, int length) {
        void var2_2;
        void var1_1;
        super.setZero((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf readBytes(ByteBuf dst) {
        void var1_1;
        void v0 = var1_1;
        super.readBytes((ByteBuf)v0, v0.writableBytes());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf readBytes(ByteBuf dst, int length) {
        void var2_2;
        void var1_1;
        super.readBytes((ByteBuf)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf readBytes(ByteBuf dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.readBytes((ByteBuf)var1_1, (int)var2_2, (int)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf readBytes(byte[] dst) {
        void var1_1;
        super.readBytes(dst, 0, ((void)var1_1).length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf readBytes(byte[] dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.readBytes((byte[])var1_1, (int)var2_2, (int)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf readBytes(ByteBuffer dst) {
        void var1_1;
        super.readBytes((ByteBuffer)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf readBytes(OutputStream out, int length) throws IOException {
        void var2_2;
        void var1_1;
        super.readBytes((OutputStream)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf skipBytes(int length) {
        void var1_1;
        super.skipBytes((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf writeBoolean(boolean value) {
        void var1_1;
        this.writeByte(var1_1 != false ? 1 : 0);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf writeByte(int value) {
        void var1_1;
        this.ensureWritable0(1);
        CompositeByteBuf compositeByteBuf = this;
        compositeByteBuf._setByte(compositeByteBuf.writerIndex++, (int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf writeShort(int value) {
        void var1_1;
        super.writeShort((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf writeMedium(int value) {
        void var1_1;
        super.writeMedium((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf writeInt(int value) {
        void var1_1;
        super.writeInt((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf writeLong(long value) {
        void var1_1;
        super.writeLong((long)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf writeChar(int value) {
        void var1_1;
        super.writeShort((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf writeFloat(float value) {
        void var1_1;
        super.writeInt(Float.floatToRawIntBits((float)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf writeDouble(double value) {
        void var1_1;
        super.writeLong(Double.doubleToRawLongBits((double)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf writeBytes(ByteBuf src) {
        void var1_1;
        void v0 = var1_1;
        super.writeBytes((ByteBuf)v0, v0.readableBytes());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf writeBytes(ByteBuf src, int length) {
        void var2_2;
        void var1_1;
        super.writeBytes((ByteBuf)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf writeBytes(ByteBuf src, int srcIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.writeBytes((ByteBuf)var1_1, (int)var2_2, (int)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf writeBytes(byte[] src) {
        void var1_1;
        super.writeBytes(src, 0, ((void)var1_1).length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf writeBytes(byte[] src, int srcIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.writeBytes((byte[])var1_1, (int)var2_2, (int)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf writeBytes(ByteBuffer src) {
        void var1_1;
        super.writeBytes((ByteBuffer)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf writeZero(int length) {
        void var1_1;
        super.writeZero((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf retain(int increment) {
        void var1_1;
        super.retain((int)var1_1);
        return this;
    }

    @Override
    public CompositeByteBuf retain() {
        super.retain();
        return this;
    }

    @Override
    public CompositeByteBuf touch() {
        return this;
    }

    @Override
    public CompositeByteBuf touch(Object hint) {
        return this;
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        CompositeByteBuf compositeByteBuf = this;
        return ((ByteBuf)compositeByteBuf).nioBuffers(((ByteBuf)compositeByteBuf).readerIndex(), ((ByteBuf)this).readableBytes());
    }

    @Override
    public CompositeByteBuf discardSomeReadBytes() {
        return this.discardReadComponents();
    }

    @Override
    protected void deallocate() {
        if (this.freed) {
            return;
        }
        this.freed = true;
        int size = this.componentCount;
        for (int i = 0; i < size; ++i) {
            this.components[i].free();
        }
    }

    @Override
    boolean isAccessible() {
        return !this.freed;
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }

    private void clearComps() {
        this.removeCompRange(0, this.componentCount);
    }

    /*
     * WARNING - void declaration
     */
    private void removeComp(int i) {
        void var1_1;
        void v0 = var1_1;
        this.removeCompRange((int)v0, (int)(v0 + true));
    }

    /*
     * WARNING - void declaration
     */
    private void removeCompRange(int from, int to) {
        void var1_1;
        int newSize;
        if (from >= to) {
            return;
        }
        int size = this.componentCount;
        assert (from >= 0 && to <= size);
        if (to < size) {
            System.arraycopy(this.components, to, this.components, from, size - to);
        }
        for (int i = newSize = size - to + from; i < size; ++i) {
            this.components[i] = null;
        }
        this.componentCount = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void addComp(int i, Component c) {
        void var2_2;
        this.shiftComps(i, 1);
        this.components[var1_1] = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void shiftComps(int i, int count) {
        int size = this.componentCount;
        int newSize = size + count;
        assert (i >= 0 && i <= size && count > 0);
        if (newSize > this.components.length) {
            Component[] newArr2;
            int n = size;
            int newArrSize = Math.max(n + (n >> 1), newSize);
            if (i == size) {
                newArr2 = (Component[])Arrays.copyOf(this.components, newArrSize, Component[].class);
            } else {
                void newArr;
                newArr2 = new Component[newArr];
                if (i > 0) {
                    System.arraycopy(this.components, 0, newArr2, 0, i);
                }
                if (i < size) {
                    System.arraycopy(this.components, i, newArr2, i + count, size - i);
                }
            }
            this.components = newArr2;
        } else if (i < size) {
            void var1_1;
            void var3_3;
            void var2_2;
            System.arraycopy(this.components, i, this.components, i + var2_2, (int)(var3_3 - var1_1));
        }
        this.componentCount = newSize;
    }

    private final class CompositeByteBufIterator
    implements Iterator<ByteBuf> {
        private final int size;
        private int index;

        private CompositeByteBufIterator() {
            this.size = CompositeByteBuf.this.numComponents();
        }

        @Override
        public final boolean hasNext() {
            return this.size > this.index;
        }

        @Override
        public final ByteBuf next() {
            if (this.size != CompositeByteBuf.this.numComponents()) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                return CompositeByteBuf.this.components[this.index++].slice();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("Read-Only");
        }
    }

    private static final class Component {
        final ByteBuf srcBuf;
        final ByteBuf buf;
        int srcAdjustment;
        int adjustment;
        int offset;
        int endOffset;
        private ByteBuf slice;

        /*
         * WARNING - void declaration
         */
        Component(ByteBuf srcBuf, int srcOffset, ByteBuf buf, int bufOffset, int offset, int len, ByteBuf slice) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.srcBuf = var1_1;
            this.srcAdjustment = var2_2 - offset;
            this.buf = var3_3;
            this.adjustment = bufOffset - offset;
            this.offset = offset;
            this.endOffset = offset + len;
            this.slice = slice;
        }

        final int srcIdx(int index) {
            return index + this.srcAdjustment;
        }

        final int idx(int index) {
            return index + this.adjustment;
        }

        final int length() {
            return this.endOffset - this.offset;
        }

        /*
         * WARNING - void declaration
         */
        final void reposition(int newOffset) {
            void var1_1;
            void var2_2;
            int move = newOffset - this.offset;
            this.endOffset += move;
            this.srcAdjustment -= move;
            this.adjustment -= var2_2;
            this.offset = var1_1;
        }

        final void transferTo(ByteBuf dst) {
            Component component = this;
            dst.writeBytes(this.buf, component.idx(component.offset), this.length());
            this.free();
        }

        /*
         * WARNING - void declaration
         */
        final ByteBuf slice() {
            void var1_1;
            ByteBuf s = this.slice;
            if (s == null) {
                Component component = this;
                this.slice = s = this.srcBuf.slice(component.srcIdx(component.offset), this.length());
            }
            return var1_1;
        }

        final ByteBuf duplicate() {
            return this.srcBuf.duplicate();
        }

        /*
         * WARNING - void declaration
         */
        final ByteBuffer internalNioBuffer(int index, int length) {
            void var2_2;
            void var1_1;
            return this.srcBuf.internalNioBuffer(this.srcIdx((int)var1_1), (int)var2_2);
        }

        final void free() {
            this.slice = null;
            this.srcBuf.release();
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ ByteBuf access$102(Component x0, ByteBuf x1) {
            void var1_1;
            x0.slice = var1_1;
            return x0.slice;
        }
    }

    static interface ByteWrapper<T> {
        public ByteBuf wrap(T var1);

        public boolean isEmpty(T var1);
    }
}

