/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.AdaptiveByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.buffer.UnpooledDirectByteBuf;
import io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import io.netty.buffer.WrappedByteBuf;
import io.netty.buffer.WrappedCompositeByteBuf;
import io.netty.util.AsciiString;
import io.netty.util.ByteProcessor;
import io.netty.util.CharsetUtil;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.Recycler;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SWARUtil;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;

public final class ByteBufUtil {
    private static final InternalLogger logger;
    private static final FastThreadLocal<byte[]> BYTE_ARRAYS;
    private static final byte WRITE_UTF_UNKNOWN = 63;
    private static final int MAX_CHAR_BUFFER_SIZE;
    private static final int THREAD_LOCAL_BUFFER_SIZE;
    private static final int MAX_BYTES_PER_CHAR_UTF8;
    static final int WRITE_CHUNK_SIZE = 8192;
    static final ByteBufAllocator DEFAULT_ALLOCATOR;
    static final int MAX_TL_ARRAY_LEN = 1024;
    private static final ByteProcessor FIND_NON_ASCII;

    static byte[] threadLocalTempArray(int minLength) {
        int n;
        if (minLength <= 1024) {
            return (byte[])BYTE_ARRAYS.get();
        }
        return PlatformDependent.allocateUninitializedArray((int)n);
    }

    public static boolean isAccessible(ByteBuf buffer) {
        return buffer.isAccessible();
    }

    public static ByteBuf ensureAccessible(ByteBuf buffer) {
        ByteBuf byteBuf;
        if (!buffer.isAccessible()) {
            throw new IllegalReferenceCountException(buffer.refCnt());
        }
        return byteBuf;
    }

    public static String hexDump(ByteBuf buffer) {
        ByteBuf byteBuf;
        ByteBuf byteBuf2 = buffer;
        return ByteBufUtil.hexDump(byteBuf2, byteBuf2.readerIndex(), byteBuf.readableBytes());
    }

    /*
     * WARNING - void declaration
     */
    public static String hexDump(ByteBuf buffer, int fromIndex, int length) {
        void var2_2;
        void var1_1;
        return HexUtil.access$000(buffer, (int)var1_1, (int)var2_2);
    }

    public static String hexDump(byte[] array) {
        byte[] byArray;
        return ByteBufUtil.hexDump(array, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static String hexDump(byte[] array, int fromIndex, int length) {
        void var2_2;
        void var1_1;
        return HexUtil.access$100(array, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static byte decodeHexByte(CharSequence s, int pos) {
        void var1_1;
        return StringUtil.decodeHexByte((CharSequence)s, (int)var1_1);
    }

    public static byte[] decodeHexDump(CharSequence hexDump) {
        CharSequence charSequence;
        return StringUtil.decodeHexDump((CharSequence)hexDump, (int)0, (int)charSequence.length());
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] decodeHexDump(CharSequence hexDump, int fromIndex, int length) {
        void var2_2;
        void var1_1;
        return StringUtil.decodeHexDump((CharSequence)hexDump, (int)var1_1, (int)var2_2);
    }

    public static boolean ensureWritableSuccess(int ensureWritableResult) {
        int n;
        return ensureWritableResult == 0 || n == 2;
    }

    /*
     * WARNING - void declaration
     */
    public static int hashCode(ByteBuf buffer) {
        void var3_3;
        void i;
        int aLen = buffer.readableBytes();
        int intCount = aLen >>> 2;
        int byteCount = aLen & 3;
        int hashCode = 1;
        int arrayIndex = buffer.readerIndex();
        if (buffer.order() == ByteOrder.BIG_ENDIAN) {
            while (i > 0) {
                hashCode = hashCode * 31 + buffer.getInt(arrayIndex);
                arrayIndex += 4;
                --i;
            }
        } else {
            while (i > 0) {
                hashCode = hashCode * 31 + ByteBufUtil.swapInt(buffer.getInt(arrayIndex));
                arrayIndex += 4;
                --i;
            }
        }
        for (i = var1_1; i > 0; --i) {
            hashCode = hashCode * 31 + buffer.getByte(arrayIndex++);
        }
        if (hashCode == 0) {
            hashCode = 1;
        }
        return (int)var3_3;
    }

    public static int indexOf(ByteBuf needle, ByteBuf haystack) {
        int i;
        int length;
        if (haystack == null || needle == null) {
            return -1;
        }
        if (needle.readableBytes() > haystack.readableBytes()) {
            return -1;
        }
        int n = haystack.readableBytes();
        int m = needle.readableBytes();
        if (m == 0) {
            return 0;
        }
        if (m == 1) {
            ByteBuf byteBuf = haystack;
            ByteBuf byteBuf2 = needle;
            return byteBuf.indexOf(byteBuf.readerIndex(), haystack.writerIndex(), byteBuf2.getByte(byteBuf2.readerIndex()));
        }
        int j = 0;
        int aStartIndex = needle.readerIndex();
        int bStartIndex = haystack.readerIndex();
        long suffixes = ByteBufUtil.maxSuf(needle, m, aStartIndex, true);
        long prefixes = ByteBufUtil.maxSuf(needle, m, aStartIndex, false);
        int ell = Math.max((int)(suffixes >> 32), (int)(prefixes >> 32));
        int per = Math.max((int)suffixes, (int)prefixes);
        if (ByteBufUtil.equals(needle, aStartIndex, needle, aStartIndex + per, length = Math.min(m - per, ell + 1))) {
            int memory = -1;
            while (j <= n - m) {
                for (i = Math.max(ell, memory) + 1; i < m && needle.getByte(i + aStartIndex) == haystack.getByte(i + j + bStartIndex); ++i) {
                }
                if (i > n) {
                    return -1;
                }
                if (i >= m) {
                    for (i = ell; i > memory && needle.getByte(i + aStartIndex) == haystack.getByte(i + j + bStartIndex); --i) {
                    }
                    if (i <= memory) {
                        return j + bStartIndex;
                    }
                    j += per;
                    memory = m - per - 1;
                    continue;
                }
                j += i - ell;
                memory = -1;
            }
        } else {
            per = Math.max(ell + 1, m - ell - 1) + 1;
            while (j <= n - m) {
                for (i = ell + 1; i < m && needle.getByte(i + aStartIndex) == haystack.getByte(i + j + bStartIndex); ++i) {
                }
                if (i > n) {
                    return -1;
                }
                if (i >= m) {
                    for (i = ell; i >= 0 && needle.getByte(i + aStartIndex) == haystack.getByte(i + j + bStartIndex); --i) {
                    }
                    if (i < 0) {
                        return j + bStartIndex;
                    }
                    j += per;
                    continue;
                }
                j += i - ell;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private static long maxSuf(ByteBuf x, int m, int start, boolean isSuffix) {
        void j;
        int p = 1;
        int ms = -1;
        int k = 1;
        while (j + k < m) {
            boolean bl;
            byte a = x.getByte((int)(j + k));
            byte b = x.getByte(ms + k);
            boolean bl2 = isSuffix ? a < b : (bl = a > b);
            if (bl2) {
                k = 1;
                p = (j += k) - ms;
                continue;
            }
            if (a == b) {
                if (k != p) {
                    ++k;
                    continue;
                }
                j += p;
                k = 1;
                continue;
            }
            ms = j;
            j = ms + true;
            p = 1;
            k = 1;
        }
        return ((long)ms << 32) + (long)p;
    }

    public static boolean equals(ByteBuf a, int aStartIndex, ByteBuf b, int bStartIndex, int length) {
        int i;
        ObjectUtil.checkNotNull((Object)a, (String)"a");
        ObjectUtil.checkNotNull((Object)b, (String)"b");
        ObjectUtil.checkPositiveOrZero((int)aStartIndex, (String)"aStartIndex");
        ObjectUtil.checkPositiveOrZero((int)bStartIndex, (String)"bStartIndex");
        ObjectUtil.checkPositiveOrZero((int)length, (String)"length");
        if (a.writerIndex() - length < aStartIndex || b.writerIndex() - length < bStartIndex) {
            return false;
        }
        int longCount = length >>> 3;
        int byteCount = length & 7;
        if (a.order() == b.order()) {
            for (i = longCount; i > 0; --i) {
                if (a.getLong(aStartIndex) != b.getLong(bStartIndex)) {
                    return false;
                }
                aStartIndex += 8;
                bStartIndex += 8;
            }
        } else {
            while (i > 0) {
                if (a.getLong(aStartIndex) != ByteBufUtil.swapLong(b.getLong(bStartIndex))) {
                    return false;
                }
                aStartIndex += 8;
                bStartIndex += 8;
                --i;
            }
        }
        for (i = byteCount; i > 0; --i) {
            if (a.getByte(aStartIndex) != b.getByte(bStartIndex)) {
                return false;
            }
            ++aStartIndex;
            ++bStartIndex;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equals(ByteBuf bufferA, ByteBuf bufferB) {
        void var2_2;
        void var1_1;
        ByteBuf byteBuf;
        if (bufferA == bufferB) {
            return true;
        }
        int aLen = bufferA.readableBytes();
        if (aLen != bufferB.readableBytes()) {
            return false;
        }
        ByteBuf byteBuf2 = byteBuf;
        void v1 = var1_1;
        return ByteBufUtil.equals(byteBuf2, byteBuf2.readerIndex(), (ByteBuf)v1, v1.readerIndex(), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(ByteBuf bufferA, ByteBuf bufferB) {
        void var3_3;
        void var2_2;
        if (bufferA == bufferB) {
            return 0;
        }
        int aLen = bufferA.readableBytes();
        int bLen = bufferB.readableBytes();
        int minLength = Math.min(aLen, bLen);
        int uintCount = minLength >>> 2;
        int byteCount = minLength & 3;
        int aIndex = bufferA.readerIndex();
        int bIndex = bufferB.readerIndex();
        if (uintCount > 0) {
            long res;
            boolean bufferAIsBigEndian = bufferA.order() == ByteOrder.BIG_ENDIAN;
            int uintCountIncrement = uintCount << 2;
            if (bufferA.order() == bufferB.order()) {
                res = bufferAIsBigEndian ? ByteBufUtil.compareUintBigEndian(bufferA, bufferB, aIndex, bIndex, uintCountIncrement) : ByteBufUtil.compareUintLittleEndian(bufferA, bufferB, aIndex, bIndex, uintCountIncrement);
            } else {
                long l = res = bufferAIsBigEndian ? ByteBufUtil.compareUintBigEndianA(bufferA, bufferB, aIndex, bIndex, uintCountIncrement) : ByteBufUtil.compareUintBigEndianB(bufferA, bufferB, aIndex, bIndex, uintCountIncrement);
            }
            if (res != 0L) {
                return (int)Math.min(Integer.MAX_VALUE, Math.max(Integer.MIN_VALUE, res));
            }
            aIndex += uintCountIncrement;
            bIndex += uintCountIncrement;
        }
        int aEnd = aIndex + byteCount;
        while (aIndex < aEnd) {
            int comp = bufferA.getUnsignedByte(aIndex) - bufferB.getUnsignedByte(bIndex);
            if (comp != 0) {
                return comp;
            }
            ++aIndex;
            ++bIndex;
        }
        return (int)(var2_2 - var3_3);
    }

    private static long compareUintBigEndian(ByteBuf bufferA, ByteBuf bufferB, int aIndex, int bIndex, int uintCountIncrement) {
        int aEnd = aIndex + uintCountIncrement;
        while (aIndex < aEnd) {
            long comp = bufferA.getUnsignedInt(aIndex) - bufferB.getUnsignedInt(bIndex);
            if (comp != 0L) {
                return comp;
            }
            aIndex += 4;
            bIndex += 4;
        }
        return 0L;
    }

    private static long compareUintLittleEndian(ByteBuf bufferA, ByteBuf bufferB, int aIndex, int bIndex, int uintCountIncrement) {
        int aEnd = aIndex + uintCountIncrement;
        while (aIndex < aEnd) {
            long comp = ByteBufUtil.uintFromLE(bufferA.getUnsignedIntLE(aIndex)) - ByteBufUtil.uintFromLE(bufferB.getUnsignedIntLE(bIndex));
            if (comp != 0L) {
                return comp;
            }
            aIndex += 4;
            bIndex += 4;
        }
        return 0L;
    }

    private static long compareUintBigEndianA(ByteBuf bufferA, ByteBuf bufferB, int aIndex, int bIndex, int uintCountIncrement) {
        int aEnd = aIndex + uintCountIncrement;
        while (aIndex < aEnd) {
            long b;
            long a = bufferA.getUnsignedInt(aIndex);
            long comp = a - (b = ByteBufUtil.uintFromLE(bufferB.getUnsignedIntLE(bIndex)));
            if (comp != 0L) {
                return comp;
            }
            aIndex += 4;
            bIndex += 4;
        }
        return 0L;
    }

    private static long compareUintBigEndianB(ByteBuf bufferA, ByteBuf bufferB, int aIndex, int bIndex, int uintCountIncrement) {
        int aEnd = aIndex + uintCountIncrement;
        while (aIndex < aEnd) {
            long b;
            long a = ByteBufUtil.uintFromLE(bufferA.getUnsignedIntLE(aIndex));
            long comp = a - (b = bufferB.getUnsignedInt(bIndex));
            if (comp != 0L) {
                return comp;
            }
            aIndex += 4;
            bIndex += 4;
        }
        return 0L;
    }

    private static long uintFromLE(long value) {
        return Long.reverseBytes(value) >>> 32;
    }

    /*
     * WARNING - void declaration
     */
    private static int unrolledFirstIndexOf(AbstractByteBuf buffer, int fromIndex, int byteCount, byte value) {
        void var3_3;
        AbstractByteBuf abstractByteBuf;
        void var2_2;
        assert (byteCount > 0 && byteCount < 8);
        if (buffer._getByte(fromIndex) == value) {
            return fromIndex;
        }
        if (byteCount == 1) {
            return -1;
        }
        if (buffer._getByte(fromIndex + 1) == value) {
            return fromIndex + 1;
        }
        if (byteCount == 2) {
            return -1;
        }
        if (buffer._getByte(fromIndex + 2) == value) {
            return fromIndex + 2;
        }
        if (byteCount == 3) {
            return -1;
        }
        if (buffer._getByte(fromIndex + 3) == value) {
            return fromIndex + 3;
        }
        if (byteCount == 4) {
            return -1;
        }
        if (buffer._getByte(fromIndex + 4) == value) {
            return fromIndex + 4;
        }
        if (byteCount == 5) {
            return -1;
        }
        if (buffer._getByte(fromIndex + 5) == value) {
            return fromIndex + 5;
        }
        if (var2_2 == 6) {
            return -1;
        }
        if (abstractByteBuf._getByte(fromIndex + 6) == var3_3) {
            void var1_1;
            return (int)(var1_1 + 6);
        }
        return -1;
    }

    static int firstIndexOf(AbstractByteBuf buffer, int fromIndex, int toIndex, byte value) {
        if ((fromIndex = Math.max(fromIndex, 0)) >= toIndex || buffer.capacity() == 0) {
            return -1;
        }
        int length = toIndex - fromIndex;
        buffer.checkIndex(fromIndex, length);
        if (!PlatformDependent.isUnaligned()) {
            return ByteBufUtil.linearFirstIndexOf(buffer, fromIndex, toIndex, value);
        }
        assert (PlatformDependent.isUnaligned());
        int offset = fromIndex;
        int byteCount = length & 7;
        if (byteCount > 0) {
            int index = ByteBufUtil.unrolledFirstIndexOf(buffer, fromIndex, byteCount, value);
            if (index != -1) {
                return index;
            }
            if ((offset += byteCount) == toIndex) {
                return -1;
            }
        }
        int longCount = length >>> 3;
        ByteOrder nativeOrder = ByteOrder.nativeOrder();
        boolean isNative = nativeOrder == buffer.order();
        boolean useLE = nativeOrder == ByteOrder.LITTLE_ENDIAN;
        long pattern = SWARUtil.compilePattern((byte)value);
        for (int i = 0; i < longCount; ++i) {
            long l = useLE ? buffer._getLongLE(offset) : buffer._getLong(offset);
            long result = SWARUtil.applyPattern((long)l, (long)pattern);
            if (result != 0L) {
                return offset + SWARUtil.getIndex((long)result, (boolean)isNative);
            }
            offset += 8;
        }
        return -1;
    }

    private static int linearFirstIndexOf(AbstractByteBuf buffer, int fromIndex, int toIndex, byte value) {
        for (int i = fromIndex; i < toIndex; ++i) {
            if (buffer._getByte(i) != value) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(ByteBuf buffer, int fromIndex, int toIndex, byte value) {
        void var3_3;
        void var2_2;
        void var1_1;
        return buffer.indexOf((int)var1_1, (int)var2_2, (byte)var3_3);
    }

    public static short swapShort(short value) {
        return Short.reverseBytes(value);
    }

    public static int swapMedium(int value) {
        int n;
        int swapped = value << 16 & 0xFF0000 | value & 0xFF00 | value >>> 16 & 0xFF;
        if ((swapped & 0x800000) != 0) {
            swapped |= 0xFF000000;
        }
        return n;
    }

    public static int swapInt(int value) {
        return Integer.reverseBytes(value);
    }

    public static long swapLong(long value) {
        return Long.reverseBytes(value);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf writeShortBE(ByteBuf buf, int shortValue) {
        void var1_1;
        ByteBuf byteBuf;
        if (buf.order() == ByteOrder.BIG_ENDIAN) {
            return buf.writeShort(shortValue);
        }
        return byteBuf.writeShort(ByteBufUtil.swapShort((short)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf setShortBE(ByteBuf buf, int index, int shortValue) {
        void var2_2;
        void var1_1;
        ByteBuf byteBuf;
        if (buf.order() == ByteOrder.BIG_ENDIAN) {
            return buf.setShort(index, shortValue);
        }
        return byteBuf.setShort((int)var1_1, ByteBufUtil.swapShort((short)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf writeMediumBE(ByteBuf buf, int mediumValue) {
        void var1_1;
        ByteBuf byteBuf;
        if (buf.order() == ByteOrder.BIG_ENDIAN) {
            return buf.writeMedium(mediumValue);
        }
        return byteBuf.writeMedium(ByteBufUtil.swapMedium((int)var1_1));
    }

    public static int readUnsignedShortBE(ByteBuf buf) {
        ByteBuf byteBuf;
        if (buf.order() == ByteOrder.BIG_ENDIAN) {
            return buf.readUnsignedShort();
        }
        return ByteBufUtil.swapShort((short)byteBuf.readUnsignedShort()) & 0xFFFF;
    }

    public static int readIntBE(ByteBuf buf) {
        ByteBuf byteBuf;
        if (buf.order() == ByteOrder.BIG_ENDIAN) {
            return buf.readInt();
        }
        return ByteBufUtil.swapInt(byteBuf.readInt());
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf readBytes(ByteBufAllocator alloc, ByteBuf buffer, int length) {
        void var2_3;
        boolean release = true;
        ByteBuf dst = alloc.buffer((int)var2_3);
        try {
            Object object;
            ((ByteBuf)object).readBytes(dst);
            release = false;
            object = dst;
            return object;
        }
        catch (Throwable throwable) {
            void var3_4;
            if (var3_4 != false) {
                ByteBuf byteBuf;
                byteBuf.release();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static int lastIndexOf(AbstractByteBuf buffer, int fromIndex, int toIndex, byte value) {
        void var3_3;
        void var2_2;
        void var1_1;
        AbstractByteBuf abstractByteBuf;
        assert (fromIndex > toIndex);
        int capacity = buffer.capacity();
        if ((fromIndex = Math.min(fromIndex, capacity)) <= 0) {
            return -1;
        }
        int length = fromIndex - toIndex;
        buffer.checkIndex(toIndex, length);
        if (!PlatformDependent.isUnaligned()) {
            return ByteBufUtil.linearLastIndexOf(buffer, fromIndex, toIndex, value);
        }
        int longCount = length >>> 3;
        if (longCount > 0) {
            ByteOrder nativeOrder = ByteOrder.nativeOrder();
            boolean isNative = nativeOrder == buffer.order();
            boolean useLE = nativeOrder == ByteOrder.LITTLE_ENDIAN;
            long pattern = SWARUtil.compilePattern((byte)value);
            int i = 0;
            int offset = fromIndex - 8;
            while (i < longCount) {
                long l = useLE ? buffer._getLongLE(offset) : buffer._getLong(offset);
                long result = SWARUtil.applyPattern((long)l, (long)pattern);
                if (result != 0L) {
                    return offset + 8 - 1 - SWARUtil.getIndex((long)result, (!isNative ? 1 : 0) != 0);
                }
                ++i;
                offset -= 8;
            }
        }
        return ByteBufUtil.unrolledLastIndexOf(abstractByteBuf, (int)(var1_1 - (var2_2 << 3)), length & 7, (byte)var3_3);
    }

    private static int linearLastIndexOf(AbstractByteBuf buffer, int fromIndex, int toIndex, byte value) {
        for (int i = fromIndex - 1; i >= toIndex; --i) {
            if (buffer._getByte(i) != value) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private static int unrolledLastIndexOf(AbstractByteBuf buffer, int fromIndex, int byteCount, byte value) {
        void var3_3;
        AbstractByteBuf abstractByteBuf;
        void var2_2;
        assert (byteCount >= 0 && byteCount < 8);
        if (byteCount == 0) {
            return -1;
        }
        if (buffer._getByte(fromIndex - 1) == value) {
            return fromIndex - 1;
        }
        if (byteCount == 1) {
            return -1;
        }
        if (buffer._getByte(fromIndex - 2) == value) {
            return fromIndex - 2;
        }
        if (byteCount == 2) {
            return -1;
        }
        if (buffer._getByte(fromIndex - 3) == value) {
            return fromIndex - 3;
        }
        if (byteCount == 3) {
            return -1;
        }
        if (buffer._getByte(fromIndex - 4) == value) {
            return fromIndex - 4;
        }
        if (byteCount == 4) {
            return -1;
        }
        if (buffer._getByte(fromIndex - 5) == value) {
            return fromIndex - 5;
        }
        if (byteCount == 5) {
            return -1;
        }
        if (buffer._getByte(fromIndex - 6) == value) {
            return fromIndex - 6;
        }
        if (var2_2 == 6) {
            return -1;
        }
        if (abstractByteBuf._getByte(fromIndex - 7) == var3_3) {
            void var1_1;
            return (int)(var1_1 - 7);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private static CharSequence checkCharSequenceBounds(CharSequence seq, int start, int end) {
        CharSequence charSequence;
        if (MathUtil.isOutOfBounds((int)start, (int)(end - start), (int)seq.length())) {
            void var2_2;
            void var1_1;
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + (int)var1_1 + ") <= end (" + (int)var2_2 + ") <= seq.length(" + seq.length() + ')');
        }
        return charSequence;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf writeUtf8(ByteBufAllocator alloc, CharSequence seq) {
        ByteBuf byteBuf;
        void var1_1;
        ByteBuf buf = alloc.buffer(ByteBufUtil.utf8MaxBytes(seq));
        ByteBufUtil.writeUtf8(buf, (CharSequence)var1_1);
        return byteBuf;
    }

    /*
     * WARNING - void declaration
     */
    public static int writeUtf8(ByteBuf buf, CharSequence seq) {
        void var1_1;
        ByteBuf byteBuf;
        void var2_2;
        int seqLength = seq.length();
        void v0 = var2_2;
        return ByteBufUtil.reserveAndWriteUtf8Seq(byteBuf, (CharSequence)var1_1, 0, (int)v0, ByteBufUtil.utf8MaxBytes((int)v0));
    }

    /*
     * WARNING - void declaration
     */
    public static int writeUtf8(ByteBuf buf, CharSequence seq, int start, int end) {
        void var2_2;
        void var1_1;
        ByteBuf byteBuf;
        void var3_3;
        ByteBufUtil.checkCharSequenceBounds(seq, start, end);
        void v0 = var3_3;
        return ByteBufUtil.reserveAndWriteUtf8Seq(byteBuf, (CharSequence)var1_1, start, (int)v0, ByteBufUtil.utf8MaxBytes((int)(v0 - var2_2)));
    }

    /*
     * WARNING - void declaration
     */
    public static int reserveAndWriteUtf8(ByteBuf buf, CharSequence seq, int reserveBytes) {
        void var2_2;
        void var1_1;
        return ByteBufUtil.reserveAndWriteUtf8Seq(buf, seq, 0, var1_1.length(), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int reserveAndWriteUtf8(ByteBuf buf, CharSequence seq, int start, int end, int reserveBytes) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ByteBufUtil.reserveAndWriteUtf8Seq(buf, ByteBufUtil.checkCharSequenceBounds((CharSequence)var1_1, start, end), (int)var2_2, (int)var3_3, reserveBytes);
    }

    /*
     * WARNING - void declaration
     */
    private static int reserveAndWriteUtf8Seq(ByteBuf buf, CharSequence seq, int start, int end, int reserveBytes) {
        void var3_4;
        void var2_3;
        void var1_2;
        ByteBuf byteBuf;
        while (true) {
            if (buf instanceof WrappedCompositeByteBuf) {
                buf = buf.unwrap();
                continue;
            }
            if (buf instanceof AbstractByteBuf) {
                void var0_1;
                AbstractByteBuf byteBuf2 = (AbstractByteBuf)buf;
                byteBuf2.ensureWritable0(reserveBytes);
                AbstractByteBuf abstractByteBuf = byteBuf2;
                int written = ByteBufUtil.writeUtf8(abstractByteBuf, abstractByteBuf.writerIndex, reserveBytes, seq, start, end);
                byteBuf2.writerIndex += written;
                return (int)var0_1;
            }
            if (!(byteBuf instanceof WrappedByteBuf)) break;
            byteBuf = byteBuf.unwrap();
        }
        byte[] bytes = var1_2.subSequence((int)var2_3, (int)var3_4).toString().getBytes(CharsetUtil.UTF_8);
        byteBuf.writeBytes(bytes);
        return bytes.length;
    }

    /*
     * WARNING - void declaration
     */
    static int writeUtf8(AbstractByteBuf buffer, int writerIndex, int reservedBytes, CharSequence seq, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ByteBufUtil.writeUtf8(buffer, (int)var1_1, (int)var2_2, (CharSequence)var3_3, 0, len);
    }

    /*
     * WARNING - void declaration
     */
    static int writeUtf8(AbstractByteBuf buffer, int writerIndex, int reservedBytes, CharSequence seq, int start, int end) {
        void var3_3;
        void var1_1;
        Comparable<ByteBuf> comparable;
        if (seq instanceof AsciiString) {
            ByteBufUtil.writeAsciiString(buffer, writerIndex, (AsciiString)seq, start, end);
            return end - start;
        }
        if (PlatformDependent.hasUnsafe()) {
            if (buffer.hasArray()) {
                return ByteBufUtil.unsafeWriteUtf8(buffer.array(), PlatformDependent.byteArrayBaseOffset(), buffer.arrayOffset() + writerIndex, seq, start, end);
            }
            if (buffer.hasMemoryAddress()) {
                return ByteBufUtil.unsafeWriteUtf8(null, buffer.memoryAddress(), writerIndex, seq, start, end);
            }
        } else {
            if (buffer.hasArray()) {
                return ByteBufUtil.safeArrayWriteUtf8(buffer.array(), buffer.arrayOffset() + writerIndex, seq, start, end);
            }
            if (buffer.isDirect()) {
                void var2_2;
                assert (buffer.nioBufferCount() == 1);
                Comparable<ByteBuf> internalDirectBuffer = buffer.internalNioBuffer(writerIndex, (int)var2_2);
                int bufferPosition = ((Buffer)((Object)internalDirectBuffer)).position();
                return ByteBufUtil.safeDirectWriteUtf8((ByteBuffer)comparable, (int)var1_1, seq, start, end);
            }
        }
        return ByteBufUtil.safeWriteUtf8(comparable, (int)var1_1, (CharSequence)var3_3, start, end);
    }

    /*
     * WARNING - void declaration
     */
    static void writeAsciiString(AbstractByteBuf buffer, int writerIndex, AsciiString seq, int start, int end) {
        void var3_3;
        void var2_2;
        void var1_1;
        AbstractByteBuf abstractByteBuf;
        int begin = seq.arrayOffset() + start;
        int length = end - start;
        if (PlatformDependent.hasUnsafe()) {
            if (buffer.hasArray()) {
                PlatformDependent.copyMemory((byte[])seq.array(), (int)begin, (byte[])buffer.array(), (int)(buffer.arrayOffset() + writerIndex), (long)length);
                return;
            }
            if (buffer.hasMemoryAddress()) {
                PlatformDependent.copyMemory((byte[])seq.array(), (int)begin, (long)(buffer.memoryAddress() + (long)writerIndex), (long)length);
                return;
            }
        }
        if (buffer.hasArray()) {
            System.arraycopy(seq.array(), begin, buffer.array(), buffer.arrayOffset() + writerIndex, length);
            return;
        }
        abstractByteBuf.setBytes((int)var1_1, var2_2.array(), begin, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static int safeDirectWriteUtf8(ByteBuffer buffer, int writerIndex, CharSequence seq, int start, int end) {
        void var1_1;
        void i;
        assert (!(seq instanceof AsciiString));
        int oldWriterIndex = writerIndex;
        while (i < end) {
            char c = seq.charAt((int)i);
            if (c < '\u0080') {
                buffer.put(writerIndex++, (byte)c);
            } else if (c < '\u0800') {
                buffer.put(writerIndex++, (byte)(0xC0 | c >> 6));
                buffer.put(writerIndex++, (byte)(0x80 | c & 0x3F));
            } else if (StringUtil.isSurrogate((char)c)) {
                if (!Character.isHighSurrogate(c)) {
                    buffer.put(writerIndex++, (byte)63);
                } else {
                    if (++i == end) {
                        buffer.put(writerIndex++, (byte)63);
                        break;
                    }
                    char c2 = seq.charAt((int)i);
                    if (!Character.isLowSurrogate(c2)) {
                        buffer.put(writerIndex++, (byte)63);
                        buffer.put(writerIndex++, (byte)(Character.isHighSurrogate(c2) ? 63 : (byte)c2));
                    } else {
                        int codePoint = Character.toCodePoint(c, c2);
                        buffer.put(writerIndex++, (byte)(0xF0 | codePoint >> 18));
                        buffer.put(writerIndex++, (byte)(0x80 | codePoint >> 12 & 0x3F));
                        buffer.put(writerIndex++, (byte)(0x80 | codePoint >> 6 & 0x3F));
                        buffer.put(writerIndex++, (byte)(0x80 | codePoint & 0x3F));
                    }
                }
            } else {
                void var6_6;
                buffer.put(writerIndex++, (byte)(0xE0 | var6_6 >> 12));
                buffer.put(writerIndex++, (byte)(0x80 | var6_6 >> 6 & 0x3F));
                buffer.put(writerIndex++, (byte)(0x80 | var6_6 & 0x3F));
            }
            ++i;
        }
        return (int)(var1_1 - oldWriterIndex);
    }

    /*
     * WARNING - void declaration
     */
    private static int safeWriteUtf8(AbstractByteBuf buffer, int writerIndex, CharSequence seq, int start, int end) {
        void var1_1;
        void i;
        assert (!(seq instanceof AsciiString));
        int oldWriterIndex = writerIndex;
        while (i < end) {
            char c = seq.charAt((int)i);
            if (c < '\u0080') {
                buffer._setByte(writerIndex++, (byte)c);
            } else if (c < '\u0800') {
                buffer._setByte(writerIndex++, (byte)(0xC0 | c >> 6));
                buffer._setByte(writerIndex++, (byte)(0x80 | c & 0x3F));
            } else if (StringUtil.isSurrogate((char)c)) {
                if (!Character.isHighSurrogate(c)) {
                    buffer._setByte(writerIndex++, 63);
                } else {
                    if (++i == end) {
                        buffer._setByte(writerIndex++, 63);
                        break;
                    }
                    char c2 = seq.charAt((int)i);
                    if (!Character.isLowSurrogate(c2)) {
                        buffer._setByte(writerIndex++, 63);
                        buffer._setByte(writerIndex++, Character.isHighSurrogate(c2) ? 63 : (int)c2);
                    } else {
                        int codePoint = Character.toCodePoint(c, c2);
                        buffer._setByte(writerIndex++, (byte)(0xF0 | codePoint >> 18));
                        buffer._setByte(writerIndex++, (byte)(0x80 | codePoint >> 12 & 0x3F));
                        buffer._setByte(writerIndex++, (byte)(0x80 | codePoint >> 6 & 0x3F));
                        buffer._setByte(writerIndex++, (byte)(0x80 | codePoint & 0x3F));
                    }
                }
            } else {
                void var6_6;
                buffer._setByte(writerIndex++, (byte)(0xE0 | var6_6 >> 12));
                buffer._setByte(writerIndex++, (byte)(0x80 | var6_6 >> 6 & 0x3F));
                buffer._setByte(writerIndex++, (byte)(0x80 | var6_6 & 0x3F));
            }
            ++i;
        }
        return (int)(var1_1 - oldWriterIndex);
    }

    /*
     * WARNING - void declaration
     */
    private static int safeArrayWriteUtf8(byte[] buffer, int writerIndex, CharSequence seq, int start, int end) {
        void var1_1;
        void i;
        int oldWriterIndex = writerIndex;
        while (i < end) {
            char c = seq.charAt((int)i);
            if (c < '\u0080') {
                buffer[writerIndex++] = (byte)c;
            } else if (c < '\u0800') {
                buffer[writerIndex++] = (byte)(0xC0 | c >> 6);
                buffer[writerIndex++] = (byte)(0x80 | c & 0x3F);
            } else if (StringUtil.isSurrogate((char)c)) {
                if (!Character.isHighSurrogate(c)) {
                    buffer[writerIndex++] = 63;
                } else {
                    if (++i == end) {
                        buffer[writerIndex++] = 63;
                        break;
                    }
                    char c2 = seq.charAt((int)i);
                    if (!Character.isLowSurrogate(c2)) {
                        buffer[writerIndex++] = 63;
                        buffer[writerIndex++] = (byte)(Character.isHighSurrogate(c2) ? 63 : (int)c2);
                    } else {
                        int codePoint = Character.toCodePoint(c, c2);
                        buffer[writerIndex++] = (byte)(0xF0 | codePoint >> 18);
                        buffer[writerIndex++] = (byte)(0x80 | codePoint >> 12 & 0x3F);
                        buffer[writerIndex++] = (byte)(0x80 | codePoint >> 6 & 0x3F);
                        buffer[writerIndex++] = (byte)(0x80 | codePoint & 0x3F);
                    }
                }
            } else {
                void var6_6;
                buffer[writerIndex++] = (byte)(0xE0 | var6_6 >> 12);
                buffer[writerIndex++] = (byte)(0x80 | var6_6 >> 6 & 0x3F);
                buffer[writerIndex++] = (byte)(0x80 | var6_6 & 0x3F);
            }
            ++i;
        }
        return (int)(var1_1 - oldWriterIndex);
    }

    /*
     * WARNING - void declaration
     */
    private static int unsafeWriteUtf8(byte[] buffer, long memoryOffset, int writerIndex, CharSequence seq, int start, int end) {
        long writerOffset;
        assert (!(seq instanceof AsciiString));
        long oldWriterOffset = writerOffset = memoryOffset + (long)writerIndex;
        for (int i = start; i < end; ++i) {
            void var2_9;
            char c = seq.charAt(i);
            if (c < '\u0080') {
                PlatformDependent.putByte((Object)buffer, (long)writerOffset++, (byte)((byte)c));
                continue;
            }
            if (c < '\u0800') {
                PlatformDependent.putByte((Object)buffer, (long)writerOffset++, (byte)((byte)(0xC0 | c >> 6)));
                PlatformDependent.putByte((Object)buffer, (long)writerOffset++, (byte)((byte)(0x80 | c & 0x3F)));
                continue;
            }
            if (StringUtil.isSurrogate((char)c)) {
                void var3_3;
                if (!Character.isHighSurrogate(c)) {
                    PlatformDependent.putByte((Object)buffer, (long)writerOffset++, (byte)63);
                    continue;
                }
                if (++i == end) {
                    PlatformDependent.putByte((Object)buffer, (long)writerOffset++, (byte)63);
                    break;
                }
                char c2 = seq.charAt(i);
                if (!Character.isLowSurrogate(c2)) {
                    PlatformDependent.putByte((Object)buffer, (long)writerOffset++, (byte)63);
                    PlatformDependent.putByte((Object)buffer, (long)writerOffset++, (byte)((byte)(Character.isHighSurrogate(c2) ? 63 : (int)c2)));
                    continue;
                }
                int codePoint = Character.toCodePoint(c, (char)var3_3);
                PlatformDependent.putByte((Object)buffer, (long)writerOffset++, (byte)((byte)(0xF0 | codePoint >> 18)));
                PlatformDependent.putByte((Object)buffer, (long)writerOffset++, (byte)((byte)(0x80 | codePoint >> 12 & 0x3F)));
                PlatformDependent.putByte((Object)buffer, (long)writerOffset++, (byte)((byte)(0x80 | codePoint >> 6 & 0x3F)));
                PlatformDependent.putByte((Object)buffer, (long)writerOffset++, (byte)((byte)(0x80 | var2_9 & 0x3F)));
                continue;
            }
            PlatformDependent.putByte((Object)buffer, (long)writerOffset++, (byte)((byte)(0xE0 | var2_9 >> 12)));
            PlatformDependent.putByte((Object)buffer, (long)writerOffset++, (byte)((byte)(0x80 | var2_9 >> 6 & 0x3F)));
            PlatformDependent.putByte((Object)buffer, (long)writerOffset++, (byte)((byte)(0x80 | var2_9 & 0x3F)));
        }
        return (int)(writerOffset - oldWriterOffset);
    }

    public static int utf8MaxBytes(int seqLength) {
        return seqLength * MAX_BYTES_PER_CHAR_UTF8;
    }

    public static int utf8MaxBytes(CharSequence seq) {
        CharSequence charSequence;
        if (seq instanceof AsciiString) {
            return seq.length();
        }
        return ByteBufUtil.utf8MaxBytes(charSequence.length());
    }

    public static int utf8Bytes(CharSequence seq) {
        CharSequence charSequence;
        return ByteBufUtil.utf8ByteCount(seq, 0, charSequence.length());
    }

    /*
     * WARNING - void declaration
     */
    public static int utf8Bytes(CharSequence seq, int start, int end) {
        void var2_2;
        void var1_1;
        return ByteBufUtil.utf8ByteCount(ByteBufUtil.checkCharSequenceBounds(seq, start, end), (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static int utf8ByteCount(CharSequence seq, int start, int end) {
        void var1_1;
        void var3_3;
        int i;
        if (seq instanceof AsciiString) {
            return end - start;
        }
        for (i = start; i < end && seq.charAt(i) < '\u0080'; ++i) {
        }
        if (i < end) {
            void var2_2;
            CharSequence charSequence;
            return i - start + ByteBufUtil.utf8BytesNonAscii(charSequence, i, (int)var2_2);
        }
        return (int)(var3_3 - var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static int utf8BytesNonAscii(CharSequence seq, int start, int end) {
        void var3_3;
        void i;
        int encodedLength = 0;
        while (i < end) {
            char c = seq.charAt((int)i);
            if (c < '\u0800') {
                encodedLength += (127 - c >>> 31) + 1;
            } else if (StringUtil.isSurrogate((char)c)) {
                if (!Character.isHighSurrogate(c)) {
                    ++encodedLength;
                } else {
                    if (++i == end) {
                        ++encodedLength;
                        break;
                    }
                    encodedLength = !Character.isLowSurrogate(seq.charAt((int)i)) ? (encodedLength += 2) : (encodedLength += 4);
                }
            } else {
                encodedLength += 3;
            }
            ++i;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf writeAscii(ByteBufAllocator alloc, CharSequence seq) {
        ByteBuf byteBuf;
        void var1_1;
        ByteBuf buf = alloc.buffer(seq.length());
        ByteBufUtil.writeAscii(buf, (CharSequence)var1_1);
        return byteBuf;
    }

    /*
     * WARNING - void declaration
     */
    public static int writeAscii(ByteBuf buf, CharSequence seq) {
        void var2_4;
        void var1_1;
        ByteBuf byteBuf;
        while (true) {
            if (buf instanceof WrappedCompositeByteBuf) {
                buf = buf.unwrap();
                continue;
            }
            if (buf instanceof AbstractByteBuf) {
                int len = seq.length();
                ByteBuf byteBuf2 = (AbstractByteBuf)buf;
                ((AbstractByteBuf)byteBuf2).ensureWritable0(len);
                if (seq instanceof AsciiString) {
                    ByteBuf byteBuf3 = byteBuf2;
                    ByteBufUtil.writeAsciiString((AbstractByteBuf)byteBuf3, ((AbstractByteBuf)byteBuf3).writerIndex, (AsciiString)seq, 0, len);
                } else {
                    void var1_2;
                    ByteBuf byteBuf4 = byteBuf2;
                    int written = ByteBufUtil.writeAscii((AbstractByteBuf)byteBuf4, ((AbstractByteBuf)byteBuf4).writerIndex, seq, len);
                    assert (var1_2 == len);
                }
                ((AbstractByteBuf)byteBuf).writerIndex += len;
                return len;
            }
            if (!(byteBuf instanceof WrappedByteBuf)) break;
            byteBuf = byteBuf.unwrap();
        }
        byte[] bytes = var1_1.toString().getBytes(CharsetUtil.US_ASCII);
        byteBuf.writeBytes(bytes);
        return ((void)var2_4).length;
    }

    /*
     * WARNING - void declaration
     */
    static int writeAscii(AbstractByteBuf buffer, int writerIndex, CharSequence seq, int len) {
        void var3_3;
        if (seq instanceof AsciiString) {
            ByteBufUtil.writeAsciiString(buffer, writerIndex, (AsciiString)seq, 0, len);
        } else {
            void var2_2;
            void var1_1;
            AbstractByteBuf abstractByteBuf;
            ByteBufUtil.writeAsciiCharSequence(abstractByteBuf, (int)var1_1, (CharSequence)var2_2, len);
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static int writeAsciiCharSequence(AbstractByteBuf buffer, int writerIndex, CharSequence seq, int len) {
        void var3_3;
        for (int i = 0; i < len; ++i) {
            buffer._setByte(writerIndex++, AsciiString.c2b((char)seq.charAt(i)));
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf encodeString(ByteBufAllocator alloc, CharBuffer src, Charset charset) {
        void var2_2;
        void var1_1;
        return ByteBufUtil.encodeString0(alloc, false, (CharBuffer)var1_1, (Charset)var2_2, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf encodeString(ByteBufAllocator alloc, CharBuffer src, Charset charset, int extraCapacity) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ByteBufUtil.encodeString0(alloc, false, (CharBuffer)var1_1, (Charset)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static ByteBuf encodeString0(ByteBufAllocator alloc, boolean enforceHeap, CharBuffer src, Charset charset, int extraCapacity) {
        ByteBuf dst;
        CharsetEncoder encoder = CharsetUtil.encoder((Charset)charset);
        int length = (int)((double)src.remaining() * (double)encoder.maxBytesPerChar()) + extraCapacity;
        boolean release = true;
        dst = enforceHeap ? alloc.heapBuffer(length) : dst.buffer(length);
        try {
            void var3_6;
            Object object = dst;
            Object dstBuf = ((ByteBuf)object).internalNioBuffer(((ByteBuf)object).readerIndex(), length);
            int pos = ((Buffer)dstBuf).position();
            CoderResult cr = encoder.encode(src, (ByteBuffer)dstBuf, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = var3_6.flush((ByteBuffer)dstBuf)).isUnderflow()) {
                void var2_5;
                var2_5.throwException();
            }
            Object object2 = dst;
            ((ByteBuf)object2).writerIndex(((ByteBuf)object2).writerIndex() + ((Buffer)dstBuf).position() - pos);
            release = false;
            dstBuf = dst;
            return dstBuf;
        }
        catch (CharacterCodingException x) {
            try {
                void var1_3;
                throw new IllegalStateException((Throwable)var1_3);
            }
            catch (Throwable throwable) {
                if (release) {
                    ByteBuf byteBuf;
                    byteBuf.release();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    static String decodeString(ByteBuf src, int readerIndex, int len, Charset charset) {
        void var3_3;
        void var2_2;
        int offset;
        byte[] array;
        if (len == 0) {
            return "";
        }
        if (src.hasArray()) {
            array = src.array();
            offset = src.arrayOffset() + readerIndex;
        } else {
            void var1_1;
            ByteBuf byteBuf;
            array = ByteBufUtil.threadLocalTempArray(len);
            offset = 0;
            byteBuf.getBytes((int)var1_1, array, 0, len);
        }
        if (CharsetUtil.US_ASCII.equals(charset)) {
            return new String(array, 0, offset, len);
        }
        return new String(array, offset, (int)var2_2, (Charset)var3_3);
    }

    public static ByteBuf threadLocalDirectBuffer() {
        if (THREAD_LOCAL_BUFFER_SIZE <= 0) {
            return null;
        }
        if (PlatformDependent.hasUnsafe()) {
            return ThreadLocalUnsafeDirectByteBuf.newInstance();
        }
        return ThreadLocalDirectByteBuf.newInstance();
    }

    public static byte[] getBytes(ByteBuf buf) {
        ByteBuf byteBuf;
        ByteBuf byteBuf2 = buf;
        return ByteBufUtil.getBytes(byteBuf2, byteBuf2.readerIndex(), byteBuf.readableBytes());
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] getBytes(ByteBuf buf, int start, int length) {
        void var2_2;
        void var1_1;
        return ByteBufUtil.getBytes(buf, (int)var1_1, (int)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] getBytes(ByteBuf buf, int start, int length, boolean copy) {
        void var1_1;
        void var2_2;
        Object object;
        int capacity = buf.capacity();
        if (MathUtil.isOutOfBounds((int)start, (int)length, (int)capacity)) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= start + length(" + length + ") <= buf.capacity(" + capacity + ')');
        }
        if (buf.hasArray()) {
            void var3_3;
            int baseOffset = buf.arrayOffset() + start;
            Object bytes = buf.array();
            if (var3_3 != false || baseOffset != 0 || length != ((Object)bytes).length) {
                int n = baseOffset;
                return Arrays.copyOfRange((byte[])bytes, n, n + length);
            }
            return object;
        }
        byte[] bytes = PlatformDependent.allocateUninitializedArray((int)var2_2);
        ((ByteBuf)object).getBytes((int)var1_1, bytes);
        return bytes;
    }

    /*
     * WARNING - void declaration
     */
    public static void copy(AsciiString src, ByteBuf dst) {
        AsciiString asciiString;
        void var1_1;
        ByteBufUtil.copy(src, 0, (ByteBuf)var1_1, asciiString.length());
    }

    /*
     * WARNING - void declaration
     */
    public static void copy(AsciiString src, int srcIdx, ByteBuf dst, int dstIdx, int length) {
        AsciiString asciiString;
        void var1_1;
        void var3_3;
        void var2_2;
        if (MathUtil.isOutOfBounds((int)srcIdx, (int)length, (int)src.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + srcIdx + ") <= srcIdx + length(" + length + ") <= srcLen(" + src.length() + ')');
        }
        ((ByteBuf)ObjectUtil.checkNotNull((Object)var2_2, (String)"dst")).setBytes((int)var3_3, src.array(), (int)(var1_1 + asciiString.arrayOffset()), length);
    }

    /*
     * WARNING - void declaration
     */
    public static void copy(AsciiString src, int srcIdx, ByteBuf dst, int length) {
        void var3_3;
        AsciiString asciiString;
        void var1_1;
        void var2_2;
        if (MathUtil.isOutOfBounds((int)srcIdx, (int)length, (int)src.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + srcIdx + ") <= srcIdx + length(" + length + ") <= srcLen(" + src.length() + ')');
        }
        ((ByteBuf)ObjectUtil.checkNotNull((Object)var2_2, (String)"dst")).writeBytes(src.array(), (int)(var1_1 + asciiString.arrayOffset()), (int)var3_3);
    }

    public static String prettyHexDump(ByteBuf buffer) {
        ByteBuf byteBuf;
        ByteBuf byteBuf2 = buffer;
        return ByteBufUtil.prettyHexDump(byteBuf2, byteBuf2.readerIndex(), byteBuf.readableBytes());
    }

    /*
     * WARNING - void declaration
     */
    public static String prettyHexDump(ByteBuf buffer, int offset, int length) {
        void var2_2;
        void var1_1;
        return HexUtil.access$200(buffer, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void appendPrettyHexDump(StringBuilder dump, ByteBuf buf) {
        void var1_1;
        ByteBuf byteBuf = buf;
        ByteBufUtil.appendPrettyHexDump(dump, byteBuf, byteBuf.readerIndex(), var1_1.readableBytes());
    }

    /*
     * WARNING - void declaration
     */
    public static void appendPrettyHexDump(StringBuilder dump, ByteBuf buf, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        HexUtil.access$300(dump, (ByteBuf)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isText(ByteBuf buf, Charset charset) {
        void var1_1;
        ByteBuf byteBuf;
        ByteBuf byteBuf2 = buf;
        return ByteBufUtil.isText(byteBuf2, byteBuf2.readerIndex(), byteBuf.readableBytes(), (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isText(ByteBuf buf, int index, int length, Charset charset) {
        ObjectUtil.checkNotNull((Object)buf, (String)"buf");
        ObjectUtil.checkNotNull((Object)charset, (String)"charset");
        int maxIndex = buf.readerIndex() + buf.readableBytes();
        if (index < 0 || length < 0 || index > maxIndex - length) {
            throw new IndexOutOfBoundsException("index: " + index + " length: " + length);
        }
        if (charset.equals(CharsetUtil.UTF_8)) {
            return ByteBufUtil.isUtf8(buf, index, length);
        }
        if (charset.equals(CharsetUtil.US_ASCII)) {
            return ByteBufUtil.isAscii(buf, index, length);
        }
        CodingErrorAction codingErrorAction = CodingErrorAction.REPORT;
        CharsetDecoder decoder = CharsetUtil.decoder((Charset)charset, (CodingErrorAction)codingErrorAction, (CodingErrorAction)codingErrorAction);
        try {
            if (buf.nioBufferCount() == 1) {
                decoder.decode(buf.nioBuffer(index, length));
            } else {
                ByteBuf heapBuffer = buf.alloc().heapBuffer(length);
                try {
                    void var2_3;
                    void var3_4;
                    void var1_2;
                    ByteBuf byteBuf;
                    heapBuffer.writeBytes(byteBuf, (int)var1_2, length);
                    ByteBuf byteBuf2 = heapBuffer;
                    var3_4.decode(byteBuf2.internalNioBuffer(byteBuf2.readerIndex(), (int)var2_3));
                }
                finally {
                    heapBuffer.release();
                }
            }
            return true;
        }
        catch (CharacterCodingException characterCodingException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isAscii(ByteBuf buf, int index, int length) {
        void var2_2;
        void var1_1;
        return buf.forEachByte((int)var1_1, (int)var2_2, FIND_NON_ASCII) == -1;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isUtf8(ByteBuf buf, int index, int length) {
        int endIndex = index + length;
        while (index < endIndex) {
            byte b3;
            byte b2;
            byte b1;
            if (((b1 = buf.getByte(index++)) & 0x80) == 0) continue;
            if ((b1 & 0xE0) == 192) {
                byte by;
                if (index >= endIndex) {
                    return false;
                }
                if (((by = buf.getByte(index++)) & 0xC0) != 128) {
                    return false;
                }
                if ((b1 & 0xFF) >= 194) continue;
                return false;
            }
            if ((b1 & 0xF0) == 224) {
                if (index > endIndex - 2) {
                    return false;
                }
                b2 = buf.getByte(index++);
                b3 = buf.getByte(index++);
                if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                    return false;
                }
                if ((b1 & 0xF) == 0 && (b2 & 0xFF) < 160) {
                    return false;
                }
                if ((b1 & 0xF) != 13 || (b2 & 0xFF) <= 159) continue;
                return false;
            }
            if ((b1 & 0xF8) == 240) {
                void var3_3;
                if (index > endIndex - 3) {
                    return false;
                }
                b2 = buf.getByte(index++);
                b3 = buf.getByte(index++);
                byte b4 = buf.getByte(index++);
                if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128) {
                    return false;
                }
                if ((b1 & 0xFF) <= 244 && ((b1 & 0xFF) != 240 || (b2 & 0xFF) >= 144) && ((var3_3 & 0xFF) != 244 || (b2 & 0xFF) <= 143)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    static void readBytes(ByteBufAllocator allocator, ByteBuffer buffer, int position, int length, OutputStream out) throws IOException {
        if (buffer.hasArray()) {
            out.write(buffer.array(), position + buffer.arrayOffset(), length);
            return;
        }
        int chunkLen = Math.min(length, 8192);
        buffer.clear().position(position);
        if (length <= 1024 || !allocator.isDirectBufferPooled()) {
            ByteBufUtil.getBytes(buffer, ByteBufUtil.threadLocalTempArray(chunkLen), 0, chunkLen, out, length);
            return;
        }
        ByteBuf tmpBuf = allocator.heapBuffer(chunkLen);
        try {
            void var3_5;
            void var2_4;
            void var1_1;
            byte[] tmp = tmpBuf.array();
            int offset = tmpBuf.arrayOffset();
            ByteBufUtil.getBytes((ByteBuffer)var1_1, (byte[])var2_4, offset, chunkLen, out, (int)var3_5);
        }
        catch (Throwable throwable) {
            ByteBuf byteBuf;
            byteBuf.release();
            throw throwable;
        }
        tmpBuf.release();
    }

    private static void getBytes(ByteBuffer inBuffer, byte[] in, int inOffset, int inLen, OutputStream out, int outLen) throws IOException {
        int len;
        do {
            len = Math.min(inLen, outLen);
            inBuffer.get(in, inOffset, len);
            out.write(in, inOffset, len);
        } while ((outLen -= len) > 0);
    }

    public static void setLeakListener(ResourceLeakDetector.LeakListener leakListener) {
        ResourceLeakDetector.LeakListener leakListener2;
        AbstractByteBuf.leakDetector.setLeakListener(leakListener2);
    }

    private ByteBufUtil() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        AbstractByteBufAllocator alloc;
        logger = InternalLoggerFactory.getInstance(ByteBufUtil.class);
        BYTE_ARRAYS = new FastThreadLocal<byte[]>(){

            protected final byte[] initialValue() throws Exception {
                return PlatformDependent.allocateUninitializedArray((int)1024);
            }
        };
        MAX_BYTES_PER_CHAR_UTF8 = (int)CharsetUtil.encoder((Charset)CharsetUtil.UTF_8).maxBytesPerChar();
        String allocType = SystemPropertyUtil.get((String)"io.netty.allocator.type", (String)(PlatformDependent.isAndroid() ? "unpooled" : "pooled"));
        if ("unpooled".equals(allocType)) {
            alloc = UnpooledByteBufAllocator.DEFAULT;
            logger.debug("-Dio.netty.allocator.type: {}", (Object)allocType);
        } else if ("pooled".equals(allocType)) {
            alloc = PooledByteBufAllocator.DEFAULT;
            logger.debug("-Dio.netty.allocator.type: {}", (Object)allocType);
        } else if ("adaptive".equals(allocType)) {
            alloc = new AdaptiveByteBufAllocator();
            logger.debug("-Dio.netty.allocator.type: {}", (Object)allocType);
        } else {
            void var0;
            alloc = PooledByteBufAllocator.DEFAULT;
            logger.debug("-Dio.netty.allocator.type: pooled (unknown: {})", (Object)var0);
        }
        DEFAULT_ALLOCATOR = var1_1;
        THREAD_LOCAL_BUFFER_SIZE = SystemPropertyUtil.getInt((String)"io.netty.threadLocalDirectBufferSize", (int)0);
        logger.debug("-Dio.netty.threadLocalDirectBufferSize: {}", (Object)THREAD_LOCAL_BUFFER_SIZE);
        MAX_CHAR_BUFFER_SIZE = SystemPropertyUtil.getInt((String)"io.netty.maxThreadLocalCharBufferSize", (int)16384);
        logger.debug("-Dio.netty.maxThreadLocalCharBufferSize: {}", (Object)MAX_CHAR_BUFFER_SIZE);
        FIND_NON_ASCII = new ByteProcessor(){

            public final boolean process(byte value) {
                return value >= 0;
            }
        };
    }

    static final class ThreadLocalDirectByteBuf
    extends UnpooledDirectByteBuf {
        private static final ObjectPool<ThreadLocalDirectByteBuf> RECYCLER = ObjectPool.newPool((ObjectPool.ObjectCreator)new ObjectPool.ObjectCreator<ThreadLocalDirectByteBuf>(){

            /*
             * WARNING - void declaration
             */
            public final ThreadLocalDirectByteBuf newObject(ObjectPool.Handle<ThreadLocalDirectByteBuf> handle) {
                void var1_1;
                return new ThreadLocalDirectByteBuf((ObjectPool.Handle)var1_1);
            }
        });
        private final Recycler.EnhancedHandle<ThreadLocalDirectByteBuf> handle;

        /*
         * WARNING - void declaration
         */
        static ThreadLocalDirectByteBuf newInstance() {
            void var0;
            ThreadLocalDirectByteBuf buf = (ThreadLocalDirectByteBuf)RECYCLER.get();
            buf.resetRefCnt();
            return var0;
        }

        /*
         * WARNING - void declaration
         */
        private ThreadLocalDirectByteBuf(ObjectPool.Handle<ThreadLocalDirectByteBuf> handle) {
            super((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, 256, Integer.MAX_VALUE);
            void var1_1;
            this.handle = (Recycler.EnhancedHandle)var1_1;
        }

        @Override
        protected final void deallocate() {
            if (((ByteBuf)this).capacity() > THREAD_LOCAL_BUFFER_SIZE) {
                super.deallocate();
                return;
            }
            ((ByteBuf)this).clear();
            this.handle.unguardedRecycle((Object)this);
        }
    }

    static final class ThreadLocalUnsafeDirectByteBuf
    extends UnpooledUnsafeDirectByteBuf {
        private static final ObjectPool<ThreadLocalUnsafeDirectByteBuf> RECYCLER = ObjectPool.newPool((ObjectPool.ObjectCreator)new ObjectPool.ObjectCreator<ThreadLocalUnsafeDirectByteBuf>(){

            /*
             * WARNING - void declaration
             */
            public final ThreadLocalUnsafeDirectByteBuf newObject(ObjectPool.Handle<ThreadLocalUnsafeDirectByteBuf> handle) {
                void var1_1;
                return new ThreadLocalUnsafeDirectByteBuf((ObjectPool.Handle)var1_1);
            }
        });
        private final Recycler.EnhancedHandle<ThreadLocalUnsafeDirectByteBuf> handle;

        /*
         * WARNING - void declaration
         */
        static ThreadLocalUnsafeDirectByteBuf newInstance() {
            void var0;
            ThreadLocalUnsafeDirectByteBuf buf = (ThreadLocalUnsafeDirectByteBuf)RECYCLER.get();
            buf.resetRefCnt();
            return var0;
        }

        /*
         * WARNING - void declaration
         */
        private ThreadLocalUnsafeDirectByteBuf(ObjectPool.Handle<ThreadLocalUnsafeDirectByteBuf> handle) {
            super((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, 256, Integer.MAX_VALUE);
            void var1_1;
            this.handle = (Recycler.EnhancedHandle)var1_1;
        }

        @Override
        protected final void deallocate() {
            if (((ByteBuf)this).capacity() > THREAD_LOCAL_BUFFER_SIZE) {
                super.deallocate();
                return;
            }
            ((ByteBuf)this).clear();
            this.handle.unguardedRecycle((Object)this);
        }
    }

    private static final class HexUtil {
        private static final char[] BYTE2CHAR;
        private static final char[] HEXDUMP_TABLE;
        private static final String[] HEXPADDING;
        private static final String[] HEXDUMP_ROWPREFIXES;
        private static final String[] BYTE2HEX;
        private static final String[] BYTEPADDING;

        private HexUtil() {
        }

        /*
         * WARNING - void declaration
         */
        private static String hexDump(ByteBuf buffer, int fromIndex, int length) {
            void var2_3;
            void srcIdx;
            ObjectUtil.checkPositiveOrZero((int)length, (String)"length");
            if (length == 0) {
                return "";
            }
            int endIndex = fromIndex + length;
            char[] buf = new char[length << 1];
            int dstIdx = 0;
            while (srcIdx < endIndex) {
                System.arraycopy(HEXDUMP_TABLE, buffer.getUnsignedByte((int)srcIdx) << 1, buf, dstIdx, 2);
                ++srcIdx;
                dstIdx += 2;
            }
            return new String((char[])var2_3);
        }

        /*
         * WARNING - void declaration
         */
        private static String hexDump(byte[] array, int fromIndex, int length) {
            void var2_3;
            void srcIdx;
            ObjectUtil.checkPositiveOrZero((int)length, (String)"length");
            if (length == 0) {
                return "";
            }
            int endIndex = fromIndex + length;
            char[] buf = new char[length << 1];
            int dstIdx = 0;
            while (srcIdx < endIndex) {
                System.arraycopy(HEXDUMP_TABLE, (array[srcIdx] & 0xFF) << 1, buf, dstIdx, 2);
                ++srcIdx;
                dstIdx += 2;
            }
            return new String((char[])var2_3);
        }

        /*
         * WARNING - void declaration
         */
        private static String prettyHexDump(ByteBuf buffer, int offset, int length) {
            void var3_4;
            void var2_2;
            void var1_1;
            ByteBuf byteBuf;
            if (length == 0) {
                return "";
            }
            int rows = length / 16 + ((length & 0xF) == 0 ? 0 : 1) + 4;
            StringBuilder buf = new StringBuilder(rows * 80);
            HexUtil.appendPrettyHexDump(buf, byteBuf, (int)var1_1, (int)var2_2);
            return var3_4.toString();
        }

        /*
         * WARNING - void declaration
         */
        private static void appendPrettyHexDump(StringBuilder dump, ByteBuf buf, int offset, int length) {
            StringBuilder stringBuilder;
            if (MathUtil.isOutOfBounds((int)offset, (int)length, (int)buf.capacity())) {
                throw new IndexOutOfBoundsException("expected: 0 <= offset(" + offset + ") <= offset + length(" + length + ") <= buf.capacity(" + buf.capacity() + ')');
            }
            if (length == 0) {
                return;
            }
            dump.append("         +-------------------------------------------------+" + StringUtil.NEWLINE + "         |  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f |" + StringUtil.NEWLINE + "+--------+-------------------------------------------------+----------------+");
            int fullRows = length >>> 4;
            int remainder = length & 0xF;
            for (int row = 0; row < fullRows; ++row) {
                int j;
                int rowStartIndex = (row << 4) + offset;
                HexUtil.appendHexDumpRowPrefix(dump, row, rowStartIndex);
                int rowEndIndex = rowStartIndex + 16;
                for (j = rowStartIndex; j < rowEndIndex; ++j) {
                    dump.append(BYTE2HEX[buf.getUnsignedByte(j)]);
                }
                dump.append(" |");
                for (j = rowStartIndex; j < rowEndIndex; ++j) {
                    dump.append(BYTE2CHAR[buf.getUnsignedByte(j)]);
                }
                dump.append('|');
            }
            if (remainder != 0) {
                void var3_3;
                int j;
                void var2_2;
                int rowStartIndex = (fullRows << 4) + var2_2;
                HexUtil.appendHexDumpRowPrefix(dump, fullRows, rowStartIndex);
                int rowEndIndex = rowStartIndex + remainder;
                for (j = rowStartIndex; j < rowEndIndex; ++j) {
                    dump.append(BYTE2HEX[buf.getUnsignedByte(j)]);
                }
                dump.append(HEXPADDING[remainder]);
                dump.append(" |");
                for (j = rowStartIndex; j < rowEndIndex; ++j) {
                    dump.append(BYTE2CHAR[buf.getUnsignedByte(j)]);
                }
                dump.append(BYTEPADDING[var3_3]);
                dump.append('|');
            }
            stringBuilder.append(StringUtil.NEWLINE + "+--------+-------------------------------------------------+----------------+");
        }

        /*
         * WARNING - void declaration
         */
        private static void appendHexDumpRowPrefix(StringBuilder dump, int row, int rowStartIndex) {
            StringBuilder stringBuilder;
            void var2_2;
            if (row < HEXDUMP_ROWPREFIXES.length) {
                void var1_1;
                dump.append(HEXDUMP_ROWPREFIXES[var1_1]);
                return;
            }
            dump.append(StringUtil.NEWLINE);
            dump.append(Long.toHexString((long)var2_2 & 0xFFFFFFFFL | 0x100000000L));
            StringBuilder stringBuilder2 = dump;
            stringBuilder2.setCharAt(stringBuilder2.length() - 9, '|');
            stringBuilder.append('|');
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String access$000(ByteBuf x0, int x1, int x2) {
            void var2_2;
            void var1_1;
            return HexUtil.hexDump(x0, (int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String access$100(byte[] x0, int x1, int x2) {
            void var2_2;
            void var1_1;
            return HexUtil.hexDump(x0, (int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String access$200(ByteBuf x0, int x1, int x2) {
            void var2_2;
            void var1_1;
            return HexUtil.prettyHexDump(x0, (int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$300(StringBuilder x0, ByteBuf x1, int x2, int x3) {
            void var3_3;
            void var2_2;
            void var1_1;
            HexUtil.appendPrettyHexDump(x0, (ByteBuf)var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        static {
            int j;
            StringBuilder buf;
            int i;
            BYTE2CHAR = new char[256];
            HEXDUMP_TABLE = new char[1024];
            HEXPADDING = new String[16];
            HEXDUMP_ROWPREFIXES = new String[4096];
            BYTE2HEX = new String[256];
            BYTEPADDING = new String[16];
            char[] DIGITS = "0123456789abcdef".toCharArray();
            for (i = 0; i < 256; ++i) {
                HexUtil.HEXDUMP_TABLE[i << 1] = DIGITS[i >>> 4 & 0xF];
                HexUtil.HEXDUMP_TABLE[(i << 1) + 1] = DIGITS[i & 0xF];
            }
            for (i = 0; i < HEXPADDING.length; ++i) {
                int padding = HEXPADDING.length - i;
                buf = new StringBuilder(padding * 3);
                for (j = 0; j < padding; ++j) {
                    buf.append("   ");
                }
                HexUtil.HEXPADDING[i] = buf.toString();
            }
            for (i = 0; i < HEXDUMP_ROWPREFIXES.length; ++i) {
                StringBuilder buf2 = new StringBuilder(12);
                buf2.append(StringUtil.NEWLINE);
                buf2.append(Long.toHexString((long)(i << 4) & 0xFFFFFFFFL | 0x100000000L));
                StringBuilder stringBuilder = buf2;
                stringBuilder.setCharAt(stringBuilder.length() - 9, '|');
                buf2.append('|');
                HexUtil.HEXDUMP_ROWPREFIXES[i] = buf2.toString();
            }
            for (i = 0; i < BYTE2HEX.length; ++i) {
                HexUtil.BYTE2HEX[i] = " " + StringUtil.byteToHexStringPadded((int)i);
            }
            for (i = 0; i < BYTEPADDING.length; ++i) {
                void var2_4;
                int padding = BYTEPADDING.length - i;
                buf = new StringBuilder(padding);
                for (j = 0; j < padding; ++j) {
                    buf.append(' ');
                }
                HexUtil.BYTEPADDING[i] = var2_4.toString();
            }
            for (i = 0; i < BYTE2CHAR.length; ++i) {
                if (i <= 31 || i >= 127) {
                    HexUtil.BYTE2CHAR[i] = 46;
                    continue;
                }
                int n = i;
                HexUtil.BYTE2CHAR[n] = (char)n;
            }
        }
    }
}

