/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ObjectUtil;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ByteBufOutputStream
extends OutputStream
implements DataOutput {
    private final ByteBuf buffer;
    private final int startIndex;
    private DataOutputStream utf8out;
    private boolean closed;
    private final boolean releaseOnClose;

    /*
     * WARNING - void declaration
     */
    public ByteBufOutputStream(ByteBuf buffer) {
        this((ByteBuf)var1_1, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ByteBufOutputStream(ByteBuf buffer, boolean releaseOnClose) {
        void var1_1;
        void var2_2;
        this.releaseOnClose = var2_2;
        this.buffer = (ByteBuf)ObjectUtil.checkNotNull((Object)buffer, (String)"buffer");
        this.startIndex = var1_1.writerIndex();
    }

    public int writtenBytes() {
        return this.buffer.writerIndex() - this.startIndex;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (len == 0) {
            return;
        }
        this.buffer.writeBytes((byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(byte[] b) throws IOException {
        void var1_1;
        this.buffer.writeBytes((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(int b) throws IOException {
        void var1_1;
        this.buffer.writeByte((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeBoolean(boolean v) throws IOException {
        void var1_1;
        this.buffer.writeBoolean((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeByte(int v) throws IOException {
        void var1_1;
        this.buffer.writeByte((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeBytes(String s) throws IOException {
        void var1_1;
        this.buffer.writeCharSequence((CharSequence)var1_1, CharsetUtil.US_ASCII);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeChar(int v) throws IOException {
        void var1_1;
        this.buffer.writeChar((int)var1_1);
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.buffer.writeChar(s.charAt(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeDouble(double v) throws IOException {
        void var1_1;
        this.buffer.writeDouble((double)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeFloat(float v) throws IOException {
        void var1_1;
        this.buffer.writeFloat((float)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeInt(int v) throws IOException {
        void var1_1;
        this.buffer.writeInt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeLong(long v) throws IOException {
        void var1_1;
        this.buffer.writeLong((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeShort(int v) throws IOException {
        void var1_1;
        this.buffer.writeShort((short)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeUTF(String s) throws IOException {
        void var1_1;
        void var2_2;
        DataOutputStream out = this.utf8out;
        if (out == null) {
            if (this.closed) {
                throw new IOException("The stream is closed");
            }
            this.utf8out = out = new DataOutputStream(this);
        }
        var2_2.writeUTF((String)var1_1);
    }

    public ByteBuf buffer() {
        return this.buffer;
    }

    @Override
    public void close() throws IOException {
        block6: {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                super.close();
                if (this.utf8out == null) break block6;
            }
            catch (Throwable throwable) {
                if (this.utf8out != null) {
                    this.utf8out.close();
                }
                if (this.releaseOnClose) {
                    this.buffer.release();
                }
                throw throwable;
            }
            this.utf8out.close();
        }
        if (this.releaseOnClose) {
            this.buffer.release();
            return;
        }
    }
}

