/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.SimpleLeakAwareByteBuf;
import io.netty.util.ByteProcessor;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakTracker;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

final class AdvancedLeakAwareByteBuf
extends SimpleLeakAwareByteBuf {
    private static final String PROP_ACQUIRE_AND_RELEASE_ONLY = "io.netty.leakDetection.acquireAndReleaseOnly";
    private static final boolean ACQUIRE_AND_RELEASE_ONLY;
    private static final InternalLogger logger;

    /*
     * WARNING - void declaration
     */
    AdvancedLeakAwareByteBuf(ByteBuf buf, ResourceLeakTracker<ByteBuf> leak) {
        super((ByteBuf)var1_1, (ResourceLeakTracker<ByteBuf>)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    AdvancedLeakAwareByteBuf(ByteBuf wrapped, ByteBuf trackedByteBuf, ResourceLeakTracker<ByteBuf> leak) {
        super((ByteBuf)var1_1, (ByteBuf)var2_2, (ResourceLeakTracker<ByteBuf>)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    static void recordLeakNonRefCountingOperation(ResourceLeakTracker<ByteBuf> leak) {
        if (!ACQUIRE_AND_RELEASE_ONLY) {
            ResourceLeakTracker<ByteBuf> resourceLeakTracker;
            resourceLeakTracker.record();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf order(ByteOrder endianness) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.order((ByteOrder)var1_1);
    }

    @Override
    public final ByteBuf slice() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.slice();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf slice(int index, int length) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.slice((int)var1_1, (int)var2_2);
    }

    @Override
    public final ByteBuf retainedSlice() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.retainedSlice();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf retainedSlice(int index, int length) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.retainedSlice((int)var1_1, (int)var2_2);
    }

    @Override
    public final ByteBuf retainedDuplicate() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.retainedDuplicate();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf readRetainedSlice(int length) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readRetainedSlice((int)var1_1);
    }

    @Override
    public final ByteBuf duplicate() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.duplicate();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf readSlice(int length) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readSlice((int)var1_1);
    }

    @Override
    public final ByteBuf discardReadBytes() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.discardReadBytes();
    }

    @Override
    public final ByteBuf discardSomeReadBytes() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.discardSomeReadBytes();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf ensureWritable(int minWritableBytes) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.ensureWritable((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int ensureWritable(int minWritableBytes, boolean force) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.ensureWritable((int)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean getBoolean(int index) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getBoolean((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final byte getByte(int index) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getByte((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final short getUnsignedByte(int index) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getUnsignedByte((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final short getShort(int index) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getShort((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getUnsignedShort(int index) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getUnsignedShort((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getMedium(int index) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getMedium((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getUnsignedMedium(int index) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getUnsignedMedium((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getInt(int index) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getInt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long getUnsignedInt(int index) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getUnsignedInt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long getLong(int index) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getLong((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final char getChar(int index) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getChar((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final float getFloat(int index) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getFloat((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final double getDouble(int index) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getDouble((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, ByteBuf dst) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getBytes((int)var1_1, (ByteBuf)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, ByteBuf dst, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getBytes((int)var1_1, (ByteBuf)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getBytes((int)var1_1, (ByteBuf)var2_2, (int)var3_3, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, byte[] dst) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getBytes((int)var1_1, (byte[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getBytes((int)var1_1, (byte[])var2_2, (int)var3_3, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, ByteBuffer dst) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getBytes((int)var1_1, (ByteBuffer)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getBytes((int)var1_1, (OutputStream)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getBytes((int)var1_1, (GatheringByteChannel)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CharSequence getCharSequence(int index, int length, Charset charset) {
        void var3_3;
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getCharSequence((int)var1_1, (int)var2_2, (Charset)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setBoolean(int index, boolean value) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setBoolean((int)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setByte(int index, int value) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setByte((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setShort(int index, int value) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setShort((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setMedium(int index, int value) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setMedium((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setInt(int index, int value) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setInt((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setLong(int index, long value) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setLong((int)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setChar(int index, int value) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setChar((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setFloat(int index, float value) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setFloat((int)var1_1, (float)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setDouble(int index, double value) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setDouble((int)var1_1, (double)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setBytes(int index, ByteBuf src) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setBytes((int)var1_1, (ByteBuf)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setBytes(int index, ByteBuf src, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setBytes((int)var1_1, (ByteBuf)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setBytes((int)var1_1, (ByteBuf)var2_2, (int)var3_3, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setBytes(int index, byte[] src) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setBytes((int)var1_1, (byte[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setBytes((int)var1_1, (byte[])var2_2, (int)var3_3, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setBytes(int index, ByteBuffer src) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setBytes((int)var1_1, (ByteBuffer)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int setBytes(int index, InputStream in, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setBytes((int)var1_1, (InputStream)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setBytes((int)var1_1, (ScatteringByteChannel)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setZero(int index, int length) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setZero((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int setCharSequence(int index, CharSequence sequence, Charset charset) {
        void var3_3;
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setCharSequence((int)var1_1, (CharSequence)var2_2, (Charset)var3_3);
    }

    @Override
    public final boolean readBoolean() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readBoolean();
    }

    @Override
    public final byte readByte() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readByte();
    }

    @Override
    public final short readUnsignedByte() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readUnsignedByte();
    }

    @Override
    public final short readShort() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readShort();
    }

    @Override
    public final int readUnsignedShort() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readUnsignedShort();
    }

    @Override
    public final int readMedium() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readMedium();
    }

    @Override
    public final int readUnsignedMedium() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readUnsignedMedium();
    }

    @Override
    public final int readInt() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readInt();
    }

    @Override
    public final long readUnsignedInt() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readUnsignedInt();
    }

    @Override
    public final long readLong() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readLong();
    }

    @Override
    public final char readChar() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readChar();
    }

    @Override
    public final float readFloat() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readFloat();
    }

    @Override
    public final double readDouble() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readDouble();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf readBytes(int length) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readBytes((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf readBytes(ByteBuf dst) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readBytes((ByteBuf)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf readBytes(ByteBuf dst, int length) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readBytes((ByteBuf)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf readBytes(ByteBuf dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readBytes((ByteBuf)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf readBytes(byte[] dst) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readBytes((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf readBytes(byte[] dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readBytes((byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf readBytes(ByteBuffer dst) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readBytes((ByteBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf readBytes(OutputStream out, int length) throws IOException {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readBytes((OutputStream)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int readBytes(GatheringByteChannel out, int length) throws IOException {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readBytes((GatheringByteChannel)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CharSequence readCharSequence(int length, Charset charset) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readCharSequence((int)var1_1, (Charset)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf skipBytes(int length) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.skipBytes((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeBoolean(boolean value) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeBoolean((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeByte(int value) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeByte((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeShort(int value) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeShort((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeMedium(int value) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeMedium((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeInt(int value) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeInt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeLong(long value) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeLong((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeChar(int value) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeChar((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeFloat(float value) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeFloat((float)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeDouble(double value) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeDouble((double)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeBytes(ByteBuf src) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeBytes((ByteBuf)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeBytes(ByteBuf src, int length) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeBytes((ByteBuf)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeBytes(ByteBuf src, int srcIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeBytes((ByteBuf)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeBytes(byte[] src) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeBytes((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeBytes(byte[] src, int srcIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeBytes((byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeBytes(ByteBuffer src) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeBytes((ByteBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int writeBytes(InputStream in, int length) throws IOException {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeBytes((InputStream)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int writeBytes(ScatteringByteChannel in, int length) throws IOException {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeBytes((ScatteringByteChannel)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeZero(int length) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeZero((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int indexOf(int fromIndex, int toIndex, byte value) {
        void var3_3;
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.indexOf((int)var1_1, (int)var2_2, (byte)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int bytesBefore(byte value) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.bytesBefore((byte)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int bytesBefore(int length, byte value) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.bytesBefore((int)var1_1, (byte)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int bytesBefore(int index, int length, byte value) {
        void var3_3;
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.bytesBefore((int)var1_1, (int)var2_2, (byte)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int forEachByte(ByteProcessor processor) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.forEachByte((ByteProcessor)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int forEachByte(int index, int length, ByteProcessor processor) {
        void var3_3;
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.forEachByte((int)var1_1, (int)var2_2, (ByteProcessor)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int forEachByteDesc(ByteProcessor processor) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.forEachByteDesc((ByteProcessor)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int forEachByteDesc(int index, int length, ByteProcessor processor) {
        void var3_3;
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.forEachByteDesc((int)var1_1, (int)var2_2, (ByteProcessor)var3_3);
    }

    @Override
    public final ByteBuf copy() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.copy();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf copy(int index, int length) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.copy((int)var1_1, (int)var2_2);
    }

    @Override
    public final int nioBufferCount() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.nioBufferCount();
    }

    @Override
    public final ByteBuffer nioBuffer() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.nioBuffer();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuffer nioBuffer(int index, int length) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.nioBuffer((int)var1_1, (int)var2_2);
    }

    @Override
    public final ByteBuffer[] nioBuffers() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.nioBuffers();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuffer[] nioBuffers(int index, int length) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.nioBuffers((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuffer internalNioBuffer(int index, int length) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.internalNioBuffer((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString(Charset charset) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.toString((Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString(int index, int length, Charset charset) {
        void var3_3;
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.toString((int)var1_1, (int)var2_2, (Charset)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf capacity(int newCapacity) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.capacity((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final short getShortLE(int index) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getShortLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getUnsignedShortLE(int index) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getUnsignedShortLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getMediumLE(int index) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getMediumLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getUnsignedMediumLE(int index) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getUnsignedMediumLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getIntLE(int index) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getIntLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long getUnsignedIntLE(int index) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getUnsignedIntLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long getLongLE(int index) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getLongLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setShortLE(int index, int value) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setShortLE((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setIntLE(int index, int value) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setIntLE((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setMediumLE(int index, int value) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setMediumLE((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setLongLE(int index, long value) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setLongLE((int)var1_1, (long)var2_2);
    }

    @Override
    public final short readShortLE() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readShortLE();
    }

    @Override
    public final int readUnsignedShortLE() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readUnsignedShortLE();
    }

    @Override
    public final int readMediumLE() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readMediumLE();
    }

    @Override
    public final int readUnsignedMediumLE() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readUnsignedMediumLE();
    }

    @Override
    public final int readIntLE() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readIntLE();
    }

    @Override
    public final long readUnsignedIntLE() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readUnsignedIntLE();
    }

    @Override
    public final long readLongLE() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readLongLE();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeShortLE(int value) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeShortLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeMediumLE(int value) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeMediumLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeIntLE(int value) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeIntLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeLongLE(long value) {
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeLongLE((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int writeCharSequence(CharSequence sequence, Charset charset) {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeCharSequence((CharSequence)var1_1, (Charset)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getBytes((int)var1_1, (FileChannel)var2_2, (long)var3_3, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int setBytes(int index, FileChannel in, long position, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setBytes((int)var1_1, (FileChannel)var2_2, (long)var3_3, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int readBytes(FileChannel out, long position, int length) throws IOException {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readBytes((FileChannel)var1_1, (long)var2_2, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int writeBytes(FileChannel in, long position, int length) throws IOException {
        void var2_2;
        void var1_1;
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeBytes((FileChannel)var1_1, (long)var2_2, length);
    }

    @Override
    public final ByteBuf asReadOnly() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.asReadOnly();
    }

    @Override
    public final ByteBuf retain() {
        this.leak.record();
        return super.retain();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf retain(int increment) {
        void var1_1;
        this.leak.record();
        return super.retain((int)var1_1);
    }

    @Override
    public final boolean release() {
        this.leak.record();
        return super.release();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean release(int decrement) {
        void var1_1;
        this.leak.record();
        return super.release((int)var1_1);
    }

    @Override
    public final ByteBuf touch() {
        this.leak.record();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf touch(Object hint) {
        void var1_1;
        this.leak.record((Object)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final AdvancedLeakAwareByteBuf newLeakAwareByteBuf(ByteBuf buf, ByteBuf trackedByteBuf, ResourceLeakTracker<ByteBuf> leakTracker) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new AdvancedLeakAwareByteBuf((ByteBuf)var1_1, (ByteBuf)var2_2, (ResourceLeakTracker<ByteBuf>)var3_3);
    }

    static {
        logger = InternalLoggerFactory.getInstance(AdvancedLeakAwareByteBuf.class);
        ACQUIRE_AND_RELEASE_ONLY = SystemPropertyUtil.getBoolean((String)PROP_ACQUIRE_AND_RELEASE_ONLY, (boolean)false);
        if (logger.isDebugEnabled()) {
            logger.debug("-D{}: {}", (Object)PROP_ACQUIRE_AND_RELEASE_ONLY, (Object)ACQUIRE_AND_RELEASE_ONLY);
        }
        ResourceLeakDetector.addExclusions(AdvancedLeakAwareByteBuf.class, (String[])new String[]{"touch", "recordLeakNonRefCountingOperation"});
    }
}

