/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.AdaptiveByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.PooledDuplicatedByteBuf;
import io.netty.buffer.PooledSlicedByteBuf;
import io.netty.util.ByteProcessor;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.NettyRuntime;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ReferenceCountUpdater;
import io.netty.util.internal.SuppressJava6Requirement;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThreadExecutorMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.Arrays;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.StampedLock;

@SuppressJava6Requirement(reason="Guarded by version check")
final class AdaptivePoolingAllocator
implements AdaptiveByteBufAllocator.AdaptiveAllocatorApi {
    private static final int EXPANSION_ATTEMPTS = 3;
    private static final int INITIAL_MAGAZINES = 4;
    private static final int RETIRE_CAPACITY = 4096;
    private static final int MIN_CHUNK_SIZE = 131072;
    private static final int MAX_STRIPES = NettyRuntime.availableProcessors() << 1;
    private static final int BUFS_PER_CHUNK = 10;
    private static final int MAX_CHUNK_SIZE = 0xA00000;
    private static final int CENTRAL_QUEUE_CAPACITY = SystemPropertyUtil.getInt((String)"io.netty.allocator.centralQueueCapacity", (int)NettyRuntime.availableProcessors());
    private static final Object NO_MAGAZINE = Boolean.TRUE;
    private final ChunkAllocator chunkAllocator;
    private final Queue<Chunk> centralQueue;
    private final StampedLock magazineExpandLock;
    private volatile Magazine[] magazines;
    private final FastThreadLocal<Object> threadLocalMagazine;
    private final Set<Magazine> liveCachedMagazines;
    private volatile boolean freed;

    /*
     * WARNING - void declaration
     */
    AdaptivePoolingAllocator(ChunkAllocator chunkAllocator, MagazineCaching magazineCaching) {
        void var1_3;
        ObjectUtil.checkNotNull((Object)chunkAllocator, (String)"chunkAllocator");
        ObjectUtil.checkNotNull((Object)((Object)magazineCaching), (String)"magazineCaching");
        this.chunkAllocator = chunkAllocator;
        this.centralQueue = (Queue)ObjectUtil.checkNotNull(AdaptivePoolingAllocator.createSharedChunkQueue(), (String)"centralQueue");
        this.magazineExpandLock = new StampedLock();
        if (magazineCaching != MagazineCaching.None) {
            assert (magazineCaching == MagazineCaching.EventLoopThreads || magazineCaching == MagazineCaching.FastThreadLocalThreads);
            boolean cachedMagazinesNonEventLoopThreads = magazineCaching == MagazineCaching.FastThreadLocalThreads;
            CopyOnWriteArraySet<Magazine> liveMagazines = new CopyOnWriteArraySet<Magazine>();
            this.threadLocalMagazine = new FastThreadLocal<Object>(this, cachedMagazinesNonEventLoopThreads, liveMagazines){
                final /* synthetic */ boolean val$cachedMagazinesNonEventLoopThreads;
                final /* synthetic */ Set val$liveMagazines;
                final /* synthetic */ AdaptivePoolingAllocator this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$cachedMagazinesNonEventLoopThreads = bl;
                    this.val$liveMagazines = set;
                }

                /*
                 * WARNING - void declaration
                 */
                protected Object initialValue() {
                    if (this.val$cachedMagazinesNonEventLoopThreads || ThreadExecutorMap.currentExecutor() != null) {
                        void var1_1;
                        Magazine mag = new Magazine(this.this$0, false);
                        if (FastThreadLocalThread.willCleanupFastThreadLocals((Thread)Thread.currentThread())) {
                            this.val$liveMagazines.add(mag);
                        }
                        return var1_1;
                    }
                    return NO_MAGAZINE;
                }

                /*
                 * WARNING - void declaration
                 */
                protected void onRemoval(Object value) throws Exception {
                    if (value != NO_MAGAZINE) {
                        void var1_1;
                        this.val$liveMagazines.remove(var1_1);
                    }
                }
            };
            this.liveCachedMagazines = liveMagazines;
        } else {
            this.threadLocalMagazine = null;
            this.liveCachedMagazines = null;
        }
        Magazine[] mags = new Magazine[4];
        for (int i = 0; i < mags.length; ++i) {
            mags[i] = new Magazine(this);
        }
        this.magazines = var1_3;
    }

    private static Queue<Chunk> createSharedChunkQueue() {
        return PlatformDependent.newFixedMpmcQueue((int)CENTRAL_QUEUE_CAPACITY);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf allocate(int size, int maxCapacity) {
        void var2_4;
        void var1_1;
        if (size <= 0xA00000) {
            Thread currentThread = Thread.currentThread();
            boolean bl = FastThreadLocalThread.willCleanupFastThreadLocals((Thread)currentThread);
            AdaptiveByteBuf buf = AdaptiveByteBuf.newInstance(bl);
            try {
                void var3_5;
                if (this.allocate(size, maxCapacity, (Thread)var3_5, buf)) {
                    void var1_2;
                    AdaptiveByteBuf result = buf;
                    buf = null;
                    return var1_2;
                }
            }
            finally {
                if (buf != null) {
                    buf.release();
                }
            }
        }
        return this.chunkAllocator.allocate((int)var1_1, (int)var2_4);
    }

    /*
     * WARNING - void declaration
     */
    private boolean allocate(int size, int maxCapacity, Thread currentThread, AdaptiveByteBuf buf) {
        void var3_3;
        Object mag;
        int sizeBucket = AllocationStatistics.sizeBucket(size);
        FastThreadLocal<Object> threadLocalMagazine = this.threadLocalMagazine;
        if (threadLocalMagazine != null && currentThread instanceof FastThreadLocalThread && (mag = threadLocalMagazine.get()) != NO_MAGAZINE) {
            boolean allocated = ((Magazine)mag).tryAllocate(size, sizeBucket, maxCapacity, buf);
            assert (allocated) : "Allocation of threadLocalMagazine must always succeed";
            return true;
        }
        long threadId = currentThread.getId();
        int expansions = 0;
        do {
            Magazine[] mags = this.magazines;
            int mask = this.magazines.length - 1;
            int index = (int)(threadId & (long)mask);
            int m = Integer.numberOfTrailingZeros(~mask);
            for (int i = 0; i < m; ++i) {
                Magazine magazine = mags[index + i & mask];
                if (!magazine.tryAllocate(size, sizeBucket, maxCapacity, buf)) continue;
                return true;
            }
        } while (++expansions <= 3 && this.tryExpandMagazines(((void)var3_3).length));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    final void allocate(int size, int maxCapacity, AdaptiveByteBuf into) {
        Magazine magazine = into.chunk.magazine;
        if (!this.allocate(size, maxCapacity, Thread.currentThread(), into)) {
            AbstractByteBuf innerChunk = this.chunkAllocator.allocate(size, maxCapacity);
            Chunk chunk = new Chunk(innerChunk, magazine, false);
            try {
                void var2_3;
                void var1_1;
                void var3_4;
                chunk.readInitInto((AdaptiveByteBuf)var3_4, (int)var1_1, (int)var2_3);
                return;
            }
            finally {
                chunk.release();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long usedMemory() {
        void var1_1;
        long sum = 0L;
        for (Chunk chunk : this.centralQueue) {
            sum += (long)chunk.capacity();
        }
        Magazine[] magazineArray = this.magazines;
        int chunk = this.magazines.length;
        for (int i = 0; i < chunk; ++i) {
            Magazine magazine = magazineArray[i];
            sum += magazine.usedMemory.get();
        }
        if (this.liveCachedMagazines != null) {
            for (Magazine magazine : this.liveCachedMagazines) {
                sum += magazine.usedMemory.get();
            }
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private boolean tryExpandMagazines(int currentLength) {
        if (currentLength >= MAX_STRIPES) {
            return true;
        }
        long writeLock = this.magazineExpandLock.tryWriteLock();
        if (writeLock != 0L) {
            Magazine[] mags;
            block7: {
                mags = this.magazines;
                if (this.magazines.length < MAX_STRIPES && mags.length <= currentLength && !this.freed) break block7;
                this.magazineExpandLock.unlockWrite(writeLock);
                return true;
            }
            try {
                int preferredChunkSize = mags[0].sharedPrefChunkSize;
                Magazine[] expanded = new Magazine[mags.length << 1];
                int l = expanded.length;
                for (int i = 0; i < l; ++i) {
                    Magazine m = new Magazine(this);
                    new Magazine(this).localPrefChunkSize = preferredChunkSize;
                    m.sharedPrefChunkSize = preferredChunkSize;
                    expanded[i] = m;
                }
                this.magazines = expanded;
                Magazine[] magazineArray = mags;
                int n = mags.length;
                for (int i = 0; i < n; ++i) {
                    Magazine magazine = magazineArray[i];
                    magazine.free();
                }
                this.magazineExpandLock.unlockWrite(writeLock);
            }
            catch (Throwable throwable) {
                void var2_4;
                this.magazineExpandLock.unlockWrite((long)var2_4);
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean offerToQueue(Chunk buffer) {
        void var1_1;
        if (this.freed) {
            return false;
        }
        return this.centralQueue.offer((Chunk)var1_1);
    }

    protected final void finalize() throws Throwable {
        try {
            super.finalize();
            return;
        }
        finally {
            this.free();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void free() {
        Chunk chunk;
        Magazine[] magazineArray;
        this.freed = true;
        long stamp = this.magazineExpandLock.writeLock();
        try {
            magazineArray = this.magazines;
            magazineArray = this.magazines;
            int n = magazineArray.length;
            for (int i = 0; i < n; ++i) {
                Magazine magazine = magazineArray[i];
                magazine.free();
            }
            this.magazineExpandLock.unlockWrite(stamp);
        }
        catch (Throwable throwable) {
            void var1_1;
            this.magazineExpandLock.unlockWrite((long)var1_1);
            throw throwable;
        }
        while ((chunk = this.centralQueue.poll()) != null) {
            magazineArray.release();
        }
    }

    static int sizeBucket(int size) {
        return AllocationStatistics.sizeBucket(size);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$700(AdaptivePoolingAllocator x0, Chunk x1) {
        void var1_1;
        return x0.offerToQueue((Chunk)var1_1);
    }

    static interface ChunkAllocator {
        public AbstractByteBuf allocate(int var1, int var2);
    }

    static final class AdaptiveByteBuf
    extends AbstractReferenceCountedByteBuf {
        static final ObjectPool<AdaptiveByteBuf> RECYCLER = ObjectPool.newPool((ObjectPool.ObjectCreator)new ObjectPool.ObjectCreator<AdaptiveByteBuf>(){

            /*
             * WARNING - void declaration
             */
            public final AdaptiveByteBuf newObject(ObjectPool.Handle<AdaptiveByteBuf> handle) {
                void var1_1;
                return new AdaptiveByteBuf((ObjectPool.Handle<AdaptiveByteBuf>)var1_1);
            }
        });
        private final ObjectPool.Handle<AdaptiveByteBuf> handle;
        private int adjustment;
        private AbstractByteBuf rootParent;
        private Chunk chunk;
        private int length;
        private ByteBuffer tmpNioBuf;
        private boolean hasArray;
        private boolean hasMemoryAddress;

        /*
         * WARNING - void declaration
         */
        static AdaptiveByteBuf newInstance(boolean useThreadLocal) {
            if (useThreadLocal) {
                void var0_1;
                AdaptiveByteBuf buf = (AdaptiveByteBuf)RECYCLER.get();
                buf.resetRefCnt();
                buf.discardMarks();
                return var0_1;
            }
            return new AdaptiveByteBuf(null);
        }

        /*
         * WARNING - void declaration
         */
        AdaptiveByteBuf(ObjectPool.Handle<AdaptiveByteBuf> recyclerHandle) {
            super(0);
            void var1_1;
            this.handle = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        final void init(AbstractByteBuf unwrapped, Chunk wrapped, int readerIndex, int writerIndex, int adjustment, int capacity, int maxCapacity) {
            void var1_1;
            void var3_3;
            void var2_2;
            this.adjustment = adjustment;
            this.chunk = var2_2;
            this.length = capacity;
            this.maxCapacity(maxCapacity);
            this.setIndex0((int)var3_3, writerIndex);
            this.hasArray = unwrapped.hasArray();
            this.hasMemoryAddress = unwrapped.hasMemoryAddress();
            this.rootParent = unwrapped;
            this.tmpNioBuf = var1_1.internalNioBuffer(adjustment, capacity).slice();
        }

        /*
         * WARNING - void declaration
         */
        private AbstractByteBuf rootParent() {
            AbstractByteBuf rootParent = this.rootParent;
            if (rootParent != null) {
                void var1_1;
                return var1_1;
            }
            throw new IllegalReferenceCountException();
        }

        @Override
        public final ByteBuf retainedSlice() {
            if (this.handle == null) {
                return super.retainedSlice();
            }
            this.ensureAccessible();
            AdaptiveByteBuf adaptiveByteBuf = this;
            return PooledSlicedByteBuf.newInstance(adaptiveByteBuf, adaptiveByteBuf, ((ByteBuf)this).readerIndex(), ((ByteBuf)this).readableBytes());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteBuf retainedSlice(int index, int length) {
            void var2_2;
            void var1_1;
            if (this.handle == null) {
                return super.retainedSlice(index, length);
            }
            this.ensureAccessible();
            AdaptiveByteBuf adaptiveByteBuf = this;
            return PooledSlicedByteBuf.newInstance(adaptiveByteBuf, adaptiveByteBuf, (int)var1_1, (int)var2_2);
        }

        @Override
        public final ByteBuf retainedDuplicate() {
            if (this.handle == null) {
                return super.retainedDuplicate();
            }
            this.ensureAccessible();
            AdaptiveByteBuf adaptiveByteBuf = this;
            return PooledDuplicatedByteBuf.newInstance(adaptiveByteBuf, adaptiveByteBuf, ((ByteBuf)this).readerIndex(), ((ByteBuf)this).writerIndex());
        }

        @Override
        public final int capacity() {
            return this.length;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteBuf capacity(int newCapacity) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (newCapacity == ((ByteBuf)this).capacity()) {
                this.ensureAccessible();
                return this;
            }
            this.checkNewCapacity(newCapacity);
            if (newCapacity < ((ByteBuf)this).capacity()) {
                this.length = newCapacity;
                AdaptiveByteBuf adaptiveByteBuf = this;
                adaptiveByteBuf.setIndex0(Math.min(((ByteBuf)adaptiveByteBuf).readerIndex(), newCapacity), Math.min(((ByteBuf)this).writerIndex(), newCapacity));
                return this;
            }
            ByteBuffer data = this.tmpNioBuf;
            data.clear();
            this.tmpNioBuf = null;
            Chunk chunk = this.chunk;
            Magazine magazine = chunk.magazine;
            AdaptivePoolingAllocator allocator = magazine.parent;
            int readerIndex = this.readerIndex;
            int writerIndex = this.writerIndex;
            allocator.allocate((int)var1_1, ((ByteBuf)this).maxCapacity(), this);
            this.tmpNioBuf.put((ByteBuffer)var2_2);
            this.tmpNioBuf.clear();
            var3_3.release();
            this.readerIndex = readerIndex;
            this.writerIndex = writerIndex;
            return this;
        }

        @Override
        public final ByteBufAllocator alloc() {
            return this.rootParent().alloc();
        }

        @Override
        public final ByteOrder order() {
            return this.rootParent().order();
        }

        @Override
        public final ByteBuf unwrap() {
            return null;
        }

        @Override
        public final boolean isDirect() {
            return this.rootParent().isDirect();
        }

        @Override
        public final int arrayOffset() {
            AdaptiveByteBuf adaptiveByteBuf = this;
            return adaptiveByteBuf.idx(adaptiveByteBuf.rootParent().arrayOffset());
        }

        @Override
        public final boolean hasMemoryAddress() {
            return this.hasMemoryAddress;
        }

        @Override
        public final long memoryAddress() {
            this.ensureAccessible();
            return this.rootParent().memoryAddress() + (long)this.adjustment;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteBuffer nioBuffer(int index, int length) {
            void var2_2;
            void var1_1;
            this.checkIndex(index, length);
            return this.rootParent().nioBuffer(this.idx((int)var1_1), (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteBuffer internalNioBuffer(int index, int length) {
            void var2_2;
            void var1_1;
            this.checkIndex(index, length);
            return (ByteBuffer)this.internalNioBuffer().position(index).limit((int)(var1_1 + var2_2));
        }

        private ByteBuffer internalNioBuffer() {
            return (ByteBuffer)this.tmpNioBuf.clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteBuffer[] nioBuffers(int index, int length) {
            void var2_2;
            void var1_1;
            this.checkIndex(index, length);
            return this.rootParent().nioBuffers(this.idx((int)var1_1), (int)var2_2);
        }

        @Override
        public final boolean hasArray() {
            return this.hasArray;
        }

        @Override
        public final byte[] array() {
            this.ensureAccessible();
            return this.rootParent().array();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteBuf copy(int index, int length) {
            void var2_2;
            void var1_1;
            this.checkIndex(index, length);
            return this.rootParent().copy(this.idx((int)var1_1), (int)var2_2);
        }

        @Override
        public final int nioBufferCount() {
            return this.rootParent().nioBufferCount();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final byte _getByte(int index) {
            void var1_1;
            return this.rootParent()._getByte(this.idx((int)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final short _getShort(int index) {
            void var1_1;
            return this.rootParent()._getShort(this.idx((int)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final short _getShortLE(int index) {
            void var1_1;
            return this.rootParent()._getShortLE(this.idx((int)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final int _getUnsignedMedium(int index) {
            void var1_1;
            return this.rootParent()._getUnsignedMedium(this.idx((int)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final int _getUnsignedMediumLE(int index) {
            void var1_1;
            return this.rootParent()._getUnsignedMediumLE(this.idx((int)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final int _getInt(int index) {
            void var1_1;
            return this.rootParent()._getInt(this.idx((int)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final int _getIntLE(int index) {
            void var1_1;
            return this.rootParent()._getIntLE(this.idx((int)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final long _getLong(int index) {
            void var1_1;
            return this.rootParent()._getLong(this.idx((int)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final long _getLongLE(int index) {
            void var1_1;
            return this.rootParent()._getLongLE(this.idx((int)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.checkIndex(index, length);
            this.rootParent().getBytes(this.idx((int)var1_1), (ByteBuf)var2_2, (int)var3_3, length);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.checkIndex(index, length);
            this.rootParent().getBytes(this.idx((int)var1_1), (byte[])var2_2, (int)var3_3, length);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteBuf getBytes(int index, ByteBuffer dst) {
            void var2_2;
            void var1_1;
            this.checkIndex(index, dst.remaining());
            this.rootParent().getBytes(this.idx((int)var1_1), (ByteBuffer)var2_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void _setByte(int index, int value) {
            void var2_2;
            void var1_1;
            this.rootParent()._setByte(this.idx((int)var1_1), (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void _setShort(int index, int value) {
            void var2_2;
            void var1_1;
            this.rootParent()._setShort(this.idx((int)var1_1), (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void _setShortLE(int index, int value) {
            void var2_2;
            void var1_1;
            this.rootParent()._setShortLE(this.idx((int)var1_1), (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void _setMedium(int index, int value) {
            void var2_2;
            void var1_1;
            this.rootParent()._setMedium(this.idx((int)var1_1), (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void _setMediumLE(int index, int value) {
            void var2_2;
            void var1_1;
            this.rootParent()._setMediumLE(this.idx((int)var1_1), (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void _setInt(int index, int value) {
            void var2_2;
            void var1_1;
            this.rootParent()._setInt(this.idx((int)var1_1), (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void _setIntLE(int index, int value) {
            void var2_2;
            void var1_1;
            this.rootParent()._setIntLE(this.idx((int)var1_1), (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void _setLong(int index, long value) {
            void var2_2;
            void var1_1;
            this.rootParent()._setLong(this.idx((int)var1_1), (long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void _setLongLE(int index, long value) {
            void var2_2;
            void var1_1;
            ((ByteBuf)this.rootParent()).setLongLE(this.idx((int)var1_1), (long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.checkIndex(index, length);
            this.rootParent().setBytes(this.idx((int)var1_1), (byte[])var2_2, (int)var3_3, length);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.checkIndex(index, length);
            this.rootParent().setBytes(this.idx((int)var1_1), (ByteBuf)var2_2, (int)var3_3, length);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteBuf setBytes(int index, ByteBuffer src) {
            void var2_2;
            void var1_1;
            this.checkIndex(index, src.remaining());
            this.rootParent().setBytes(this.idx((int)var1_1), (ByteBuffer)var2_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
            this.checkIndex(index, length);
            if (length != 0) {
                void var2_2;
                void var3_3;
                void var1_1;
                ByteBufUtil.readBytes(((ByteBuf)this).alloc(), this.internalNioBuffer().duplicate(), (int)var1_1, (int)var3_3, (OutputStream)var2_2);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
            void var3_3;
            void var1_1;
            return out.write(((ByteBuf)this).internalNioBuffer((int)var1_1, (int)var3_3).duplicate());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int getBytes(int index, FileChannel out, long position, int length) throws IOException {
            void var3_3;
            void var1_1;
            return out.write(((ByteBuf)this).internalNioBuffer((int)var1_1, length).duplicate(), (long)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int setBytes(int index, InputStream in, int length) throws IOException {
            void var2_3;
            void var1_1;
            void var3_4;
            this.checkIndex(index, length);
            AbstractByteBuf rootParent = this.rootParent();
            if (rootParent.hasArray()) {
                return rootParent.setBytes(this.idx(index), in, length);
            }
            byte[] tmp = ByteBufUtil.threadLocalTempArray(length);
            int readBytes = in.read(tmp, 0, (int)var3_4);
            if (readBytes <= 0) {
                return readBytes;
            }
            ((ByteBuf)this).setBytes((int)var1_1, tmp, 0, readBytes);
            return (int)var2_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
            try {
                void var3_3;
                void var1_1;
                return in.read(((ByteBuf)this).internalNioBuffer((int)var1_1, (int)var3_3).duplicate());
            }
            catch (ClosedChannelException closedChannelException) {
                return -1;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int setBytes(int index, FileChannel in, long position, int length) throws IOException {
            try {
                void var3_3;
                void var1_1;
                return in.read(((ByteBuf)this).internalNioBuffer((int)var1_1, length).duplicate(), (long)var3_3);
            }
            catch (ClosedChannelException closedChannelException) {
                return -1;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int forEachByte(int index, int length, ByteProcessor processor) {
            void var1_1;
            void var3_3;
            void var2_2;
            this.checkIndex(index, length);
            int ret = ((ByteBuf)this.rootParent()).forEachByte(this.idx(index), (int)var2_2, (ByteProcessor)var3_3);
            return this.forEachResult((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int forEachByteDesc(int index, int length, ByteProcessor processor) {
            void var1_1;
            void var3_3;
            void var2_2;
            this.checkIndex(index, length);
            int ret = ((ByteBuf)this.rootParent()).forEachByteDesc(this.idx(index), (int)var2_2, (ByteProcessor)var3_3);
            return this.forEachResult((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private int forEachResult(int ret) {
            void var1_1;
            if (ret < this.adjustment) {
                return -1;
            }
            return (int)(var1_1 - this.adjustment);
        }

        @Override
        public final boolean isContiguous() {
            return this.rootParent().isContiguous();
        }

        private int idx(int index) {
            return index + this.adjustment;
        }

        @Override
        protected final void deallocate() {
            if (this.chunk != null) {
                this.chunk.release();
            }
            this.tmpNioBuf = null;
            this.chunk = null;
            this.rootParent = null;
            if (this.handle instanceof Recycler.EnhancedHandle) {
                ((Recycler.EnhancedHandle)this.handle).unguardedRecycle((Object)this);
                return;
            }
            if (this.handle != null) {
                this.handle.recycle((Object)this);
            }
        }
    }

    private static final class Chunk
    implements ReferenceCounted {
        private final AbstractByteBuf delegate;
        private final Magazine magazine;
        private final int capacity;
        private final boolean pooled;
        private int allocatedBytes;
        private static final long REFCNT_FIELD_OFFSET = ReferenceCountUpdater.getUnsafeOffset(Chunk.class, (String)"refCnt");
        private static final AtomicIntegerFieldUpdater<Chunk> AIF_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Chunk.class, "refCnt");
        private static final ReferenceCountUpdater<Chunk> updater = new ReferenceCountUpdater<Chunk>(){

            protected final AtomicIntegerFieldUpdater<Chunk> updater() {
                return AIF_UPDATER;
            }

            protected final long unsafeOffset() {
                return REFCNT_FIELD_OFFSET;
            }
        };
        private volatile int refCnt;

        Chunk() {
            this.delegate = null;
            this.magazine = null;
            this.capacity = 0;
            this.pooled = false;
        }

        /*
         * WARNING - void declaration
         */
        Chunk(AbstractByteBuf delegate, Magazine magazine, boolean pooled) {
            void var2_2;
            void var1_1;
            void var3_3;
            this.delegate = delegate;
            this.magazine = magazine;
            this.pooled = var3_3;
            this.capacity = var1_1.capacity();
            ((Magazine)var2_2).usedMemory.getAndAdd(this.capacity);
            updater.setInitialValue((ReferenceCounted)this);
        }

        public final Chunk touch(Object hint) {
            return this;
        }

        public final int refCnt() {
            return updater.refCnt((ReferenceCounted)this);
        }

        public final Chunk retain() {
            return (Chunk)updater.retain((ReferenceCounted)this);
        }

        /*
         * WARNING - void declaration
         */
        public final Chunk retain(int increment) {
            void var1_1;
            return (Chunk)updater.retain((ReferenceCounted)this, (int)var1_1);
        }

        public final Chunk touch() {
            return this;
        }

        public final boolean release() {
            if (updater.release((ReferenceCounted)this)) {
                this.deallocate();
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean release(int decrement) {
            void var1_1;
            if (updater.release((ReferenceCounted)this, (int)var1_1)) {
                this.deallocate();
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private void deallocate() {
            void var2_2;
            void var1_1;
            block5: {
                Magazine mag;
                block4: {
                    void var3_3;
                    mag = this.magazine;
                    AdaptivePoolingAllocator parent = mag.parent;
                    int chunkSize = mag.preferredChunkSize();
                    int memSize = this.delegate.capacity();
                    if (!this.pooled || memSize < chunkSize) break block4;
                    void v0 = var3_3;
                    if (memSize <= v0 + (v0 >> 1)) break block5;
                }
                mag.usedMemory.getAndAdd(-this.capacity());
                this.delegate.release();
                return;
            }
            updater.resetRefCnt((ReferenceCounted)this);
            ((ByteBuf)this.delegate).setIndex(0, 0);
            this.allocatedBytes = 0;
            if (!var1_1.trySetNextInLine(this) && !AdaptivePoolingAllocator.access$700((AdaptivePoolingAllocator)var2_2, this)) {
                this.delegate.release();
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void readInitInto(AdaptiveByteBuf buf, int size, int maxCapacity) {
            int startIndex = this.allocatedBytes;
            this.allocatedBytes = startIndex + size;
            Chunk chunk = this;
            chunk.retain();
            try {
                void var3_4;
                void var2_3;
                void var1_1;
                var1_1.init(this.delegate, chunk, 0, 0, startIndex, (int)var2_3, (int)var3_4);
                chunk = null;
                return;
            }
            catch (Throwable throwable) {
                chunk.release();
                throw throwable;
            }
        }

        public final int remainingCapacity() {
            return this.capacity - this.allocatedBytes;
        }

        public final int capacity() {
            return this.capacity;
        }
    }

    @SuppressJava6Requirement(reason="Guarded by version check")
    private static final class Magazine
    extends AllocationStatistics {
        private static final AtomicReferenceFieldUpdater<Magazine, Chunk> NEXT_IN_LINE = AtomicReferenceFieldUpdater.newUpdater(Magazine.class, Chunk.class, "nextInLine");
        private static final Chunk MAGAZINE_FREED = new Chunk();
        private Chunk current;
        private volatile Chunk nextInLine;
        private final AtomicLong usedMemory;
        private final StampedLock allocationLock;

        /*
         * WARNING - void declaration
         */
        Magazine(AdaptivePoolingAllocator parent) {
            this((AdaptivePoolingAllocator)var1_1, true);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        Magazine(AdaptivePoolingAllocator parent, boolean shareable) {
            super((AdaptivePoolingAllocator)var1_1, shareable);
            void var2_2;
            void var1_1;
            this.allocationLock = var2_2 != false ? new StampedLock() : null;
            this.usedMemory = new AtomicLong();
        }

        /*
         * WARNING - void declaration
         */
        public final boolean tryAllocate(int size, int sizeBucket, int maxCapacity, AdaptiveByteBuf buf) {
            if (this.allocationLock == null) {
                return this.allocate(size, sizeBucket, maxCapacity, buf);
            }
            long writeLock = this.allocationLock.tryWriteLock();
            if (writeLock != 0L) {
                try {
                    void var3_4;
                    void var2_3;
                    boolean bl;
                    bl = this.allocate(bl ? 1 : 0, (int)var2_3, (int)var3_4, buf);
                    return bl;
                }
                finally {
                    this.allocationLock.unlockWrite(writeLock);
                }
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private boolean allocate(int size, int sizeBucket, int maxCapacity, AdaptiveByteBuf buf) {
            this.recordAllocationSize(sizeBucket);
            Chunk curr = this.current;
            if (curr != null) {
                if (curr.remainingCapacity() > size) {
                    curr.readInitInto(buf, size, maxCapacity);
                    return true;
                }
                this.current = null;
                if (curr.remainingCapacity() == size) {
                    try {
                        curr.readInitInto(buf, size, maxCapacity);
                        return true;
                    }
                    finally {
                        curr.release();
                    }
                }
            }
            Chunk last = curr;
            assert (this.current == null);
            if (this.nextInLine != null) {
                curr = NEXT_IN_LINE.getAndSet(this, null);
                if (curr == MAGAZINE_FREED) {
                    this.restoreMagazineFreed();
                    return false;
                }
            } else {
                curr = (Chunk)this.parent.centralQueue.poll();
                if (curr == null) {
                    curr = this.newChunkAllocation(size);
                }
            }
            this.current = curr;
            assert (this.current != null);
            if (last != null) {
                if (last.remainingCapacity() < 4096) {
                    last.release();
                } else {
                    this.transferChunk(last);
                }
            }
            if (curr.remainingCapacity() > size) {
                curr.readInitInto(buf, size, maxCapacity);
            } else {
                if (curr.remainingCapacity() == size) {
                    try {
                        curr.readInitInto(buf, size, maxCapacity);
                    }
                    finally {
                        curr.release();
                        this.current = null;
                    }
                }
                Chunk newChunk = this.newChunkAllocation(size);
                try {
                    void var3_6;
                    void var1_1;
                    newChunk.readInitInto(buf, (int)var1_1, (int)var3_6);
                    if (curr.remainingCapacity() < 4096) {
                        void var2_5;
                        var2_5.release();
                        this.current = newChunk;
                    } else {
                        this.transferChunk(newChunk);
                    }
                    newChunk = null;
                }
                catch (Throwable throwable) {
                    if (newChunk != null) {
                        assert (this.current == null);
                        newChunk.release();
                    }
                    throw throwable;
                }
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private void restoreMagazineFreed() {
            Chunk next = NEXT_IN_LINE.getAndSet(this, MAGAZINE_FREED);
            if (next != null && next != MAGAZINE_FREED) {
                void var1_1;
                var1_1.release();
            }
        }

        /*
         * WARNING - void declaration
         */
        private void transferChunk(Chunk current) {
            void var1_1;
            if (NEXT_IN_LINE.compareAndSet(this, null, current) || AdaptivePoolingAllocator.access$700(this.parent, current)) {
                return;
            }
            Chunk nextChunk = NEXT_IN_LINE.get(this);
            if (nextChunk != null && current.remainingCapacity() > nextChunk.remainingCapacity() && NEXT_IN_LINE.compareAndSet(this, nextChunk, current)) {
                if (nextChunk != MAGAZINE_FREED) {
                    void var2_2;
                    var2_2.release();
                }
                return;
            }
            var1_1.release();
        }

        /*
         * WARNING - void declaration
         */
        private Chunk newChunkAllocation(int promptingSize) {
            void var2_2;
            void var1_1;
            int size = Math.max(promptingSize * 10, this.preferredChunkSize());
            ChunkAllocator chunkAllocator = this.parent.chunkAllocator;
            void v0 = var1_1;
            return new Chunk(var2_2.allocate((int)v0, (int)v0), this, true);
        }

        /*
         * WARNING - void declaration
         */
        final boolean trySetNextInLine(Chunk chunk) {
            void var1_1;
            return NEXT_IN_LINE.compareAndSet(this, null, (Chunk)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final void free() {
            this.restoreMagazineFreed();
            long stamp = this.allocationLock.writeLock();
            try {
                if (this.current != null) {
                    this.current.release();
                    this.current = null;
                }
                this.allocationLock.unlockWrite(stamp);
                return;
            }
            catch (Throwable throwable) {
                void var1_1;
                this.allocationLock.unlockWrite((long)var1_1);
                throw throwable;
            }
        }
    }

    private static class AllocationStatistics {
        private static final int MIN_DATUM_TARGET = 1024;
        private static final int MAX_DATUM_TARGET = 65534;
        private static final int INIT_DATUM_TARGET = 9;
        private static final int HISTO_MIN_BUCKET_SHIFT = 13;
        private static final int HISTO_MAX_BUCKET_SHIFT = 20;
        private static final int HISTO_BUCKET_COUNT = 8;
        private static final int HISTO_MAX_BUCKET_MASK = 7;
        private static final int SIZE_MAX_MASK = 0x9FFFFF;
        protected final AdaptivePoolingAllocator parent;
        private final boolean shareable;
        private final short[][] histos = new short[][]{new short[8], new short[8], new short[8], new short[8]};
        private short[] histo = this.histos[0];
        private final int[] sums = new int[8];
        private int histoIndex;
        private int datumCount;
        private int datumTarget = 9;
        protected volatile int sharedPrefChunkSize = 131072;
        protected volatile int localPrefChunkSize = 131072;

        /*
         * WARNING - void declaration
         */
        private AllocationStatistics(AdaptivePoolingAllocator parent, boolean shareable) {
            void var2_2;
            void var1_1;
            this.parent = var1_1;
            this.shareable = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        protected void recordAllocationSize(int bucket) {
            void var1_1;
            void v0 = var1_1;
            this.histo[v0] = (short)(this.histo[v0] + 1);
            if (this.datumCount++ == this.datumTarget) {
                this.rotateHistograms();
            }
        }

        static int sizeBucket(int size) {
            int n;
            if (size == 0) {
                return 0;
            }
            int normalizedSize = size - 1 >> 13 & 0x9FFFFF;
            return Math.min(32 - Integer.numberOfLeadingZeros(n), 7);
        }

        private void rotateHistograms() {
            int prefChunkSize;
            int n;
            int n2;
            Object hs = this.histos;
            for (int i = 0; i < 8; ++i) {
                this.sums[i] = (hs[0][i] & 0xFFFF) + (hs[1][i] & 0xFFFF) + (hs[2][i] & 0xFFFF) + (hs[3][i] & 0xFFFF);
            }
            int sum = 0;
            hs = this.sums;
            int n3 = this.sums.length;
            for (n2 = 0; n2 < n3; ++n2) {
                short[] count = hs[n2];
                sum += count;
            }
            int targetPercentile = (int)((double)n * 0.99);
            for (int sizeBucket = 0; sizeBucket < this.sums.length && this.sums[sizeBucket] <= targetPercentile; targetPercentile -= this.sums[sizeBucket], ++sizeBucket) {
            }
            n2 = 1 << n3 + 13;
            this.localPrefChunkSize = prefChunkSize = Math.max(n2 * 10, 131072);
            if (this.shareable) {
                for (Magazine mag : this.parent.magazines) {
                    prefChunkSize = Math.max(prefChunkSize, mag.localPrefChunkSize);
                }
            }
            if (this.sharedPrefChunkSize != prefChunkSize) {
                this.datumTarget = Math.max(this.datumTarget >> 1, 1024);
                this.sharedPrefChunkSize = prefChunkSize;
            } else {
                this.datumTarget = Math.min(this.datumTarget << 1, 65534);
            }
            this.histoIndex = this.histoIndex + 1 & 3;
            this.histo = this.histos[this.histoIndex];
            this.datumCount = 0;
            Arrays.fill(this.histo, (short)0);
        }

        protected int preferredChunkSize() {
            return this.sharedPrefChunkSize;
        }
    }

    static enum MagazineCaching {
        EventLoopThreads,
        FastThreadLocalThreads,
        None;

    }
}

