/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.AdaptivePoolingAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufAllocatorMetric;
import io.netty.buffer.ByteBufAllocatorMetricProvider;
import io.netty.buffer.UnpooledDirectByteBuf;
import io.netty.buffer.UnpooledHeapByteBuf;
import io.netty.buffer.UnpooledUnsafeHeapByteBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public final class AdaptiveByteBufAllocator
extends AbstractByteBufAllocator
implements ByteBufAllocatorMetric,
ByteBufAllocatorMetricProvider {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AdaptiveByteBufAllocator.class);
    private static final boolean DEFAULT_USE_CACHED_MAGAZINES_FOR_NON_EVENT_LOOP_THREADS = SystemPropertyUtil.getBoolean((String)"io.netty.allocator.useCachedMagazinesForNonEventLoopThreads", (boolean)false);
    private final AdaptiveAllocatorApi direct;
    private final AdaptiveAllocatorApi heap;

    public AdaptiveByteBufAllocator() {
        this(PlatformDependent.directBufferPreferred());
    }

    /*
     * WARNING - void declaration
     */
    public AdaptiveByteBufAllocator(boolean preferDirect) {
        this((boolean)var1_1, DEFAULT_USE_CACHED_MAGAZINES_FOR_NON_EVENT_LOOP_THREADS);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AdaptiveByteBufAllocator(boolean preferDirect, boolean useCacheForNonEventLoopThreads) {
        super(preferDirect);
        void var1_2;
        void var2_3;
        if (PlatformDependent.javaVersion() < 8) {
            throw new IllegalStateException("This allocator require Java 8 or newer.");
        }
        AdaptivePoolingAllocator.MagazineCaching magazineCaching = var2_3 != false ? AdaptivePoolingAllocator.MagazineCaching.FastThreadLocalThreads : AdaptivePoolingAllocator.MagazineCaching.EventLoopThreads;
        this.direct = new AdaptivePoolingAllocator(new DirectChunkAllocator(this), magazineCaching);
        this.heap = new AdaptivePoolingAllocator(new HeapChunkAllocator(this), (AdaptivePoolingAllocator.MagazineCaching)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final ByteBuf newHeapBuffer(int initialCapacity, int maxCapacity) {
        void var2_2;
        void var1_1;
        return this.heap.allocate((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final ByteBuf newDirectBuffer(int initialCapacity, int maxCapacity) {
        void var2_2;
        void var1_1;
        return this.direct.allocate((int)var1_1, (int)var2_2);
    }

    @Override
    public final boolean isDirectBufferPooled() {
        return true;
    }

    @Override
    public final long usedHeapMemory() {
        return this.heap.usedMemory();
    }

    @Override
    public final long usedDirectMemory() {
        return this.direct.usedMemory();
    }

    @Override
    public final ByteBufAllocatorMetric metric() {
        return this;
    }

    static {
        logger.debug("-Dio.netty.allocator.useCachedMagazinesForNonEventLoopThreads: {}", (Object)DEFAULT_USE_CACHED_MAGAZINES_FOR_NON_EVENT_LOOP_THREADS);
    }

    private static final class DirectChunkAllocator
    implements AdaptivePoolingAllocator.ChunkAllocator {
        private final ByteBufAllocator allocator;

        /*
         * WARNING - void declaration
         */
        private DirectChunkAllocator(ByteBufAllocator allocator) {
            void var1_1;
            this.allocator = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final AbstractByteBuf allocate(int initialCapacity, int maxCapacity) {
            void var2_2;
            void var1_1;
            if (PlatformDependent.hasUnsafe()) {
                return UnsafeByteBufUtil.newUnsafeDirectByteBuf(this.allocator, initialCapacity, maxCapacity);
            }
            return new UnpooledDirectByteBuf(this.allocator, (int)var1_1, (int)var2_2);
        }
    }

    private static final class HeapChunkAllocator
    implements AdaptivePoolingAllocator.ChunkAllocator {
        private final ByteBufAllocator allocator;

        /*
         * WARNING - void declaration
         */
        private HeapChunkAllocator(ByteBufAllocator allocator) {
            void var1_1;
            this.allocator = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final AbstractByteBuf allocate(int initialCapacity, int maxCapacity) {
            void var2_2;
            void var1_1;
            if (PlatformDependent.hasUnsafe()) {
                return new UnpooledUnsafeHeapByteBuf(this.allocator, initialCapacity, maxCapacity);
            }
            return new UnpooledHeapByteBuf(this.allocator, (int)var1_1, (int)var2_2);
        }
    }

    static interface AdaptiveAllocatorApi {
        public ByteBuf allocate(int var1, int var2);

        public long usedMemory();
    }
}

