/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.SwappedByteBuf;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteOrder;

abstract class AbstractUnsafeSwappedByteBuf
extends SwappedByteBuf {
    private final boolean nativeByteOrder;
    private final AbstractByteBuf wrapped;

    /*
     * WARNING - void declaration
     */
    AbstractUnsafeSwappedByteBuf(AbstractByteBuf buf) {
        super(buf);
        void var1_1;
        assert (PlatformDependent.isUnaligned());
        this.wrapped = var1_1;
        this.nativeByteOrder = PlatformDependent.BIG_ENDIAN_NATIVE_ORDER == (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long getLong(int index) {
        void var2_2;
        void var1_1;
        this.wrapped.checkIndex(index, 8);
        AbstractUnsafeSwappedByteBuf abstractUnsafeSwappedByteBuf = this;
        long v = abstractUnsafeSwappedByteBuf._getLong(abstractUnsafeSwappedByteBuf.wrapped, (int)var1_1);
        if (this.nativeByteOrder) {
            return v;
        }
        return Long.reverseBytes((long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final float getFloat(int index) {
        void var1_1;
        return Float.intBitsToFloat(((ByteBuf)this).getInt((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final double getDouble(int index) {
        void var1_1;
        return Double.longBitsToDouble(((ByteBuf)this).getLong((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final char getChar(int index) {
        void var1_1;
        return (char)((ByteBuf)this).getShort((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long getUnsignedInt(int index) {
        void var1_1;
        return (long)((ByteBuf)this).getInt((int)var1_1) & 0xFFFFFFFFL;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getInt(int index) {
        void var1_1;
        this.wrapped.checkIndex(index, 4);
        AbstractUnsafeSwappedByteBuf abstractUnsafeSwappedByteBuf = this;
        int v = abstractUnsafeSwappedByteBuf._getInt(abstractUnsafeSwappedByteBuf.wrapped, index);
        if (this.nativeByteOrder) {
            return v;
        }
        return Integer.reverseBytes((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getUnsignedShort(int index) {
        void var1_1;
        return ((ByteBuf)this).getShort((int)var1_1) & 0xFFFF;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final short getShort(int index) {
        void var1_1;
        this.wrapped.checkIndex(index, 2);
        AbstractUnsafeSwappedByteBuf abstractUnsafeSwappedByteBuf = this;
        short v = abstractUnsafeSwappedByteBuf._getShort(abstractUnsafeSwappedByteBuf.wrapped, index);
        if (this.nativeByteOrder) {
            return v;
        }
        return Short.reverseBytes((short)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setShort(int index, int value) {
        void var2_2;
        void var1_1;
        this.wrapped.checkIndex(index, 2);
        AbstractUnsafeSwappedByteBuf abstractUnsafeSwappedByteBuf = this;
        abstractUnsafeSwappedByteBuf._setShort(abstractUnsafeSwappedByteBuf.wrapped, (int)var1_1, this.nativeByteOrder ? (short)value : Short.reverseBytes((short)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setInt(int index, int value) {
        void var2_2;
        void var1_1;
        this.wrapped.checkIndex(index, 4);
        AbstractUnsafeSwappedByteBuf abstractUnsafeSwappedByteBuf = this;
        abstractUnsafeSwappedByteBuf._setInt(abstractUnsafeSwappedByteBuf.wrapped, (int)var1_1, this.nativeByteOrder ? value : Integer.reverseBytes((int)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setLong(int index, long value) {
        void var2_2;
        void var1_1;
        this.wrapped.checkIndex(index, 8);
        AbstractUnsafeSwappedByteBuf abstractUnsafeSwappedByteBuf = this;
        abstractUnsafeSwappedByteBuf._setLong(abstractUnsafeSwappedByteBuf.wrapped, (int)var1_1, this.nativeByteOrder ? value : Long.reverseBytes((long)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setChar(int index, int value) {
        void var2_2;
        void var1_1;
        ((ByteBuf)this).setShort((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setFloat(int index, float value) {
        void var2_2;
        void var1_1;
        ((ByteBuf)this).setInt((int)var1_1, Float.floatToRawIntBits((float)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf setDouble(int index, double value) {
        void var2_2;
        void var1_1;
        ((ByteBuf)this).setLong((int)var1_1, Double.doubleToRawLongBits((double)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeShort(int value) {
        void var1_1;
        this.wrapped.ensureWritable0(2);
        AbstractUnsafeSwappedByteBuf abstractUnsafeSwappedByteBuf = this;
        abstractUnsafeSwappedByteBuf._setShort(abstractUnsafeSwappedByteBuf.wrapped, this.wrapped.writerIndex, this.nativeByteOrder ? (short)value : Short.reverseBytes((short)var1_1));
        this.wrapped.writerIndex += 2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeInt(int value) {
        void var1_1;
        this.wrapped.ensureWritable0(4);
        AbstractUnsafeSwappedByteBuf abstractUnsafeSwappedByteBuf = this;
        abstractUnsafeSwappedByteBuf._setInt(abstractUnsafeSwappedByteBuf.wrapped, this.wrapped.writerIndex, this.nativeByteOrder ? value : Integer.reverseBytes((int)var1_1));
        this.wrapped.writerIndex += 4;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeLong(long value) {
        void var1_1;
        this.wrapped.ensureWritable0(8);
        AbstractUnsafeSwappedByteBuf abstractUnsafeSwappedByteBuf = this;
        abstractUnsafeSwappedByteBuf._setLong(abstractUnsafeSwappedByteBuf.wrapped, this.wrapped.writerIndex, this.nativeByteOrder ? value : Long.reverseBytes((long)var1_1));
        this.wrapped.writerIndex += 8;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeChar(int value) {
        void var1_1;
        ((ByteBuf)this).writeShort((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeFloat(float value) {
        void var1_1;
        ((ByteBuf)this).writeInt(Float.floatToRawIntBits((float)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf writeDouble(double value) {
        void var1_1;
        ((ByteBuf)this).writeLong(Double.doubleToRawLongBits((double)var1_1));
        return this;
    }

    protected abstract short _getShort(AbstractByteBuf var1, int var2);

    protected abstract int _getInt(AbstractByteBuf var1, int var2);

    protected abstract long _getLong(AbstractByteBuf var1, int var2);

    protected abstract void _setShort(AbstractByteBuf var1, int var2, short var3);

    protected abstract void _setInt(AbstractByteBuf var1, int var2, int var3);

    protected abstract void _setLong(AbstractByteBuf var1, int var2, long var3);
}

