/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractDerivedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.DuplicatedByteBuf;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.MathUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

abstract class AbstractUnpooledSlicedByteBuf
extends AbstractDerivedByteBuf {
    private final ByteBuf buffer;
    private final int adjustment;

    /*
     * WARNING - void declaration
     */
    AbstractUnpooledSlicedByteBuf(ByteBuf buffer, int index, int length) {
        super(length);
        void var3_3;
        AbstractUnpooledSlicedByteBuf.checkSliceOutOfBounds(index, length, buffer);
        if (buffer instanceof AbstractUnpooledSlicedByteBuf) {
            this.buffer = ((AbstractUnpooledSlicedByteBuf)buffer).buffer;
            this.adjustment = ((AbstractUnpooledSlicedByteBuf)buffer).adjustment + index;
        } else if (buffer instanceof DuplicatedByteBuf) {
            this.buffer = buffer.unwrap();
            this.adjustment = index;
        } else {
            void var2_2;
            void var1_1;
            this.buffer = var1_1;
            this.adjustment = var2_2;
        }
        this.initLength(length);
        ((ByteBuf)this).writerIndex((int)var3_3);
    }

    void initLength(int length) {
    }

    int length() {
        return this.capacity();
    }

    @Override
    public ByteBuf unwrap() {
        return this.buffer;
    }

    @Override
    public ByteBufAllocator alloc() {
        return ((ByteBuf)this).unwrap().alloc();
    }

    @Override
    @Deprecated
    public ByteOrder order() {
        return ((ByteBuf)this).unwrap().order();
    }

    @Override
    public boolean isDirect() {
        return ((ByteBuf)this).unwrap().isDirect();
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        throw new UnsupportedOperationException("sliced buffer");
    }

    @Override
    public boolean hasArray() {
        return ((ByteBuf)this).unwrap().hasArray();
    }

    @Override
    public byte[] array() {
        return ((ByteBuf)this).unwrap().array();
    }

    @Override
    public int arrayOffset() {
        AbstractUnpooledSlicedByteBuf abstractUnpooledSlicedByteBuf = this;
        return abstractUnpooledSlicedByteBuf.idx(((ByteBuf)abstractUnpooledSlicedByteBuf).unwrap().arrayOffset());
    }

    @Override
    public boolean hasMemoryAddress() {
        return ((ByteBuf)this).unwrap().hasMemoryAddress();
    }

    @Override
    public long memoryAddress() {
        return ((ByteBuf)this).unwrap().memoryAddress() + (long)this.adjustment;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte getByte(int index) {
        void var1_1;
        this.checkIndex0(index, 1);
        return ((ByteBuf)this).unwrap().getByte(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected byte _getByte(int index) {
        void var1_1;
        return ((ByteBuf)this).unwrap().getByte(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public short getShort(int index) {
        void var1_1;
        this.checkIndex0(index, 2);
        return ((ByteBuf)this).unwrap().getShort(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected short _getShort(int index) {
        void var1_1;
        return ((ByteBuf)this).unwrap().getShort(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public short getShortLE(int index) {
        void var1_1;
        this.checkIndex0(index, 2);
        return ((ByteBuf)this).unwrap().getShortLE(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected short _getShortLE(int index) {
        void var1_1;
        return ((ByteBuf)this).unwrap().getShortLE(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getUnsignedMedium(int index) {
        void var1_1;
        this.checkIndex0(index, 3);
        return ((ByteBuf)this).unwrap().getUnsignedMedium(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getUnsignedMedium(int index) {
        void var1_1;
        return ((ByteBuf)this).unwrap().getUnsignedMedium(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getUnsignedMediumLE(int index) {
        void var1_1;
        this.checkIndex0(index, 3);
        return ((ByteBuf)this).unwrap().getUnsignedMediumLE(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getUnsignedMediumLE(int index) {
        void var1_1;
        return ((ByteBuf)this).unwrap().getUnsignedMediumLE(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getInt(int index) {
        void var1_1;
        this.checkIndex0(index, 4);
        return ((ByteBuf)this).unwrap().getInt(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getInt(int index) {
        void var1_1;
        return ((ByteBuf)this).unwrap().getInt(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getIntLE(int index) {
        void var1_1;
        this.checkIndex0(index, 4);
        return ((ByteBuf)this).unwrap().getIntLE(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getIntLE(int index) {
        void var1_1;
        return ((ByteBuf)this).unwrap().getIntLE(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getLong(int index) {
        void var1_1;
        this.checkIndex0(index, 8);
        return ((ByteBuf)this).unwrap().getLong(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected long _getLong(int index) {
        void var1_1;
        return ((ByteBuf)this).unwrap().getLong(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getLongLE(int index) {
        void var1_1;
        this.checkIndex0(index, 8);
        return ((ByteBuf)this).unwrap().getLongLE(this.idx((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected long _getLongLE(int index) {
        void var1_1;
        return ((ByteBuf)this).unwrap().getLongLE(this.idx((int)var1_1));
    }

    @Override
    public ByteBuf duplicate() {
        return ((ByteBuf)this).slice(0, this.capacity()).setIndex(((ByteBuf)this).readerIndex(), ((ByteBuf)this).writerIndex());
    }

    @Override
    public ByteBuf retainedDuplicate() {
        return ((ByteBuf)this).retainedSlice(0, this.capacity()).setIndex(((ByteBuf)this).readerIndex(), ((ByteBuf)this).writerIndex());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf copy(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        return ((ByteBuf)this).unwrap().copy(this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf slice(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        return ((ByteBuf)this).unwrap().slice(this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        ((ByteBuf)this).unwrap().getBytes(this.idx((int)var1_1), (ByteBuf)var2_2, (int)var3_3, length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        ((ByteBuf)this).unwrap().getBytes(this.idx((int)var1_1), (byte[])var2_2, (int)var3_3, length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getBytes(int index, ByteBuffer dst) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, dst.remaining());
        ((ByteBuf)this).unwrap().getBytes(this.idx((int)var1_1), (ByteBuffer)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setByte(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, 1);
        ((ByteBuf)this).unwrap().setByte(this.idx((int)var1_1), (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CharSequence getCharSequence(int index, int length, Charset charset) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        return ((ByteBuf)this).unwrap().getCharSequence(this.idx((int)var1_1), (int)var2_2, (Charset)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setByte(int index, int value) {
        void var2_2;
        void var1_1;
        ((ByteBuf)this).unwrap().setByte(this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setShort(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, 2);
        ((ByteBuf)this).unwrap().setShort(this.idx((int)var1_1), (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setShort(int index, int value) {
        void var2_2;
        void var1_1;
        ((ByteBuf)this).unwrap().setShort(this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setShortLE(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, 2);
        ((ByteBuf)this).unwrap().setShortLE(this.idx((int)var1_1), (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setShortLE(int index, int value) {
        void var2_2;
        void var1_1;
        ((ByteBuf)this).unwrap().setShortLE(this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setMedium(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, 3);
        ((ByteBuf)this).unwrap().setMedium(this.idx((int)var1_1), (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setMedium(int index, int value) {
        void var2_2;
        void var1_1;
        ((ByteBuf)this).unwrap().setMedium(this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setMediumLE(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, 3);
        ((ByteBuf)this).unwrap().setMediumLE(this.idx((int)var1_1), (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setMediumLE(int index, int value) {
        void var2_2;
        void var1_1;
        ((ByteBuf)this).unwrap().setMediumLE(this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setInt(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, 4);
        ((ByteBuf)this).unwrap().setInt(this.idx((int)var1_1), (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setInt(int index, int value) {
        void var2_2;
        void var1_1;
        ((ByteBuf)this).unwrap().setInt(this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setIntLE(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, 4);
        ((ByteBuf)this).unwrap().setIntLE(this.idx((int)var1_1), (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setIntLE(int index, int value) {
        void var2_2;
        void var1_1;
        ((ByteBuf)this).unwrap().setIntLE(this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setLong(int index, long value) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, 8);
        ((ByteBuf)this).unwrap().setLong(this.idx((int)var1_1), (long)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setLong(int index, long value) {
        void var2_2;
        void var1_1;
        ((ByteBuf)this).unwrap().setLong(this.idx((int)var1_1), (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setLongLE(int index, long value) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, 8);
        ((ByteBuf)this).unwrap().setLongLE(this.idx((int)var1_1), (long)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setLongLE(int index, long value) {
        void var2_2;
        void var1_1;
        ((ByteBuf)this).unwrap().setLongLE(this.idx((int)var1_1), (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        ((ByteBuf)this).unwrap().setBytes(this.idx((int)var1_1), (byte[])var2_2, (int)var3_3, length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        ((ByteBuf)this).unwrap().setBytes(this.idx((int)var1_1), (ByteBuf)var2_2, (int)var3_3, length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setBytes(int index, ByteBuffer src) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, src.remaining());
        ((ByteBuf)this).unwrap().setBytes(this.idx((int)var1_1), (ByteBuffer)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        ((ByteBuf)this).unwrap().getBytes(this.idx((int)var1_1), (OutputStream)var2_2, (int)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        return ((ByteBuf)this).unwrap().getBytes(this.idx((int)var1_1), (GatheringByteChannel)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        return ((ByteBuf)this).unwrap().getBytes(this.idx((int)var1_1), (FileChannel)var2_2, (long)var3_3, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        return ((ByteBuf)this).unwrap().setBytes(this.idx((int)var1_1), (InputStream)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        return ((ByteBuf)this).unwrap().setBytes(this.idx((int)var1_1), (ScatteringByteChannel)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int setBytes(int index, FileChannel in, long position, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        return ((ByteBuf)this).unwrap().setBytes(this.idx((int)var1_1), (FileChannel)var2_2, (long)var3_3, length);
    }

    @Override
    public int nioBufferCount() {
        return ((ByteBuf)this).unwrap().nioBufferCount();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer nioBuffer(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        return ((ByteBuf)this).unwrap().nioBuffer(this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer[] nioBuffers(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex0(index, length);
        return ((ByteBuf)this).unwrap().nioBuffers(this.idx((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int forEachByte(int index, int length, ByteProcessor processor) {
        void var3_3;
        void var2_2;
        this.checkIndex0(index, length);
        int ret = ((ByteBuf)this).unwrap().forEachByte(this.idx(index), (int)var2_2, (ByteProcessor)var3_3);
        if (ret >= this.adjustment) {
            void var1_1;
            return (int)(var1_1 - this.adjustment);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int forEachByteDesc(int index, int length, ByteProcessor processor) {
        void var3_3;
        void var2_2;
        this.checkIndex0(index, length);
        int ret = ((ByteBuf)this).unwrap().forEachByteDesc(this.idx(index), (int)var2_2, (ByteProcessor)var3_3);
        if (ret >= this.adjustment) {
            void var1_1;
            return (int)(var1_1 - this.adjustment);
        }
        return -1;
    }

    final int idx(int index) {
        return index + this.adjustment;
    }

    /*
     * WARNING - void declaration
     */
    static void checkSliceOutOfBounds(int index, int length, ByteBuf buffer) {
        if (MathUtil.isOutOfBounds((int)index, (int)length, (int)buffer.capacity())) {
            void var1_1;
            int n;
            void var2_2;
            throw new IndexOutOfBoundsException(var2_2 + ".slice(" + n + ", " + (int)var1_1 + ')');
        }
    }
}

