/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledDuplicatedByteBuf;
import io.netty.buffer.PooledSlicedByteBuf;
import io.netty.buffer.SimpleLeakAwareByteBuf;
import io.netty.buffer.UnpooledDuplicatedByteBuf;
import io.netty.buffer.UnpooledSlicedByteBuf;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.Recycler;
import io.netty.util.internal.ObjectPool;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

abstract class AbstractPooledDerivedByteBuf
extends AbstractReferenceCountedByteBuf {
    private final Recycler.EnhancedHandle<AbstractPooledDerivedByteBuf> recyclerHandle;
    private AbstractByteBuf rootParent;
    private ByteBuf parent;

    /*
     * WARNING - void declaration
     */
    AbstractPooledDerivedByteBuf(ObjectPool.Handle<? extends AbstractPooledDerivedByteBuf> recyclerHandle) {
        super(0);
        void var1_1;
        this.recyclerHandle = (Recycler.EnhancedHandle)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final void parent(ByteBuf newParent) {
        void var1_1;
        assert (newParent instanceof SimpleLeakAwareByteBuf);
        this.parent = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final AbstractByteBuf unwrap() {
        void var1_1;
        AbstractByteBuf rootParent = this.rootParent;
        if (rootParent == null) {
            throw new IllegalReferenceCountException();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final <U extends AbstractPooledDerivedByteBuf> U init(AbstractByteBuf unwrapped, ByteBuf wrapped, int readerIndex, int writerIndex, int maxCapacity) {
        void var1_1;
        wrapped.retain();
        this.parent = wrapped;
        this.rootParent = unwrapped;
        try {
            void var3_4;
            this.maxCapacity(maxCapacity);
            this.setIndex0((int)var3_4, writerIndex);
            this.resetRefCnt();
            AbstractPooledDerivedByteBuf castThis = this;
            wrapped = null;
        }
        catch (Throwable throwable) {
            if (wrapped != null) {
                void var2_3;
                AbstractPooledDerivedByteBuf abstractPooledDerivedByteBuf = this;
                abstractPooledDerivedByteBuf.rootParent = null;
                abstractPooledDerivedByteBuf.parent = null;
                var2_3.release();
            }
            throw throwable;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void deallocate() {
        void var1_1;
        ByteBuf parent = this.parent;
        AbstractPooledDerivedByteBuf abstractPooledDerivedByteBuf = this;
        abstractPooledDerivedByteBuf.rootParent = null;
        abstractPooledDerivedByteBuf.parent = null;
        this.recyclerHandle.unguardedRecycle((Object)this);
        var1_1.release();
    }

    @Override
    public final ByteBufAllocator alloc() {
        return this.unwrap().alloc();
    }

    @Override
    @Deprecated
    public final ByteOrder order() {
        return this.unwrap().order();
    }

    @Override
    public boolean isReadOnly() {
        return ((ByteBuf)this.unwrap()).isReadOnly();
    }

    @Override
    public final boolean isDirect() {
        return this.unwrap().isDirect();
    }

    @Override
    public boolean hasArray() {
        return this.unwrap().hasArray();
    }

    @Override
    public byte[] array() {
        return this.unwrap().array();
    }

    @Override
    public boolean hasMemoryAddress() {
        return this.unwrap().hasMemoryAddress();
    }

    @Override
    public boolean isContiguous() {
        return this.unwrap().isContiguous();
    }

    @Override
    public final int nioBufferCount() {
        return this.unwrap().nioBufferCount();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuffer internalNioBuffer(int index, int length) {
        void var2_2;
        void var1_1;
        return this.nioBuffer((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteBuf retainedSlice() {
        void var1_1;
        int index = ((ByteBuf)this).readerIndex();
        return ((ByteBuf)this).retainedSlice(index, ((ByteBuf)this).writerIndex() - var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf slice(int index, int length) {
        void var2_2;
        void var1_1;
        this.ensureAccessible();
        AbstractPooledDerivedByteBuf abstractPooledDerivedByteBuf = this;
        return new PooledNonRetainedSlicedByteBuf(abstractPooledDerivedByteBuf, abstractPooledDerivedByteBuf.unwrap(), (int)var1_1, (int)var2_2);
    }

    final ByteBuf duplicate0() {
        this.ensureAccessible();
        AbstractPooledDerivedByteBuf abstractPooledDerivedByteBuf = this;
        return new PooledNonRetainedDuplicateByteBuf(abstractPooledDerivedByteBuf, abstractPooledDerivedByteBuf.unwrap());
    }

    private static final class PooledNonRetainedSlicedByteBuf
    extends UnpooledSlicedByteBuf {
        private final ByteBuf referenceCountDelegate;

        /*
         * WARNING - void declaration
         */
        PooledNonRetainedSlicedByteBuf(ByteBuf referenceCountDelegate, AbstractByteBuf buffer, int index, int length) {
            super((AbstractByteBuf)var2_2, (int)var3_3, length);
            void var1_1;
            void var3_3;
            void var2_2;
            this.referenceCountDelegate = var1_1;
        }

        @Override
        final boolean isAccessible0() {
            return this.referenceCountDelegate.isAccessible();
        }

        @Override
        final int refCnt0() {
            return this.referenceCountDelegate.refCnt();
        }

        @Override
        final ByteBuf retain0() {
            this.referenceCountDelegate.retain();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final ByteBuf retain0(int increment) {
            void var1_1;
            this.referenceCountDelegate.retain((int)var1_1);
            return this;
        }

        @Override
        final ByteBuf touch0() {
            this.referenceCountDelegate.touch();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final ByteBuf touch0(Object hint) {
            void var1_1;
            this.referenceCountDelegate.touch(var1_1);
            return this;
        }

        @Override
        final boolean release0() {
            return this.referenceCountDelegate.release();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean release0(int decrement) {
            void var1_1;
            return this.referenceCountDelegate.release((int)var1_1);
        }

        @Override
        public final ByteBuf duplicate() {
            this.ensureAccessible();
            PooledNonRetainedSlicedByteBuf pooledNonRetainedSlicedByteBuf = this;
            PooledNonRetainedSlicedByteBuf pooledNonRetainedSlicedByteBuf2 = this;
            return ((ByteBuf)new PooledNonRetainedDuplicateByteBuf(this.referenceCountDelegate, this.unwrap())).setIndex(pooledNonRetainedSlicedByteBuf.idx(((ByteBuf)pooledNonRetainedSlicedByteBuf).readerIndex()), pooledNonRetainedSlicedByteBuf2.idx(((ByteBuf)pooledNonRetainedSlicedByteBuf2).writerIndex()));
        }

        @Override
        public final ByteBuf retainedDuplicate() {
            PooledNonRetainedSlicedByteBuf pooledNonRetainedSlicedByteBuf = this;
            PooledNonRetainedSlicedByteBuf pooledNonRetainedSlicedByteBuf2 = this;
            return PooledDuplicatedByteBuf.newInstance(this.unwrap(), pooledNonRetainedSlicedByteBuf, pooledNonRetainedSlicedByteBuf.idx(((ByteBuf)this).readerIndex()), pooledNonRetainedSlicedByteBuf2.idx(((ByteBuf)pooledNonRetainedSlicedByteBuf2).writerIndex()));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteBuf slice(int index, int length) {
            void var2_2;
            void var1_1;
            this.checkIndex(index, length);
            return new PooledNonRetainedSlicedByteBuf(this.referenceCountDelegate, this.unwrap(), this.idx((int)var1_1), (int)var2_2);
        }

        @Override
        public final ByteBuf retainedSlice() {
            return ((ByteBuf)this).retainedSlice(0, ((ByteBuf)this).capacity());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteBuf retainedSlice(int index, int length) {
            void var2_2;
            void var1_1;
            PooledNonRetainedSlicedByteBuf pooledNonRetainedSlicedByteBuf = this;
            return PooledSlicedByteBuf.newInstance(this.unwrap(), pooledNonRetainedSlicedByteBuf, pooledNonRetainedSlicedByteBuf.idx((int)var1_1), (int)var2_2);
        }
    }

    private static final class PooledNonRetainedDuplicateByteBuf
    extends UnpooledDuplicatedByteBuf {
        private final ByteBuf referenceCountDelegate;

        /*
         * WARNING - void declaration
         */
        PooledNonRetainedDuplicateByteBuf(ByteBuf referenceCountDelegate, AbstractByteBuf buffer) {
            super((AbstractByteBuf)var2_2);
            void var1_1;
            void var2_2;
            this.referenceCountDelegate = var1_1;
        }

        @Override
        final boolean isAccessible0() {
            return this.referenceCountDelegate.isAccessible();
        }

        @Override
        final int refCnt0() {
            return this.referenceCountDelegate.refCnt();
        }

        @Override
        final ByteBuf retain0() {
            this.referenceCountDelegate.retain();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final ByteBuf retain0(int increment) {
            void var1_1;
            this.referenceCountDelegate.retain((int)var1_1);
            return this;
        }

        @Override
        final ByteBuf touch0() {
            this.referenceCountDelegate.touch();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final ByteBuf touch0(Object hint) {
            void var1_1;
            this.referenceCountDelegate.touch(var1_1);
            return this;
        }

        @Override
        final boolean release0() {
            return this.referenceCountDelegate.release();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean release0(int decrement) {
            void var1_1;
            return this.referenceCountDelegate.release((int)var1_1);
        }

        @Override
        public final ByteBuf duplicate() {
            this.ensureAccessible();
            return new PooledNonRetainedDuplicateByteBuf(this.referenceCountDelegate, this);
        }

        @Override
        public final ByteBuf retainedDuplicate() {
            PooledNonRetainedDuplicateByteBuf pooledNonRetainedDuplicateByteBuf = this;
            return PooledDuplicatedByteBuf.newInstance(this.unwrap(), pooledNonRetainedDuplicateByteBuf, ((ByteBuf)pooledNonRetainedDuplicateByteBuf).readerIndex(), ((ByteBuf)this).writerIndex());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteBuf slice(int index, int length) {
            void var2_2;
            void var1_1;
            this.checkIndex(index, length);
            return new PooledNonRetainedSlicedByteBuf(this.referenceCountDelegate, this.unwrap(), (int)var1_1, (int)var2_2);
        }

        @Override
        public final ByteBuf retainedSlice() {
            PooledNonRetainedDuplicateByteBuf pooledNonRetainedDuplicateByteBuf = this;
            return ((ByteBuf)pooledNonRetainedDuplicateByteBuf).retainedSlice(((ByteBuf)pooledNonRetainedDuplicateByteBuf).readerIndex(), ((ByteBuf)this).capacity());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteBuf retainedSlice(int index, int length) {
            void var2_2;
            void var1_1;
            return PooledSlicedByteBuf.newInstance(this.unwrap(), this, (int)var1_1, (int)var2_2);
        }
    }
}

