/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AdvancedLeakAwareByteBuf;
import io.netty.buffer.AdvancedLeakAwareCompositeByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.EmptyByteBuf;
import io.netty.buffer.SimpleLeakAwareByteBuf;
import io.netty.buffer.SimpleLeakAwareCompositeByteBuf;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakTracker;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;

public abstract class AbstractByteBufAllocator
implements ByteBufAllocator {
    static final int DEFAULT_INITIAL_CAPACITY = 256;
    static final int DEFAULT_MAX_CAPACITY = Integer.MAX_VALUE;
    static final int DEFAULT_MAX_COMPONENTS = 16;
    static final int CALCULATE_THRESHOLD = 0x400000;
    private final boolean directByDefault;
    private final ByteBuf emptyBuf;

    /*
     * WARNING - void declaration
     */
    protected static ByteBuf toLeakAwareBuffer(ByteBuf buf) {
        ByteBuf byteBuf;
        switch (ResourceLeakDetector.getLevel()) {
            case SIMPLE: {
                ResourceLeakTracker leak = AbstractByteBuf.leakDetector.track((Object)buf);
                if (leak == null) break;
                buf = new SimpleLeakAwareByteBuf(buf, (ResourceLeakTracker<ByteBuf>)leak);
                break;
            }
            case ADVANCED: 
            case PARANOID: {
                void var1_2;
                ResourceLeakTracker leak = AbstractByteBuf.leakDetector.track((Object)buf);
                if (leak == null) break;
                buf = new AdvancedLeakAwareByteBuf(buf, (ResourceLeakTracker<ByteBuf>)var1_2);
            }
        }
        return byteBuf;
    }

    /*
     * WARNING - void declaration
     */
    protected static CompositeByteBuf toLeakAwareBuffer(CompositeByteBuf buf) {
        CompositeByteBuf compositeByteBuf;
        switch (ResourceLeakDetector.getLevel()) {
            case SIMPLE: {
                ResourceLeakTracker leak = AbstractByteBuf.leakDetector.track((Object)buf);
                if (leak == null) break;
                buf = new SimpleLeakAwareCompositeByteBuf(buf, (ResourceLeakTracker<ByteBuf>)leak);
                break;
            }
            case ADVANCED: 
            case PARANOID: {
                void var1_2;
                ResourceLeakTracker leak = AbstractByteBuf.leakDetector.track((Object)buf);
                if (leak == null) break;
                buf = new AdvancedLeakAwareCompositeByteBuf(buf, (ResourceLeakTracker<ByteBuf>)var1_2);
            }
        }
        return compositeByteBuf;
    }

    protected AbstractByteBufAllocator() {
        this(false);
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractByteBufAllocator(boolean preferDirect) {
        void var1_1;
        this.directByDefault = var1_1 != false && PlatformDependent.hasUnsafe();
        this.emptyBuf = new EmptyByteBuf(this);
    }

    @Override
    public ByteBuf buffer() {
        if (this.directByDefault) {
            return this.directBuffer();
        }
        return this.heapBuffer();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf buffer(int initialCapacity) {
        void var1_1;
        if (this.directByDefault) {
            return this.directBuffer(initialCapacity);
        }
        return this.heapBuffer((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf buffer(int initialCapacity, int maxCapacity) {
        void var2_2;
        void var1_1;
        if (this.directByDefault) {
            return this.directBuffer(initialCapacity, maxCapacity);
        }
        return this.heapBuffer((int)var1_1, (int)var2_2);
    }

    @Override
    public ByteBuf ioBuffer() {
        if (PlatformDependent.hasUnsafe() || this.isDirectBufferPooled()) {
            return this.directBuffer(256);
        }
        return this.heapBuffer(256);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf ioBuffer(int initialCapacity) {
        void var1_1;
        if (PlatformDependent.hasUnsafe() || this.isDirectBufferPooled()) {
            return this.directBuffer(initialCapacity);
        }
        return this.heapBuffer((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf ioBuffer(int initialCapacity, int maxCapacity) {
        void var2_2;
        void var1_1;
        if (PlatformDependent.hasUnsafe() || this.isDirectBufferPooled()) {
            return this.directBuffer(initialCapacity, maxCapacity);
        }
        return this.heapBuffer((int)var1_1, (int)var2_2);
    }

    @Override
    public ByteBuf heapBuffer() {
        return this.heapBuffer(256, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf heapBuffer(int initialCapacity) {
        void var1_1;
        return this.heapBuffer((int)var1_1, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf heapBuffer(int initialCapacity, int maxCapacity) {
        void var2_2;
        void var1_1;
        if (initialCapacity == 0 && maxCapacity == 0) {
            return this.emptyBuf;
        }
        AbstractByteBufAllocator.validate(initialCapacity, maxCapacity);
        return this.newHeapBuffer((int)var1_1, (int)var2_2);
    }

    @Override
    public ByteBuf directBuffer() {
        return this.directBuffer(256, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf directBuffer(int initialCapacity) {
        void var1_1;
        return this.directBuffer((int)var1_1, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf directBuffer(int initialCapacity, int maxCapacity) {
        void var2_2;
        void var1_1;
        if (initialCapacity == 0 && maxCapacity == 0) {
            return this.emptyBuf;
        }
        AbstractByteBufAllocator.validate(initialCapacity, maxCapacity);
        return this.newDirectBuffer((int)var1_1, (int)var2_2);
    }

    @Override
    public CompositeByteBuf compositeBuffer() {
        if (this.directByDefault) {
            return this.compositeDirectBuffer();
        }
        return this.compositeHeapBuffer();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf compositeBuffer(int maxNumComponents) {
        void var1_1;
        if (this.directByDefault) {
            return this.compositeDirectBuffer(maxNumComponents);
        }
        return this.compositeHeapBuffer((int)var1_1);
    }

    @Override
    public CompositeByteBuf compositeHeapBuffer() {
        return this.compositeHeapBuffer(16);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
        void var1_1;
        return AbstractByteBufAllocator.toLeakAwareBuffer(new CompositeByteBuf(this, false, (int)var1_1));
    }

    @Override
    public CompositeByteBuf compositeDirectBuffer() {
        return this.compositeDirectBuffer(16);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeByteBuf compositeDirectBuffer(int maxNumComponents) {
        void var1_1;
        return AbstractByteBufAllocator.toLeakAwareBuffer(new CompositeByteBuf(this, true, (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static void validate(int initialCapacity, int maxCapacity) {
        ObjectUtil.checkPositiveOrZero((int)initialCapacity, (String)"initialCapacity");
        if (initialCapacity > maxCapacity) {
            void var1_1;
            int n;
            throw new IllegalArgumentException(String.format("initialCapacity: %d (expected: not greater than maxCapacity(%d)", n, (int)var1_1));
        }
    }

    protected abstract ByteBuf newHeapBuffer(int var1, int var2);

    protected abstract ByteBuf newDirectBuffer(int var1, int var2);

    public String toString() {
        return StringUtil.simpleClassName((Object)this) + "(directByDefault: " + this.directByDefault + ')';
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int calculateNewCapacity(int minNewCapacity, int maxCapacity) {
        void var2_2;
        int n;
        ObjectUtil.checkPositiveOrZero((int)minNewCapacity, (String)"minNewCapacity");
        if (minNewCapacity > maxCapacity) {
            throw new IllegalArgumentException(String.format("minNewCapacity: %d (expected: not greater than maxCapacity(%d)", minNewCapacity, maxCapacity));
        }
        if (minNewCapacity == 0x400000) {
            return 0x400000;
        }
        if (minNewCapacity > 0x400000) {
            int newCapacity = minNewCapacity / 0x400000 * 0x400000;
            newCapacity = newCapacity > maxCapacity - 0x400000 ? maxCapacity : (newCapacity += 0x400000);
            return n;
        }
        n = MathUtil.findNextPositivePowerOfTwo((int)Math.max(n, 64));
        return Math.min(n, (int)var2_2);
    }

    static {
        ResourceLeakDetector.addExclusions(AbstractByteBufAllocator.class, (String[])new String[]{"toLeakAwareBuffer"});
    }
}

