/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledDuplicatedByteBuf;
import io.netty.buffer.UnpooledSlicedByteBuf;
import io.netty.util.AsciiString;
import io.netty.util.ByteProcessor;
import io.netty.util.CharsetUtil;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

public abstract class AbstractByteBuf
extends ByteBuf {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractByteBuf.class);
    private static final String LEGACY_PROP_CHECK_ACCESSIBLE = "io.netty.buffer.bytebuf.checkAccessible";
    private static final String PROP_CHECK_ACCESSIBLE = "io.netty.buffer.checkAccessible";
    static final boolean checkAccessible = SystemPropertyUtil.contains((String)"io.netty.buffer.checkAccessible") ? SystemPropertyUtil.getBoolean((String)"io.netty.buffer.checkAccessible", (boolean)true) : SystemPropertyUtil.getBoolean((String)"io.netty.buffer.bytebuf.checkAccessible", (boolean)true);
    private static final String PROP_CHECK_BOUNDS = "io.netty.buffer.checkBounds";
    private static final boolean checkBounds = SystemPropertyUtil.getBoolean((String)"io.netty.buffer.checkBounds", (boolean)true);
    static final ResourceLeakDetector<ByteBuf> leakDetector;
    int readerIndex;
    int writerIndex;
    private int markedReaderIndex;
    private int markedWriterIndex;
    private int maxCapacity;

    /*
     * WARNING - void declaration
     */
    protected AbstractByteBuf(int maxCapacity) {
        void var1_1;
        ObjectUtil.checkPositiveOrZero((int)maxCapacity, (String)"maxCapacity");
        this.maxCapacity = var1_1;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteBuf asReadOnly() {
        if (((ByteBuf)this).isReadOnly()) {
            return this;
        }
        return Unpooled.unmodifiableBuffer((ByteBuf)this);
    }

    @Override
    public int maxCapacity() {
        return this.maxCapacity;
    }

    /*
     * WARNING - void declaration
     */
    protected final void maxCapacity(int maxCapacity) {
        void var1_1;
        this.maxCapacity = var1_1;
    }

    @Override
    public int readerIndex() {
        return this.readerIndex;
    }

    /*
     * WARNING - void declaration
     */
    private static void checkIndexBounds(int readerIndex, int writerIndex, int capacity) {
        if (readerIndex < 0 || readerIndex > writerIndex || writerIndex > capacity) {
            void var2_2;
            void var1_1;
            int n;
            throw new IndexOutOfBoundsException(String.format("readerIndex: %d, writerIndex: %d (expected: 0 <= readerIndex <= writerIndex <= capacity(%d))", n, (int)var1_1, (int)var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readerIndex(int readerIndex) {
        void var1_1;
        if (checkBounds) {
            AbstractByteBuf.checkIndexBounds(readerIndex, this.writerIndex, this.capacity());
        }
        this.readerIndex = var1_1;
        return this;
    }

    @Override
    public int writerIndex() {
        return this.writerIndex;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writerIndex(int writerIndex) {
        void var1_1;
        if (checkBounds) {
            AbstractByteBuf.checkIndexBounds(this.readerIndex, writerIndex, this.capacity());
        }
        this.writerIndex = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setIndex(int readerIndex, int writerIndex) {
        void var2_2;
        void var1_1;
        if (checkBounds) {
            AbstractByteBuf.checkIndexBounds(readerIndex, writerIndex, this.capacity());
        }
        this.setIndex0((int)var1_1, (int)var2_2);
        return this;
    }

    @Override
    public ByteBuf clear() {
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.writerIndex = 0;
        abstractByteBuf.readerIndex = 0;
        return this;
    }

    @Override
    public boolean isReadable() {
        return this.writerIndex > this.readerIndex;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isReadable(int numBytes) {
        void var1_1;
        return this.writerIndex - this.readerIndex >= var1_1;
    }

    @Override
    public boolean isWritable() {
        return this.capacity() > this.writerIndex;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isWritable(int numBytes) {
        void var1_1;
        return this.capacity() - this.writerIndex >= var1_1;
    }

    @Override
    public int readableBytes() {
        return this.writerIndex - this.readerIndex;
    }

    @Override
    public int writableBytes() {
        return this.capacity() - this.writerIndex;
    }

    @Override
    public int maxWritableBytes() {
        return ((ByteBuf)this).maxCapacity() - this.writerIndex;
    }

    @Override
    public ByteBuf markReaderIndex() {
        this.markedReaderIndex = this.readerIndex;
        return this;
    }

    @Override
    public ByteBuf resetReaderIndex() {
        AbstractByteBuf abstractByteBuf = this;
        ((ByteBuf)abstractByteBuf).readerIndex(abstractByteBuf.markedReaderIndex);
        return this;
    }

    @Override
    public ByteBuf markWriterIndex() {
        this.markedWriterIndex = this.writerIndex;
        return this;
    }

    @Override
    public ByteBuf resetWriterIndex() {
        AbstractByteBuf abstractByteBuf = this;
        ((ByteBuf)abstractByteBuf).writerIndex(abstractByteBuf.markedWriterIndex);
        return this;
    }

    @Override
    public ByteBuf discardReadBytes() {
        if (this.readerIndex == 0) {
            this.ensureAccessible();
            return this;
        }
        if (this.readerIndex != this.writerIndex) {
            AbstractByteBuf abstractByteBuf = this;
            this.setBytes(0, abstractByteBuf, abstractByteBuf.readerIndex, this.writerIndex - this.readerIndex);
            this.writerIndex -= this.readerIndex;
            AbstractByteBuf abstractByteBuf2 = this;
            abstractByteBuf2.adjustMarkers(abstractByteBuf2.readerIndex);
            this.readerIndex = 0;
        } else {
            this.ensureAccessible();
            AbstractByteBuf abstractByteBuf = this;
            abstractByteBuf.adjustMarkers(abstractByteBuf.readerIndex);
            AbstractByteBuf abstractByteBuf3 = this;
            abstractByteBuf3.readerIndex = 0;
            abstractByteBuf3.writerIndex = 0;
        }
        return this;
    }

    @Override
    public ByteBuf discardSomeReadBytes() {
        if (this.readerIndex > 0) {
            if (this.readerIndex == this.writerIndex) {
                this.ensureAccessible();
                AbstractByteBuf abstractByteBuf = this;
                abstractByteBuf.adjustMarkers(abstractByteBuf.readerIndex);
                AbstractByteBuf abstractByteBuf2 = this;
                abstractByteBuf2.readerIndex = 0;
                abstractByteBuf2.writerIndex = 0;
                return this;
            }
            if (this.readerIndex >= this.capacity() >>> 1) {
                AbstractByteBuf abstractByteBuf = this;
                this.setBytes(0, abstractByteBuf, abstractByteBuf.readerIndex, this.writerIndex - this.readerIndex);
                this.writerIndex -= this.readerIndex;
                AbstractByteBuf abstractByteBuf3 = this;
                abstractByteBuf3.adjustMarkers(abstractByteBuf3.readerIndex);
                this.readerIndex = 0;
                return this;
            }
        }
        this.ensureAccessible();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    protected final void adjustMarkers(int decrement) {
        void var1_1;
        if (this.markedReaderIndex <= decrement) {
            this.markedReaderIndex = 0;
            if (this.markedWriterIndex <= decrement) {
                this.markedWriterIndex = 0;
                return;
            }
            this.markedWriterIndex -= decrement;
            return;
        }
        this.markedReaderIndex -= decrement;
        this.markedWriterIndex -= var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected final void trimIndicesToCapacity(int newCapacity) {
        if (((ByteBuf)this).writerIndex() > newCapacity) {
            void var1_1;
            AbstractByteBuf abstractByteBuf = this;
            abstractByteBuf.setIndex0(Math.min(((ByteBuf)abstractByteBuf).readerIndex(), newCapacity), (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf ensureWritable(int minWritableBytes) {
        void var1_1;
        this.ensureWritable0(ObjectUtil.checkPositiveOrZero((int)var1_1, (String)"minWritableBytes"));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    final void ensureWritable0(int minWritableBytes) {
        void var1_1;
        void var3_3;
        void var2_2;
        int writerIndex = ((ByteBuf)this).writerIndex();
        int targetCapacity = writerIndex + minWritableBytes;
        if (targetCapacity >= 0 & targetCapacity <= this.capacity()) {
            this.ensureAccessible();
            return;
        }
        if (checkBounds && (targetCapacity < 0 || targetCapacity > this.maxCapacity)) {
            this.ensureAccessible();
            throw new IndexOutOfBoundsException(String.format("writerIndex(%d) + minWritableBytes(%d) exceeds maxCapacity(%d): %s", writerIndex, minWritableBytes, this.maxCapacity, this));
        }
        int fastWritable = this.maxFastWritableBytes();
        void newCapacity = fastWritable >= minWritableBytes ? var2_2 + fastWritable : this.alloc().calculateNewCapacity((int)var3_3, this.maxCapacity);
        this.capacity((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int ensureWritable(int minWritableBytes, boolean force) {
        void var1_1;
        void var3_3;
        void var2_2;
        int writerIndex;
        this.ensureAccessible();
        ObjectUtil.checkPositiveOrZero((int)minWritableBytes, (String)"minWritableBytes");
        if (minWritableBytes <= ((ByteBuf)this).writableBytes()) {
            return 0;
        }
        int maxCapacity = ((ByteBuf)this).maxCapacity();
        if (minWritableBytes > maxCapacity - (writerIndex = ((ByteBuf)this).writerIndex())) {
            if (!force || this.capacity() == maxCapacity) {
                return 1;
            }
            this.capacity(maxCapacity);
            return 3;
        }
        int fastWritable = this.maxFastWritableBytes();
        int newCapacity = fastWritable >= minWritableBytes ? writerIndex + var2_2 : this.alloc().calculateNewCapacity(writerIndex + minWritableBytes, (int)var3_3);
        this.capacity((int)var1_1);
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf order(ByteOrder endianness) {
        void var1_1;
        if (endianness == this.order()) {
            return this;
        }
        ObjectUtil.checkNotNull((Object)var1_1, (String)"endianness");
        return this.newSwappedByteBuf();
    }

    protected SwappedByteBuf newSwappedByteBuf() {
        return new SwappedByteBuf(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte getByte(int index) {
        void var1_1;
        this.checkIndex(index);
        return this._getByte((int)var1_1);
    }

    protected abstract byte _getByte(int var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean getBoolean(int index) {
        void var1_1;
        return ((ByteBuf)this).getByte((int)var1_1) != 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public short getUnsignedByte(int index) {
        void var1_1;
        return (short)(((ByteBuf)this).getByte((int)var1_1) & 0xFF);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public short getShort(int index) {
        void var1_1;
        this.checkIndex(index, 2);
        return this._getShort((int)var1_1);
    }

    protected abstract short _getShort(int var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public short getShortLE(int index) {
        void var1_1;
        this.checkIndex(index, 2);
        return this._getShortLE((int)var1_1);
    }

    protected abstract short _getShortLE(int var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public int getUnsignedShort(int index) {
        void var1_1;
        return ((ByteBuf)this).getShort((int)var1_1) & 0xFFFF;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getUnsignedShortLE(int index) {
        void var1_1;
        return ((ByteBuf)this).getShortLE((int)var1_1) & 0xFFFF;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getUnsignedMedium(int index) {
        void var1_1;
        this.checkIndex(index, 3);
        return this._getUnsignedMedium((int)var1_1);
    }

    protected abstract int _getUnsignedMedium(int var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public int getUnsignedMediumLE(int index) {
        void var1_1;
        this.checkIndex(index, 3);
        return this._getUnsignedMediumLE((int)var1_1);
    }

    protected abstract int _getUnsignedMediumLE(int var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public int getMedium(int index) {
        void var1_1;
        int value = ((ByteBuf)this).getUnsignedMedium(index);
        if ((value & 0x800000) != 0) {
            value |= 0xFF000000;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getMediumLE(int index) {
        void var1_1;
        int value = ((ByteBuf)this).getUnsignedMediumLE(index);
        if ((value & 0x800000) != 0) {
            value |= 0xFF000000;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getInt(int index) {
        void var1_1;
        this.checkIndex(index, 4);
        return this._getInt((int)var1_1);
    }

    protected abstract int _getInt(int var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public int getIntLE(int index) {
        void var1_1;
        this.checkIndex(index, 4);
        return this._getIntLE((int)var1_1);
    }

    protected abstract int _getIntLE(int var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public long getUnsignedInt(int index) {
        void var1_1;
        return (long)((ByteBuf)this).getInt((int)var1_1) & 0xFFFFFFFFL;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getUnsignedIntLE(int index) {
        void var1_1;
        return (long)((ByteBuf)this).getIntLE((int)var1_1) & 0xFFFFFFFFL;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getLong(int index) {
        void var1_1;
        this.checkIndex(index, 8);
        return this._getLong((int)var1_1);
    }

    protected abstract long _getLong(int var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public long getLongLE(int index) {
        void var1_1;
        this.checkIndex(index, 8);
        return this._getLongLE((int)var1_1);
    }

    protected abstract long _getLongLE(int var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public char getChar(int index) {
        void var1_1;
        return (char)((ByteBuf)this).getShort((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getFloat(int index) {
        void var1_1;
        return Float.intBitsToFloat(((ByteBuf)this).getInt((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double getDouble(int index) {
        void var1_1;
        return Double.longBitsToDouble(((ByteBuf)this).getLong((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getBytes(int index, byte[] dst) {
        void var2_2;
        void var1_1;
        this.getBytes((int)var1_1, dst, 0, ((void)var2_2).length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getBytes(int index, ByteBuf dst) {
        void var1_1;
        void var2_2;
        void v0 = var2_2;
        ((ByteBuf)this).getBytes((int)var1_1, (ByteBuf)v0, v0.writableBytes());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getBytes(int index, ByteBuf dst, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        ByteBuf byteBuf = dst;
        this.getBytes((int)var1_1, byteBuf, byteBuf.writerIndex(), length);
        void v1 = var2_2;
        v1.writerIndex(v1.writerIndex() + var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CharSequence getCharSequence(int index, int length, Charset charset) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (CharsetUtil.US_ASCII.equals(charset) || CharsetUtil.ISO_8859_1.equals(charset)) {
            return new AsciiString(ByteBufUtil.getBytes(this, index, length, true), false);
        }
        return ((ByteBuf)this).toString((int)var1_1, (int)var2_2, (Charset)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CharSequence readCharSequence(int length, Charset charset) {
        void var2_2;
        void var1_1;
        AbstractByteBuf abstractByteBuf = this;
        CharSequence sequence = ((ByteBuf)abstractByteBuf).getCharSequence(abstractByteBuf.readerIndex, length, charset);
        this.readerIndex += var1_1;
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setByte(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex(index);
        this._setByte((int)var1_1, (int)var2_2);
        return this;
    }

    protected abstract void _setByte(int var1, int var2);

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setBoolean(int index, boolean value) {
        void var2_2;
        void var1_1;
        ((ByteBuf)this).setByte((int)var1_1, var2_2 != false ? 1 : 0);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setShort(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, 2);
        this._setShort((int)var1_1, (int)var2_2);
        return this;
    }

    protected abstract void _setShort(int var1, int var2);

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setShortLE(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, 2);
        this._setShortLE((int)var1_1, (int)var2_2);
        return this;
    }

    protected abstract void _setShortLE(int var1, int var2);

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setChar(int index, int value) {
        void var2_2;
        void var1_1;
        ((ByteBuf)this).setShort((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setMedium(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, 3);
        this._setMedium((int)var1_1, (int)var2_2);
        return this;
    }

    protected abstract void _setMedium(int var1, int var2);

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setMediumLE(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, 3);
        this._setMediumLE((int)var1_1, (int)var2_2);
        return this;
    }

    protected abstract void _setMediumLE(int var1, int var2);

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setInt(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, 4);
        this._setInt((int)var1_1, (int)var2_2);
        return this;
    }

    protected abstract void _setInt(int var1, int var2);

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setIntLE(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, 4);
        this._setIntLE((int)var1_1, (int)var2_2);
        return this;
    }

    protected abstract void _setIntLE(int var1, int var2);

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setFloat(int index, float value) {
        void var2_2;
        void var1_1;
        ((ByteBuf)this).setInt((int)var1_1, Float.floatToRawIntBits((float)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setLong(int index, long value) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, 8);
        this._setLong((int)var1_1, (long)var2_2);
        return this;
    }

    protected abstract void _setLong(int var1, long var2);

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setLongLE(int index, long value) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, 8);
        this._setLongLE((int)var1_1, (long)var2_2);
        return this;
    }

    protected abstract void _setLongLE(int var1, long var2);

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setDouble(int index, double value) {
        void var2_2;
        void var1_1;
        ((ByteBuf)this).setLong((int)var1_1, Double.doubleToRawLongBits((double)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setBytes(int index, byte[] src) {
        void var2_2;
        void var1_1;
        this.setBytes((int)var1_1, src, 0, ((void)var2_2).length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setBytes(int index, ByteBuf src) {
        void var1_1;
        void var2_2;
        void v0 = var2_2;
        ((ByteBuf)this).setBytes((int)var1_1, (ByteBuf)v0, v0.readableBytes());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private static void checkReadableBounds(ByteBuf src, int length) {
        if (length > src.readableBytes()) {
            ByteBuf byteBuf;
            void var1_1;
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds src.readableBytes(%d) where src is: %s", (int)var1_1, src.readableBytes(), byteBuf));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setBytes(int index, ByteBuf src, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkIndex(index, length);
        ObjectUtil.checkNotNull((Object)src, (String)"src");
        if (checkBounds) {
            AbstractByteBuf.checkReadableBounds(src, length);
        }
        ByteBuf byteBuf = src;
        this.setBytes((int)var1_1, byteBuf, byteBuf.readerIndex(), length);
        void v1 = var2_2;
        v1.readerIndex(v1.readerIndex() + var3_3);
        return this;
    }

    @Override
    public ByteBuf setZero(int index, int length) {
        int i;
        if (length == 0) {
            return this;
        }
        this.checkIndex(index, length);
        int nLong = length >>> 3;
        int nBytes = length & 7;
        while (i > 0) {
            this._setLong(index, 0L);
            index += 8;
            --i;
        }
        if (nBytes == 4) {
            this._setInt(index, 0);
        } else if (nBytes < 4) {
            for (i = nBytes; i > 0; --i) {
                this._setByte(index, 0);
                ++index;
            }
        } else {
            this._setInt(index, 0);
            index += 4;
            for (i = var2_2 - 4; i > 0; --i) {
                this._setByte(index, 0);
                ++index;
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int setCharSequence(int index, CharSequence sequence, Charset charset) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.setCharSequence0((int)var1_1, (CharSequence)var2_2, (Charset)var3_3, false);
    }

    /*
     * WARNING - void declaration
     */
    private int setCharSequence0(int index, CharSequence sequence, Charset charset, boolean expand) {
        void var3_3;
        void var1_1;
        void var2_2;
        void length2;
        if (charset.equals(CharsetUtil.UTF_8)) {
            int length2 = ByteBufUtil.utf8MaxBytes(sequence);
            if (expand) {
                this.ensureWritable0(length2);
                this.checkIndex0(index, length2);
            } else {
                this.checkIndex(index, length2);
            }
            CharSequence charSequence = sequence;
            return ByteBufUtil.writeUtf8(this, index, length2, charSequence, charSequence.length());
        }
        if (length2.equals(CharsetUtil.US_ASCII) || length2.equals(CharsetUtil.ISO_8859_1)) {
            int length3 = sequence.length();
            if (expand) {
                this.ensureWritable0(length3);
                this.checkIndex0(index, length3);
            } else {
                this.checkIndex(index, length3);
            }
            return ByteBufUtil.writeAscii(this, index, sequence, length3);
        }
        byte[] bytes = var2_2.toString().getBytes((Charset)length2);
        if (expand) {
            this.ensureWritable0(bytes.length);
        }
        ((ByteBuf)this).setBytes((int)var1_1, bytes);
        return ((void)var3_3).length;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte readByte() {
        void var2_2;
        void var1_1;
        this.checkReadableBytes0(1);
        int i = this.readerIndex;
        byte b = this._getByte(i);
        this.readerIndex = var1_1 + true;
        return (byte)var2_2;
    }

    @Override
    public boolean readBoolean() {
        return ((ByteBuf)this).readByte() != 0;
    }

    @Override
    public short readUnsignedByte() {
        return (short)(((ByteBuf)this).readByte() & 0xFF);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public short readShort() {
        void var1_1;
        this.checkReadableBytes0(2);
        AbstractByteBuf abstractByteBuf = this;
        short v = abstractByteBuf._getShort(abstractByteBuf.readerIndex);
        this.readerIndex += 2;
        return (short)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public short readShortLE() {
        void var1_1;
        this.checkReadableBytes0(2);
        AbstractByteBuf abstractByteBuf = this;
        short v = abstractByteBuf._getShortLE(abstractByteBuf.readerIndex);
        this.readerIndex += 2;
        return (short)var1_1;
    }

    @Override
    public int readUnsignedShort() {
        return ((ByteBuf)this).readShort() & 0xFFFF;
    }

    @Override
    public int readUnsignedShortLE() {
        return ((ByteBuf)this).readShortLE() & 0xFFFF;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readMedium() {
        void var1_1;
        int value = ((ByteBuf)this).readUnsignedMedium();
        if ((value & 0x800000) != 0) {
            value |= 0xFF000000;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readMediumLE() {
        void var1_1;
        int value = ((ByteBuf)this).readUnsignedMediumLE();
        if ((value & 0x800000) != 0) {
            value |= 0xFF000000;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readUnsignedMedium() {
        void var1_1;
        this.checkReadableBytes0(3);
        AbstractByteBuf abstractByteBuf = this;
        int v = abstractByteBuf._getUnsignedMedium(abstractByteBuf.readerIndex);
        this.readerIndex += 3;
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readUnsignedMediumLE() {
        void var1_1;
        this.checkReadableBytes0(3);
        AbstractByteBuf abstractByteBuf = this;
        int v = abstractByteBuf._getUnsignedMediumLE(abstractByteBuf.readerIndex);
        this.readerIndex += 3;
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readInt() {
        void var1_1;
        this.checkReadableBytes0(4);
        AbstractByteBuf abstractByteBuf = this;
        int v = abstractByteBuf._getInt(abstractByteBuf.readerIndex);
        this.readerIndex += 4;
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readIntLE() {
        void var1_1;
        this.checkReadableBytes0(4);
        AbstractByteBuf abstractByteBuf = this;
        int v = abstractByteBuf._getIntLE(abstractByteBuf.readerIndex);
        this.readerIndex += 4;
        return (int)var1_1;
    }

    @Override
    public long readUnsignedInt() {
        return (long)((ByteBuf)this).readInt() & 0xFFFFFFFFL;
    }

    @Override
    public long readUnsignedIntLE() {
        return (long)((ByteBuf)this).readIntLE() & 0xFFFFFFFFL;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long readLong() {
        void var1_1;
        this.checkReadableBytes0(8);
        AbstractByteBuf abstractByteBuf = this;
        long v = abstractByteBuf._getLong(abstractByteBuf.readerIndex);
        this.readerIndex += 8;
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long readLongLE() {
        void var1_1;
        this.checkReadableBytes0(8);
        AbstractByteBuf abstractByteBuf = this;
        long v = abstractByteBuf._getLongLE(abstractByteBuf.readerIndex);
        this.readerIndex += 8;
        return (long)var1_1;
    }

    @Override
    public char readChar() {
        return (char)((ByteBuf)this).readShort();
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(((ByteBuf)this).readInt());
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(((ByteBuf)this).readLong());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readBytes(int length) {
        void var2_2;
        void var1_1;
        this.checkReadableBytes(length);
        if (length == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf buf = this.alloc().buffer(length, this.maxCapacity);
        AbstractByteBuf abstractByteBuf = this;
        buf.writeBytes(abstractByteBuf, abstractByteBuf.readerIndex, length);
        this.readerIndex += var1_1;
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readSlice(int length) {
        void var2_2;
        void var1_1;
        this.checkReadableBytes(length);
        AbstractByteBuf abstractByteBuf = this;
        ByteBuf slice = ((ByteBuf)abstractByteBuf).slice(abstractByteBuf.readerIndex, length);
        this.readerIndex += var1_1;
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readRetainedSlice(int length) {
        void var2_2;
        void var1_1;
        this.checkReadableBytes(length);
        AbstractByteBuf abstractByteBuf = this;
        ByteBuf slice = ((ByteBuf)abstractByteBuf).retainedSlice(abstractByteBuf.readerIndex, length);
        this.readerIndex += var1_1;
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readBytes(byte[] dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkReadableBytes(length);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.getBytes(abstractByteBuf.readerIndex, (byte[])var1_1, (int)var2_2, length);
        this.readerIndex += var3_3;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readBytes(byte[] dst) {
        void var1_1;
        ((ByteBuf)this).readBytes(dst, 0, ((void)var1_1).length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readBytes(ByteBuf dst) {
        void var1_1;
        void v0 = var1_1;
        ((ByteBuf)this).readBytes((ByteBuf)v0, v0.writableBytes());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readBytes(ByteBuf dst, int length) {
        void var2_2;
        void var1_1;
        if (checkBounds && length > dst.writableBytes()) {
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds dst.writableBytes(%d) where dst is: %s", length, dst.writableBytes(), dst));
        }
        ByteBuf byteBuf = dst;
        ((ByteBuf)this).readBytes(byteBuf, byteBuf.writerIndex(), length);
        void v1 = var1_1;
        v1.writerIndex(v1.writerIndex() + var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readBytes(ByteBuf dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkReadableBytes(length);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.getBytes(abstractByteBuf.readerIndex, (ByteBuf)var1_1, (int)var2_2, length);
        this.readerIndex += var3_3;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readBytes(ByteBuffer dst) {
        void var2_2;
        void var1_1;
        int length = dst.remaining();
        this.checkReadableBytes(length);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.getBytes(abstractByteBuf.readerIndex, (ByteBuffer)var1_1);
        this.readerIndex += var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        void var1_2;
        void var2_3;
        this.checkReadableBytes(length);
        AbstractByteBuf abstractByteBuf = this;
        int readBytes = abstractByteBuf.getBytes(abstractByteBuf.readerIndex, out, (int)var2_3);
        this.readerIndex += readBytes;
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readBytes(FileChannel out, long position, int length) throws IOException {
        void var1_2;
        void var2_3;
        this.checkReadableBytes(length);
        AbstractByteBuf abstractByteBuf = this;
        int readBytes = abstractByteBuf.getBytes(abstractByteBuf.readerIndex, out, (long)var2_3, length);
        this.readerIndex += readBytes;
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readBytes(OutputStream out, int length) throws IOException {
        void var2_2;
        void var1_1;
        this.checkReadableBytes(length);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.getBytes(abstractByteBuf.readerIndex, (OutputStream)var1_1, length);
        this.readerIndex += var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf skipBytes(int length) {
        void var1_1;
        this.checkReadableBytes(length);
        this.readerIndex += var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeBoolean(boolean value) {
        void var1_1;
        ((ByteBuf)this).writeByte(var1_1 != false ? 1 : 0);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeByte(int value) {
        void var1_1;
        this.ensureWritable0(1);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setByte(abstractByteBuf.writerIndex++, (int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeShort(int value) {
        void var1_1;
        this.ensureWritable0(2);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setShort(abstractByteBuf.writerIndex, (int)var1_1);
        this.writerIndex += 2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeShortLE(int value) {
        void var1_1;
        this.ensureWritable0(2);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setShortLE(abstractByteBuf.writerIndex, (int)var1_1);
        this.writerIndex += 2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeMedium(int value) {
        void var1_1;
        this.ensureWritable0(3);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setMedium(abstractByteBuf.writerIndex, (int)var1_1);
        this.writerIndex += 3;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeMediumLE(int value) {
        void var1_1;
        this.ensureWritable0(3);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setMediumLE(abstractByteBuf.writerIndex, (int)var1_1);
        this.writerIndex += 3;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeInt(int value) {
        void var1_1;
        this.ensureWritable0(4);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setInt(abstractByteBuf.writerIndex, (int)var1_1);
        this.writerIndex += 4;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeIntLE(int value) {
        void var1_1;
        this.ensureWritable0(4);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setIntLE(abstractByteBuf.writerIndex, (int)var1_1);
        this.writerIndex += 4;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeLong(long value) {
        void var1_1;
        this.ensureWritable0(8);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setLong(abstractByteBuf.writerIndex, (long)var1_1);
        this.writerIndex += 8;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeLongLE(long value) {
        void var1_1;
        this.ensureWritable0(8);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setLongLE(abstractByteBuf.writerIndex, (long)var1_1);
        this.writerIndex += 8;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeChar(int value) {
        void var1_1;
        ((ByteBuf)this).writeShort((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeFloat(float value) {
        void var1_1;
        ((ByteBuf)this).writeInt(Float.floatToRawIntBits((float)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeDouble(double value) {
        void var1_1;
        ((ByteBuf)this).writeLong(Double.doubleToRawLongBits((double)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeBytes(byte[] src, int srcIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        ((ByteBuf)this).ensureWritable(length);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.setBytes(abstractByteBuf.writerIndex, (byte[])var1_1, (int)var2_2, length);
        this.writerIndex += var3_3;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeBytes(byte[] src) {
        void var1_1;
        ((ByteBuf)this).writeBytes(src, 0, ((void)var1_1).length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeBytes(ByteBuf src) {
        void var1_1;
        void v0 = var1_1;
        ((ByteBuf)this).writeBytes((ByteBuf)v0, v0.readableBytes());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeBytes(ByteBuf src, int length) {
        void var2_2;
        void var1_1;
        if (checkBounds) {
            AbstractByteBuf.checkReadableBounds(src, length);
        }
        ByteBuf byteBuf = src;
        ((ByteBuf)this).writeBytes(byteBuf, byteBuf.readerIndex(), length);
        void v1 = var1_1;
        v1.readerIndex(v1.readerIndex() + var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeBytes(ByteBuf src, int srcIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        ((ByteBuf)this).ensureWritable(length);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.setBytes(abstractByteBuf.writerIndex, (ByteBuf)var1_1, (int)var2_2, length);
        this.writerIndex += var3_3;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeBytes(ByteBuffer src) {
        void var2_2;
        void var1_1;
        int length = src.remaining();
        this.ensureWritable0(length);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.setBytes(abstractByteBuf.writerIndex, (ByteBuffer)var1_1);
        this.writerIndex += var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int writeBytes(InputStream in, int length) throws IOException {
        void var1_2;
        void var2_3;
        ((ByteBuf)this).ensureWritable(length);
        AbstractByteBuf abstractByteBuf = this;
        int writtenBytes = abstractByteBuf.setBytes(abstractByteBuf.writerIndex, in, (int)var2_3);
        if (writtenBytes > 0) {
            this.writerIndex += writtenBytes;
        }
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int writeBytes(ScatteringByteChannel in, int length) throws IOException {
        void var1_2;
        void var2_3;
        ((ByteBuf)this).ensureWritable(length);
        AbstractByteBuf abstractByteBuf = this;
        int writtenBytes = abstractByteBuf.setBytes(abstractByteBuf.writerIndex, in, (int)var2_3);
        if (writtenBytes > 0) {
            this.writerIndex += writtenBytes;
        }
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int writeBytes(FileChannel in, long position, int length) throws IOException {
        void var1_2;
        void var2_3;
        ((ByteBuf)this).ensureWritable(length);
        AbstractByteBuf abstractByteBuf = this;
        int writtenBytes = abstractByteBuf.setBytes(abstractByteBuf.writerIndex, in, (long)var2_3, length);
        if (writtenBytes > 0) {
            this.writerIndex += writtenBytes;
        }
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeZero(int length) {
        void var2_2;
        int i;
        if (length == 0) {
            return this;
        }
        ((ByteBuf)this).ensureWritable(length);
        int wIndex = this.writerIndex;
        this.checkIndex0(wIndex, length);
        int nLong = length >>> 3;
        int nBytes = length & 7;
        while (i > 0) {
            this._setLong(wIndex, 0L);
            wIndex += 8;
            --i;
        }
        if (nBytes == 4) {
            this._setInt(wIndex, 0);
            wIndex += 4;
        } else if (nBytes < 4) {
            for (i = nBytes; i > 0; --i) {
                this._setByte(wIndex, 0);
                ++wIndex;
            }
        } else {
            this._setInt(wIndex, 0);
            wIndex += 4;
            for (i = var1_1 - 4; i > 0; --i) {
                this._setByte(wIndex, 0);
                ++wIndex;
            }
        }
        this.writerIndex = var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int writeCharSequence(CharSequence sequence, Charset charset) {
        void var1_2;
        void var2_3;
        AbstractByteBuf abstractByteBuf = this;
        int written = abstractByteBuf.setCharSequence0(abstractByteBuf.writerIndex, sequence, (Charset)var2_3, true);
        this.writerIndex += written;
        return (int)var1_2;
    }

    @Override
    public ByteBuf copy() {
        AbstractByteBuf abstractByteBuf = this;
        return abstractByteBuf.copy(abstractByteBuf.readerIndex, ((ByteBuf)this).readableBytes());
    }

    @Override
    public ByteBuf duplicate() {
        this.ensureAccessible();
        return new UnpooledDuplicatedByteBuf(this);
    }

    @Override
    public ByteBuf retainedDuplicate() {
        return ((ByteBuf)this).duplicate().retain();
    }

    @Override
    public ByteBuf slice() {
        AbstractByteBuf abstractByteBuf = this;
        return ((ByteBuf)abstractByteBuf).slice(abstractByteBuf.readerIndex, ((ByteBuf)this).readableBytes());
    }

    @Override
    public ByteBuf retainedSlice() {
        return ((ByteBuf)this).slice().retain();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf slice(int index, int length) {
        void var2_2;
        void var1_1;
        this.ensureAccessible();
        return new UnpooledSlicedByteBuf(this, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf retainedSlice(int index, int length) {
        void var2_2;
        void var1_1;
        return ((ByteBuf)this).slice((int)var1_1, (int)var2_2).retain();
    }

    @Override
    public ByteBuffer nioBuffer() {
        AbstractByteBuf abstractByteBuf = this;
        return abstractByteBuf.nioBuffer(abstractByteBuf.readerIndex, ((ByteBuf)this).readableBytes());
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        AbstractByteBuf abstractByteBuf = this;
        return abstractByteBuf.nioBuffers(abstractByteBuf.readerIndex, ((ByteBuf)this).readableBytes());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString(Charset charset) {
        void var1_1;
        AbstractByteBuf abstractByteBuf = this;
        return ((ByteBuf)abstractByteBuf).toString(abstractByteBuf.readerIndex, ((ByteBuf)this).readableBytes(), (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString(int index, int length, Charset charset) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ByteBufUtil.decodeString(this, (int)var1_1, (int)var2_2, (Charset)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int indexOf(int fromIndex, int toIndex, byte value) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (fromIndex <= toIndex) {
            return ByteBufUtil.firstIndexOf(this, fromIndex, toIndex, value);
        }
        return ByteBufUtil.lastIndexOf(this, (int)var1_1, (int)var2_2, (byte)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int bytesBefore(byte value) {
        void var1_1;
        AbstractByteBuf abstractByteBuf = this;
        return ((ByteBuf)abstractByteBuf).bytesBefore(((ByteBuf)abstractByteBuf).readerIndex(), ((ByteBuf)this).readableBytes(), (byte)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int bytesBefore(int length, byte value) {
        void var2_2;
        void var1_1;
        this.checkReadableBytes(length);
        AbstractByteBuf abstractByteBuf = this;
        return ((ByteBuf)abstractByteBuf).bytesBefore(((ByteBuf)abstractByteBuf).readerIndex(), (int)var1_1, (byte)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int bytesBefore(int index, int length, byte value) {
        void var1_1;
        void var2_2;
        void var3_3;
        int n = index;
        int endIndex = ((ByteBuf)this).indexOf(n, n + length, (byte)var3_3);
        if (endIndex < 0) {
            return -1;
        }
        return (int)(var2_2 - var1_1);
    }

    @Override
    public int forEachByte(ByteProcessor processor) {
        Exception exception;
        this.ensureAccessible();
        try {
            AbstractByteBuf abstractByteBuf = this;
            return abstractByteBuf.forEachByteAsc0(abstractByteBuf.readerIndex, this.writerIndex, (ByteProcessor)exception);
        }
        catch (Exception exception2) {
            exception = exception2;
            PlatformDependent.throwException((Throwable)exception2);
            return -1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int forEachByte(int index, int length, ByteProcessor processor) {
        this.checkIndex(index, length);
        try {
            void var3_4;
            void var2_3;
            void var1_1;
            void v0 = var1_1;
            return this.forEachByteAsc0((int)v0, (int)(v0 + var2_3), (ByteProcessor)var3_4);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            PlatformDependent.throwException((Throwable)exception);
            return -1;
        }
    }

    int forEachByteAsc0(int start, int end, ByteProcessor processor) throws Exception {
        while (start < end) {
            if (!processor.process(this._getByte(start))) {
                return start;
            }
            ++start;
        }
        return -1;
    }

    @Override
    public int forEachByteDesc(ByteProcessor processor) {
        Exception exception;
        this.ensureAccessible();
        try {
            AbstractByteBuf abstractByteBuf = this;
            return abstractByteBuf.forEachByteDesc0(abstractByteBuf.writerIndex - 1, this.readerIndex, (ByteProcessor)exception);
        }
        catch (Exception exception2) {
            exception = exception2;
            PlatformDependent.throwException((Throwable)exception2);
            return -1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int forEachByteDesc(int index, int length, ByteProcessor processor) {
        this.checkIndex(index, length);
        try {
            void var3_4;
            void var1_1;
            void var2_3;
            return this.forEachByteDesc0(index + var2_3 - 1, (int)var1_1, (ByteProcessor)var3_4);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            PlatformDependent.throwException((Throwable)exception);
            return -1;
        }
    }

    int forEachByteDesc0(int rStart, int rEnd, ByteProcessor processor) throws Exception {
        while (rStart >= rEnd) {
            if (!processor.process(this._getByte(rStart))) {
                return rStart;
            }
            --rStart;
        }
        return -1;
    }

    @Override
    public int hashCode() {
        return ByteBufUtil.hashCode(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object o) {
        void var1_1;
        return o instanceof ByteBuf && ByteBufUtil.equals(this, (ByteBuf)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(ByteBuf that) {
        void var1_1;
        return ByteBufUtil.compare(this, (ByteBuf)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString() {
        void var1_1;
        ByteBuf unwrapped;
        if (this.refCnt() == 0) {
            return StringUtil.simpleClassName((Object)this) + "(freed)";
        }
        StringBuilder buf = new StringBuilder().append(StringUtil.simpleClassName((Object)this)).append("(ridx: ").append(this.readerIndex).append(", widx: ").append(this.writerIndex).append(", cap: ").append(this.capacity());
        if (this.maxCapacity != Integer.MAX_VALUE) {
            buf.append('/').append(this.maxCapacity);
        }
        if ((unwrapped = this.unwrap()) != null) {
            void var2_2;
            buf.append(", unwrapped: ").append(var2_2);
        }
        buf.append(')');
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected final void checkIndex(int index) {
        void var1_1;
        this.checkIndex((int)var1_1, 1);
    }

    /*
     * WARNING - void declaration
     */
    protected final void checkIndex(int index, int fieldLength) {
        void var2_2;
        void var1_1;
        this.ensureAccessible();
        this.checkIndex0((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static void checkRangeBounds(String indexName, int index, int fieldLength, int capacity) {
        if (MathUtil.isOutOfBounds((int)index, (int)fieldLength, (int)capacity)) {
            void var3_3;
            void var2_2;
            void var1_1;
            String string;
            throw new IndexOutOfBoundsException(String.format("%s: %d, length: %d (expected: range(0, %d))", string, (int)var1_1, (int)var2_2, (int)var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    final void checkIndex0(int index, int fieldLength) {
        if (checkBounds) {
            void var2_2;
            void var1_1;
            AbstractByteBuf.checkRangeBounds("index", (int)var1_1, (int)var2_2, this.capacity());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void checkSrcIndex(int index, int length, int srcIndex, int srcCapacity) {
        void var1_1;
        this.checkIndex((int)var1_1, length);
        if (checkBounds) {
            void var2_2;
            void var3_3;
            AbstractByteBuf.checkRangeBounds("srcIndex", (int)var3_3, (int)var2_2, srcCapacity);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void checkDstIndex(int index, int length, int dstIndex, int dstCapacity) {
        void var1_1;
        this.checkIndex((int)var1_1, length);
        if (checkBounds) {
            void var2_2;
            void var3_3;
            AbstractByteBuf.checkRangeBounds("dstIndex", (int)var3_3, (int)var2_2, dstCapacity);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void checkDstIndex(int length, int dstIndex, int dstCapacity) {
        this.checkReadableBytes(length);
        if (checkBounds) {
            void var3_3;
            void var1_1;
            void var2_2;
            AbstractByteBuf.checkRangeBounds("dstIndex", (int)var2_2, (int)var1_1, (int)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void checkReadableBytes(int minimumReadableBytes) {
        void var1_1;
        this.checkReadableBytes0(ObjectUtil.checkPositiveOrZero((int)var1_1, (String)"minimumReadableBytes"));
    }

    /*
     * WARNING - void declaration
     */
    protected final void checkNewCapacity(int newCapacity) {
        this.ensureAccessible();
        if (checkBounds && (newCapacity < 0 || newCapacity > ((ByteBuf)this).maxCapacity())) {
            void var1_1;
            throw new IllegalArgumentException("newCapacity: " + (int)var1_1 + " (expected: 0-" + ((ByteBuf)this).maxCapacity() + ')');
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkReadableBytes0(int minimumReadableBytes) {
        this.ensureAccessible();
        if (checkBounds && this.readerIndex > this.writerIndex - minimumReadableBytes) {
            void var1_1;
            throw new IndexOutOfBoundsException(String.format("readerIndex(%d) + length(%d) exceeds writerIndex(%d): %s", this.readerIndex, (int)var1_1, this.writerIndex, this));
        }
    }

    protected final void ensureAccessible() {
        if (checkAccessible && !this.isAccessible()) {
            throw new IllegalReferenceCountException(0);
        }
    }

    /*
     * WARNING - void declaration
     */
    final void setIndex0(int readerIndex, int writerIndex) {
        void var2_2;
        void var1_1;
        this.readerIndex = var1_1;
        this.writerIndex = var2_2;
    }

    final void discardMarks() {
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.markedWriterIndex = 0;
        abstractByteBuf.markedReaderIndex = 0;
    }

    static {
        if (logger.isDebugEnabled()) {
            logger.debug("-D{}: {}", (Object)PROP_CHECK_ACCESSIBLE, (Object)checkAccessible);
            logger.debug("-D{}: {}", (Object)PROP_CHECK_BOUNDS, (Object)checkBounds);
        }
        leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(ByteBuf.class);
    }
}

