/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation;

import androidx.compose.animation.AndroidFlingSpline;
import androidx.compose.animation.FlingCalculatorKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.unit.Density;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u000e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0003J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0003H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Landroidx/compose/animation/FlingCalculator;", "", "friction", "", "density", "Landroidx/compose/ui/unit/Density;", "(FLandroidx/compose/ui/unit/Density;)V", "getDensity", "()Landroidx/compose/ui/unit/Density;", "magicPhysicalCoefficient", "computeDeceleration", "flingDistance", "velocity", "flingDuration", "", "flingInfo", "Landroidx/compose/animation/FlingCalculator$FlingInfo;", "getSplineDeceleration", "", "FlingInfo", "animation"})
@StabilityInferred(parameters=1)
public final class FlingCalculator {
    private final float friction;
    private final Density density;
    private final float magicPhysicalCoefficient;

    /*
     * WARNING - void declaration
     */
    public FlingCalculator(float friction, Density density) {
        void var2_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        this.friction = var1_1;
        Density density2 = this.density = var2_3;
        this.magicPhysicalCoefficient = FlingCalculatorKt.access$computeDeceleration(0.84f, density2.getDensity());
    }

    /*
     * WARNING - void declaration
     */
    private final double getSplineDeceleration(float velocity) {
        void var1_1;
        return AndroidFlingSpline.deceleration((float)var1_1, this.friction * this.magicPhysicalCoefficient);
    }

    /*
     * WARNING - void declaration
     */
    public final long flingDuration(float velocity) {
        void var2_2;
        void var1_1;
        double l = this.getSplineDeceleration((float)var1_1);
        double decelMinusOne = (double)FlingCalculatorKt.access$getDecelerationRate$p() - 1.0;
        return (long)(1000.0 * Math.exp((double)(var2_2 / decelMinusOne)));
    }

    /*
     * WARNING - void declaration
     */
    public final float flingDistance(float velocity) {
        void var2_2;
        void var1_1;
        double l = this.getSplineDeceleration((float)var1_1);
        double decelMinusOne = (double)FlingCalculatorKt.access$getDecelerationRate$p() - 1.0;
        return (float)((double)(this.friction * this.magicPhysicalCoefficient) * Math.exp((double)FlingCalculatorKt.access$getDecelerationRate$p() / decelMinusOne * var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final FlingInfo flingInfo(float velocity) {
        void var2_2;
        void var1_1;
        double l = this.getSplineDeceleration(velocity);
        double decelMinusOne = (double)FlingCalculatorKt.access$getDecelerationRate$p() - 1.0;
        return new FlingInfo((float)var1_1, (float)((double)(this.friction * this.magicPhysicalCoefficient) * Math.exp((double)FlingCalculatorKt.access$getDecelerationRate$p() / decelMinusOne * l)), (long)(1000.0 * Math.exp((double)(var2_2 / decelMinusOne))));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u000e\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0006J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\u000e\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0006R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u001b"}, d2={"Landroidx/compose/animation/FlingCalculator$FlingInfo;", "", "initialVelocity", "", "distance", "duration", "", "(FFJ)V", "getDistance", "()F", "getDuration", "()J", "getInitialVelocity", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "position", "time", "toString", "", "velocity", "animation"})
    @StabilityInferred(parameters=1)
    public static final class FlingInfo {
        private final float initialVelocity;
        private final float distance;
        private final long duration;

        /*
         * WARNING - void declaration
         */
        public FlingInfo(float initialVelocity, float distance, long duration) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.initialVelocity = var1_1;
            this.distance = var2_2;
            this.duration = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public final float position(long time) {
            void var1_2;
            float splinePos = this.duration > 0L ? (float)time / (float)this.duration : 1.0f;
            return this.distance * Math.signum(this.initialVelocity) * AndroidFlingSpline.flingPosition((float)var1_2).getDistanceCoefficient();
        }

        /*
         * WARNING - void declaration
         */
        public final float velocity(long time) {
            void var1_2;
            float splinePos = this.duration > 0L ? (float)time / (float)this.duration : 1.0f;
            return AndroidFlingSpline.flingPosition((float)var1_2).getVelocityCoefficient() * Math.signum(this.initialVelocity) * this.distance / (float)this.duration * 1000.0f;
        }

        public final String toString() {
            return "FlingInfo(initialVelocity=" + this.initialVelocity + ", distance=" + this.distance + ", duration=" + this.duration + ')';
        }

        public final int hashCode() {
            int n = Float.hashCode(this.initialVelocity);
            n = n * 31 + Float.hashCode(this.distance);
            n = n * 31 + Long.hashCode(this.duration);
            return n;
        }

        public final boolean equals(Object other) {
            FlingInfo flingInfo;
            if (this == other) {
                return true;
            }
            if (!(other instanceof FlingInfo)) {
                return false;
            }
            flingInfo = flingInfo;
            if (Float.compare(this.initialVelocity, flingInfo.initialVelocity) != 0) {
                return false;
            }
            if (Float.compare(this.distance, flingInfo.distance) != 0) {
                return false;
            }
            return this.duration == flingInfo.duration;
        }
    }
}

