/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util.pipeline;

import io.ktor.util.Attributes;
import io.ktor.util.AttributesJvmKt;
import io.ktor.util.pipeline.InvalidPhaseException;
import io.ktor.util.pipeline.PhaseContent;
import io.ktor.util.pipeline.PipelineContext;
import io.ktor.util.pipeline.PipelineContextKt;
import io.ktor.util.pipeline.PipelinePhase;
import io.ktor.util.pipeline.PipelinePhaseRelation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u000e\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u0001*\b\b\u0001\u0010\u0003*\u00020\u00012\u00020\u0001B\u001b\u0012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bBb\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012O\u0010\u0011\u001aK\u0012G\u0012E\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u000f\u00a2\u0006\u0002\b\u00100\n\u00a2\u0006\u0004\b\u0007\u0010\u0012J \u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u00012\u0006\u0010\u0014\u001a\u00028\u0000H\u0086@\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001d\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\u001c\u0010\u001bJ`\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00052I\u0010\u001d\u001aE\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u000f\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b \u0010!J^\u0010\"\u001aK\u0012G\u0012E\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u000f\u00a2\u0006\u0002\b\u00100\n2\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\"\u0010#J!\u0010%\u001a\u00020\u000e2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\u00a2\u0006\u0004\b%\u0010&J#\u0010'\u001a\u00020\u000e2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H\u0002\u00a2\u0006\u0004\b'\u0010&J!\u0010(\u001a\u00020\u000e2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\u00a2\u0006\u0004\b(\u0010&J!\u0010)\u001a\u00020\u000e2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\u00a2\u0006\u0004\b)\u0010&J\u000f\u0010+\u001a\u00020*H\u0016\u00a2\u0006\u0004\b+\u0010,J`\u0010.\u001aK\u0012G\u0012E\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u000f\u00a2\u0006\u0002\b\u00100\n2\u0006\u0010\t\u001a\u00020\u0005H\u0000\u00a2\u0006\u0004\b-\u0010#JX\u00101\u001aK\u0012G\u0012E\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u000f\u00a2\u0006\u0002\b\u00100\nH\u0000\u00a2\u0006\u0004\b/\u00100J3\u00104\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f2\u0006\u0010\u0013\u001a\u00028\u00012\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u00103\u001a\u000202H\u0002\u00a2\u0006\u0004\b4\u00105J%\u00107\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u0001062\u0006\u0010\t\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b7\u00108J\u0017\u0010:\u001a\u0002092\u0006\u0010\t\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b:\u0010;J\u0017\u0010=\u001a\u00020<2\u0006\u0010\t\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b=\u0010>JX\u0010?\u001aK\u0012G\u0012E\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u000f\u00a2\u0006\u0002\b\u00100\nH\u0002\u00a2\u0006\u0004\b?\u00100J#\u0010@\u001a\u00020<2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H\u0002\u00a2\u0006\u0004\b@\u0010AJX\u0010B\u001aK\u0012G\u0012E\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u000f\u00a2\u0006\u0002\b\u00100\nH\u0002\u00a2\u0006\u0004\bB\u00100J\u000f\u0010C\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\bC\u0010!J`\u0010E\u001a\u00020\u000e2O\u0010D\u001aK\u0012G\u0012E\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u000f\u00a2\u0006\u0002\b\u00100\nH\u0002\u00a2\u0006\u0004\bE\u0010FJ#\u0010H\u001a\u00020\u000e2\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u000106H\u0002\u00a2\u0006\u0004\bH\u0010IJ#\u0010K\u001a\u00020\u000e2\u0012\u0010J\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H\u0002\u00a2\u0006\u0004\bK\u0010&Jb\u0010L\u001a\u00020<2\u0006\u0010\t\u001a\u00020\u00052I\u0010\u001d\u001aE\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u000f\u00a2\u0006\u0002\b\u0010H\u0002\u00a2\u0006\u0004\bL\u0010MJ\u001f\u0010P\u001a\u00020<2\u0006\u0010N\u001a\u00020\u00012\u0006\u0010O\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\bP\u0010QR\u0017\u0010S\u001a\u00020R8\u0006\u00a2\u0006\f\n\u0004\bS\u0010T\u001a\u0004\bU\u0010VR\u001a\u0010W\u001a\u00020<8\u0016X\u0096D\u00a2\u0006\f\n\u0004\bW\u0010X\u001a\u0004\bY\u0010ZR\u001a\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00010[8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\\\u0010]R\u0016\u0010^\u001a\u0002098\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b^\u0010_R\u0017\u0010a\u001a\b\u0012\u0004\u0012\u00020\u00050\n8F\u00a2\u0006\u0006\u001a\u0004\b`\u00100R\u0011\u0010b\u001a\u00020<8F\u00a2\u0006\u0006\u001a\u0004\bb\u0010ZR\u00ba\u0001\u0010\u0011\u001aM\u0012G\u0012E\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u000f\u00a2\u0006\u0002\b\u0010\u0018\u00010\n2Q\u0010c\u001aM\u0012G\u0012E\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u000f\u00a2\u0006\u0002\b\u0010\u0018\u00010\n8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\bd\u00100\"\u0004\be\u0010FR\u0016\u0010f\u001a\u00020<8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bf\u0010XR\u0018\u0010g\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bg\u0010h\u00a8\u0006i"}, d2={"Lio/ktor/util/pipeline/Pipeline;", "", "TSubject", "TContext", "", "Lio/ktor/util/pipeline/PipelinePhase;", "phases", "<init>", "([Lio/ktor/util/pipeline/PipelinePhase;)V", "phase", "", "Lkotlin/Function3;", "Lio/ktor/util/pipeline/PipelineContext;", "Lkotlin/coroutines/Continuation;", "", "Lio/ktor/util/pipeline/PipelineInterceptor;", "Lkotlin/ExtensionFunctionType;", "interceptors", "(Lio/ktor/util/pipeline/PipelinePhase;Ljava/util/List;)V", "context", "subject", "execute", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addPhase", "(Lio/ktor/util/pipeline/PipelinePhase;)V", "reference", "insertPhaseAfter", "(Lio/ktor/util/pipeline/PipelinePhase;Lio/ktor/util/pipeline/PipelinePhase;)V", "insertPhaseBefore", "block", "intercept", "(Lio/ktor/util/pipeline/PipelinePhase;Lkotlin/jvm/functions/Function3;)V", "afterIntercepted", "()V", "interceptorsForPhase", "(Lio/ktor/util/pipeline/PipelinePhase;)Ljava/util/List;", "from", "mergePhases", "(Lio/ktor/util/pipeline/Pipeline;)V", "mergeInterceptors", "merge", "resetFrom", "", "toString", "()Ljava/lang/String;", "phaseInterceptors$ktor_utils", "phaseInterceptors", "interceptorsForTests$ktor_utils", "()Ljava/util/List;", "interceptorsForTests", "Lkotlin/coroutines/CoroutineContext;", "coroutineContext", "createContext", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/coroutines/CoroutineContext;)Lio/ktor/util/pipeline/PipelineContext;", "Lio/ktor/util/pipeline/PhaseContent;", "findPhase", "(Lio/ktor/util/pipeline/PipelinePhase;)Lio/ktor/util/pipeline/PhaseContent;", "", "findPhaseIndex", "(Lio/ktor/util/pipeline/PipelinePhase;)I", "", "hasPhase", "(Lio/ktor/util/pipeline/PipelinePhase;)Z", "cacheInterceptors", "fastPathMerge", "(Lio/ktor/util/pipeline/Pipeline;)Z", "sharedInterceptorsList", "resetInterceptorsList", "list", "notSharedInterceptorsList", "(Ljava/util/List;)V", "phaseContent", "setInterceptorsListFromPhase", "(Lio/ktor/util/pipeline/PhaseContent;)V", "pipeline", "setInterceptorsListFromAnotherPipeline", "tryAddToPhaseFastPath", "(Lio/ktor/util/pipeline/PipelinePhase;Lkotlin/jvm/functions/Function3;)Z", "fromPhaseOrContent", "fromPhase", "insertRelativePhase", "(Ljava/lang/Object;Lio/ktor/util/pipeline/PipelinePhase;)Z", "Lio/ktor/util/Attributes;", "attributes", "Lio/ktor/util/Attributes;", "getAttributes", "()Lio/ktor/util/Attributes;", "developmentMode", "Z", "getDevelopmentMode", "()Z", "", "phasesRaw", "Ljava/util/List;", "interceptorsQuantity", "I", "getItems", "items", "isEmpty", "value", "getInterceptors", "setInterceptors", "interceptorsListShared", "interceptorsListSharedPhase", "Lio/ktor/util/pipeline/PipelinePhase;", "ktor-utils"})
@SourceDebugExtension(value={"SMAP\nPipeline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pipeline.kt\nio/ktor/util/pipeline/Pipeline\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,513:1\n1557#2:514\n1628#2,3:515\n1863#2,2:518\n808#2,11:520\n295#2,2:531\n1863#2,2:533\n*S KotlinDebug\n*F\n+ 1 Pipeline.kt\nio/ktor/util/pipeline/Pipeline\n*L\n52#1:514\n52#1:515,3\n79#1:518,2\n179#1:520,11\n180#1:531,2\n220#1:533,2\n*E\n"})
public class Pipeline<TSubject, TContext> {
    private final Attributes attributes;
    private final boolean developmentMode;
    private final List<Object> phasesRaw;
    private int interceptorsQuantity;
    private volatile /* synthetic */ Object _interceptors;
    private boolean interceptorsListShared;
    private PipelinePhase interceptorsListSharedPhase;

    /*
     * WARNING - void declaration
     */
    public Pipeline(PipelinePhase ... phases) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)phases, (String)"phases");
        this.attributes = AttributesJvmKt.Attributes(true);
        void v0 = var1_1;
        this.phasesRaw = CollectionsKt.mutableListOf((Object[])Arrays.copyOf(v0, ((void)v0).length));
        this._interceptors = null;
    }

    public final Attributes getAttributes() {
        return this.attributes;
    }

    public boolean getDevelopmentMode() {
        return this.developmentMode;
    }

    /*
     * WARNING - void declaration
     */
    public final List<PipelinePhase> getItems() {
        void var1_1;
        Iterable $this$map$iv = this.phasesRaw;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            void it;
            Object item$iv$iv = object.next();
            Collection collection = destination$iv$iv;
            PipelinePhase pipelinePhase = it instanceof PipelinePhase ? (PipelinePhase)it : null;
            if (pipelinePhase == null) {
                void var3_3;
                PhaseContent phaseContent = it instanceof PhaseContent ? (PhaseContent)var3_3 : null;
                PipelinePhase pipelinePhase2 = phaseContent != null ? phaseContent.getPhase() : null;
                pipelinePhase = pipelinePhase2;
                Intrinsics.checkNotNull((Object)pipelinePhase2);
            }
            collection.add(pipelinePhase);
        }
        return (List)var1_1;
    }

    public final boolean isEmpty() {
        return this.interceptorsQuantity == 0;
    }

    private final List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> getInterceptors() {
        return (List)this._interceptors;
    }

    /*
     * WARNING - void declaration
     */
    private final void setInterceptors(List<? extends Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object>> value) {
        void var1_1;
        this._interceptors = var1_1;
    }

    public Pipeline(PipelinePhase phase, List<? extends Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object>> interceptors) {
        Iterator iterator2;
        Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
        Intrinsics.checkNotNullParameter(interceptors, (String)"interceptors");
        PipelinePhase[] pipelinePhaseArray = new PipelinePhase[1];
        PipelinePhase[] object2 = pipelinePhaseArray;
        pipelinePhaseArray[0] = phase;
        this(object2);
        Iterable iterable = (Iterable)((Object)iterator2);
        for (Object t : iterable) {
            Function3 function3 = (Function3)t;
            this.intercept(phase, function3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Object execute(TContext context, TSubject subject, Continuation<? super TSubject> $completion) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.createContext(var1_1, subject, $completion.getContext()).execute$ktor_utils(var2_2, (Continuation<void>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final void addPhase(PipelinePhase phase) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
        if (this.hasPhase(phase)) {
            return;
        }
        this.phasesRaw.add(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void insertPhaseAfter(PipelinePhase reference, PipelinePhase phase) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
        if (this.hasPhase(phase)) {
            return;
        }
        int index = this.findPhaseIndex(reference);
        if (index == -1) {
            throw new InvalidPhaseException("Phase " + reference + " was not registered for this pipeline");
        }
        int lastRelatedPhaseIndex = index;
        int i = index + 1;
        int n = CollectionsKt.getLastIndex(this.phasesRaw);
        if (i <= n) {
            Object object;
            Object object2;
            while ((object2 = (object = this.phasesRaw.get(i)) instanceof PhaseContent ? (PhaseContent)object : null) != null && (object2 = ((PhaseContent)object2).getRelation()) != null) {
                Object relation = object2;
                Object object3 = object2 instanceof PipelinePhaseRelation.After ? (PipelinePhaseRelation.After)relation : null;
                if (object3 != null && (object3 = ((PipelinePhaseRelation.After)object3).getRelativeTo()) != null) {
                    object = object3;
                    int n2 = lastRelatedPhaseIndex = Intrinsics.areEqual((Object)object3, (Object)reference) ? i : lastRelatedPhaseIndex;
                }
                if (i == n) break;
                ++i;
            }
        }
        this.phasesRaw.add(lastRelatedPhaseIndex + 1, new PhaseContent((PipelinePhase)var2_2, new PipelinePhaseRelation.After((PipelinePhase)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public final void insertPhaseBefore(PipelinePhase reference, PipelinePhase phase) {
        void var1_1;
        void var2_2;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
        if (this.hasPhase(phase)) {
            return;
        }
        int index = this.findPhaseIndex(reference);
        if (index == -1) {
            throw new InvalidPhaseException("Phase " + reference + " was not registered for this pipeline");
        }
        this.phasesRaw.add((int)var3_3, new PhaseContent((PipelinePhase)var2_2, new PipelinePhaseRelation.Before((PipelinePhase)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public final void intercept(PipelinePhase phase, Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object> block) {
        void var2_4;
        void var3_5;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        PhaseContent<TSubject, TContext> phaseContent = this.findPhase(phase);
        if (phaseContent == null) {
            throw new InvalidPhaseException("Phase " + phase + " was not registered for this pipeline");
        }
        PhaseContent<TSubject, TContext> phaseContent2 = phaseContent;
        if (this.tryAddToPhaseFastPath((PipelinePhase)var1_1, block)) {
            int n = this.interceptorsQuantity;
            this.interceptorsQuantity = n + 1;
            return;
        }
        var3_5.addInterceptor(var2_4);
        int n = this.interceptorsQuantity;
        this.interceptorsQuantity = n + 1;
        this.resetInterceptorsList();
        this.afterIntercepted();
    }

    public void afterIntercepted() {
    }

    /*
     * WARNING - void declaration
     */
    public final List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> interceptorsForPhase(PipelinePhase phase) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
            Iterator iterator2 = this.phasesRaw;
            Collection destination$iv$iv = new ArrayList();
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                if (!(element$iv$iv instanceof PhaseContent)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            iterator2 = (List)destination$iv$iv;
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                void var3_3;
                Object element$iv = iterator2.next();
                PhaseContent phaseContent = (PhaseContent)element$iv;
                if (!Intrinsics.areEqual((Object)phaseContent.getPhase(), (Object)phase)) continue;
                v0 = var3_3;
                break block3;
            }
            v0 = null;
        }
        PhaseContent phaseContent = v0;
        List list = phaseContent != null ? phaseContent.sharedInterceptors() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public final void mergePhases(Pipeline<TSubject, TContext> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        from = ((Pipeline)from).phasesRaw;
        List toInsert = CollectionsKt.toMutableList((Collection)((Collection)from));
        while (!((Collection)toInsert).isEmpty()) {
            Iterator iterator2 = toInsert.iterator();
            while (iterator2.hasNext()) {
                void var3_3;
                PipelinePhase fromPhase;
                Object fromPhaseOrContent = iterator2.next();
                PipelinePhase pipelinePhase = fromPhaseOrContent instanceof PipelinePhase ? (PipelinePhase)fromPhaseOrContent : null;
                if (pipelinePhase == null) {
                    Intrinsics.checkNotNull(fromPhaseOrContent, (String)"null cannot be cast to non-null type io.ktor.util.pipeline.PhaseContent<*, *>");
                    pipelinePhase = ((PhaseContent)fromPhaseOrContent).getPhase();
                }
                if (this.hasPhase(fromPhase = pipelinePhase)) {
                    iterator2.remove();
                    continue;
                }
                boolean bl = this.insertRelativePhase(var3_3, fromPhase);
                if (!bl) continue;
                iterator2.remove();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void mergeInterceptors(Pipeline<TSubject, TContext> from) {
        Object object;
        if (this.interceptorsQuantity == 0) {
            this.setInterceptorsListFromAnotherPipeline(from);
        } else {
            this.resetInterceptorsList();
        }
        object = ((Pipeline)object).phasesRaw;
        object = (Iterable)object;
        object = object.iterator();
        while (object.hasNext()) {
            void var3_3;
            Object e;
            Object fromPhaseOrContent = e = object.next();
            PipelinePhase pipelinePhase = e instanceof PipelinePhase ? (PipelinePhase)fromPhaseOrContent : null;
            if (pipelinePhase == null) {
                PipelinePhase fromPhase;
                Intrinsics.checkNotNull(fromPhaseOrContent, (String)"null cannot be cast to non-null type io.ktor.util.pipeline.PhaseContent<*, *>");
                pipelinePhase = fromPhase = ((PhaseContent)fromPhaseOrContent).getPhase();
            }
            if (!(fromPhaseOrContent instanceof PhaseContent) || ((PhaseContent)fromPhaseOrContent).isEmpty()) continue;
            PhaseContent cfr_ignored_0 = (PhaseContent)fromPhaseOrContent;
            PhaseContent phaseContent = (PhaseContent)fromPhaseOrContent;
            PhaseContent<TSubject, TContext> phaseContent2 = this.findPhase((PipelinePhase)var3_3);
            Intrinsics.checkNotNull(phaseContent2);
            phaseContent.addTo(phaseContent2);
            this.interceptorsQuantity += ((PhaseContent)e).getSize();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void merge(Pipeline<TSubject, TContext> from) {
        void var1_1;
        Intrinsics.checkNotNullParameter(from, (String)"from");
        if (this.fastPathMerge(from)) {
            return;
        }
        this.mergePhases(from);
        this.mergeInterceptors((Pipeline<TSubject, TContext>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void resetFrom(Pipeline<TSubject, TContext> from) {
        void var1_1;
        Intrinsics.checkNotNullParameter(from, (String)"from");
        this.phasesRaw.clear();
        if (!(this.interceptorsQuantity == 0)) {
            from = "Check failed.";
            throw new IllegalStateException(from.toString());
        }
        this.fastPathMerge((Pipeline<TSubject, TContext>)var1_1);
    }

    public String toString() {
        return super.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> phaseInterceptors$ktor_utils(PipelinePhase phase) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
        PhaseContent<TSubject, TContext> phaseContent = this.findPhase((PipelinePhase)var1_1);
        if (phaseContent == null || (phaseContent = phaseContent.sharedInterceptors()) == null) {
            phaseContent = CollectionsKt.emptyList();
        }
        return phaseContent;
    }

    public final List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> interceptorsForTests$ktor_utils() {
        List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<Unit>, Object>> list = this.getInterceptors();
        if (list == null) {
            list = this.cacheInterceptors();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final PipelineContext<TSubject, TContext> createContext(TContext context, TSubject subject, CoroutineContext coroutineContext) {
        void var3_3;
        void var2_2;
        return PipelineContextKt.pipelineContextFor(context, this.sharedInterceptorsList(), var2_2, (CoroutineContext)var3_3, this.getDevelopmentMode());
    }

    /*
     * WARNING - void declaration
     */
    private final PhaseContent<TSubject, TContext> findPhase(PipelinePhase phase) {
        List<Object> phasesList = this.phasesRaw;
        int n = phasesList.size();
        for (int index = 0; index < n; ++index) {
            void var1_1;
            Object current = phasesList.get(index);
            if (current == phase) {
                PhaseContent content = new PhaseContent(phase, PipelinePhaseRelation.Last.INSTANCE);
                phasesList.set(index, content);
                return var1_1;
            }
            if (!(current instanceof PhaseContent) || ((PhaseContent)current).getPhase() != var1_1) continue;
            return (PhaseContent)current;
        }
        return null;
    }

    private final int findPhaseIndex(PipelinePhase phase) {
        List<Object> phasesList = this.phasesRaw;
        int n = phasesList.size();
        for (int index = 0; index < n; ++index) {
            Object current = phasesList.get(index);
            if (current != phase && (!(current instanceof PhaseContent) || ((PhaseContent)current).getPhase() != phase)) continue;
            return index;
        }
        return -1;
    }

    private final boolean hasPhase(PipelinePhase phase) {
        List<Object> phasesList = this.phasesRaw;
        int n = phasesList.size();
        for (int index = 0; index < n; ++index) {
            Object current = phasesList.get(index);
            if (current != phase && (!(current instanceof PhaseContent) || ((PhaseContent)current).getPhase() != phase)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> cacheInterceptors() {
        void var1_2;
        int interceptorsQuantity = this.interceptorsQuantity;
        if (interceptorsQuantity == 0) {
            this.notSharedInterceptorsList(CollectionsKt.emptyList());
            return CollectionsKt.emptyList();
        }
        List<Object> phases = this.phasesRaw;
        if (interceptorsQuantity == 1) {
            int phaseIndex = 0;
            int n = CollectionsKt.getLastIndex(phases);
            if (n >= 0) {
                while (true) {
                    Object object;
                    if (((object = phases.get(phaseIndex)) instanceof PhaseContent ? (PhaseContent)object : null) != null) {
                        PhaseContent phaseContent;
                        if (!(phaseContent = phaseContent).isEmpty()) {
                            List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> interceptors = phaseContent.sharedInterceptors();
                            this.setInterceptorsListFromPhase(phaseContent);
                            return interceptors;
                        }
                    }
                    if (phaseIndex == n) break;
                    ++phaseIndex;
                }
            }
        }
        List destination = new ArrayList();
        int phaseIndex = 0;
        int n = CollectionsKt.getLastIndex(phases);
        if (n >= 0) {
            while (true) {
                Object object;
                PhaseContent phaseContent = (object = phases.get(phaseIndex)) instanceof PhaseContent ? (PhaseContent)object : null;
                if (phaseContent != null) {
                    object = phaseContent;
                    phaseContent.addTo(destination);
                }
                if (phaseIndex == n) break;
                ++phaseIndex;
            }
        }
        this.notSharedInterceptorsList(destination);
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean fastPathMerge(Pipeline<TSubject, TContext> from) {
        void var1_1;
        if (from.phasesRaw.isEmpty()) {
            return true;
        }
        if (!((Collection)this.phasesRaw).isEmpty()) {
            return false;
        }
        List<Object> fromPhases = from.phasesRaw;
        int index = 0;
        int n = CollectionsKt.getLastIndex(fromPhases);
        if (n >= 0) {
            while (true) {
                Object fromPhaseOrContent;
                if ((fromPhaseOrContent = fromPhases.get(index)) instanceof PipelinePhase) {
                    this.phasesRaw.add(fromPhaseOrContent);
                } else if (fromPhaseOrContent instanceof PhaseContent) {
                    PhaseContent cfr_ignored_0 = (PhaseContent)fromPhaseOrContent;
                    this.phasesRaw.add(new PhaseContent(((PhaseContent)fromPhaseOrContent).getPhase(), ((PhaseContent)fromPhaseOrContent).getRelation(), ((PhaseContent)fromPhaseOrContent).sharedInterceptors()));
                }
                if (index == n) break;
                ++index;
            }
        }
        this.interceptorsQuantity += from.interceptorsQuantity;
        this.setInterceptorsListFromAnotherPipeline((Pipeline<TSubject, TContext>)var1_1);
        return true;
    }

    private final List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> sharedInterceptorsList() {
        if (this.getInterceptors() == null) {
            this.cacheInterceptors();
        }
        this.interceptorsListShared = true;
        List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> list = this.getInterceptors();
        Intrinsics.checkNotNull(list);
        return list;
    }

    private final void resetInterceptorsList() {
        this.setInterceptors(null);
        this.interceptorsListShared = false;
        this.interceptorsListSharedPhase = null;
    }

    /*
     * WARNING - void declaration
     */
    private final void notSharedInterceptorsList(List<? extends Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object>> list) {
        void var1_1;
        this.setInterceptors((List<? extends Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object>>)var1_1);
        this.interceptorsListShared = false;
        this.interceptorsListSharedPhase = null;
    }

    /*
     * WARNING - void declaration
     */
    private final void setInterceptorsListFromPhase(PhaseContent<TSubject, TContext> phaseContent) {
        void var1_1;
        this.setInterceptors(phaseContent.sharedInterceptors());
        this.interceptorsListShared = false;
        this.interceptorsListSharedPhase = var1_1.getPhase();
    }

    /*
     * WARNING - void declaration
     */
    private final void setInterceptorsListFromAnotherPipeline(Pipeline<TSubject, TContext> pipeline) {
        void var1_1;
        this.setInterceptors(super.sharedInterceptorsList());
        this.interceptorsListShared = true;
        this.interceptorsListSharedPhase = null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryAddToPhaseFastPath(PipelinePhase phase, Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object> block) {
        List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<Unit>, Object>> currentInterceptors = this.getInterceptors();
        if (this.phasesRaw.isEmpty() || currentInterceptors == null) {
            return false;
        }
        if (this.interceptorsListShared || !TypeIntrinsics.isMutableList(currentInterceptors)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.interceptorsListSharedPhase, (Object)phase)) {
            currentInterceptors.add(block);
            return true;
        }
        if (Intrinsics.areEqual((Object)phase, (Object)CollectionsKt.last(this.phasesRaw)) || this.findPhaseIndex(phase) == CollectionsKt.getLastIndex(this.phasesRaw)) {
            void var2_2;
            void var3_3;
            void var1_1;
            PhaseContent<? super TSubject, TContext> phaseContent = this.findPhase((PipelinePhase)var1_1);
            Intrinsics.checkNotNull(phaseContent);
            phaseContent.addInterceptor(block);
            var3_3.add(var2_2);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean insertRelativePhase(Object fromPhaseOrContent, PipelinePhase fromPhase) {
        PipelinePhaseRelation fromPhaseRelation;
        PipelinePhaseRelation pipelinePhaseRelation;
        if (fromPhaseOrContent == fromPhase) {
            pipelinePhaseRelation = PipelinePhaseRelation.Last.INSTANCE;
        } else {
            Intrinsics.checkNotNull((Object)fromPhaseOrContent, (String)"null cannot be cast to non-null type io.ktor.util.pipeline.PhaseContent<*, *>");
            pipelinePhaseRelation = fromPhaseRelation = ((PhaseContent)fromPhaseOrContent).getRelation();
        }
        if (pipelinePhaseRelation instanceof PipelinePhaseRelation.Last) {
            this.addPhase(fromPhase);
        } else if (fromPhaseRelation instanceof PipelinePhaseRelation.Before && this.hasPhase(((PipelinePhaseRelation.Before)fromPhaseRelation).getRelativeTo())) {
            this.insertPhaseBefore(((PipelinePhaseRelation.Before)fromPhaseRelation).getRelativeTo(), fromPhase);
        } else if (fromPhaseRelation instanceof PipelinePhaseRelation.After) {
            void var2_2;
            void var1_1;
            this.insertPhaseAfter(((PipelinePhaseRelation.After)var1_1).getRelativeTo(), (PipelinePhase)var2_2);
        } else {
            return false;
        }
        return true;
    }
}

