/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import io.ktor.util.HashFunction;
import io.ktor.util.HashFunctionKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\r\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0003R\u0016\u0010\u0013\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u0018R\u0016\u0010\u001d\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u0018R\u0016\u0010\u001e\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u0018R\u0016\u0010\u001f\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u0018R\u0016\u0010 \u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010\u0018\u00a8\u0006!"}, d2={"Lio/ktor/util/Sha1;", "Lio/ktor/util/HashFunction;", "<init>", "()V", "", "input", "", "offset", "length", "", "update", "([BII)V", "pos", "processChunk", "([BI)V", "digest", "()[B", "reset", "", "messageLength", "J", "unprocessed", "[B", "unprocessedLimit", "I", "", "words", "[I", "h0", "h1", "h2", "h3", "h4", "ktor-utils"})
public final class Sha1
implements HashFunction {
    private long messageLength;
    private final byte[] unprocessed = new byte[64];
    private int unprocessedLimit;
    private final int[] words = new int[80];
    private int h0 = 1732584193;
    private int h1 = -271733879;
    private int h2 = -1732584194;
    private int h3 = 271733878;
    private int h4 = -1009589776;

    /*
     * WARNING - void declaration
     */
    @Override
    public final void update(byte[] input, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.messageLength += (long)length;
        int pos = offset;
        int limit = pos + length;
        byte[] unprocessed = this.unprocessed;
        int unprocessedLimit = this.unprocessedLimit;
        if (unprocessedLimit > 0) {
            if (unprocessedLimit + length < 64) {
                ArraysKt.copyInto((byte[])input, (byte[])unprocessed, (int)unprocessedLimit, (int)pos, (int)limit);
                this.unprocessedLimit = unprocessedLimit + length;
                return;
            }
            int consumeByteCount = 64 - unprocessedLimit;
            int n = pos;
            ArraysKt.copyInto((byte[])input, (byte[])unprocessed, (int)unprocessedLimit, (int)n, (int)(n + consumeByteCount));
            this.processChunk(unprocessed, 0);
            this.unprocessedLimit = 0;
            pos += consumeByteCount;
        }
        while (pos < limit) {
            void var3_3;
            int nextPos = pos + 64;
            if (nextPos > limit) {
                ArraysKt.copyInto((byte[])input, (byte[])unprocessed, (int)0, (int)pos, (int)limit);
                this.unprocessedLimit = limit - pos;
                return;
            }
            this.processChunk(input, pos);
            pos = var3_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processChunk(byte[] input, int pos) {
        void var2_3;
        void var1_2;
        int w;
        int[] words = this.words;
        for (w = 0; w < 16; ++w) {
            void currentPosition;
            words[w] = (input[currentPosition++] & 0xFF) << 24 | (input[currentPosition++] & 0xFF) << 16 | (input[currentPosition++] & 0xFF) << 8 | input[currentPosition++] & 0xFF;
        }
        for (w = 16; w < 80; ++w) {
            words[w] = HashFunctionKt.access$leftRotate(words[w - 3] ^ words[w - 8] ^ words[w - 14] ^ words[w - 16], 1);
        }
        int a = this.h0;
        int b = this.h1;
        int c = this.h2;
        int d = this.h3;
        int e = this.h4;
        for (int i = 0; i < 80; ++i) {
            int n;
            int f;
            if (i < 20) {
                f = d ^ b & (c ^ d);
                n = HashFunctionKt.access$leftRotate(a, 5) + f + e + 1518500249 + words[i];
            } else if (i < 40) {
                f = b ^ c ^ d;
                n = HashFunctionKt.access$leftRotate(a, 5) + f + e + 1859775393 + words[i];
            } else if (i < 60) {
                f = b & c | b & d | c & d;
                n = HashFunctionKt.access$leftRotate(a, 5) + f + e + -1894007588 + words[i];
            } else {
                f = b ^ c ^ d;
                n = HashFunctionKt.access$leftRotate(a, 5) + f + e + -899497514 + words[i];
            }
            int a2 = n;
            e = d;
            d = c;
            c = HashFunctionKt.access$leftRotate(b, 30);
            b = a;
            a = a2;
        }
        this.h0 += a;
        this.h1 += var1_2;
        this.h2 += var2_3;
        this.h3 += d;
        this.h4 += e;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final byte[] digest() {
        void var3_5;
        void var2_3;
        void var1_2;
        byte[] unprocessed = this.unprocessed;
        int unprocessedLimit = this.unprocessedLimit;
        long messageLengthBits = this.messageLength << 3;
        unprocessed[unprocessedLimit++] = -128;
        if (unprocessedLimit > 56) {
            ArraysKt.fill((byte[])unprocessed, (byte)0, (int)unprocessedLimit, (int)64);
            this.processChunk(unprocessed, 0);
            ArraysKt.fill((byte[])unprocessed, (byte)0, (int)0, (int)unprocessedLimit);
        } else {
            ArraysKt.fill((byte[])unprocessed, (byte)0, (int)unprocessedLimit, (int)56);
        }
        unprocessed[56] = (byte)(messageLengthBits >>> 56);
        unprocessed[57] = (byte)(messageLengthBits >>> 48);
        unprocessed[58] = (byte)(messageLengthBits >>> 40);
        unprocessed[59] = (byte)(messageLengthBits >>> 32);
        unprocessed[60] = (byte)(messageLengthBits >>> 24);
        unprocessed[61] = (byte)(messageLengthBits >>> 16);
        unprocessed[62] = (byte)(messageLengthBits >>> 8);
        unprocessed[63] = (byte)messageLengthBits;
        this.processChunk(unprocessed, 0);
        int a = this.h0;
        int b = this.h1;
        int c = this.h2;
        int d = this.h3;
        int e = this.h4;
        this.reset();
        byte[] byArray = new byte[20];
        byte[] byArray2 = byArray;
        byArray[0] = (byte)(a >> 24);
        byArray2[1] = (byte)(a >> 16);
        byArray2[2] = (byte)(a >> 8);
        byArray2[3] = (byte)var1_2;
        byArray2[4] = (byte)(b >> 24);
        byArray2[5] = (byte)(b >> 16);
        byArray2[6] = (byte)(b >> 8);
        byArray2[7] = (byte)var2_3;
        byArray2[8] = (byte)(c >> 24);
        byArray2[9] = (byte)(c >> 16);
        byArray2[10] = (byte)(c >> 8);
        byArray2[11] = (byte)var3_5;
        byArray2[12] = (byte)(d >> 24);
        byArray2[13] = (byte)(d >> 16);
        byArray2[14] = (byte)(d >> 8);
        byArray2[15] = (byte)d;
        byArray2[16] = (byte)(e >> 24);
        byArray2[17] = (byte)(e >> 16);
        byArray2[18] = (byte)(e >> 8);
        byArray2[19] = (byte)e;
        return byArray2;
    }

    private final void reset() {
        this.messageLength = 0L;
        ArraysKt.fill$default((byte[])this.unprocessed, (byte)0, (int)0, (int)0, (int)6, null);
        this.unprocessedLimit = 0;
        ArraysKt.fill$default((int[])this.words, (int)0, (int)0, (int)0, (int)6, null);
        this.h0 = 1732584193;
        this.h1 = -271733879;
        this.h2 = -1732584194;
        this.h3 = 271733878;
        this.h4 = -1009589776;
    }
}

