/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0019\u0010\u0002\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0011\u0010\u0004\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u0013\u0010\u0006\u001a\u00020\u0000*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0005\u001a\u0019\u0010\u0002\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\b\u00a8\u0006\t"}, d2={"Ljava/nio/file/Path;", "relativePath", "combineSafe", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)Ljava/nio/file/Path;", "normalizeAndRelativize", "(Ljava/nio/file/Path;)Ljava/nio/file/Path;", "dropLeadingTopDirs", "Ljava/io/File;", "(Ljava/io/File;Ljava/nio/file/Path;)Ljava/io/File;", "ktor-utils"})
@SourceDebugExtension(value={"SMAP\nNioPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NioPath.kt\nio/ktor/util/NioPathKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n1#2:50\n346#3,8:51\n*S KotlinDebug\n*F\n+ 1 NioPath.kt\nio/ktor/util/NioPathKt\n*L\n31#1:51,8\n*E\n"})
public final class NioPathKt {
    /*
     * WARNING - void declaration
     */
    public static final Path combineSafe(Path $this$combineSafe, Path relativePath) {
        void var2_2;
        Path path;
        Intrinsics.checkNotNullParameter((Object)$this$combineSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Path normalized = NioPathKt.normalizeAndRelativize(relativePath);
        if (normalized.startsWith("..")) {
            throw new InvalidPathException(((Object)relativePath).toString(), "Relative path " + relativePath + " beginning with .. is invalid");
        }
        if (!(!normalized.isAbsolute())) {
            void var1_1;
            $this$combineSafe = "Bad relative path " + var1_1;
            throw new IllegalStateException($this$combineSafe.toString());
        }
        Path path2 = path.resolve((Path)var2_2);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    public static final Path normalizeAndRelativize(Path $this$normalizeAndRelativize) {
        Intrinsics.checkNotNullParameter((Object)$this$normalizeAndRelativize, (String)"<this>");
        Path path = $this$normalizeAndRelativize.getRoot();
        if (path == null || (path = path.relativize($this$normalizeAndRelativize)) == null || (path = path.normalize()) == null || (path = NioPathKt.dropLeadingTopDirs(path)) == null) {
            Path path2;
            Path path3 = path2.normalize();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"normalize(...)");
            path = NioPathKt.dropLeadingTopDirs(path3);
        }
        return path;
    }

    /*
     * WARNING - void declaration
     */
    private static final Path dropLeadingTopDirs(Path $this$dropLeadingTopDirs) {
        Path path;
        void var1_2;
        int n;
        block4: {
            int startIndex;
            Object $this$indexOfFirst$iv = $this$dropLeadingTopDirs;
            int index$iv = 0;
            $this$indexOfFirst$iv = $this$indexOfFirst$iv.iterator();
            while ($this$indexOfFirst$iv.hasNext()) {
                Path path2;
                Object item$iv = $this$indexOfFirst$iv.next();
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                if (!Intrinsics.areEqual((Object)((Object)(path2 = (Path)path2)).toString(), (Object)"..")) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = startIndex = -1;
        }
        if (n <= 0) {
            return $this$dropLeadingTopDirs;
        }
        Path path3 = $this$dropLeadingTopDirs.subpath((int)var1_2, path.getNameCount());
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"subpath(...)");
        return path3;
    }

    /*
     * WARNING - void declaration
     */
    public static final File combineSafe(File $this$combineSafe, Path relativePath) {
        void var2_2;
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$combineSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Path normalized = NioPathKt.normalizeAndRelativize(relativePath);
        if (normalized.startsWith("..")) {
            throw new InvalidPathException(((Object)relativePath).toString(), "Relative path " + relativePath + " beginning with .. is invalid");
        }
        if (!(!normalized.isAbsolute())) {
            void var1_1;
            $this$combineSafe = "Bad relative path " + var1_1;
            throw new IllegalStateException($this$combineSafe.toString());
        }
        return new File(file, var2_2.toString());
    }
}

