/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.Syntax;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ScopedHandler;
import org.eclipse.jetty.server.session.DefaultSessionCache;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.server.session.NullSessionDataStore;
import org.eclipse.jetty.server.session.Session;
import org.eclipse.jetty.server.session.SessionCache;
import org.eclipse.jetty.server.session.SessionCacheFactory;
import org.eclipse.jetty.server.session.SessionContext;
import org.eclipse.jetty.server.session.SessionDataStore;
import org.eclipse.jetty.server.session.SessionDataStoreFactory;
import org.eclipse.jetty.server.session.UnreadableSessionDataException;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.eclipse.jetty.util.statistic.SampleStatistic;
import org.eclipse.jetty.util.thread.Locker;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;

@ManagedObject
public class SessionHandler
extends ScopedHandler {
    static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.server.session");
    public static final EnumSet<SessionTrackingMode> DEFAULT_TRACKING = EnumSet.of(SessionTrackingMode.COOKIE, SessionTrackingMode.URL);
    public static final String __SessionCookieProperty = "org.eclipse.jetty.servlet.SessionCookie";
    public static final String __DefaultSessionCookie = "JSESSIONID";
    public static final String __SessionIdPathParameterNameProperty = "org.eclipse.jetty.servlet.SessionIdPathParameterName";
    public static final String __DefaultSessionIdPathParameterName = "jsessionid";
    public static final String __CheckRemoteSessionEncoding = "org.eclipse.jetty.servlet.CheckingRemoteSessionIdEncoding";
    public static final String __SessionDomainProperty = "org.eclipse.jetty.servlet.SessionDomain";
    public static final String __DefaultSessionDomain = null;
    public static final String __SessionPathProperty = "org.eclipse.jetty.servlet.SessionPath";
    public static final String __MaxAgeProperty = "org.eclipse.jetty.servlet.MaxAge";
    public static final Set<SessionTrackingMode> DEFAULT_SESSION_TRACKING_MODES = Collections.unmodifiableSet(new HashSet<SessionTrackingMode>(Arrays.asList(SessionTrackingMode.COOKIE, SessionTrackingMode.URL)));
    public static final Class<? extends EventListener>[] SESSION_LISTENER_TYPES = new Class[]{HttpSessionAttributeListener.class, HttpSessionIdListener.class, HttpSessionListener.class};
    public static final BigDecimal MAX_INACTIVE_MINUTES = new BigDecimal(0x2222222);
    static final HttpSessionContext __nullSessionContext = new HttpSessionContext(){

        public HttpSession getSession(String sessionId) {
            return null;
        }

        public Enumeration getIds() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
    };
    protected int _dftMaxIdleSecs = -1;
    protected boolean _httpOnly = false;
    protected SessionIdManager _sessionIdManager;
    protected boolean _secureCookies = false;
    protected boolean _secureRequestOnly = true;
    protected final List<HttpSessionAttributeListener> _sessionAttributeListeners = new CopyOnWriteArrayList<HttpSessionAttributeListener>();
    protected final List<HttpSessionListener> _sessionListeners = new CopyOnWriteArrayList<HttpSessionListener>();
    protected final List<HttpSessionIdListener> _sessionIdListeners = new CopyOnWriteArrayList<HttpSessionIdListener>();
    protected ClassLoader _loader;
    protected ContextHandler.Context _context;
    protected SessionContext _sessionContext;
    protected String _sessionCookie = "JSESSIONID";
    protected String _sessionIdPathParameterName = "jsessionid";
    protected String _sessionIdPathParameterNamePrefix = ";" + this._sessionIdPathParameterName + "=";
    protected String _sessionDomain;
    protected String _sessionPath;
    protected int _maxCookieAge = -1;
    protected int _refreshCookieAge;
    protected boolean _nodeIdInSessionId;
    protected boolean _checkingRemoteSessionIdEncoding;
    protected String _sessionComment;
    protected SessionCache _sessionCache;
    protected final SampleStatistic _sessionTimeStats = new SampleStatistic();
    protected final CounterStatistic _sessionsCreatedStats = new CounterStatistic();
    public Set<SessionTrackingMode> _sessionTrackingModes;
    protected boolean _usingURLs;
    protected boolean _usingCookies = true;
    protected Set<String> _candidateSessionIdsForExpiry = ConcurrentHashMap.newKeySet();
    protected Scheduler _scheduler;
    protected boolean _ownScheduler = false;
    private SessionCookieConfig _cookieConfig = new CookieConfig(this);

    public SessionHandler() {
        this.setSessionTrackingModes(DEFAULT_SESSION_TRACKING_MODES);
    }

    @ManagedAttribute(value="path of the session cookie, or null for default")
    public String getSessionPath() {
        return this._sessionPath;
    }

    @ManagedAttribute(value="if greater the zero, the time in seconds a session cookie will last for")
    public int getMaxCookieAge() {
        return this._maxCookieAge;
    }

    /*
     * WARNING - void declaration
     */
    public HttpCookie access(HttpSession session, boolean secure) {
        void var3_3;
        long now = System.currentTimeMillis();
        Session s = ((SessionIf)session).getSession();
        if (s.access(now) && this.isUsingCookies() && (s.isIdChanged() || this.getSessionCookieConfig().getMaxAge() > 0 && this.getRefreshCookieAge() > 0 && (var3_3 - s.getCookieSetTime()) / 1000L > (long)this.getRefreshCookieAge())) {
            void var1_1;
            void var2_2;
            HttpCookie cookie = this.getSessionCookie(session, this._context == null ? "/" : ((ContextHandler.StaticContext)this._context).getContextPath(), (boolean)var2_2);
            s.cookieSet();
            s.setIdChanged(false);
            return var1_1;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void addEventListener(EventListener listener) {
        void var1_1;
        if (listener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners.add((HttpSessionAttributeListener)listener);
        }
        if (listener instanceof HttpSessionListener) {
            this._sessionListeners.add((HttpSessionListener)listener);
        }
        if (listener instanceof HttpSessionIdListener) {
            this._sessionIdListeners.add((HttpSessionIdListener)listener);
        }
        this.addBean(var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public void clearEventListeners() {
        for (EventListener e : this.getBeans(EventListener.class)) {
            void var2_2;
            this.removeBean(var2_2);
        }
        this._sessionAttributeListeners.clear();
        this._sessionListeners.clear();
        this._sessionIdListeners.clear();
    }

    /*
     * WARNING - void declaration
     */
    protected void callSessionDestroyedListeners(Session session) {
        if (session == null) {
            return;
        }
        if (this._sessionListeners != null) {
            void var1_1;
            Runnable r = new Runnable(this, session){
                final /* synthetic */ Session val$session;
                final /* synthetic */ SessionHandler this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$session = session;
                }

                @Override
                public void run() {
                    HttpSessionEvent event = new HttpSessionEvent((HttpSession)this.val$session);
                    for (int i = this.this$0._sessionListeners.size() - 1; i >= 0; --i) {
                        this.this$0._sessionListeners.get(i).sessionDestroyed(event);
                    }
                }
            };
            this._sessionContext.run((Runnable)var1_1);
        }
    }

    protected void callSessionCreatedListeners(Session session) {
        if (session == null) {
            return;
        }
        if (this._sessionListeners != null) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
            for (int i = this._sessionListeners.size() - 1; i >= 0; --i) {
                this._sessionListeners.get(i).sessionCreated(event);
            }
        }
    }

    protected void callSessionIdListeners(Session session, String oldId) {
        if (!this._sessionIdListeners.isEmpty()) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
            for (HttpSessionIdListener httpSessionIdListener : this._sessionIdListeners) {
                httpSessionIdListener.sessionIdChanged(event, oldId);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void complete(HttpSession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Complete called with session {}", new Object[]{session});
        }
        if (session == null) {
            return;
        }
        Session s = ((SessionIf)session).getSession();
        try {
            this._sessionCache.release(s.getId(), s);
            return;
        }
        catch (Exception e) {
            void var1_2;
            LOG.warn((Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void commit(HttpSession session) {
        if (session == null) {
            return;
        }
        Session s = ((SessionIf)session).getSession();
        try {
            this._sessionCache.commit(s);
            return;
        }
        catch (Exception e) {
            void var1_2;
            LOG.warn((Throwable)var1_2);
            return;
        }
    }

    @Deprecated
    public void complete(Session session, Request baseRequest) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doStart() throws Exception {
        Server server = this.getServer();
        this._context = ContextHandler.getCurrentContext();
        this._loader = Thread.currentThread().getContextClassLoader();
        Server server2 = server;
        synchronized (server2) {
            void var1_1;
            if (this._sessionCache == null) {
                SessionCacheFactory ssFactory = (SessionCacheFactory)server.getBean(SessionCacheFactory.class);
                this.setSessionCache(ssFactory != null ? ssFactory.getSessionCache(this) : new DefaultSessionCache(this));
                SessionDataStoreFactory sdsFactory = (SessionDataStoreFactory)server.getBean(SessionDataStoreFactory.class);
                SessionDataStore sds = sdsFactory != null ? sdsFactory.getSessionDataStore(this) : new NullSessionDataStore();
                this._sessionCache.setSessionDataStore(sds);
            }
            if (this._sessionIdManager == null) {
                this._sessionIdManager = server.getSessionIdManager();
                if (this._sessionIdManager == null) {
                    ClassLoader serverLoader = server.getClass().getClassLoader();
                    try {
                        void var3_5;
                        Thread.currentThread().setContextClassLoader((ClassLoader)var3_5);
                        this._sessionIdManager = new DefaultSessionIdManager(server);
                        server.setSessionIdManager(this._sessionIdManager);
                        server.manage(this._sessionIdManager);
                        this._sessionIdManager.start();
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(this._loader);
                    }
                }
                SessionHandler sessionHandler = this;
                sessionHandler.addBean(sessionHandler._sessionIdManager, false);
            }
            this._scheduler = (Scheduler)var1_1.getBean(Scheduler.class);
            if (this._scheduler == null) {
                this._scheduler = new ScheduledExecutorScheduler(String.format("Session-Scheduler-%x", this.hashCode()), false);
                this._ownScheduler = true;
                this._scheduler.start();
            }
        }
        if (this._context != null) {
            String tmp = ((ContextHandler.StaticContext)this._context).getInitParameter(__SessionCookieProperty);
            if (tmp != null) {
                this._sessionCookie = tmp;
            }
            if ((tmp = ((ContextHandler.StaticContext)this._context).getInitParameter(__SessionIdPathParameterNameProperty)) != null) {
                this.setSessionIdPathParameterName(tmp);
            }
            if (this._maxCookieAge == -1 && (tmp = ((ContextHandler.StaticContext)this._context).getInitParameter(__MaxAgeProperty)) != null) {
                this._maxCookieAge = Integer.parseInt(tmp.trim());
            }
            if (this._sessionDomain == null) {
                this._sessionDomain = ((ContextHandler.StaticContext)this._context).getInitParameter(__SessionDomainProperty);
            }
            if (this._sessionPath == null) {
                this._sessionPath = ((ContextHandler.StaticContext)this._context).getInitParameter(__SessionPathProperty);
            }
            if ((tmp = ((ContextHandler.StaticContext)this._context).getInitParameter(__CheckRemoteSessionEncoding)) != null) {
                this._checkingRemoteSessionIdEncoding = Boolean.parseBoolean((String)((Object)server2));
            }
        }
        this._sessionContext = new SessionContext(this._sessionIdManager.getWorkerName(), this._context);
        this._sessionCache.initialize(this._sessionContext);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        this.shutdownSessions();
        this._sessionCache.stop();
        if (this._ownScheduler && this._scheduler != null) {
            this._scheduler.stop();
        }
        this._scheduler = null;
        super.doStop();
        this._loader = null;
    }

    @ManagedAttribute(value="true if cookies use the http only flag")
    public boolean getHttpOnly() {
        return this._httpOnly;
    }

    @ManagedAttribute(value="SameSite setting for session cookies")
    public HttpCookie.SameSite getSameSite() {
        return HttpCookie.getSameSiteFromComment((String)this._sessionComment);
    }

    /*
     * WARNING - void declaration
     */
    protected HttpSession getHttpSession(String extendedId) {
        void var2_2;
        void var1_1;
        String id = this.getSessionIdManager().getId(extendedId);
        Session session = this.getSession(id);
        if (session != null && !session.getExtendedId().equals(var1_1)) {
            session.setIdChanged(true);
        }
        return var2_2;
    }

    @ManagedAttribute(value="Session ID Manager")
    public SessionIdManager getSessionIdManager() {
        return this._sessionIdManager;
    }

    @ManagedAttribute(value="default maximum time a session may be idle for (in s)")
    public int getMaxInactiveInterval() {
        return this._dftMaxIdleSecs;
    }

    @ManagedAttribute(value="time before a session cookie is re-set (in s)")
    public int getRefreshCookieAge() {
        return this._refreshCookieAge;
    }

    @ManagedAttribute(value="if true, secure cookie flag is set on session cookies")
    public boolean getSecureCookies() {
        return this._secureCookies;
    }

    public boolean isSecureRequestOnly() {
        return this._secureRequestOnly;
    }

    /*
     * WARNING - void declaration
     */
    public void setSecureRequestOnly(boolean secureRequestOnly) {
        void var1_1;
        this._secureRequestOnly = var1_1;
    }

    @ManagedAttribute(value="the set session cookie")
    public String getSessionCookie() {
        return this._sessionCookie;
    }

    /*
     * WARNING - void declaration
     */
    public HttpCookie getSessionCookie(HttpSession session, String contextPath, boolean requestIsSecure) {
        if (this.isUsingCookies()) {
            void var3_3;
            void var2_2;
            HttpCookie httpCookie;
            String sessionPath = this._cookieConfig.getPath() == null ? contextPath : this._cookieConfig.getPath();
            sessionPath = StringUtil.isEmpty((String)sessionPath) ? "/" : sessionPath;
            String id = this.getExtendedId(session);
            httpCookie = new HttpCookie(SessionHandler.getSessionCookieName(this._cookieConfig), (String)httpCookie, this._cookieConfig.getDomain(), (String)var2_2, (long)this._cookieConfig.getMaxAge(), this._cookieConfig.isHttpOnly(), this._cookieConfig.isSecure() || this.isSecureRequestOnly() && var3_3 != false, HttpCookie.getCommentWithoutAttributes((String)this._cookieConfig.getComment()), 0, HttpCookie.getSameSiteFromComment((String)this._cookieConfig.getComment()));
            return httpCookie;
        }
        return null;
    }

    @ManagedAttribute(value="domain of the session cookie, or null for the default")
    public String getSessionDomain() {
        return this._sessionDomain;
    }

    @ManagedAttribute(value="number of sessions created by this node")
    public int getSessionsCreated() {
        return (int)this._sessionsCreatedStats.getCurrent();
    }

    @ManagedAttribute(value="name of use for URL session tracking")
    public String getSessionIdPathParameterName() {
        return this._sessionIdPathParameterName;
    }

    public String getSessionIdPathParameterNamePrefix() {
        return this._sessionIdPathParameterNamePrefix;
    }

    public boolean isUsingCookies() {
        return this._usingCookies;
    }

    public boolean isValid(HttpSession session) {
        Session session2 = ((SessionIf)session).getSession();
        return session2.isValid();
    }

    public String getId(HttpSession session) {
        Session session2 = ((SessionIf)session).getSession();
        return session2.getId();
    }

    public String getExtendedId(HttpSession session) {
        Session session2 = ((SessionIf)session).getSession();
        return session2.getExtendedId();
    }

    /*
     * WARNING - void declaration
     */
    public HttpSession newHttpSession(HttpServletRequest request) {
        long created = System.currentTimeMillis();
        String id = this._sessionIdManager.newSessionId(request, created);
        Session session = this._sessionCache.newSession(request, id, created, this._dftMaxIdleSecs > 0 ? (long)this._dftMaxIdleSecs * 1000L : -1L);
        session.setExtendedId(this._sessionIdManager.getExtendedId(id, request));
        session.getSessionData().setLastNode(this._sessionIdManager.getWorkerName());
        try {
            void var2_3;
            void var1_1;
            this._sessionCache.add(id, session);
            Request baseRequest = Request.getBaseRequest((ServletRequest)request);
            baseRequest.setSession(session);
            baseRequest.enterSession(session);
            this._sessionsCreatedStats.increment();
            if (request != null && var1_1.isSecure()) {
                session.setAttribute("org.eclipse.jetty.security.sessionCreatedSecure", Boolean.TRUE);
            }
            this.callSessionCreatedListeners(session);
            return var2_3;
        }
        catch (Exception e) {
            void var3_6;
            LOG.warn((Throwable)var3_6);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeEventListener(EventListener listener) {
        void var1_1;
        if (listener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners.remove(listener);
        }
        if (listener instanceof HttpSessionListener) {
            this._sessionListeners.remove(listener);
        }
        if (listener instanceof HttpSessionIdListener) {
            this._sessionIdListeners.remove(listener);
        }
        this.removeBean(var1_1);
    }

    @ManagedOperation(value="reset statistics", impact="ACTION")
    public void statsReset() {
        this._sessionsCreatedStats.reset();
        this._sessionTimeStats.reset();
    }

    /*
     * WARNING - void declaration
     */
    public void setHttpOnly(boolean httpOnly) {
        void var1_1;
        this._httpOnly = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setSameSite(HttpCookie.SameSite sameSite) {
        void var1_1;
        this._sessionComment = HttpCookie.getCommentWithAttributes((String)this._sessionComment, (boolean)false, (HttpCookie.SameSite)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setSessionIdManager(SessionIdManager metaManager) {
        void var1_1;
        SessionHandler sessionHandler = this;
        sessionHandler.updateBean(sessionHandler._sessionIdManager, metaManager);
        this._sessionIdManager = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxInactiveInterval(int seconds) {
        void var1_1;
        this._dftMaxIdleSecs = var1_1;
        if (LOG.isDebugEnabled()) {
            if (this._dftMaxIdleSecs <= 0) {
                LOG.debug("Sessions created by this manager are immortal (default maxInactiveInterval={})", (long)this._dftMaxIdleSecs);
                return;
            }
            LOG.debug("SessionManager default maxInactiveInterval={}", (long)this._dftMaxIdleSecs);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setRefreshCookieAge(int ageInSeconds) {
        void var1_1;
        this._refreshCookieAge = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setSessionCookie(String cookieName) {
        void var1_1;
        this._sessionCookie = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setSessionIdPathParameterName(String param) {
        void var1_1;
        this._sessionIdPathParameterName = param == null || "none".equals(param) ? null : param;
        this._sessionIdPathParameterNamePrefix = param == null || "none".equals(var1_1) ? null : ";" + this._sessionIdPathParameterName + "=";
    }

    /*
     * WARNING - void declaration
     */
    public void setUsingCookies(boolean usingCookies) {
        void var1_1;
        this._usingCookies = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Session getSession(String id) {
        try {
            void e2;
            Session session = this._sessionCache.get(id);
            if (session != null) {
                if (session.isExpiredAt(System.currentTimeMillis())) {
                    try {
                        session.invalidate();
                    }
                    catch (Exception e2) {
                        LOG.warn("Invalidating session {} found to be expired when requested", new Object[]{id});
                        LOG.warn((Throwable)e2);
                    }
                    return null;
                }
                e2.setExtendedId(this._sessionIdManager.getExtendedId(id, null));
            }
            return e2;
        }
        catch (UnreadableSessionDataException e) {
            LOG.warn("Error loading session {}", new Object[]{id});
            LOG.warn((Throwable)e);
            try {
                this.getSessionIdManager().invalidateAll(id);
            }
            catch (Exception x) {
                void var1_1;
                LOG.warn("Error cross-context invalidating unreadable session {}", new Object[]{var1_1});
                LOG.warn((Throwable)x);
            }
            return null;
        }
        catch (Exception other) {
            void var2_6;
            LOG.warn((Throwable)var2_6);
            return null;
        }
    }

    protected void shutdownSessions() throws Exception {
        this._sessionCache.shutdown();
    }

    public SessionCache getSessionCache() {
        return this._sessionCache;
    }

    /*
     * WARNING - void declaration
     */
    public void setSessionCache(SessionCache cache) {
        void var1_1;
        SessionHandler sessionHandler = this;
        sessionHandler.updateBean(sessionHandler._sessionCache, cache);
        this._sessionCache = var1_1;
    }

    public boolean isNodeIdInSessionId() {
        return this._nodeIdInSessionId;
    }

    /*
     * WARNING - void declaration
     */
    public void setNodeIdInSessionId(boolean nodeIdInSessionId) {
        void var1_1;
        this._nodeIdInSessionId = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Session removeSession(String id, boolean invalidate) {
        try {
            Session session = this._sessionCache.delete(id);
            if (session != null && invalidate) {
                session.beginInvalidate();
                if (this._sessionListeners != null) {
                    HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
                    for (int i = this._sessionListeners.size() - 1; i >= 0; --i) {
                        this._sessionListeners.get(i).sessionDestroyed(event);
                    }
                }
            }
            return session;
        }
        catch (Exception e) {
            void var1_2;
            LOG.warn((Throwable)var1_2);
            return null;
        }
    }

    @ManagedAttribute(value="maximum amount of time sessions have remained active (in s)")
    public long getSessionTimeMax() {
        return this._sessionTimeStats.getMax();
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return DEFAULT_SESSION_TRACKING_MODES;
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return Collections.unmodifiableSet(this._sessionTrackingModes);
    }

    /*
     * WARNING - void declaration
     */
    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        void var1_1;
        if (sessionTrackingModes != null && sessionTrackingModes.size() > 1 && sessionTrackingModes.contains(SessionTrackingMode.SSL)) {
            throw new IllegalArgumentException("sessionTrackingModes specifies a combination of SessionTrackingMode.SSL with a session tracking mode other than SessionTrackingMode.SSL");
        }
        this._sessionTrackingModes = new HashSet<SessionTrackingMode>((Collection<SessionTrackingMode>)var1_1);
        this._usingCookies = this._sessionTrackingModes.contains(SessionTrackingMode.COOKIE);
        this._usingURLs = this._sessionTrackingModes.contains(SessionTrackingMode.URL);
    }

    public boolean isUsingURLs() {
        return this._usingURLs;
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this._cookieConfig;
    }

    @ManagedAttribute(value="total time sessions have remained valid")
    public long getSessionTimeTotal() {
        return this._sessionTimeStats.getTotal();
    }

    @ManagedAttribute(value="mean time sessions remain valid (in s)")
    public double getSessionTimeMean() {
        return this._sessionTimeStats.getMean();
    }

    @ManagedAttribute(value="standard deviation a session remained valid (in s)")
    public double getSessionTimeStdDev() {
        return this._sessionTimeStats.getStdDev();
    }

    @ManagedAttribute(value="check remote session id encoding")
    public boolean isCheckingRemoteSessionIdEncoding() {
        return this._checkingRemoteSessionIdEncoding;
    }

    /*
     * WARNING - void declaration
     */
    public void setCheckingRemoteSessionIdEncoding(boolean remote) {
        void var1_1;
        this._checkingRemoteSessionIdEncoding = var1_1;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void renewSessionId(String oldId, String oldExtendedId, String newId, String newExtendedId) {
        void e2222222;
        Session session;
        block13: {
            session = null;
            session = this._sessionCache.renewSessionId(oldId, newId, oldExtendedId, newExtendedId);
            if (session != null) break block13;
            if (session == null) return;
            try {
                this._sessionCache.release(newId, session);
                return;
            }
            catch (Exception e2222222) {
                LOG.warn((Throwable)e2222222);
            }
            return;
        }
        this.callSessionIdListeners(session, (String)e2222222);
        if (session == null) return;
        try {
            this._sessionCache.release(newId, session);
            return;
        }
        catch (Exception e6) {
            LOG.warn((Throwable)e6);
            return;
        }
        catch (Exception e3) {
            try {
                LOG.warn((Throwable)e3);
                if (session == null) return;
            }
            catch (Throwable throwable) {
                if (session == null) throw throwable;
                try {
                    void var3_9;
                    this._sessionCache.release((String)var3_9, session);
                    throw throwable;
                }
                catch (Exception e4) {
                    void var2_8;
                    LOG.warn((Throwable)var2_8);
                }
                throw throwable;
            }
            try {
                this._sessionCache.release(newId, session);
                return;
            }
            catch (Exception e5) {
                void var1_5;
                LOG.warn((Throwable)var1_5);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void recordSessionTime(Session session) {
        void var1_1;
        this._sessionTimeStats.record(Math.round((double)(System.currentTimeMillis() - var1_1.getSessionData().getCreated()) / 1000.0));
    }

    /*
     * WARNING - void declaration
     */
    public void invalidate(String id) {
        block9: {
            if (StringUtil.isBlank((String)id)) {
                return;
            }
            try {
                Session session = this._sessionCache.delete(id);
                if (session != null) {
                    try {
                        if (!session.beginInvalidate()) break block9;
                        try {
                            this.callSessionDestroyedListeners(session);
                        }
                        catch (Exception e) {
                            LOG.warn((Throwable)e);
                        }
                        session.finishInvalidate();
                        break block9;
                    }
                    catch (IllegalStateException e) {
                        void var2_4;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Session {} already invalid", new Object[]{session});
                        }
                        LOG.ignore((Throwable)var2_4);
                    }
                }
                return;
            }
            catch (Exception e) {
                void var1_2;
                LOG.warn((Throwable)var1_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void scavenge() {
        if (this.isStopping() || this.isStopped()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} scavenging sessions", new Object[]{this});
        }
        String[] ss = this._candidateSessionIdsForExpiry.toArray(new String[0]);
        Object candidates = new HashSet<String>(Arrays.asList(ss));
        this._candidateSessionIdsForExpiry.removeAll((Collection<?>)candidates);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} scavenging session ids {}", new Object[]{this, candidates});
        }
        try {
            candidates = this._sessionCache.checkExpiration((Set<String>)candidates);
            candidates = candidates.iterator();
            while (candidates.hasNext()) {
                String id = (String)candidates.next();
                try {
                    this.getSessionIdManager().expireAll(id);
                }
                catch (Exception e) {
                    void var2_4;
                    LOG.warn((Throwable)var2_4);
                }
            }
            return;
        }
        catch (Exception e) {
            void var1_2;
            LOG.warn((Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void sessionInactivityTimerExpired(Session session) {
        void var1_1;
        this.sessionInactivityTimerExpired((Session)var1_1, System.currentTimeMillis());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sessionInactivityTimerExpired(Session session, long now) {
        void var2_3;
        Locker.Lock lock;
        block13: {
            block12: {
                if (session == null) {
                    return;
                }
                lock = session.lock();
                try {
                    if (session.getRequests() <= 0L) break block12;
                    if (lock == null) return;
                }
                catch (Throwable throwable) {
                    if (lock == null) throw throwable;
                    try {
                        lock.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                lock.close();
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Inspecting session {}, valid={}", new Object[]{session.getId(), session.isValid()});
            }
            if (session.isValid()) break block13;
            if (lock == null) return;
            lock.close();
            return;
        }
        if (session.isExpiredAt((long)var2_3)) {
            if (this._sessionIdManager.getSessionHouseKeeper() != null && this._sessionIdManager.getSessionHouseKeeper().getIntervalSec() > 0L) {
                this._candidateSessionIdsForExpiry.add(session.getId());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Session {} is candidate for expiry", new Object[]{session.getId()});
                }
            }
        } else {
            void var1_1;
            this._sessionCache.checkInactiveSession((Session)var1_1);
        }
        if (lock == null) return;
        lock.close();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isIdInUse(String id) throws Exception {
        void var1_1;
        return this._sessionCache.exists((String)var1_1);
    }

    public Scheduler getScheduler() {
        return this._scheduler;
    }

    public static String getSessionCookieName(SessionCookieConfig config) {
        SessionCookieConfig sessionCookieConfig;
        if (config == null || config.getName() == null) {
            return __DefaultSessionCookie;
        }
        return sessionCookieConfig.getName();
    }

    public void doSessionAttributeListeners(Session session, String name, Object old, Object value) {
        if (!this._sessionAttributeListeners.isEmpty()) {
            Iterator<HttpSessionAttributeListener> iterator;
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)session, (String)((Object)iterator), old == null ? value : old);
            for (HttpSessionAttributeListener l : this._sessionAttributeListeners) {
                if (old == null) {
                    l.attributeAdded(event);
                    continue;
                }
                if (value == null) {
                    l.attributeRemoved(event);
                    continue;
                }
                l.attributeReplaced(event);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doScope(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession oldSession;
        SessionHandler oldSessionHandler;
        block16: {
            oldSessionHandler = null;
            oldSession = null;
            HttpSession existingSession = null;
            try {
                void var3_4;
                void var1_1;
                HttpCookie cookie;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Entering scope {}, dispatch={} asyncstarted={}", new Object[]{this, baseRequest.getDispatcherType(), baseRequest.isAsyncStarted()});
                }
                switch (baseRequest.getDispatcherType()) {
                    case REQUEST: {
                        baseRequest.setSession(null);
                        this.checkRequestedSessionId(baseRequest, request);
                        existingSession = baseRequest.getSession(false);
                        baseRequest.setSessionHandler(this);
                        baseRequest.setSession(existingSession);
                        break;
                    }
                    case ASYNC: 
                    case ERROR: 
                    case FORWARD: 
                    case INCLUDE: {
                        oldSessionHandler = baseRequest.getSessionHandler();
                        oldSession = baseRequest.getSession(false);
                        if (oldSessionHandler == this) break;
                        existingSession = baseRequest.getSession(this);
                        if (existingSession == null) {
                            baseRequest.setSession(null);
                            this.checkRequestedSessionId(baseRequest, request);
                            existingSession = baseRequest.getSession(false);
                        }
                        baseRequest.setSession(existingSession);
                        baseRequest.setSessionHandler(this);
                    }
                }
                if (existingSession != null && oldSessionHandler != this && (cookie = this.access(existingSession, request.isSecure())) != null && (request.getDispatcherType() == DispatcherType.ASYNC || request.getDispatcherType() == DispatcherType.REQUEST)) {
                    baseRequest.getResponse().replaceCookie(cookie);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("sessionHandler={} session={}", new Object[]{this, existingSession});
                }
                if (this._nextScope != null) {
                    this._nextScope.doScope(target, baseRequest, request, response);
                    break block16;
                }
                if (this._outerScope != null) {
                    this._outerScope.doHandle(target, baseRequest, request, response);
                    break block16;
                }
                ((ScopedHandler)this).doHandle((String)var1_1, baseRequest, (HttpServletRequest)var3_4, response);
            }
            catch (Throwable throwable) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Leaving scope {} dispatch={}, async={}, session={}, oldsession={}, oldsessionhandler={}", new Object[]{this, baseRequest.getDispatcherType(), baseRequest.isAsyncStarted(), baseRequest.getSession(false), oldSession, oldSessionHandler});
                }
                if (oldSessionHandler != null && oldSessionHandler != this) {
                    void var2_3;
                    baseRequest.setSessionHandler(oldSessionHandler);
                    var2_3.setSession(oldSession);
                }
                throw throwable;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Leaving scope {} dispatch={}, async={}, session={}, oldsession={}, oldsessionhandler={}", new Object[]{this, baseRequest.getDispatcherType(), baseRequest.isAsyncStarted(), baseRequest.getSession(false), oldSession, oldSessionHandler});
        }
        if (oldSessionHandler != null && oldSessionHandler != this) {
            baseRequest.setSessionHandler(oldSessionHandler);
            baseRequest.setSession(oldSession);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.nextHandle((String)var1_1, (Request)var2_2, (HttpServletRequest)var3_3, response);
    }

    /*
     * WARNING - void declaration
     */
    protected void checkRequestedSessionId(Request baseRequest, HttpServletRequest request) {
        void var3_3;
        void var1_1;
        int s;
        String prefix;
        void var2_2;
        String uri;
        Cookie[] cookies;
        String requestedSessionId = request.getRequestedSessionId();
        if (requestedSessionId != null) {
            HttpSession session = this.getHttpSession(requestedSessionId);
            if (session != null && this.isValid(session)) {
                baseRequest.enterSession(session);
                baseRequest.setSession(session);
            }
            return;
        }
        if (!DispatcherType.REQUEST.equals((Object)baseRequest.getDispatcherType())) {
            return;
        }
        boolean requestedSessionIdFromCookie = false;
        HttpSession session = null;
        if (this.isUsingCookies() && (cookies = request.getCookies()) != null && cookies.length > 0) {
            String sessionCookie = SessionHandler.getSessionCookieName(this.getSessionCookieConfig());
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            for (int i = 0; i < n; ++i) {
                HttpSession s2;
                Cookie cookie = cookieArray[i];
                if (!sessionCookie.equalsIgnoreCase(cookie.getName())) continue;
                String id = cookie.getValue();
                requestedSessionIdFromCookie = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Got Session ID {} from cookie {}", new Object[]{id, sessionCookie});
                }
                if (session == null) {
                    s2 = this.getHttpSession(id);
                    if (s2 != null && this.isValid(s2)) {
                        requestedSessionId = id;
                        session = s2;
                        baseRequest.enterSession(session);
                        baseRequest.setSession(session);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Selected session {}", new Object[]{session});
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("No session found for session cookie id {}", new Object[]{id});
                    }
                    if (requestedSessionId != null) continue;
                    requestedSessionId = id;
                    continue;
                }
                if (!session.getId().equals(this.getSessionIdManager().getId(id))) {
                    s2 = this.getHttpSession(id);
                    if (s2 == null || !this.isValid(s2)) continue;
                    baseRequest.enterSession(s2);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Multiple different valid session ids: {}, {}", new Object[]{requestedSessionId, id});
                    }
                    throw new BadMessageException("Duplicate valid session cookies: " + requestedSessionId + " ," + id);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Duplicate valid session cookie id: {}", new Object[]{id});
            }
        }
        if (this.isUsingURLs() && requestedSessionId == null && (uri = var2_2.getRequestURI()) != null && (prefix = this.getSessionIdPathParameterNamePrefix()) != null && (s = uri.indexOf(prefix)) >= 0) {
            char c;
            int i;
            for (i = s += prefix.length(); i < uri.length() && (c = uri.charAt(i)) != ';' && c != '#' && c != '?' && c != '/'; ++i) {
            }
            requestedSessionId = uri.substring(s, i);
            requestedSessionIdFromCookie = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got Session ID {} from URL", new Object[]{requestedSessionId});
            }
            if ((session = this.getHttpSession(requestedSessionId)) != null && this.isValid(session)) {
                baseRequest.enterSession(session);
                baseRequest.setSession(session);
            }
        }
        baseRequest.setRequestedSessionId(requestedSessionId);
        var1_1.setRequestedSessionIdFromCookie(var3_3 != null && requestedSessionIdFromCookie);
    }

    public String toString() {
        return String.format("%s%d==dftMaxIdleSec=%d", this.getClass().getName(), this.hashCode(), this._dftMaxIdleSecs);
    }

    public final class CookieConfig
    implements SessionCookieConfig {
        final /* synthetic */ SessionHandler this$0;

        /*
         * WARNING - void declaration
         */
        public CookieConfig(SessionHandler this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        public final String getComment() {
            return this.this$0._sessionComment;
        }

        public final String getDomain() {
            return this.this$0._sessionDomain;
        }

        public final int getMaxAge() {
            return this.this$0._maxCookieAge;
        }

        public final String getName() {
            return this.this$0._sessionCookie;
        }

        public final String getPath() {
            return this.this$0._sessionPath;
        }

        public final boolean isHttpOnly() {
            return this.this$0._httpOnly;
        }

        public final boolean isSecure() {
            return this.this$0._secureCookies;
        }

        /*
         * WARNING - void declaration
         */
        public final void setComment(String comment) {
            void var1_1;
            if (this.this$0._context != null && this.this$0._context.getContextHandler().isAvailable()) {
                throw new IllegalStateException("CookieConfig cannot be set after ServletContext is started");
            }
            this.this$0._sessionComment = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setDomain(String domain) {
            void var1_1;
            if (this.this$0._context != null && this.this$0._context.getContextHandler().isAvailable()) {
                throw new IllegalStateException("CookieConfig cannot be set after ServletContext is started");
            }
            this.this$0._sessionDomain = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setHttpOnly(boolean httpOnly) {
            void var1_1;
            if (this.this$0._context != null && this.this$0._context.getContextHandler().isAvailable()) {
                throw new IllegalStateException("CookieConfig cannot be set after ServletContext is started");
            }
            this.this$0._httpOnly = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setMaxAge(int maxAge) {
            void var1_1;
            if (this.this$0._context != null && this.this$0._context.getContextHandler().isAvailable()) {
                throw new IllegalStateException("CookieConfig cannot be set after ServletContext is started");
            }
            this.this$0._maxCookieAge = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setName(String name) {
            void var1_1;
            if (this.this$0._context != null && this.this$0._context.getContextHandler().isAvailable()) {
                throw new IllegalStateException("CookieConfig cannot be set after ServletContext is started");
            }
            if ("".equals(name)) {
                throw new IllegalArgumentException("Blank cookie name");
            }
            if (name != null) {
                Syntax.requireValidRFC2616Token((String)name, (String)"Bad Session cookie name");
            }
            this.this$0._sessionCookie = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setPath(String path) {
            void var1_1;
            if (this.this$0._context != null && this.this$0._context.getContextHandler().isAvailable()) {
                throw new IllegalStateException("CookieConfig cannot be set after ServletContext is started");
            }
            this.this$0._sessionPath = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setSecure(boolean secure) {
            void var1_1;
            if (this.this$0._context != null && this.this$0._context.getContextHandler().isAvailable()) {
                throw new IllegalStateException("CookieConfig cannot be set after ServletContext is started");
            }
            this.this$0._secureCookies = var1_1;
        }
    }

    public static interface SessionIf
    extends HttpSession {
        public Session getSession();
    }
}

