/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.util.ClassLoadingObjectInputStream;
import org.eclipse.jetty.util.ClassVisibilityChecker;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SessionData
implements Serializable {
    private static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.server.session");
    private static final long serialVersionUID = 1L;
    protected String _id;
    protected String _contextPath;
    protected String _vhost;
    protected String _lastNode;
    protected long _expiry;
    protected long _created;
    protected long _cookieSet;
    protected long _accessed;
    protected long _lastAccessed;
    protected long _maxInactiveMs;
    protected Map<String, Object> _attributes;
    protected boolean _dirty;
    protected long _lastSaved;
    protected boolean _metaDataDirty;

    /*
     * WARNING - void declaration
     */
    public static void serializeAttributes(SessionData data, ObjectOutputStream out) throws IOException {
        Object object;
        int n = data._attributes.size();
        out.writeObject(n);
        for (Map.Entry entry : ((SessionData)object)._attributes.entrySet()) {
            boolean isContextLoader3;
            out.writeUTF((String)entry.getKey());
            Class<?> clazz = entry.getValue().getClass();
            ClassLoader loader = clazz.getClassLoader();
            ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
            if (loader == contextLoader) {
                boolean isContextLoader2 = true;
            } else if (contextLoader == null) {
                isContextLoader3 = false;
            } else if (contextLoader instanceof ClassVisibilityChecker) {
                ClassVisibilityChecker checker = (ClassVisibilityChecker)contextLoader;
                isContextLoader3 = checker.isSystemClass(clazz) && !checker.isServerClass(clazz);
            } else {
                try {
                    Class<?> isContextLoader = contextLoader.loadClass(clazz.getName());
                    isContextLoader3 = isContextLoader == clazz;
                }
                catch (Throwable throwable) {
                    isContextLoader3 = false;
                }
            }
            if (LOG.isDebugEnabled()) {
                void var3_4;
                LOG.debug("Attribute {} class={} isServerLoader={}", new Object[]{entry.getKey(), var3_4.getName(), !isContextLoader3});
            }
            out.writeBoolean(!isContextLoader3);
            out.writeObject(entry.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void deserializeAttributes(SessionData data, ObjectInputStream in) throws IOException, ClassNotFoundException {
        void var2_2;
        SessionData sessionData;
        Object o = in.readObject();
        if (o instanceof Integer) {
            if (!ClassLoadingObjectInputStream.class.isAssignableFrom(in.getClass())) {
                throw new IOException("Not ClassLoadingObjectInputStream");
            }
            data._attributes = new ConcurrentHashMap<String, Object>();
            int entries = (Integer)o;
            ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader serverLoader = SessionData.class.getClassLoader();
            for (int i = 0; i < entries; ++i) {
                String name = in.readUTF();
                boolean isServerClassLoader = in.readBoolean();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Deserialize {} isServerLoader={} serverLoader={} tccl={}", new Object[]{name, isServerClassLoader, serverLoader, contextLoader});
                }
                Object value = ((ClassLoadingObjectInputStream)in).readObject(isServerClassLoader ? serverLoader : contextLoader);
                data._attributes.put(name, value);
            }
            return;
        }
        LOG.info("Legacy serialization detected for {}", new Object[]{data.getId()});
        data._attributes = new ConcurrentHashMap<String, Object>();
        sessionData.putAllAttributes((Map)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public SessionData(String id, String cpath, String vhost, long created, long accessed, long lastAccessed, long maxInactiveMs) {
        void var3_3;
        void var2_2;
        void var1_1;
        this._id = var1_1;
        this.setContextPath((String)var2_2);
        this.setVhost((String)var3_3);
        this._created = created;
        this._accessed = accessed;
        this._lastAccessed = lastAccessed;
        this._maxInactiveMs = maxInactiveMs;
        this.calcAndSetExpiry();
        this._attributes = new ConcurrentHashMap<String, Object>();
    }

    /*
     * WARNING - void declaration
     */
    public SessionData(String id, String cpath, String vhost, long created, long accessed, long lastAccessed, long maxInactiveMs, Map<String, Object> attributes) {
        this((String)var1_1, (String)var2_2, (String)var3_3, created, accessed, lastAccessed, maxInactiveMs);
        void var3_3;
        void var2_2;
        void var1_1;
        this.putAllAttributes(attributes);
    }

    /*
     * WARNING - void declaration
     */
    public void copy(SessionData data) {
        void var1_1;
        if (data == null) {
            return;
        }
        if (data.getId() == null || !this.getId().equals(data.getId())) {
            throw new IllegalStateException("Can only copy data for same session id");
        }
        if (data == this) {
            return;
        }
        this.setLastNode(data.getLastNode());
        this.setContextPath(data.getContextPath());
        this.setVhost(data.getVhost());
        this.setCookieSet(data.getCookieSet());
        this.setCreated(data.getCreated());
        this.setAccessed(data.getAccessed());
        this.setLastAccessed(data.getLastAccessed());
        this.setMaxInactiveMs(data.getMaxInactiveMs());
        this.setExpiry(data.getExpiry());
        this.setLastSaved(data.getLastSaved());
        this.clearAllAttributes();
        this.putAllAttributes(var1_1.getAllAttributes());
    }

    public long getLastSaved() {
        return this._lastSaved;
    }

    /*
     * WARNING - void declaration
     */
    public void setLastSaved(long lastSaved) {
        void var1_1;
        this._lastSaved = var1_1;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    /*
     * WARNING - void declaration
     */
    public void setDirty(boolean dirty) {
        void var1_1;
        this._dirty = var1_1;
    }

    public boolean isMetaDataDirty() {
        return this._metaDataDirty;
    }

    /*
     * WARNING - void declaration
     */
    public void setMetaDataDirty(boolean metaDataDirty) {
        void var1_1;
        this._metaDataDirty = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Object getAttribute(String name) {
        void var1_1;
        return this._attributes.get(var1_1);
    }

    public Set<String> getKeys() {
        return this._attributes.keySet();
    }

    /*
     * WARNING - void declaration
     */
    public Object setAttribute(String name, Object value) {
        void var3_3;
        void var1_1;
        void var2_2;
        Object old;
        Object object = old = value == null ? this._attributes.remove(name) : this._attributes.put(name, value);
        if (var2_2 == null && old == null) {
            return old;
        }
        this.setDirty((String)var1_1);
        return var3_3;
    }

    public void setDirty(String name) {
        this.setDirty(true);
    }

    public void clean() {
        this.setDirty(false);
        this.setMetaDataDirty(false);
    }

    /*
     * WARNING - void declaration
     */
    public void putAllAttributes(Map<String, Object> attributes) {
        void var1_1;
        this._attributes.putAll((Map<String, Object>)var1_1);
    }

    public void clearAllAttributes() {
        this._attributes.clear();
    }

    public Map<String, Object> getAllAttributes() {
        return Collections.unmodifiableMap(this._attributes);
    }

    public String getId() {
        return this._id;
    }

    /*
     * WARNING - void declaration
     */
    public void setId(String id) {
        void var1_1;
        this._id = var1_1;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    /*
     * WARNING - void declaration
     */
    public void setContextPath(String contextPath) {
        void var1_1;
        this._contextPath = var1_1;
    }

    public String getVhost() {
        return this._vhost;
    }

    /*
     * WARNING - void declaration
     */
    public void setVhost(String vhost) {
        void var1_1;
        this._vhost = var1_1;
    }

    public String getLastNode() {
        return this._lastNode;
    }

    /*
     * WARNING - void declaration
     */
    public void setLastNode(String lastNode) {
        void var1_1;
        this._lastNode = var1_1;
    }

    public long getExpiry() {
        return this._expiry;
    }

    /*
     * WARNING - void declaration
     */
    public void setExpiry(long expiry) {
        void var1_1;
        this._expiry = var1_1;
    }

    public long calcExpiry() {
        return this.calcExpiry(System.currentTimeMillis());
    }

    /*
     * WARNING - void declaration
     */
    public long calcExpiry(long time) {
        void var1_1;
        if (this.getMaxInactiveMs() <= 0L) {
            return 0L;
        }
        return (long)(var1_1 + this.getMaxInactiveMs());
    }

    /*
     * WARNING - void declaration
     */
    public void calcAndSetExpiry(long time) {
        void var1_1;
        SessionData sessionData = this;
        sessionData.setExpiry(sessionData.calcExpiry((long)var1_1));
        this.setMetaDataDirty(true);
    }

    public void calcAndSetExpiry() {
        SessionData sessionData = this;
        sessionData.setExpiry(sessionData.calcExpiry());
        this.setMetaDataDirty(true);
    }

    public long getCreated() {
        return this._created;
    }

    /*
     * WARNING - void declaration
     */
    public void setCreated(long created) {
        void var1_1;
        this._created = var1_1;
    }

    public long getCookieSet() {
        return this._cookieSet;
    }

    /*
     * WARNING - void declaration
     */
    public void setCookieSet(long cookieSet) {
        void var1_1;
        this._cookieSet = var1_1;
    }

    public long getAccessed() {
        return this._accessed;
    }

    /*
     * WARNING - void declaration
     */
    public void setAccessed(long accessed) {
        void var1_1;
        this._accessed = var1_1;
    }

    public long getLastAccessed() {
        return this._lastAccessed;
    }

    /*
     * WARNING - void declaration
     */
    public void setLastAccessed(long lastAccessed) {
        void var1_1;
        this._lastAccessed = var1_1;
    }

    public long getMaxInactiveMs() {
        return this._maxInactiveMs;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxInactiveMs(long maxInactive) {
        void var1_1;
        this._maxInactiveMs = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        void var1_1;
        out.writeUTF(this._id);
        out.writeUTF(this._contextPath);
        out.writeUTF(this._vhost);
        out.writeLong(this._accessed);
        out.writeLong(this._lastAccessed);
        out.writeLong(this._created);
        out.writeLong(this._cookieSet);
        out.writeUTF(this._lastNode);
        out.writeLong(this._expiry);
        out.writeLong(this._maxInactiveMs);
        SessionData.serializeAttributes(this, (ObjectOutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        void var1_1;
        this._id = in.readUTF();
        this._contextPath = in.readUTF();
        this._vhost = in.readUTF();
        this._accessed = in.readLong();
        this._lastAccessed = in.readLong();
        this._created = in.readLong();
        this._cookieSet = in.readLong();
        this._lastNode = in.readUTF();
        this._expiry = in.readLong();
        this._maxInactiveMs = in.readLong();
        SessionData.deserializeAttributes(this, (ObjectInputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isExpiredAt(long time) {
        void var1_1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Testing expiry on session {}: expires at {} now {} maxIdle {}", new Object[]{this._id, this.getExpiry(), time, this.getMaxInactiveMs()});
        }
        if (this.getMaxInactiveMs() <= 0L) {
            return false;
        }
        return this.getExpiry() <= var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder builder = new StringBuilder();
        builder.append("id=" + this._id);
        builder.append(", contextpath=" + this._contextPath);
        builder.append(", vhost=" + this._vhost);
        builder.append(", accessed=" + this._accessed);
        builder.append(", lastaccessed=" + this._lastAccessed);
        builder.append(", created=" + this._created);
        builder.append(", cookieset=" + this._cookieSet);
        builder.append(", lastnode=" + this._lastNode);
        builder.append(", expiry=" + this._expiry);
        builder.append(", maxinactive=" + this._maxInactiveMs);
        return var1_1.toString();
    }
}

