/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.StringUtil;

public class SessionContext {
    public static final String NULL_VHOST = "0.0.0.0";
    private ContextHandler.Context _context;
    private SessionHandler _sessionHandler;
    private String _workerName;
    private String _canonicalContextPath;
    private String _vhost;

    /*
     * WARNING - void declaration
     */
    public SessionContext(String workerName, ContextHandler.Context context) {
        void var2_2;
        void var1_1;
        if (context != null) {
            this._sessionHandler = context.getContextHandler().getChildHandlerByClass(SessionHandler.class);
        }
        this._workerName = var1_1;
        this._context = var2_2;
        this._canonicalContextPath = this.canonicalizeContextPath(this._context);
        this._vhost = this.canonicalizeVHost(this._context);
    }

    public String getWorkerName() {
        return this._workerName;
    }

    public SessionHandler getSessionHandler() {
        return this._sessionHandler;
    }

    public ContextHandler.Context getContext() {
        return this._context;
    }

    public String getCanonicalContextPath() {
        return this._canonicalContextPath;
    }

    public String getVhost() {
        return this._vhost;
    }

    public String toString() {
        return this._workerName + "_" + this._canonicalContextPath + "_" + this._vhost;
    }

    /*
     * WARNING - void declaration
     */
    public void run(Runnable r) {
        void var1_1;
        if (this._context != null) {
            this._context.getContextHandler().handle(r);
            return;
        }
        var1_1.run();
    }

    /*
     * WARNING - void declaration
     */
    private String canonicalizeContextPath(ContextHandler.Context context) {
        void var1_1;
        if (context == null) {
            return "";
        }
        return this.canonicalize(var1_1.getContextPath());
    }

    /*
     * WARNING - void declaration
     */
    private String canonicalizeVHost(ContextHandler.Context context) {
        void var1_1;
        String vhost = NULL_VHOST;
        if (context == null) {
            return vhost;
        }
        String[] vhosts = context.getContextHandler().getVirtualHosts();
        if (vhosts == null || vhosts.length == 0 || vhosts[0] == null) {
            void var2_2;
            return var2_2;
        }
        return var1_1[0];
    }

    /*
     * WARNING - void declaration
     */
    private String canonicalize(String path) {
        void var1_1;
        if (path == null) {
            return "";
        }
        return StringUtil.sanitizeFileSystemName((String)var1_1);
    }
}

