/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import org.eclipse.jetty.io.CyclicTimeout;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Locker;
import org.eclipse.jetty.util.thread.Scheduler;

public class Session
implements SessionHandler.SessionIf {
    private static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.server.session");
    public static final String SESSION_CREATED_SECURE = "org.eclipse.jetty.security.sessionCreatedSecure";
    protected final SessionData _sessionData;
    protected final SessionHandler _handler;
    protected String _extendedId;
    protected long _requests;
    protected boolean _idChanged;
    protected boolean _newSession;
    protected State _state = State.VALID;
    protected Locker _lock = new Locker();
    protected Condition _stateChangeCompleted = this._lock.newCondition();
    protected boolean _resident = false;
    protected final SessionInactivityTimer _sessionInactivityTimer;

    /*
     * WARNING - void declaration
     */
    public Session(SessionHandler handler, HttpServletRequest request, SessionData data) {
        void var3_3;
        void var1_1;
        this._handler = var1_1;
        this._sessionData = var3_3;
        this._newSession = true;
        this._sessionData.setDirty(true);
        this._sessionInactivityTimer = new SessionInactivityTimer();
    }

    /*
     * WARNING - void declaration
     */
    public Session(SessionHandler handler, SessionData data) {
        void var2_2;
        void var1_1;
        this._handler = var1_1;
        this._sessionData = var2_2;
        this._sessionInactivityTimer = new SessionInactivityTimer();
    }

    /*
     * WARNING - void declaration
     */
    public long getRequests() {
        long l;
        block5: {
            Locker.Lock lock = this._lock.lock();
            try {
                l = this._requests;
                if (lock == null) break block5;
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            lock.close();
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public void setExtendedId(String extendedId) {
        void var1_1;
        this._extendedId = var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void cookieSet() {
        Locker.Lock lock = this._lock.lock();
        try {
            this._sessionData.setCookieSet(this._sessionData.getAccessed());
            if (lock == null) return;
        }
        catch (Throwable throwable) {
            if (lock == null) throw throwable;
            try {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        lock.close();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void use() {
        Locker.Lock lock = this._lock.lock();
        try {
            ++this._requests;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Session {} in use, stopping timer, active requests={}", new Object[]{this.getId(), this._requests});
            }
            this._sessionInactivityTimer.cancel();
            if (lock == null) return;
        }
        catch (Throwable throwable) {
            if (lock == null) throw throwable;
            try {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        lock.close();
    }

    /*
     * WARNING - void declaration
     */
    protected boolean access(long time) {
        Locker.Lock lock;
        block9: {
            block10: {
                void var1_1;
                block7: {
                    block8: {
                        lock = this._lock.lock();
                        try {
                            if (this.isValid() && this.isResident()) break block7;
                            if (lock == null) break block8;
                        }
                        catch (Throwable throwable) {
                            if (lock != null) {
                                try {
                                    void var3_2;
                                    var3_2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        lock.close();
                    }
                    return false;
                }
                this._newSession = false;
                long lastAccessed = this._sessionData.getAccessed();
                this._sessionData.setAccessed(time);
                this._sessionData.setLastAccessed(lastAccessed);
                this._sessionData.calcAndSetExpiry(time);
                if (!this.isExpiredAt((long)var1_1)) break block9;
                this.invalidate();
                if (lock == null) break block10;
                lock.close();
            }
            return false;
        }
        if (lock != null) {
            lock.close();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void complete() {
        Locker.Lock lock = this._lock.lock();
        try {
            --this._requests;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Session {} complete, active requests={}", new Object[]{this.getId(), this._requests});
            }
            if (this._requests == 0L) {
                void var2_2;
                long now = System.currentTimeMillis();
                this._sessionData.calcAndSetExpiry(now);
                this._sessionInactivityTimer.schedule(this.calculateInactivityTimeout((long)var2_2));
            }
            if (lock == null) return;
        }
        catch (Throwable throwable) {
            if (lock == null) throw throwable;
            try {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        lock.close();
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isExpiredAt(long time) {
        boolean bl;
        block5: {
            Locker.Lock lock = this._lock.lock();
            try {
                void var1_1;
                bl = this._sessionData.isExpiredAt((long)var1_1);
                if (lock == null) break block5;
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        void var3_4;
                        var3_4.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            lock.close();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isIdleLongerThan(int sec) {
        long now = System.currentTimeMillis();
        try (Locker.Lock lock = this._lock.lock();){
            void var2_3;
            boolean bl;
            bl = this._sessionData.getAccessed() + (long)(bl * 1000) <= var2_3;
            return bl;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void callSessionAttributeListeners(String name, Object newValue, Object oldValue) {
        if (newValue == null || !newValue.equals(oldValue)) {
            void var2_2;
            void var3_3;
            void var1_1;
            if (oldValue != null) {
                this.unbindValue(name, oldValue);
            }
            if (newValue != null) {
                this.bindValue(name, newValue);
            }
            if (this._handler == null) {
                throw new IllegalStateException("No session manager for session " + this._sessionData.getId());
            }
            this._handler.doSessionAttributeListeners(this, (String)var1_1, var3_3, var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void unbindValue(String name, Object value) {
        if (value != null && value instanceof HttpSessionBindingListener) {
            void var1_1;
            void var2_2;
            ((HttpSessionBindingListener)var2_2).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, (String)var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void bindValue(String name, Object value) {
        if (value != null && value instanceof HttpSessionBindingListener) {
            void var1_1;
            void var2_2;
            ((HttpSessionBindingListener)var2_2).valueBound(new HttpSessionBindingEvent((HttpSession)this, (String)var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void didActivate() {
        boolean dirty = this.getSessionData().isDirty();
        try {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
            Iterator<String> iter = this._sessionData.getKeys().iterator();
            while (iter.hasNext()) {
                Object value = this._sessionData.getAttribute(iter.next());
                if (!(value instanceof HttpSessionActivationListener)) continue;
                HttpSessionActivationListener httpSessionActivationListener = (HttpSessionActivationListener)value;
                httpSessionActivationListener.sessionDidActivate(event);
            }
            this.getSessionData().setDirty(dirty);
            return;
        }
        catch (Throwable throwable) {
            void var1_1;
            this.getSessionData().setDirty((boolean)var1_1);
            throw throwable;
        }
    }

    public void willPassivate() {
        HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
        Iterator<String> iter = this._sessionData.getKeys().iterator();
        while (iter.hasNext()) {
            HttpSessionActivationListener httpSessionActivationListener;
            Object value = this._sessionData.getAttribute(iter.next());
            if (!(value instanceof HttpSessionActivationListener)) continue;
            httpSessionActivationListener = httpSessionActivationListener;
            httpSessionActivationListener.sessionWillPassivate(event);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isValid() {
        boolean bl;
        block5: {
            Locker.Lock lock = this._lock.lock();
            try {
                boolean bl2 = bl = this._state == State.VALID;
                if (lock == null) break block5;
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            lock.close();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isInvalid() {
        boolean bl;
        block5: {
            Locker.Lock lock = this._lock.lock();
            try {
                boolean bl2 = bl = this._state == State.INVALID || this._state == State.INVALIDATING;
                if (lock == null) break block5;
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            lock.close();
        }
        return bl;
    }

    public boolean isChanging() {
        this.checkLocked();
        return this._state == State.CHANGING;
    }

    /*
     * WARNING - void declaration
     */
    public long getCookieSetTime() {
        long l;
        block5: {
            Locker.Lock lock = this._lock.lock();
            try {
                l = this._sessionData.getCookieSet();
                if (lock == null) break block5;
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            lock.close();
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public long getCreationTime() throws IllegalStateException {
        long l;
        block5: {
            Locker.Lock lock = this._lock.lock();
            try {
                this.checkValidForRead();
                l = this._sessionData.getCreated();
                if (lock == null) break block5;
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            lock.close();
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public String getId() {
        String string;
        block5: {
            Locker.Lock lock = this._lock.lock();
            try {
                string = this._sessionData.getId();
                if (lock == null) break block5;
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            lock.close();
        }
        return string;
    }

    public String getExtendedId() {
        return this._extendedId;
    }

    public String getContextPath() {
        return this._sessionData.getContextPath();
    }

    public String getVHost() {
        return this._sessionData.getVhost();
    }

    /*
     * WARNING - void declaration
     */
    public long getLastAccessedTime() {
        long l;
        block5: {
            Locker.Lock lock = this._lock.lock();
            try {
                this.checkValidForRead();
                l = this._sessionData.getLastAccessed();
                if (lock == null) break block5;
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            lock.close();
        }
        return l;
    }

    public ServletContext getServletContext() {
        if (this._handler == null) {
            throw new IllegalStateException("No session manager for session " + this._sessionData.getId());
        }
        return this._handler._context;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setMaxInactiveInterval(int secs) {
        Locker.Lock lock = this._lock.lock();
        try {
            this._sessionData.setMaxInactiveMs((long)secs * 1000L);
            this._sessionData.calcAndSetExpiry();
            this._sessionData.setDirty(true);
            if (LOG.isDebugEnabled()) {
                if (secs <= 0) {
                    LOG.debug("Session {} is now immortal (maxInactiveInterval={})", new Object[]{this._sessionData.getId(), secs});
                } else {
                    void var1_1;
                    LOG.debug("Session {} maxInactiveInterval={}", new Object[]{this._sessionData.getId(), (int)var1_1});
                }
            }
            if (lock == null) return;
        }
        catch (Throwable throwable) {
            if (lock == null) throw throwable;
            try {
                void var2_3;
                var2_3.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        lock.close();
    }

    @Deprecated
    public void updateInactivityTimer() {
    }

    /*
     * WARNING - void declaration
     */
    public long calculateInactivityTimeout(long now) {
        void var3_7;
        try (Locker.Lock lock = this._lock.lock();){
            long time;
            long remaining = this._sessionData.getExpiry() - now;
            long maxInactive = this._sessionData.getMaxInactiveMs();
            int evictionPolicy = this.getSessionHandler().getSessionCache().getEvictionPolicy();
            if (maxInactive <= 0L) {
                if (evictionPolicy <= 0) {
                    time = -1L;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Session {} is immortal && no inactivity eviction", new Object[]{this.getId()});
                    }
                } else {
                    time = TimeUnit.SECONDS.toMillis(evictionPolicy);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Session {} is immortal; evict after {} sec inactivity", new Object[]{this.getId(), evictionPolicy});
                    }
                }
            } else if (evictionPolicy == -1) {
                long l = time = remaining > 0L ? remaining : 0L;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Session {} no eviction", new Object[]{this.getId()});
                }
            } else if (evictionPolicy == 0) {
                time = -1L;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Session {} evict on exit", new Object[]{this.getId()});
                }
            } else {
                long l = time = remaining > 0L ? Math.min(maxInactive, TimeUnit.SECONDS.toMillis(evictionPolicy)) : 0L;
                if (LOG.isDebugEnabled()) {
                    void var1_2;
                    LOG.debug("Session {} timer set to lesser of maxInactive={} and inactivityEvict={}", new Object[]{this.getId(), maxInactive, (int)var1_2});
                }
            }
        }
        return (long)var3_7;
    }

    /*
     * WARNING - void declaration
     */
    public int getMaxInactiveInterval() {
        int n;
        block5: {
            Locker.Lock lock = this._lock.lock();
            try {
                void var2_2;
                long maxInactiveMs = this._sessionData.getMaxInactiveMs();
                n = (int)(maxInactiveMs < 0L ? -1L : var2_2 / 1000L);
                if (lock == null) break block5;
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            lock.close();
        }
        return n;
    }

    @Deprecated
    public HttpSessionContext getSessionContext() {
        this.checkValidForRead();
        return SessionHandler.__nullSessionContext;
    }

    public SessionHandler getSessionHandler() {
        return this._handler;
    }

    protected void checkValidForWrite() throws IllegalStateException {
        this.checkLocked();
        if (this._state == State.INVALID) {
            throw new IllegalStateException("Not valid for write: id=" + this._sessionData.getId() + " created=" + this._sessionData.getCreated() + " accessed=" + this._sessionData.getAccessed() + " lastaccessed=" + this._sessionData.getLastAccessed() + " maxInactiveMs=" + this._sessionData.getMaxInactiveMs() + " expiry=" + this._sessionData.getExpiry());
        }
        if (this._state == State.INVALIDATING) {
            return;
        }
        if (!this.isResident()) {
            throw new IllegalStateException("Not valid for write: id=" + this._sessionData.getId() + " not resident");
        }
    }

    protected void checkValidForRead() throws IllegalStateException {
        this.checkLocked();
        if (this._state == State.INVALID) {
            throw new IllegalStateException("Invalid for read: id=" + this._sessionData.getId() + " created=" + this._sessionData.getCreated() + " accessed=" + this._sessionData.getAccessed() + " lastaccessed=" + this._sessionData.getLastAccessed() + " maxInactiveMs=" + this._sessionData.getMaxInactiveMs() + " expiry=" + this._sessionData.getExpiry());
        }
        if (this._state == State.INVALIDATING) {
            return;
        }
        if (!this.isResident()) {
            throw new IllegalStateException("Invalid for read: id=" + this._sessionData.getId() + " not resident");
        }
    }

    protected void checkLocked() throws IllegalStateException {
        if (!this._lock.isLocked()) {
            throw new IllegalStateException("Session not locked");
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object getAttribute(String name) {
        Object object;
        block5: {
            Locker.Lock lock = this._lock.lock();
            try {
                this.checkValidForRead();
                object = this._sessionData.getAttribute((String)object);
                if (lock == null) break block5;
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        void var2_3;
                        var2_3.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            lock.close();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public Object getValue(String name) {
        Object object;
        block5: {
            Locker.Lock lock = this._lock.lock();
            try {
                this.checkValidForRead();
                object = this._sessionData.getAttribute((String)object);
                if (lock == null) break block5;
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        void var2_3;
                        var2_3.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            lock.close();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public Enumeration<String> getAttributeNames() {
        Enumeration<String> enumeration;
        block5: {
            Locker.Lock lock = this._lock.lock();
            try {
                void var2_2;
                this.checkValidForRead();
                Iterator<String> itor = this._sessionData.getKeys().iterator();
                enumeration = new Enumeration<String>(this, (Iterator)var2_2){
                    final /* synthetic */ Iterator val$itor;
                    final /* synthetic */ Session this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$itor = iterator;
                    }

                    @Override
                    public boolean hasMoreElements() {
                        return this.val$itor.hasNext();
                    }

                    @Override
                    public String nextElement() {
                        return (String)this.val$itor.next();
                    }
                };
                if (lock == null) break block5;
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            lock.close();
        }
        return enumeration;
    }

    public int getAttributes() {
        return this._sessionData.getKeys().size();
    }

    public Set<String> getNames() {
        return Collections.unmodifiableSet(this._sessionData.getKeys());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String[] getValueNames() throws IllegalStateException {
        String[] stringArray;
        block9: {
            Iterator<String> itor;
            Locker.Lock lock;
            block7: {
                String[] stringArray2;
                block8: {
                    lock = this._lock.lock();
                    this.checkValidForRead();
                    itor = this._sessionData.getKeys().iterator();
                    if (itor.hasNext()) break block7;
                    stringArray2 = new String[]{};
                    if (lock == null) break block8;
                    lock.close();
                }
                return stringArray2;
            }
            try {
                void var3_5;
                ArrayList<String> names = new ArrayList<String>();
                while (itor.hasNext()) {
                    names.add(itor.next());
                }
                void v0 = var3_5;
                stringArray = v0.toArray(new String[v0.size()]);
                if (lock == null) break block9;
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            lock.close();
        }
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    public void setAttribute(String name, Object value) {
        void var3_6;
        void var2_3;
        void var1_1;
        Object old;
        try (Locker.Lock lock = this._lock.lock();){
            this.checkValidForWrite();
            old = this._sessionData.setAttribute(name, value);
        }
        if (value == null && old == null) {
            return;
        }
        this.callSessionAttributeListeners((String)var1_1, var2_3, var3_6);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void putValue(String name, Object value) {
        void var2_2;
        void var1_1;
        this.setAttribute((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void removeAttribute(String name) {
        void var1_1;
        this.setAttribute((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void removeValue(String name) {
        void var1_1;
        this.setAttribute((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void renewId(HttpServletRequest request) {
        String extendedId;
        String id;
        if (this._handler == null) {
            throw new IllegalStateException("No session manager for session " + this._sessionData.getId());
        }
        try (Locker.Lock lock = this._lock.lock();){
            block20: while (true) {
                switch (2.$SwitchMap$org$eclipse$jetty$server$session$Session$State[this._state.ordinal()]) {
                    case 1: 
                    case 2: {
                        throw new IllegalStateException();
                    }
                    case 3: {
                        try {
                            this._stateChangeCompleted.await();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    continue block20;
                    case 4: {
                        this._state = State.CHANGING;
                        break block20;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                break;
            }
            id = this._sessionData.getId();
            extendedId = this.getExtendedId();
        }
        String newId = this._handler._sessionIdManager.renewSessionId(id, extendedId, request);
        Locker.Lock lock = this._lock.lock();
        try {
            switch (this._state) {
                case CHANGING: {
                    void var1_1;
                    void var2_8;
                    if (var2_8.equals(newId)) {
                        throw new IllegalStateException("Unable to change session id");
                    }
                    this._sessionData.setId(newId);
                    Session session = this;
                    session.setExtendedId(session._handler._sessionIdManager.getExtendedId(newId, (HttpServletRequest)var1_1));
                    this.setIdChanged(true);
                    this._state = State.VALID;
                    this._stateChangeCompleted.signalAll();
                    break;
                }
                case INVALID: 
                case INVALIDATING: {
                    throw new IllegalStateException("Session invalid");
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (lock == null) return;
        }
        catch (Throwable throwable) {
            if (lock == null) throw throwable;
            try {
                void var3_6;
                var3_6.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        lock.close();
    }

    /*
     * WARNING - void declaration
     */
    public void invalidate() {
        block9: {
            if (this._handler == null) {
                throw new IllegalStateException("No session manager for session " + this._sessionData.getId());
            }
            boolean result = this.beginInvalidate();
            try {
                if (result) {
                    try {
                        this._handler.callSessionDestroyedListeners(this);
                        break block9;
                    }
                    catch (Exception e) {
                        LOG.warn("Error during Session destroy listener", (Throwable)e);
                        break block9;
                    }
                    finally {
                        this.finishInvalidate();
                        this._handler.getSessionIdManager().invalidateAll(this._sessionData.getId());
                    }
                }
                return;
            }
            catch (Exception e) {
                void var1_4;
                LOG.warn((Throwable)var1_4);
            }
        }
    }

    public Locker.Lock lock() {
        return this._lock.lock();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean beginInvalidate() {
        boolean bl;
        boolean result = false;
        Locker.Lock lock = this._lock.lock();
        try {
            block12: while (true) {
                switch (2.$SwitchMap$org$eclipse$jetty$server$session$Session$State[this._state.ordinal()]) {
                    case 1: {
                        throw new IllegalStateException();
                    }
                    case 2: {
                        if (!LOG.isDebugEnabled()) break block12;
                        LOG.debug("Session {} already being invalidated", new Object[]{this._sessionData.getId()});
                        break block12;
                    }
                    case 3: {
                        try {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Session {} waiting for id change to complete", new Object[]{this._sessionData.getId()});
                            }
                            this._stateChangeCompleted.await();
                        }
                        catch (InterruptedException e) {
                            void var1_2;
                            throw new RuntimeException((Throwable)var1_2);
                        }
                    }
                    continue block12;
                    case 4: {
                        bl = true;
                        this._state = State.INVALIDATING;
                        break block12;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                break;
            }
            if (lock == null) return bl;
        }
        catch (Throwable throwable) {
            if (lock == null) throw throwable;
            try {
                void var2_4;
                var2_4.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        lock.close();
        return bl;
    }

    @Deprecated
    protected void doInvalidate() throws IllegalStateException {
        this.finishInvalidate();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void finishInvalidate() throws IllegalStateException {
        Locker.Lock lock = this._lock.lock();
        try {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("invalidate {}", new Object[]{this._sessionData.getId()});
                }
                if (this._state == State.VALID || this._state == State.INVALIDATING) {
                    void var2_2;
                    do {
                        Set<String> keys = this._sessionData.getKeys();
                        for (String key : keys) {
                            Object old = this._sessionData.setAttribute(key, null);
                            if (old == null) continue;
                            this.callSessionAttributeListeners(key, null, old);
                        }
                    } while (!var2_2.isEmpty());
                }
            }
            finally {
                this._state = State.INVALID;
                this._handler.recordSessionTime(this);
                this._stateChangeCompleted.signalAll();
            }
            if (lock == null) return;
        }
        catch (Throwable throwable) {
            if (lock == null) throw throwable;
            try {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        lock.close();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isNew() throws IllegalStateException {
        boolean bl;
        block5: {
            Locker.Lock lock = this._lock.lock();
            try {
                this.checkValidForRead();
                bl = this._newSession;
                if (lock == null) break block5;
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            lock.close();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setIdChanged(boolean changed) {
        Locker.Lock lock = this._lock.lock();
        try {
            void var1_1;
            this._idChanged = var1_1;
            if (lock == null) return;
        }
        catch (Throwable throwable) {
            if (lock == null) throw throwable;
            try {
                void var2_3;
                var2_3.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        lock.close();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isIdChanged() {
        boolean bl;
        block5: {
            Locker.Lock lock = this._lock.lock();
            try {
                bl = this._idChanged;
                if (lock == null) break block5;
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            lock.close();
        }
        return bl;
    }

    @Override
    public Session getSession() {
        return this;
    }

    protected SessionData getSessionData() {
        return this._sessionData;
    }

    /*
     * WARNING - void declaration
     */
    public void setResident(boolean resident) {
        void var1_1;
        this._resident = var1_1;
        if (!this._resident) {
            this._sessionInactivityTimer.destroy();
        }
    }

    public boolean isResident() {
        return this._resident;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        String string;
        block5: {
            Locker.Lock lock = this._lock.lock();
            try {
                string = String.format("%s@%x{id=%s,x=%s,req=%d,res=%b}", this.getClass().getSimpleName(), this.hashCode(), this._sessionData.getId(), this._extendedId, this._requests, this._resident);
                if (lock == null) break block5;
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            lock.close();
        }
        return string;
    }

    public class SessionInactivityTimer {
        protected final CyclicTimeout _timer;

        /*
         * WARNING - void declaration
         */
        public SessionInactivityTimer() {
            void var1_1;
            this._timer = new CyclicTimeout(this, Session.this.getSessionHandler().getScheduler(), (Session)var1_1){
                final /* synthetic */ Session val$this$0;
                final /* synthetic */ SessionInactivityTimer this$1;
                {
                    void var2_2;
                    void var1_1;
                    this.this$1 = var1_1;
                    this.val$this$0 = session;
                    super((Scheduler)var2_2);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void onTimeoutExpired() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Timer expired for session {}", new Object[]{this.this$1.Session.this.getId()});
                    }
                    long now = System.currentTimeMillis();
                    this.this$1.Session.this.getSessionHandler().sessionInactivityTimerExpired(this.this$1.Session.this, now);
                    Locker.Lock lock = this.this$1.Session.this.lock();
                    try {
                        if (this.this$1.Session.this.isResident() && this.this$1.Session.this.getRequests() <= 0L && this.this$1.Session.this.isValid() && !this.this$1.Session.this.isExpiredAt(now)) {
                            void var1_1;
                            this.this$1.schedule(this.this$1.Session.this.calculateInactivityTimeout((long)var1_1));
                        }
                        if (lock == null) return;
                    }
                    catch (Throwable throwable) {
                        if (lock == null) throw throwable;
                        try {
                            void var3_3;
                            var3_3.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    lock.close();
                }
            };
        }

        @Deprecated
        public void schedule() {
            SessionInactivityTimer sessionInactivityTimer = this;
            sessionInactivityTimer.schedule(sessionInactivityTimer.Session.this.calculateInactivityTimeout(System.currentTimeMillis()));
        }

        /*
         * WARNING - void declaration
         */
        public void schedule(long time) {
            if (time >= 0L) {
                void var1_1;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("(Re)starting timer for session {} at {}ms", new Object[]{Session.this.getId(), time});
                }
                this._timer.schedule((long)var1_1, TimeUnit.MILLISECONDS);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Not starting timer for session {}", new Object[]{Session.this.getId()});
            }
        }

        public void cancel() {
            this._timer.cancel();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cancelled timer for session {}", new Object[]{Session.this.getId()});
            }
        }

        public void destroy() {
            this._timer.destroy();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Destroyed timer for session {}", new Object[]{Session.this.getId()});
            }
        }
    }

    public static enum IdState {
        SET,
        CHANGING;

    }

    public static enum State {
        VALID,
        INVALID,
        INVALIDATING,
        CHANGING;

    }
}

