/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.server.session.AbstractSessionDataStore;
import org.eclipse.jetty.server.session.DatabaseAdaptor;
import org.eclipse.jetty.server.session.SessionContext;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject
public class JDBCSessionDataStore
extends AbstractSessionDataStore {
    static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.server.session");
    public static final String NULL_CONTEXT_PATH = "/";
    protected boolean _initialized = false;
    protected DatabaseAdaptor _dbAdaptor;
    protected SessionTableSchema _sessionTableSchema;
    protected boolean _schemaProvided;
    private static final ByteArrayInputStream EMPTY = new ByteArrayInputStream(new byte[0]);

    @Override
    protected void doStart() throws Exception {
        if (this._dbAdaptor == null) {
            throw new IllegalStateException("No jdbc config");
        }
        this.initialize();
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this._initialized = false;
        if (!this._schemaProvided) {
            this._sessionTableSchema = null;
        }
    }

    public void initialize() throws Exception {
        if (!this._initialized) {
            this._initialized = true;
            if (this._sessionTableSchema == null) {
                this._sessionTableSchema = new SessionTableSchema();
                JDBCSessionDataStore jDBCSessionDataStore = this;
                jDBCSessionDataStore.addBean(jDBCSessionDataStore._sessionTableSchema, true);
            }
            this._dbAdaptor.initialize();
            this._sessionTableSchema.setDatabaseAdaptor(this._dbAdaptor);
            this._sessionTableSchema.prepareTables();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public SessionData doLoad(String id) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    @Override
    public boolean delete(String id) throws Exception {
        boolean bl;
        PreparedStatement statement;
        Connection connection;
        block13: {
            block12: {
                connection = this._dbAdaptor.getConnection();
                statement = this._sessionTableSchema.getDeleteStatement(connection, id, this._context);
                connection.setAutoCommit(true);
                int rows = statement.executeUpdate();
                if (LOG.isDebugEnabled()) {
                    void var1_1;
                    LOG.debug("Deleted Session {}:{}", new Object[]{var1_1, rows > 0});
                }
                boolean bl2 = bl = rows > 0;
                if (statement == null) break block12;
                statement.close();
            }
            if (connection == null) break block13;
            connection.close();
        }
        return bl;
        {
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            void var3_5;
                            var3_5.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    if (connection != null) {
                        try {
                            void var2_4;
                            var2_4.close();
                        }
                        catch (Throwable throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                    }
                    throw throwable3;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doStore(String id, SessionData data, long lastSaveTime) throws Exception {
        void var2_2;
        void var1_1;
        void var3_3;
        if (data == null || id == null) {
            return;
        }
        if (var3_3 <= 0L) {
            this.doInsert(id, data);
            return;
        }
        this.doUpdate((String)var1_1, (SessionData)var2_2);
    }

    /*
     * Unable to fully structure code
     */
    protected void doInsert(String id, SessionData data) throws Exception {
        s = this._sessionTableSchema.getInsertSessionStatementAsString();
        connection = this._dbAdaptor.getConnection();
        try {
            connection.setAutoCommit(true);
            statement = connection.prepareStatement(s);
            try {
                statement.setString(1, id);
                cp = this._context.getCanonicalContextPath();
                if (this._dbAdaptor.isEmptyStringNull() && StringUtil.isBlank((String)cp)) {
                    cp = "/";
                }
                statement.setString(2, cp);
                statement.setString(3, this._context.getVhost());
                statement.setString(4, data.getLastNode());
                statement.setLong(5, data.getAccessed());
                statement.setLong(6, data.getLastAccessed());
                statement.setLong(7, data.getCreated());
                statement.setLong(8, data.getCookieSet());
                statement.setLong(9, data.getLastSaved());
                statement.setLong(10, data.getExpiry());
                statement.setLong(11, data.getMaxInactiveMs());
                baos = new ByteArrayOutputStream();
                try {
                    oos = new ObjectOutputStream(baos);
                    try {
                        SessionData.serializeAttributes(data, oos);
                        bytes = baos.toByteArray();
                        bais = new ByteArrayInputStream(bytes);
                        statement.setBinaryStream(12, (InputStream)bais, bytes.length);
                    }
                    catch (Throwable var6_12) {
                        try {
                            var1_1.close();
                        }
                        catch (Throwable var7_15) {
                            var6_12.addSuppressed(var7_15);
                        }
                        throw var6_12;
                    }
                    oos.close();
                }
                finally {
                    baos.close();
                }
                statement.executeUpdate();
                if (JDBCSessionDataStore.LOG.isDebugEnabled()) {
                    JDBCSessionDataStore.LOG.debug("Inserted session " + var2_5, new Object[0]);
                }
                ** if (statement == null) goto lbl-1000
            }
            catch (Throwable var1_3) {
                if (statement != null) {
                    try {
                        var3_6.close();
                    }
                    catch (Throwable var5_10) {
                        var1_3.addSuppressed(var5_10);
                    }
                }
                throw var1_3;
            }
lbl-1000:
            // 1 sources

            {
                statement.close();
            }
lbl-1000:
            // 2 sources

            {
            }
            ** if (connection == null) goto lbl-1000
        }
        catch (Throwable var3_7) {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Throwable var1_4) {
                    var3_7.addSuppressed(var1_4);
                }
            }
            throw var3_7;
        }
lbl-1000:
        // 1 sources

        {
            connection.close();
            return;
        }
lbl-1000:
        // 1 sources

        {
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doUpdate(String id, SessionData data) throws Exception {
        Connection connection = this._dbAdaptor.getConnection();
        try {
            block25: {
                connection.setAutoCommit(true);
                PreparedStatement statement = this._sessionTableSchema.getUpdateSessionStatement(connection, data.getId(), this._context);
                try {
                    statement.setString(1, data.getLastNode());
                    statement.setLong(2, data.getAccessed());
                    statement.setLong(3, data.getLastAccessed());
                    statement.setLong(4, data.getLastSaved());
                    statement.setLong(5, data.getExpiry());
                    statement.setLong(6, data.getMaxInactiveMs());
                    try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                         ObjectOutputStream oos = new ObjectOutputStream(baos);){
                        SessionData.serializeAttributes(data, oos);
                        byte[] bytes = baos.toByteArray();
                        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
                            statement.setBinaryStream(7, (InputStream)bais, bytes.length);
                        }
                    }
                    statement.executeUpdate();
                    if (LOG.isDebugEnabled()) {
                        void var2_2;
                        LOG.debug("Updated session " + var2_2, new Object[0]);
                    }
                    if (statement == null) break block25;
                }
                catch (Throwable throwable) {
                    if (statement == null) throw throwable;
                    try {
                        void var3_4;
                        var3_4.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                statement.close();
            }
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            if (connection == null) throw throwable;
            try {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
            catch (Throwable throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        connection.close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<String> doGetExpired(Set<String> candidates) {
        HashSet<String> hashSet;
        block56: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Getting expired sessions at time {}", System.currentTimeMillis());
            }
            long now = System.currentTimeMillis();
            HashSet<String> expiredSessionKeys = new HashSet<String>();
            Connection connection = this._dbAdaptor.getConnection();
            try {
                String sessionId;
                connection.setAutoCommit(true);
                long upperBound = now;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}- Pass 1: Searching for sessions for context {} managed by me and expired before {}", new Object[]{this._context.getWorkerName(), this._context.getCanonicalContextPath(), upperBound});
                }
                try (PreparedStatement statement = this._sessionTableSchema.getExpiredSessionsStatement(connection, this._context.getCanonicalContextPath(), this._context.getVhost(), upperBound);
                     ResultSet result = statement.executeQuery();){
                    while (result.next()) {
                        sessionId = result.getString(this._sessionTableSchema.getIdColumn());
                        result.getLong(this._sessionTableSchema.getExpiryTimeColumn());
                        expiredSessionKeys.add(sessionId);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug(this._context.getCanonicalContextPath() + "- Found expired sessionId=" + sessionId, new Object[0]);
                    }
                }
                try (PreparedStatement selectExpiredSessions = this._sessionTableSchema.getAllAncientExpiredSessionsStatement(connection);){
                    long result = this._lastExpiryCheckTime <= 0L ? now - 3L * (1000L * (long)this._gracePeriodSec) : this._lastExpiryCheckTime - 1000L * (long)this._gracePeriodSec;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{}- Pass 2: Searching for sessions expired before {}", new Object[]{this._context.getWorkerName(), result});
                    }
                    selectExpiredSessions.setLong(1, result);
                    try (ResultSet result2 = selectExpiredSessions.executeQuery();){
                        while (result2.next()) {
                            sessionId = result2.getString(this._sessionTableSchema.getIdColumn());
                            result2.getString(this._sessionTableSchema.getContextPathColumn());
                            result2.getString(this._sessionTableSchema.getVirtualHostColumn());
                            expiredSessionKeys.add(sessionId);
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug("{}- Found expired sessionId=", new Object[]{this._context.getWorkerName(), sessionId});
                        }
                    }
                }
                HashSet<String> notExpiredInDB = new HashSet<String>();
                for (String k : candidates) {
                    if (expiredSessionKeys.contains(k)) continue;
                    notExpiredInDB.add(k);
                }
                if (!notExpiredInDB.isEmpty()) {
                    try (PreparedStatement checkSessionExists = this._sessionTableSchema.getCheckSessionExistsStatement(connection, this._context);){
                        for (String k : notExpiredInDB) {
                            checkSessionExists.setString(1, k);
                            try {
                                ResultSet result = checkSessionExists.executeQuery();
                                try {
                                    if (result.next()) continue;
                                    expiredSessionKeys.add(k);
                                }
                                finally {
                                    if (result == null) continue;
                                    result.close();
                                }
                            }
                            catch (Exception e) {
                                void var2_8;
                                void var1_1;
                                LOG.warn("{} Problem checking if potentially expired session {} exists in db", new Object[]{this._context.getWorkerName(), var1_1});
                                LOG.warn((Throwable)var2_8);
                            }
                        }
                    }
                }
                hashSet = expiredSessionKeys;
                if (connection == null) break block56;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                    return expiredSessionKeys;
                }
            }
            connection.close();
        }
        return hashSet;
    }

    /*
     * WARNING - void declaration
     */
    public void setDatabaseAdaptor(DatabaseAdaptor dbAdaptor) {
        void var1_1;
        this.checkStarted();
        JDBCSessionDataStore jDBCSessionDataStore = this;
        jDBCSessionDataStore.updateBean(jDBCSessionDataStore._dbAdaptor, dbAdaptor);
        this._dbAdaptor = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setSessionTableSchema(SessionTableSchema schema) {
        void var1_1;
        this.checkStarted();
        JDBCSessionDataStore jDBCSessionDataStore = this;
        jDBCSessionDataStore.updateBean(jDBCSessionDataStore._sessionTableSchema, schema);
        this._sessionTableSchema = var1_1;
        this._schemaProvided = true;
    }

    @Override
    @ManagedAttribute(value="does this store serialize sessions", readonly=true)
    public boolean isPassivating() {
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean exists(String id) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class SessionTableSchema {
        public static final int MAX_INTERVAL_NOT_SET = -999;
        public static final String INFERRED = "INFERRED";
        protected DatabaseAdaptor _dbAdaptor;
        protected String _schemaName = null;
        protected String _catalogName = null;
        protected String _tableName = "JettySessions";
        protected String _idColumn = "sessionId";
        protected String _contextPathColumn = "contextPath";
        protected String _virtualHostColumn = "virtualHost";
        protected String _lastNodeColumn = "lastNode";
        protected String _accessTimeColumn = "accessTime";
        protected String _lastAccessTimeColumn = "lastAccessTime";
        protected String _createTimeColumn = "createTime";
        protected String _cookieTimeColumn = "cookieTime";
        protected String _lastSavedTimeColumn = "lastSavedTime";
        protected String _expiryTimeColumn = "expiryTime";
        protected String _maxIntervalColumn = "maxInterval";
        protected String _mapColumn = "map";

        /*
         * WARNING - void declaration
         */
        protected void setDatabaseAdaptor(DatabaseAdaptor dbadaptor) {
            void var1_1;
            this._dbAdaptor = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void setCatalogName(String catalogName) {
            void var1_1;
            if (catalogName != null && StringUtil.isBlank((String)catalogName)) {
                this._catalogName = null;
                return;
            }
            this._catalogName = var1_1;
        }

        public String getCatalogName() {
            return this._catalogName;
        }

        public String getSchemaName() {
            return this._schemaName;
        }

        /*
         * WARNING - void declaration
         */
        public void setSchemaName(String schemaName) {
            void var1_1;
            if (schemaName != null && StringUtil.isBlank((String)schemaName)) {
                this._schemaName = null;
                return;
            }
            this._schemaName = var1_1;
        }

        public String getTableName() {
            return this._tableName;
        }

        /*
         * WARNING - void declaration
         */
        public void setTableName(String tableName) {
            void var1_1;
            this.checkNotNull(tableName);
            this._tableName = var1_1;
        }

        private String getSchemaTableName() {
            return (this.getSchemaName() != null ? this.getSchemaName() + "." : "") + this.getTableName();
        }

        public String getIdColumn() {
            return this._idColumn;
        }

        /*
         * WARNING - void declaration
         */
        public void setIdColumn(String idColumn) {
            void var1_1;
            this.checkNotNull(idColumn);
            this._idColumn = var1_1;
        }

        public String getContextPathColumn() {
            return this._contextPathColumn;
        }

        /*
         * WARNING - void declaration
         */
        public void setContextPathColumn(String contextPathColumn) {
            void var1_1;
            this.checkNotNull(contextPathColumn);
            this._contextPathColumn = var1_1;
        }

        public String getVirtualHostColumn() {
            return this._virtualHostColumn;
        }

        /*
         * WARNING - void declaration
         */
        public void setVirtualHostColumn(String virtualHostColumn) {
            void var1_1;
            this.checkNotNull(virtualHostColumn);
            this._virtualHostColumn = var1_1;
        }

        public String getLastNodeColumn() {
            return this._lastNodeColumn;
        }

        /*
         * WARNING - void declaration
         */
        public void setLastNodeColumn(String lastNodeColumn) {
            void var1_1;
            this.checkNotNull(lastNodeColumn);
            this._lastNodeColumn = var1_1;
        }

        public String getAccessTimeColumn() {
            return this._accessTimeColumn;
        }

        /*
         * WARNING - void declaration
         */
        public void setAccessTimeColumn(String accessTimeColumn) {
            void var1_1;
            this.checkNotNull(accessTimeColumn);
            this._accessTimeColumn = var1_1;
        }

        public String getLastAccessTimeColumn() {
            return this._lastAccessTimeColumn;
        }

        /*
         * WARNING - void declaration
         */
        public void setLastAccessTimeColumn(String lastAccessTimeColumn) {
            void var1_1;
            this.checkNotNull(lastAccessTimeColumn);
            this._lastAccessTimeColumn = var1_1;
        }

        public String getCreateTimeColumn() {
            return this._createTimeColumn;
        }

        /*
         * WARNING - void declaration
         */
        public void setCreateTimeColumn(String createTimeColumn) {
            void var1_1;
            this.checkNotNull(createTimeColumn);
            this._createTimeColumn = var1_1;
        }

        public String getCookieTimeColumn() {
            return this._cookieTimeColumn;
        }

        /*
         * WARNING - void declaration
         */
        public void setCookieTimeColumn(String cookieTimeColumn) {
            void var1_1;
            this.checkNotNull(cookieTimeColumn);
            this._cookieTimeColumn = var1_1;
        }

        public String getLastSavedTimeColumn() {
            return this._lastSavedTimeColumn;
        }

        /*
         * WARNING - void declaration
         */
        public void setLastSavedTimeColumn(String lastSavedTimeColumn) {
            void var1_1;
            this.checkNotNull(lastSavedTimeColumn);
            this._lastSavedTimeColumn = var1_1;
        }

        public String getExpiryTimeColumn() {
            return this._expiryTimeColumn;
        }

        /*
         * WARNING - void declaration
         */
        public void setExpiryTimeColumn(String expiryTimeColumn) {
            void var1_1;
            this.checkNotNull(expiryTimeColumn);
            this._expiryTimeColumn = var1_1;
        }

        public String getMaxIntervalColumn() {
            return this._maxIntervalColumn;
        }

        /*
         * WARNING - void declaration
         */
        public void setMaxIntervalColumn(String maxIntervalColumn) {
            void var1_1;
            this.checkNotNull(maxIntervalColumn);
            this._maxIntervalColumn = var1_1;
        }

        public String getMapColumn() {
            return this._mapColumn;
        }

        /*
         * WARNING - void declaration
         */
        public void setMapColumn(String mapColumn) {
            void var1_1;
            this.checkNotNull(mapColumn);
            this._mapColumn = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public String getCreateStatementAsString() {
            void var1_1;
            void var2_2;
            void var3_3;
            if (this._dbAdaptor == null) {
                throw new IllegalStateException("No DBAdaptor");
            }
            String blobType = this._dbAdaptor.getBlobType();
            String longType = this._dbAdaptor.getLongType();
            String stringType = this._dbAdaptor.getStringType();
            return "create table " + this._tableName + " (" + this._idColumn + " " + stringType + "(120), " + this._contextPathColumn + " " + stringType + "(60), " + this._virtualHostColumn + " " + stringType + "(60), " + this._lastNodeColumn + " " + (String)var3_3 + "(60), " + this._accessTimeColumn + " " + longType + ", " + this._lastAccessTimeColumn + " " + longType + ", " + this._createTimeColumn + " " + longType + ", " + this._cookieTimeColumn + " " + longType + ", " + this._lastSavedTimeColumn + " " + longType + ", " + this._expiryTimeColumn + " " + longType + ", " + this._maxIntervalColumn + " " + (String)var2_2 + ", " + this._mapColumn + " " + (String)var1_1 + ", primary key(" + this._idColumn + ", " + this._contextPathColumn + "," + this._virtualHostColumn + "))";
        }

        /*
         * WARNING - void declaration
         */
        public String getCreateIndexOverExpiryStatementAsString(String indexName) {
            void var1_1;
            return "create index " + (String)var1_1 + " on " + this.getSchemaTableName() + " (" + this.getExpiryTimeColumn() + ")";
        }

        /*
         * WARNING - void declaration
         */
        public String getCreateIndexOverSessionStatementAsString(String indexName) {
            void var1_1;
            return "create index " + (String)var1_1 + " on " + this.getSchemaTableName() + " (" + this.getIdColumn() + ", " + this.getContextPathColumn() + ")";
        }

        /*
         * WARNING - void declaration
         */
        public String getAlterTableForMaxIntervalAsString() {
            void var1_1;
            if (this._dbAdaptor == null) {
                throw new IllegalStateException("No DBAdaptor");
            }
            String longType = this._dbAdaptor.getLongType();
            String stem = "alter table " + this.getSchemaTableName() + " add " + this.getMaxIntervalColumn() + " " + longType;
            if (this._dbAdaptor.getDBName().contains("oracle")) {
                return stem + " default -999" + " not null";
            }
            return (String)var1_1 + " not null default -999";
        }

        /*
         * WARNING - void declaration
         */
        private void checkNotNull(String s) {
            if (s == null) {
                void var1_1;
                throw new IllegalArgumentException((String)var1_1);
            }
        }

        public String getInsertSessionStatementAsString() {
            return "insert into " + this.getSchemaTableName() + " (" + this.getIdColumn() + ", " + this.getContextPathColumn() + ", " + this.getVirtualHostColumn() + ", " + this.getLastNodeColumn() + ", " + this.getAccessTimeColumn() + ", " + this.getLastAccessTimeColumn() + ", " + this.getCreateTimeColumn() + ", " + this.getCookieTimeColumn() + ", " + this.getLastSavedTimeColumn() + ", " + this.getExpiryTimeColumn() + ", " + this.getMaxIntervalColumn() + ", " + this.getMapColumn() + ")  values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        }

        /*
         * WARNING - void declaration
         */
        public PreparedStatement getUpdateSessionStatement(Connection connection, String id, SessionContext context) throws SQLException {
            void var1_1;
            void var3_3;
            void var2_2;
            String s = "update " + this.getSchemaTableName() + " set " + this.getLastNodeColumn() + " = ?, " + this.getAccessTimeColumn() + " = ?, " + this.getLastAccessTimeColumn() + " = ?, " + this.getLastSavedTimeColumn() + " = ?, " + this.getExpiryTimeColumn() + " = ?, " + this.getMaxIntervalColumn() + " = ?, " + this.getMapColumn() + " = ? where " + this.getIdColumn() + " = ? and " + this.getContextPathColumn() + " = ? and " + this.getVirtualHostColumn() + " = ?";
            String cp = context.getCanonicalContextPath();
            if (this._dbAdaptor.isEmptyStringNull() && StringUtil.isBlank((String)cp)) {
                cp = JDBCSessionDataStore.NULL_CONTEXT_PATH;
            }
            PreparedStatement statement = connection.prepareStatement(s);
            statement.setString(8, (String)var2_2);
            statement.setString(9, cp);
            statement.setString(10, var3_3.getVhost());
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public PreparedStatement getExpiredSessionsStatement(Connection connection, String canonicalContextPath, String vhost, long expiry) throws SQLException {
            void var1_1;
            void var3_3;
            void var2_2;
            String cp;
            if (this._dbAdaptor == null) {
                throw new IllegalStateException("No DB adaptor");
            }
            if (this._dbAdaptor.isEmptyStringNull() && StringUtil.isBlank((String)cp)) {
                cp = JDBCSessionDataStore.NULL_CONTEXT_PATH;
            }
            PreparedStatement statement = connection.prepareStatement("select " + this.getIdColumn() + ", " + this.getExpiryTimeColumn() + " from " + this.getSchemaTableName() + " where " + this.getContextPathColumn() + " = ? and " + this.getVirtualHostColumn() + " = ? and " + this.getExpiryTimeColumn() + " >0 and " + this.getExpiryTimeColumn() + " <= ?");
            statement.setString(1, (String)var2_2);
            statement.setString(2, (String)var3_3);
            statement.setLong(3, expiry);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public PreparedStatement getMyExpiredSessionsStatement(Connection connection, SessionContext sessionContext, long expiry) throws SQLException {
            void var1_1;
            void var3_3;
            void var2_2;
            if (this._dbAdaptor == null) {
                throw new IllegalStateException("No DB adaptor");
            }
            String cp = sessionContext.getCanonicalContextPath();
            if (this._dbAdaptor.isEmptyStringNull() && StringUtil.isBlank((String)cp)) {
                cp = JDBCSessionDataStore.NULL_CONTEXT_PATH;
            }
            PreparedStatement statement = connection.prepareStatement("select " + this.getIdColumn() + ", " + this.getExpiryTimeColumn() + " from " + this.getSchemaTableName() + " where " + this.getLastNodeColumn() + " = ? and " + this.getContextPathColumn() + " = ? and " + this.getVirtualHostColumn() + " = ? and " + this.getExpiryTimeColumn() + " >0 and " + this.getExpiryTimeColumn() + " <= ?");
            statement.setString(1, sessionContext.getWorkerName());
            statement.setString(2, cp);
            statement.setString(3, var2_2.getVhost());
            statement.setLong(4, (long)var3_3);
            return var1_1;
        }

        public PreparedStatement getAllAncientExpiredSessionsStatement(Connection connection) throws SQLException {
            PreparedStatement preparedStatement;
            if (this._dbAdaptor == null) {
                throw new IllegalStateException("No DB adaptor");
            }
            preparedStatement = preparedStatement.prepareStatement("select " + this.getIdColumn() + ", " + this.getContextPathColumn() + ", " + this.getVirtualHostColumn() + " from " + this.getSchemaTableName() + " where " + this.getExpiryTimeColumn() + " >0 and " + this.getExpiryTimeColumn() + " <= ?");
            return preparedStatement;
        }

        /*
         * WARNING - void declaration
         */
        public PreparedStatement getCheckSessionExistsStatement(Connection connection, SessionContext context) throws SQLException {
            void var1_1;
            void var2_2;
            void var3_3;
            if (this._dbAdaptor == null) {
                throw new IllegalStateException("No DB adaptor");
            }
            String cp = context.getCanonicalContextPath();
            if (this._dbAdaptor.isEmptyStringNull() && StringUtil.isBlank((String)cp)) {
                cp = JDBCSessionDataStore.NULL_CONTEXT_PATH;
            }
            PreparedStatement statement = connection.prepareStatement("select " + this.getIdColumn() + ", " + this.getExpiryTimeColumn() + " from " + this.getSchemaTableName() + " where " + this.getIdColumn() + " = ? and " + this.getContextPathColumn() + " = ? and " + this.getVirtualHostColumn() + " = ?");
            statement.setString(2, (String)var3_3);
            statement.setString(3, var2_2.getVhost());
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public PreparedStatement getLoadStatement(Connection connection, String id, SessionContext contextId) throws SQLException {
            void var1_1;
            void var3_3;
            void var2_2;
            if (this._dbAdaptor == null) {
                throw new IllegalStateException("No DB adaptor");
            }
            String cp = contextId.getCanonicalContextPath();
            if (this._dbAdaptor.isEmptyStringNull() && StringUtil.isBlank((String)cp)) {
                cp = JDBCSessionDataStore.NULL_CONTEXT_PATH;
            }
            PreparedStatement statement = connection.prepareStatement("select * from " + this.getSchemaTableName() + " where " + this.getIdColumn() + " = ? and " + this.getContextPathColumn() + " = ? and " + this.getVirtualHostColumn() + " = ?");
            statement.setString(1, (String)var2_2);
            statement.setString(2, cp);
            statement.setString(3, var3_3.getVhost());
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public PreparedStatement getUpdateStatement(Connection connection, String id, SessionContext contextId) throws SQLException {
            void var1_1;
            void var3_3;
            void var2_2;
            if (this._dbAdaptor == null) {
                throw new IllegalStateException("No DB adaptor");
            }
            String cp = contextId.getCanonicalContextPath();
            if (this._dbAdaptor.isEmptyStringNull() && StringUtil.isBlank((String)cp)) {
                cp = JDBCSessionDataStore.NULL_CONTEXT_PATH;
            }
            String s = "update " + this.getSchemaTableName() + " set " + this.getLastNodeColumn() + " = ?, " + this.getAccessTimeColumn() + " = ?, " + this.getLastAccessTimeColumn() + " = ?, " + this.getLastSavedTimeColumn() + " = ?, " + this.getExpiryTimeColumn() + " = ?, " + this.getMaxIntervalColumn() + " = ?, " + this.getMapColumn() + " = ? where " + this.getIdColumn() + " = ? and " + this.getContextPathColumn() + " = ? and " + this.getVirtualHostColumn() + " = ?";
            PreparedStatement statement = connection.prepareStatement(s);
            statement.setString(8, (String)var2_2);
            statement.setString(9, cp);
            statement.setString(10, var3_3.getVhost());
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public PreparedStatement getDeleteStatement(Connection connection, String id, SessionContext contextId) throws Exception {
            void var1_1;
            void var3_3;
            void var2_2;
            if (this._dbAdaptor == null) {
                throw new IllegalStateException("No DB adaptor");
            }
            String cp = contextId.getCanonicalContextPath();
            if (this._dbAdaptor.isEmptyStringNull() && StringUtil.isBlank((String)cp)) {
                cp = JDBCSessionDataStore.NULL_CONTEXT_PATH;
            }
            PreparedStatement statement = connection.prepareStatement("delete from " + this.getSchemaTableName() + " where " + this.getIdColumn() + " = ? and " + this.getContextPathColumn() + " = ? and " + this.getVirtualHostColumn() + " = ?");
            statement.setString(1, (String)var2_2);
            statement.setString(2, cp);
            statement.setString(3, var3_3.getVhost());
            return var1_1;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void prepareTables() throws SQLException {
            ResultSet result;
            boolean index2Exists;
            boolean index1Exists;
            String index2;
            String index1;
            Statement statement;
            Connection connection = this._dbAdaptor.getConnection();
            try {
                statement = connection.createStatement();
                try {
                    String catalogName;
                    String schemaName;
                    String tableName;
                    DatabaseMetaData metaData;
                    block36: {
                        connection.setAutoCommit(true);
                        metaData = connection.getMetaData();
                        this._dbAdaptor.adaptTo(metaData);
                        tableName = this._dbAdaptor.convertIdentifier(this.getTableName());
                        schemaName = this._dbAdaptor.convertIdentifier(this.getSchemaName());
                        if (INFERRED.equalsIgnoreCase(schemaName)) {
                            schemaName = connection.getSchema();
                            this.setSchemaName(schemaName);
                        }
                        if (INFERRED.equalsIgnoreCase(catalogName = this._dbAdaptor.convertIdentifier(this.getCatalogName()))) {
                            catalogName = connection.getCatalog();
                            this.setCatalogName(catalogName);
                        }
                        try (ResultSet result2 = metaData.getTables(catalogName, schemaName, tableName, null);){
                            ResultSet colResult;
                            if (!result2.next()) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Creating table {} schema={} catalog={}", new Object[]{tableName, schemaName, catalogName});
                                }
                                statement.executeUpdate(this.getCreateStatementAsString());
                                break block36;
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Not creating table {} schema={} catalog={}", new Object[]{tableName, schemaName, catalogName});
                            }
                            try {
                                colResult = metaData.getColumns(catalogName, schemaName, tableName, this._dbAdaptor.convertIdentifier(this.getMaxIntervalColumn()));
                            }
                            catch (SQLException sqlEx) {
                                LOG.warn("Problem checking if {} table contains {} column. Ensure table contains column with definition: long not null default -999", new Object[]{this.getTableName(), this.getMaxIntervalColumn()});
                                throw sqlEx;
                            }
                            try {
                                if (colResult.next()) break block36;
                                try {
                                    statement.executeUpdate(this.getAlterTableForMaxIntervalAsString());
                                }
                                catch (SQLException sqlEx) {
                                    LOG.warn("Problem adding {} column. Ensure table contains column definition: long not null default -999", new Object[]{this.getMaxIntervalColumn()});
                                    throw sqlEx;
                                }
                            }
                            finally {
                                colResult.close();
                            }
                        }
                    }
                    index1 = "idx_" + this.getTableName() + "_expiry";
                    index2 = "idx_" + this.getTableName() + "_session";
                    index1Exists = false;
                    index2Exists = false;
                    result = metaData.getIndexInfo(catalogName, schemaName, tableName, false, true);
                    try {}
                    catch (Throwable throwable) {
                        if (result == null) throw throwable;
                        try {
                            void var3_4;
                            var3_4.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    if (statement == null) throw throwable;
                    try {
                        void var2_2;
                        var2_2.close();
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                if (connection == null) throw throwable;
                try {
                    void var1_1;
                    var1_1.close();
                    throw throwable;
                }
                catch (Throwable throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            while (result.next()) {
                String idxName = result.getString("INDEX_NAME");
                if (index1.equalsIgnoreCase(idxName)) {
                    index1Exists = true;
                    continue;
                }
                if (!index2.equalsIgnoreCase(idxName)) continue;
                index2Exists = true;
            }
            if (result != null) {
                result.close();
            }
            if (!index1Exists) {
                statement.executeUpdate(this.getCreateIndexOverExpiryStatementAsString(index1));
            }
            if (!index2Exists) {
                statement.executeUpdate(this.getCreateIndexOverSessionStatementAsString(index2));
            }
            if (statement != null) {
                statement.close();
            }
            if (connection == null) return;
            connection.close();
        }

        public String toString() {
            return String.format("%s[%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s]", super.toString(), this._catalogName, this._schemaName, this._tableName, this._idColumn, this._contextPathColumn, this._virtualHostColumn, this._cookieTimeColumn, this._createTimeColumn, this._expiryTimeColumn, this._accessTimeColumn, this._lastAccessTimeColumn, this._lastNodeColumn, this._lastSavedTimeColumn, this._maxIntervalColumn);
        }
    }
}

