/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;

@ManagedObject
public class HouseKeeper
extends AbstractLifeCycle {
    private static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.server.session");
    public static final long DEFAULT_PERIOD_MS = 600000L;
    protected SessionIdManager _sessionIdManager;
    protected Scheduler _scheduler;
    protected Scheduler.Task _task;
    protected Runner _runner;
    protected boolean _ownScheduler = false;
    private long _intervalMs = 600000L;

    /*
     * WARNING - void declaration
     */
    public void setSessionIdManager(SessionIdManager sessionIdManager) {
        void var1_1;
        if (this.isStarted()) {
            throw new IllegalStateException("HouseKeeper started");
        }
        this._sessionIdManager = var1_1;
    }

    protected void doStart() throws Exception {
        if (this._sessionIdManager == null) {
            throw new IllegalStateException("No SessionIdManager for Housekeeper");
        }
        HouseKeeper houseKeeper = this;
        houseKeeper.setIntervalSec(houseKeeper.getIntervalSec());
        super.doStart();
    }

    protected void startScavenging() throws Exception {
        HouseKeeper houseKeeper = this;
        synchronized (houseKeeper) {
            if (this._scheduler == null) {
                if (this._sessionIdManager instanceof DefaultSessionIdManager) {
                    this._scheduler = (Scheduler)((DefaultSessionIdManager)this._sessionIdManager).getServer().getBean(Scheduler.class);
                }
                if (this._scheduler == null) {
                    this._scheduler = new ScheduledExecutorScheduler(String.format("Session-HouseKeeper-%x", ((Object)((Object)this)).hashCode()), false);
                    this._ownScheduler = true;
                    this._scheduler.start();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Using own scheduler for scavenging", new Object[0]);
                    }
                } else if (!this._scheduler.isStarted()) {
                    throw new IllegalStateException("Shared scheduler not started");
                }
            }
            if (this._task != null) {
                this._task.cancel();
            }
            if (this._runner == null) {
                this._runner = new Runner(this);
            }
            LOG.info("{} Scavenging every {}ms", new Object[]{this._sessionIdManager.getWorkerName(), this._intervalMs});
            this._task = this._scheduler.schedule((Runnable)this._runner, this._intervalMs, TimeUnit.MILLISECONDS);
            return;
        }
    }

    protected void stopScavenging() throws Exception {
        HouseKeeper houseKeeper = this;
        synchronized (houseKeeper) {
            if (this._task != null) {
                this._task.cancel();
                LOG.info("{} Stopped scavenging", new Object[]{this._sessionIdManager.getWorkerName()});
            }
            this._task = null;
            if (this._ownScheduler && this._scheduler != null) {
                this._ownScheduler = false;
                this._scheduler.stop();
                this._scheduler = null;
            }
            this._runner = null;
            return;
        }
    }

    protected void doStop() throws Exception {
        HouseKeeper houseKeeper = this;
        synchronized (houseKeeper) {
            this.stopScavenging();
            this._scheduler = null;
        }
        super.doStop();
    }

    /*
     * WARNING - void declaration
     */
    public void setIntervalSec(long sec) throws Exception {
        HouseKeeper houseKeeper = this;
        synchronized (houseKeeper) {
            if (this.isStarted() || this.isStarting()) {
                if (sec <= 0L) {
                    this._intervalMs = 0L;
                    LOG.info("{} Scavenging disabled", new Object[]{this._sessionIdManager.getWorkerName()});
                    this.stopScavenging();
                } else {
                    if (sec < 10L) {
                        LOG.warn("{} Short interval of {}sec for session scavenging.", new Object[]{this._sessionIdManager.getWorkerName(), sec});
                    }
                    this._intervalMs = sec * 1000L;
                    long tenPercent = this._intervalMs / 10L;
                    if (System.currentTimeMillis() % 2L == 0L) {
                        this._intervalMs += tenPercent;
                    }
                    if (this.isStarting() || this.isStarted()) {
                        this.startScavenging();
                    }
                }
            } else {
                void var1_1;
                this._intervalMs = var1_1 * 1000L;
            }
            return;
        }
    }

    @ManagedAttribute(value="secs between scavenge cycles", readonly=true)
    public long getIntervalSec() {
        HouseKeeper houseKeeper = this;
        synchronized (houseKeeper) {
            return this._intervalMs / 1000L;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void scavenge() {
        if (this.isStopping() || this.isStopped()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} scavenging sessions", new Object[]{this._sessionIdManager.getWorkerName()});
        }
        for (SessionHandler manager : this._sessionIdManager.getSessionHandlers()) {
            if (manager == null) continue;
            try {
                manager.scavenge();
            }
            catch (Exception e) {
                void var2_3;
                LOG.warn((Throwable)var2_3);
            }
        }
    }

    public String toString() {
        HouseKeeper houseKeeper = this;
        synchronized (houseKeeper) {
            return super.toString() + "[interval=" + this._intervalMs + ", ownscheduler=" + this._ownScheduler + "]";
        }
    }

    protected class Runner
    implements Runnable {
        final /* synthetic */ HouseKeeper this$0;

        /*
         * WARNING - void declaration
         */
        protected Runner(HouseKeeper this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public void run() {
            HouseKeeper houseKeeper;
            try {
                this.this$0.scavenge();
                houseKeeper = this.this$0;
            }
            catch (Throwable throwable) {
                HouseKeeper houseKeeper2 = this.this$0;
                synchronized (houseKeeper2) {
                    if (this.this$0._scheduler != null && this.this$0._scheduler.isRunning()) {
                        Runner runner = this;
                        this.this$0._task = this.this$0._scheduler.schedule((Runnable)runner, runner.this$0._intervalMs, TimeUnit.MILLISECONDS);
                    }
                }
                throw throwable;
            }
            synchronized (houseKeeper) {
                if (this.this$0._scheduler != null && this.this$0._scheduler.isRunning()) {
                    Runner runner = this;
                    this.this$0._task = this.this$0._scheduler.schedule((Runnable)runner, runner.this$0._intervalMs, TimeUnit.MILLISECONDS);
                }
            }
        }
    }
}

