/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.eclipse.jetty.server.session.AbstractSessionDataStore;
import org.eclipse.jetty.server.session.SessionContext;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.server.session.UnreadableSessionDataException;
import org.eclipse.jetty.server.session.UnwriteableSessionDataException;
import org.eclipse.jetty.util.ClassLoadingObjectInputStream;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject
public class FileSessionDataStore
extends AbstractSessionDataStore {
    private static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.server.session");
    protected File _storeDir;
    protected boolean _deleteUnrestorableFiles = false;
    protected Map<String, String> _sessionFileMap = new ConcurrentHashMap<String, String>();
    protected String _contextString;
    protected long _lastSweepTime = 0L;

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize(SessionContext context) throws Exception {
        void var1_1;
        super.initialize((SessionContext)var1_1);
        this._contextString = this._context.getCanonicalContextPath() + "_" + this._context.getVhost();
    }

    @Override
    protected void doStart() throws Exception {
        this.initializeStore();
        super.doStart();
    }

    protected void doStop() throws Exception {
        this._sessionFileMap.clear();
        this._lastSweepTime = 0L;
        super.doStop();
    }

    @ManagedAttribute(value="dir where sessions are stored", readonly=true)
    public File getStoreDir() {
        return this._storeDir;
    }

    /*
     * WARNING - void declaration
     */
    public void setStoreDir(File storeDir) {
        void var1_1;
        this.checkStarted();
        this._storeDir = var1_1;
    }

    public boolean isDeleteUnrestorableFiles() {
        return this._deleteUnrestorableFiles;
    }

    /*
     * WARNING - void declaration
     */
    public void setDeleteUnrestorableFiles(boolean deleteUnrestorableFiles) {
        void var1_1;
        this.checkStarted();
        this._deleteUnrestorableFiles = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean delete(String id) throws Exception {
        if (this._storeDir != null) {
            void var1_1;
            String filename = this._sessionFileMap.remove(this.getIdWithContext(id));
            if (filename == null) {
                return false;
            }
            return this.deleteFile((String)var1_1);
        }
        return false;
    }

    public boolean deleteFile(String filename) throws Exception {
        File file;
        if (filename == null) {
            return false;
        }
        file = new File(this._storeDir, (String)((Object)file));
        return Files.deleteIfExists(file.toPath());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<String> doGetExpired(Set<String> candidates) {
        void var1_1;
        long now = System.currentTimeMillis();
        HashSet<String> expired = new HashSet<String>();
        for (String filename : this._sessionFileMap.values()) {
            try {
                long expiry = this.getExpiryFromFilename(filename);
                if (expiry <= 0L || expiry >= now) continue;
                expired.add(this.getIdFromFilename(filename));
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
        for (String c : var1_1) {
            String string;
            if (expired.contains(c) || (string = this._sessionFileMap.get(this.getIdWithContext(c))) != null) continue;
            expired.add(c);
        }
        if (this._gracePeriodSec > 0 && (this._lastSweepTime == 0L || now - this._lastSweepTime >= 5L * TimeUnit.SECONDS.toMillis(this._gracePeriodSec))) {
            void var2_2;
            this._lastSweepTime = var2_2;
            this.sweepDisk();
        }
        return expired;
    }

    /*
     * WARNING - void declaration
     */
    public void sweepDisk() {
        long now = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sweeping {} for old session files", new Object[]{this._storeDir});
        }
        try {
            Stream<Path> stream;
            block9: {
                block8: {
                    stream = Files.walk(this._storeDir.toPath(), 1, FileVisitOption.FOLLOW_LINKS);
                    try {
                        void var1_1;
                        stream.filter(p -> !Files.isDirectory(p, new LinkOption[0])).filter(p -> {
                            void var1_1;
                            return !this.isOurContextSessionFilename(var1_1.getFileName().toString());
                        }).filter(p -> {
                            void var1_1;
                            return this.isSessionFilename(var1_1.getFileName().toString());
                        }).forEach(arg_0 -> this.lambda$sweepDisk$3((long)var1_1, arg_0));
                        if (stream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    break block9;
                }
                return;
            }
            stream.close();
        }
        catch (Exception e) {
            void var3_4;
            LOG.warn((Throwable)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void sweepFile(long now, Path p) {
        block9: {
            if (p != null) {
                try {
                    block8: {
                        long expiry = this.getExpiryFromFilename(p.getFileName().toString());
                        if (expiry > 0L && now - expiry >= 5L * TimeUnit.SECONDS.toMillis(this._gracePeriodSec)) {
                            try {
                                if (!Files.deleteIfExists(p)) {
                                    LOG.warn("Could not delete {}", new Object[]{p.getFileName()});
                                    break block8;
                                }
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Deleted {}", new Object[]{p.getFileName()});
                                }
                                break block9;
                            }
                            catch (IOException e) {
                                void var1_2;
                                LOG.warn("Could not delete {}", new Object[]{p.getFileName(), var1_2});
                            }
                        }
                    }
                    return;
                }
                catch (NumberFormatException e) {
                    void var3_3;
                    LOG.warn("Not valid session filename {}", new Object[]{var3_3.getFileName()});
                    LOG.warn((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SessionData doLoad(String id) throws Exception {
        SessionData sessionData;
        String idWithContext = this.getIdWithContext(id);
        String filename = this._sessionFileMap.get(idWithContext);
        if (filename == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unknown file {}", new Object[]{idWithContext});
            }
            return null;
        }
        File file = new File(this._storeDir, filename);
        if (!file.exists()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No such file {}", new Object[]{filename});
            }
            return null;
        }
        FileInputStream in = new FileInputStream(file);
        try {
            SessionData data = this.load(in, id);
            data.setLastSaved(file.lastModified());
            sessionData = data;
        }
        catch (Throwable data) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable) {
                    data.addSuppressed(throwable);
                }
                throw data;
            }
            catch (UnreadableSessionDataException e) {
                void var2_2;
                if (this.isDeleteUnrestorableFiles() && file.exists() && var2_2.getParentFile().equals(this._storeDir)) {
                    try {
                        this.delete(id);
                        LOG.warn("Deleted unrestorable file for session {}", new Object[]{id});
                    }
                    catch (Exception x) {
                        void var1_1;
                        void var3_3;
                        LOG.warn("Unable to delete unrestorable file {} for session {}", new Object[]{var3_3, var1_1});
                        LOG.warn((Throwable)x);
                    }
                }
                throw e;
            }
        }
        in.close();
        return sessionData;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doStore(String id, SessionData data, long lastSaveTime) throws Exception {
        if (this._storeDir != null) {
            this.delete(id);
            String filename = this.getIdWithContextAndExpiry(data);
            String idWithContext = this.getIdWithContext(id);
            File file = new File(this._storeDir, filename);
            try (FileOutputStream fos = new FileOutputStream(file, false);){
                void var2_2;
                this.save(fos, id, (SessionData)var2_2);
                this._sessionFileMap.put(idWithContext, filename);
            }
            catch (Exception e) {
                void var1_1;
                if (!file.delete()) {
                    void var3_5;
                    e.addSuppressed(new IOException("Could not delete " + var3_5));
                }
                throw new UnwriteableSessionDataException((String)var1_1, this._context, e);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initializeStore() throws Exception {
        if (this._storeDir == null) {
            throw new IllegalStateException("No file store specified");
        }
        if (!this._storeDir.exists()) {
            if (this._storeDir.mkdirs()) return;
            throw new IllegalStateException("Could not create " + this._storeDir);
        }
        if (!(this._storeDir.isDirectory() && this._storeDir.canWrite() && this._storeDir.canRead())) {
            throw new IllegalStateException(this._storeDir.getAbsolutePath() + " must be readable/writeable dir");
        }
        MultiException me = new MultiException();
        long now = System.currentTimeMillis();
        try (Stream<Path> stream = Files.walk(this._storeDir.toPath(), 1, FileVisitOption.FOLLOW_LINKS);){
            void var1_1;
            void var2_3;
            stream.filter(p -> !Files.isDirectory(p, new LinkOption[0])).filter(p -> {
                void var1_1;
                return this.isSessionFilename(var1_1.getFileName().toString());
            }).forEach(arg_0 -> this.lambda$initializeStore$6((long)var2_3, me, arg_0));
            var1_1.ifExceptionThrow();
            if (stream == null) return;
        }
    }

    @Override
    @ManagedAttribute(value="are sessions serialized by this store", readonly=true)
    public boolean isPassivating() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean exists(String id) throws Exception {
        void var1_1;
        String idWithContext = this.getIdWithContext(id);
        String filename = this._sessionFileMap.get(idWithContext);
        if (filename == null) {
            return false;
        }
        long expiry = this.getExpiryFromFilename((String)var1_1);
        if (expiry <= 0L) {
            return true;
        }
        return expiry > System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    protected void save(OutputStream os, String id, SessionData data) throws IOException {
        void var1_1;
        void var3_3;
        void var2_2;
        DataOutputStream out = new DataOutputStream(os);
        out.writeUTF((String)var2_2);
        out.writeUTF(this._context.getCanonicalContextPath());
        out.writeUTF(this._context.getVhost());
        out.writeUTF(data.getLastNode());
        out.writeLong(data.getCreated());
        out.writeLong(data.getAccessed());
        out.writeLong(data.getLastAccessed());
        out.writeLong(data.getCookieSet());
        out.writeLong(data.getExpiry());
        out.writeLong(data.getMaxInactiveMs());
        ObjectOutputStream oos = new ObjectOutputStream(out);
        SessionData.serializeAttributes((SessionData)var3_3, (ObjectOutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected String getIdWithContext(String id) {
        void var1_1;
        return this._contextString + "_" + (String)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected String getIdWithContextAndExpiry(SessionData data) {
        void var1_1;
        return data.getExpiry() + "_" + this.getIdWithContext(var1_1.getId());
    }

    /*
     * WARNING - void declaration
     */
    protected String getIdFromFilename(String filename) {
        void var1_1;
        if (filename == null) {
            return null;
        }
        void v0 = var1_1;
        return v0.substring(v0.lastIndexOf(95) + 1);
    }

    protected long getExpiryFromFilename(String filename) {
        String string;
        if (StringUtil.isBlank((String)filename) || !filename.contains("_")) {
            throw new IllegalStateException("Invalid or missing filename");
        }
        string = filename.substring(0, string.indexOf(95));
        return Long.parseLong(string);
    }

    /*
     * WARNING - void declaration
     */
    protected String getContextFromFilename(String filename) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (StringUtil.isBlank((String)filename)) {
            return null;
        }
        int start = filename.indexOf(95);
        int end = filename.lastIndexOf(95);
        return var1_1.substring((int)(var2_2 + true), (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected String getIdWithContextFromFilename(String filename) {
        void var1_1;
        if (StringUtil.isBlank((String)filename) || filename.indexOf(95) < 0) {
            return null;
        }
        void v0 = var1_1;
        return v0.substring(v0.indexOf(95) + 1);
    }

    protected boolean isSessionFilename(String filename) {
        String[] stringArray;
        if (StringUtil.isBlank((String)filename)) {
            return false;
        }
        return (stringArray = stringArray.split("_")).length >= 4;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isOurContextSessionFilename(String filename) {
        void var1_1;
        if (StringUtil.isBlank((String)filename)) {
            return false;
        }
        String[] stringArray = filename.split("_");
        if (stringArray.length < 4) {
            return false;
        }
        String context = this.getContextFromFilename(filename);
        if (context == null) {
            return false;
        }
        return this._contextString.equals(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected SessionData load(InputStream is, String expectedId) throws Exception {
        try {
            void var1_1;
            DataInputStream di = new DataInputStream(is);
            String id = di.readUTF();
            String contextPath = di.readUTF();
            String vhost = di.readUTF();
            String lastNode = di.readUTF();
            long created = di.readLong();
            long accessed = di.readLong();
            long lastAccessed = di.readLong();
            long cookieSet = di.readLong();
            long expiry = di.readLong();
            long maxIdle = di.readLong();
            SessionData data = this.newSessionData(id, created, accessed, lastAccessed, maxIdle);
            data.setContextPath(contextPath);
            data.setVhost(vhost);
            data.setLastNode(lastNode);
            data.setCookieSet(cookieSet);
            data.setExpiry(expiry);
            data.setMaxInactiveMs(maxIdle);
            ClassLoadingObjectInputStream ois = new ClassLoadingObjectInputStream(is);
            SessionData.deserializeAttributes(data, (ObjectInputStream)var1_1);
            return data;
        }
        catch (Exception e) {
            void var3_5;
            void var2_2;
            throw new UnreadableSessionDataException((String)var2_2, this._context, (Throwable)var3_5);
        }
    }

    @Override
    public String toString() {
        return String.format("%s[dir=%s,deleteUnrestorableFiles=%b]", super.toString(), this._storeDir, this._deleteUnrestorableFiles);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$initializeStore$6(long now, MultiException me, Path p) {
        block6: {
            String existing;
            String sessionIdWithContext;
            this.sweepFile(now, p);
            String filename = p.getFileName().toString();
            String context = this.getContextFromFilename(filename);
            if (Files.exists(p, new LinkOption[0]) && this._contextString.equals(context) && (sessionIdWithContext = this.getIdWithContextFromFilename(filename)) != null && (existing = this._sessionFileMap.putIfAbsent(sessionIdWithContext, filename)) != null) {
                try {
                    void var4_4;
                    long existingExpiry = this.getExpiryFromFilename(existing);
                    long l = this.getExpiryFromFilename(filename);
                    if (l > existingExpiry) {
                        void var2_5;
                        Path existingPath = this._storeDir.toPath().resolve(existing);
                        this._sessionFileMap.put((String)var2_5, filename);
                        Files.delete(existingPath);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Replaced {} with {}", new Object[]{existing, filename});
                        }
                        break block6;
                    }
                    Files.delete((Path)var4_4);
                    if (LOG.isDebugEnabled()) {
                        void var1_2;
                        LOG.debug("Deleted expired session file {}", new Object[]{var1_2});
                    }
                    return;
                }
                catch (IOException e) {
                    void var3_3;
                    var3_3.add((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$sweepDisk$3(long now, Path p) {
        void var3_2;
        void var1_1;
        this.sweepFile((long)var1_1, (Path)var3_2);
    }
}

