/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.security.SecureRandom;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.session.HouseKeeper;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject
public class DefaultSessionIdManager
extends ContainerLifeCycle
implements SessionIdManager {
    private static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.server.session");
    public static final String __NEW_SESSION_ID = "org.eclipse.jetty.server.newSessionId";
    protected static final AtomicLong COUNTER = new AtomicLong();
    protected Random _random;
    protected boolean _weakRandom;
    protected String _workerName;
    protected String _workerAttr;
    protected long _reseed = 100000L;
    protected Server _server;
    protected HouseKeeper _houseKeeper;
    protected boolean _ownHouseKeeper;

    /*
     * WARNING - void declaration
     */
    public DefaultSessionIdManager(Server server) {
        void var1_1;
        this._server = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultSessionIdManager(Server server, Random random) {
        this((Server)var1_1);
        void var2_2;
        void var1_1;
        this._random = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void setServer(Server server) {
        void var1_1;
        this._server = var1_1;
    }

    public Server getServer() {
        return this._server;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setSessionHouseKeeper(HouseKeeper houseKeeper) {
        void var1_1;
        DefaultSessionIdManager defaultSessionIdManager = this;
        defaultSessionIdManager.updateBean((Object)defaultSessionIdManager._houseKeeper, (Object)houseKeeper);
        this._houseKeeper = var1_1;
        this._houseKeeper.setSessionIdManager(this);
    }

    @Override
    public HouseKeeper getSessionHouseKeeper() {
        return this._houseKeeper;
    }

    @Override
    @ManagedAttribute(value="unique name for this node", readonly=true)
    public String getWorkerName() {
        return this._workerName;
    }

    /*
     * WARNING - void declaration
     */
    public void setWorkerName(String workerName) {
        void var1_1;
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        if (workerName == null) {
            this._workerName = "";
            return;
        }
        if (workerName.contains(".")) {
            throw new IllegalArgumentException("Name cannot contain '.'");
        }
        this._workerName = var1_1;
    }

    public Random getRandom() {
        return this._random;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setRandom(Random random) {
        void var1_1;
        this._random = var1_1;
        this._weakRandom = false;
    }

    public long getReseed() {
        return this._reseed;
    }

    /*
     * WARNING - void declaration
     */
    public void setReseed(long reseed) {
        void var1_1;
        this._reseed = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String newSessionId(HttpServletRequest request, long created) {
        void var2_3;
        void var1_1;
        String clusterId;
        if (request == null) {
            return this.newSessionId(created);
        }
        String requestedId = request.getRequestedSessionId();
        if (requestedId != null && this.isIdInUse(clusterId = this.getId(requestedId))) {
            return clusterId;
        }
        String newId = (String)request.getAttribute(__NEW_SESSION_ID);
        if (newId != null && this.isIdInUse(newId)) {
            return newId;
        }
        String id = this.newSessionId(request.hashCode());
        var1_1.setAttribute(__NEW_SESSION_ID, (Object)id);
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public String newSessionId(long seedTerm) {
        void var3_3;
        String id = null;
        Random random = this._random;
        synchronized (random) {
            while (id == null || id.length() == 0) {
                long r1;
                long r0 = this._weakRandom ? (long)this.hashCode() ^ Runtime.getRuntime().freeMemory() ^ (long)this._random.nextInt() ^ seedTerm << 32 : this._random.nextLong();
                if (r0 < 0L) {
                    r0 = -r0;
                }
                if (this._reseed > 0L && r0 % this._reseed == 1L) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Reseeding {}", new Object[]{this});
                    }
                    if (this._random instanceof SecureRandom) {
                        SecureRandom secure = (SecureRandom)this._random;
                        secure.setSeed(secure.generateSeed(8));
                    } else {
                        this._random.setSeed(this._random.nextLong() ^ System.currentTimeMillis() ^ seedTerm ^ Runtime.getRuntime().freeMemory());
                    }
                }
                if ((r1 = this._weakRandom ? (long)this.hashCode() ^ Runtime.getRuntime().freeMemory() ^ (long)this._random.nextInt() ^ seedTerm << 32 : this._random.nextLong()) < 0L) {
                    r1 = -r1;
                }
                id = Long.toString(r0, 36) + Long.toString(r1, 36);
                if (!StringUtil.isBlank((String)this._workerName)) {
                    id = this._workerName + id;
                }
                id = id + COUNTER.getAndIncrement();
            }
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isIdInUse(String id) {
        if (id == null) {
            return false;
        }
        boolean inUse = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking {} is in use by at least one context", new Object[]{id});
        }
        try {
            void var2_2;
            for (SessionHandler manager : this.getSessionHandlers()) {
                if (!manager.isIdInUse(id)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Context {} reports id in use", new Object[]{manager});
                }
                inUse = true;
                break;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checked {}, in use: {}", new Object[]{id, inUse});
            }
            return (boolean)var2_2;
        }
        catch (Exception e) {
            void var3_4;
            void var1_1;
            LOG.warn("Problem checking if id {} is in use", new Object[]{var1_1});
            LOG.warn((Throwable)var3_4);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void doStart() throws Exception {
        if (this._server == null) {
            throw new IllegalStateException("No Server for SessionIdManager");
        }
        this.initRandom();
        if (this._workerName == null) {
            void var1_1;
            String inst = System.getenv("JETTY_WORKER_INSTANCE");
            this._workerName = "node" + (String)(inst == null ? "0" : var1_1);
        }
        LOG.info("DefaultSessionIdManager workerName={}", new Object[]{this._workerName});
        String string = this._workerAttr = this._workerName != null && this._workerName.startsWith("$") ? this._workerName.substring(1) : null;
        if (this._houseKeeper == null) {
            LOG.info("No SessionScavenger set, using defaults", new Object[0]);
            this._ownHouseKeeper = true;
            this._houseKeeper = new HouseKeeper();
            this._houseKeeper.setSessionIdManager(this);
            DefaultSessionIdManager defaultSessionIdManager = this;
            defaultSessionIdManager.addBean((Object)defaultSessionIdManager._houseKeeper, true);
        }
        this._houseKeeper.start();
    }

    protected void doStop() throws Exception {
        this._houseKeeper.stop();
        if (this._ownHouseKeeper) {
            this._houseKeeper = null;
        }
        this._random = null;
    }

    /*
     * WARNING - void declaration
     */
    public void initRandom() {
        if (this._random == null) {
            try {
                this._random = new SecureRandom();
                return;
            }
            catch (Exception e) {
                void var1_1;
                LOG.warn("Could not generate SecureRandom for session-id randomness", (Throwable)var1_1);
                this._random = new Random();
                this._weakRandom = true;
                return;
            }
        }
        this._random.setSeed(this._random.nextLong() ^ System.currentTimeMillis() ^ (long)this.hashCode() ^ Runtime.getRuntime().freeMemory());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getExtendedId(String clusterId, HttpServletRequest request) {
        void var1_1;
        if (!StringUtil.isBlank((String)this._workerName)) {
            if (this._workerAttr == null) {
                return clusterId + '.' + this._workerName;
            }
            String worker = (String)request.getAttribute(this._workerAttr);
            if (worker != null) {
                void var2_2;
                return clusterId + '.' + (String)var2_2;
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getId(String extendedId) {
        void var1_1;
        int dot = extendedId.lastIndexOf(46);
        if (dot > 0) {
            void var2_2;
            return extendedId.substring(0, (int)var2_2);
        }
        return var1_1;
    }

    @Override
    public void expireAll(String id) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Expiring {}", new Object[]{id});
        }
        for (SessionHandler sessionHandler : this.getSessionHandlers()) {
            sessionHandler.invalidate(id);
        }
    }

    @Override
    public void invalidateAll(String id) {
        for (SessionHandler sessionHandler : this.getSessionHandlers()) {
            sessionHandler.invalidate(id);
        }
    }

    @Override
    public String renewSessionId(String oldClusterId, String oldNodeId, HttpServletRequest request) {
        String newClusterId = this.newSessionId(request.hashCode());
        for (SessionHandler sessionHandler : this.getSessionHandlers()) {
            sessionHandler.renewSessionId(oldClusterId, oldNodeId, newClusterId, this.getExtendedId(newClusterId, request));
        }
        return newClusterId;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<SessionHandler> getSessionHandlers() {
        void var1_1;
        HashSet<SessionHandler> handlers = new HashSet<SessionHandler>();
        Handler[] tmp = this._server.getChildHandlersByClass(SessionHandler.class);
        if (tmp != null) {
            void var2_2;
            for (void h : var2_2) {
                if (h.isStopped() || h.isFailed()) continue;
                handlers.add((SessionHandler)h);
            }
        }
        return var1_1;
    }

    public String toString() {
        return String.format("%s[worker=%s]", super.toString(), this._workerName);
    }
}

