/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.session.AbstractSessionCache;
import org.eclipse.jetty.server.session.Session;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.statistic.CounterStatistic;

@ManagedObject
public class DefaultSessionCache
extends AbstractSessionCache {
    private static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.server.session");
    protected ConcurrentHashMap<String, Session> _sessions = new ConcurrentHashMap();
    private final CounterStatistic _stats = new CounterStatistic();

    /*
     * WARNING - void declaration
     */
    public DefaultSessionCache(SessionHandler manager) {
        super((SessionHandler)var1_1);
        void var1_1;
    }

    @ManagedAttribute(value="current sessions in cache", readonly=true)
    public long getSessionsCurrent() {
        return this._stats.getCurrent();
    }

    @ManagedAttribute(value="max sessions in cache", readonly=true)
    public long getSessionsMax() {
        return this._stats.getMax();
    }

    @ManagedAttribute(value="total sessions in cache", readonly=true)
    public long getSessionsTotal() {
        return this._stats.getTotal();
    }

    @ManagedOperation(value="reset statistics", impact="ACTION")
    public void resetStats() {
        this._stats.reset();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Session doGet(String id) {
        void var1_1;
        if (id == null) {
            return null;
        }
        return this._sessions.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Session doPutIfAbsent(String id, Session session) {
        void var1_1;
        void var2_2;
        Session s = this._sessions.putIfAbsent(id, (Session)var2_2);
        if (s == null) {
            this._stats.increment();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Session doComputeIfAbsent(String id, Function<String, Session> mappingFunction) {
        void var2_2;
        void var1_1;
        return this._sessions.computeIfAbsent((String)var1_1, arg_0 -> this.lambda$doComputeIfAbsent$0((Function)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Session doDelete(String id) {
        void var1_1;
        Session s = this._sessions.remove(id);
        if (s != null) {
            this._stats.decrement();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void shutdown() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Shutdown sessions, invalidating = {}", new Object[]{this.isInvalidateOnShutdown()});
        }
        int loop = 100;
        while (!this._sessions.isEmpty() && loop-- > 0) {
            for (Session session : this._sessions.values()) {
                void var3_3;
                if (this.isInvalidateOnShutdown()) {
                    try {
                        session.invalidate();
                    }
                    catch (Exception e) {
                        LOG.ignore((Throwable)e);
                    }
                    continue;
                }
                if (this._sessionDataStore.isPassivating()) {
                    session.willPassivate();
                }
                try {
                    this._sessionDataStore.store(session.getId(), session.getSessionData());
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
                ((AbstractSessionCache)this).doDelete(session.getId());
                var3_3.setResident(false);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Session newSession(HttpServletRequest request, SessionData data) {
        void var2_2;
        void var1_1;
        return new Session(this.getSessionHandler(), (HttpServletRequest)var1_1, (SessionData)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Session newSession(SessionData data) {
        void var1_1;
        return new Session(this.getSessionHandler(), (SessionData)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean doReplace(String id, Session oldValue, Session newValue) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this._sessions.replace((String)var1_1, (Session)var2_2, (Session)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Session lambda$doComputeIfAbsent$0(Function mappingFunction, String k) {
        void var1_1;
        void var2_2;
        Session s = (Session)mappingFunction.apply(var2_2);
        if (s != null) {
            this._stats.increment();
        }
        return var1_1;
    }
}

