/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Locale;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class DatabaseAdaptor {
    static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.server.session");
    String _dbName;
    boolean _isLower;
    boolean _isUpper;
    protected String _blobType;
    protected String _longType;
    protected String _stringType;
    private String _driverClassName;
    private String _connectionUrl;
    private Driver _driver;
    private DataSource _datasource;
    private String _jndiName;

    /*
     * WARNING - void declaration
     */
    public void adaptTo(DatabaseMetaData dbMeta) throws SQLException {
        void var1_1;
        this._dbName = dbMeta.getDatabaseProductName().toLowerCase(Locale.ENGLISH);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using database {}", new Object[]{this._dbName});
        }
        this._isLower = dbMeta.storesLowerCaseIdentifiers();
        this._isUpper = var1_1.storesUpperCaseIdentifiers();
    }

    /*
     * WARNING - void declaration
     */
    public void setBlobType(String blobType) {
        void var1_1;
        this._blobType = var1_1;
    }

    public String getBlobType() {
        if (this._blobType != null) {
            return this._blobType;
        }
        if (this._dbName.startsWith("postgres")) {
            return "bytea";
        }
        return "blob";
    }

    /*
     * WARNING - void declaration
     */
    public void setLongType(String longType) {
        void var1_1;
        this._longType = var1_1;
    }

    public String getLongType() {
        if (this._longType != null) {
            return this._longType;
        }
        if (this._dbName == null) {
            throw new IllegalStateException("DbAdaptor missing metadata");
        }
        if (this._dbName.startsWith("oracle")) {
            return "number(20)";
        }
        return "bigint";
    }

    /*
     * WARNING - void declaration
     */
    public void setStringType(String stringType) {
        void var1_1;
        this._stringType = var1_1;
    }

    public String getStringType() {
        if (this._stringType != null) {
            return this._stringType;
        }
        return "varchar";
    }

    /*
     * WARNING - void declaration
     */
    public String convertIdentifier(String identifier) {
        void var1_1;
        if (identifier == null) {
            return null;
        }
        if (this._dbName == null) {
            throw new IllegalStateException("DbAdaptor missing metadata");
        }
        if (this._isLower) {
            return identifier.toLowerCase(Locale.ENGLISH);
        }
        if (this._isUpper) {
            return identifier.toUpperCase(Locale.ENGLISH);
        }
        return var1_1;
    }

    public String getDBName() {
        return this._dbName;
    }

    /*
     * WARNING - void declaration
     */
    public InputStream getBlobInputStream(ResultSet result, String columnName) throws SQLException {
        if (this._dbName == null) {
            throw new IllegalStateException("DbAdaptor missing metadata");
        }
        if (this._dbName.startsWith("postgres")) {
            void var3_3;
            byte[] bytes = result.getBytes(columnName);
            return new ByteArrayInputStream((byte[])var3_3);
        }
        try {
            Blob blob = result.getBlob(columnName);
            return blob.getBinaryStream();
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            void var1_1;
            void var2_2;
            byte[] bytes = result.getBytes((String)var2_2);
            return new ByteArrayInputStream((byte[])var1_1);
        }
    }

    public boolean isEmptyStringNull() {
        if (this._dbName == null) {
            throw new IllegalStateException("DbAdaptor missing metadata");
        }
        return this._dbName.startsWith("oracle");
    }

    public boolean isRowIdReserved() {
        if (this._dbName == null) {
            throw new IllegalStateException("DbAdaptor missing metadata");
        }
        return this._dbName != null && this._dbName.startsWith("oracle");
    }

    /*
     * WARNING - void declaration
     */
    public void setDriverInfo(String driverClassName, String connectionUrl) {
        void var2_2;
        void var1_1;
        this._driverClassName = var1_1;
        this._connectionUrl = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void setDriverInfo(Driver driverClass, String connectionUrl) {
        void var2_2;
        void var1_1;
        this._driver = var1_1;
        this._connectionUrl = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void setDatasource(DataSource ds) {
        void var1_1;
        this._datasource = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setDatasourceName(String jndi) {
        void var1_1;
        this._jndiName = var1_1;
    }

    public String getDatasourceName() {
        return this._jndiName;
    }

    public DataSource getDatasource() {
        return this._datasource;
    }

    public String getDriverClassName() {
        return this._driverClassName;
    }

    public Driver getDriver() {
        return this._driver;
    }

    public String getConnectionUrl() {
        return this._connectionUrl;
    }

    /*
     * WARNING - void declaration
     */
    public void initialize() throws Exception {
        if (this._datasource != null) {
            return;
        }
        if (this._jndiName != null) {
            InitialContext ic = new InitialContext();
            this._datasource = (DataSource)ic.lookup(this._jndiName);
            return;
        }
        if (this._driver != null && this._connectionUrl != null) {
            DriverManager.registerDriver(this._driver);
            return;
        }
        if (this._driverClassName != null && this._connectionUrl != null) {
            Class.forName(this._driverClassName);
            return;
        }
        try {
            void var1_2;
            InitialContext ic = new InitialContext();
            this._datasource = (DataSource)var1_2.lookup("jdbc/sessions");
            return;
        }
        catch (NamingException namingException) {
            throw new IllegalStateException("No database configured for sessions");
        }
    }

    protected Connection getConnection() throws SQLException {
        if (this._datasource != null) {
            return this._datasource.getConnection();
        }
        return DriverManager.getConnection(this._connectionUrl);
    }

    public String toString() {
        return String.format("%s[jndi=%s,driver=%s]", super.toString(), this._jndiName, this._driverClassName);
    }
}

