/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.util.Set;
import org.eclipse.jetty.server.session.SessionContext;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.server.session.SessionDataMap;
import org.eclipse.jetty.server.session.SessionDataStore;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class CachingSessionDataStore
extends ContainerLifeCycle
implements SessionDataStore {
    private static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.server.session");
    protected SessionDataStore _store;
    protected SessionDataMap _cache;

    /*
     * WARNING - void declaration
     */
    public CachingSessionDataStore(SessionDataMap cache, SessionDataStore store) {
        void var2_2;
        void var1_1;
        this._cache = var1_1;
        CachingSessionDataStore cachingSessionDataStore = this;
        cachingSessionDataStore.addBean(cachingSessionDataStore._cache, true);
        this._store = var2_2;
        CachingSessionDataStore cachingSessionDataStore2 = this;
        cachingSessionDataStore2.addBean(cachingSessionDataStore2._store, true);
    }

    public SessionDataStore getSessionStore() {
        return this._store;
    }

    public SessionDataMap getSessionDataMap() {
        return this._cache;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SessionData load(String id) throws Exception {
        void var1_1;
        SessionData sessionData;
        SessionData d = null;
        try {
            d = this._cache.load(id);
        }
        catch (Exception e) {
            void var3_3;
            LOG.warn((Throwable)var3_3);
        }
        if (d != null) {
            return sessionData;
        }
        sessionData = this._store.load((String)var1_1);
        return sessionData;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean delete(String id) throws Exception {
        void var2_2;
        void var1_1;
        boolean deleted = this._store.delete(id);
        this._cache.delete((String)var1_1);
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<String> getExpired(Set<String> candidates) {
        void var1_1;
        return this._store.getExpired((Set<String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void store(String id, SessionData data) throws Exception {
        void var3_3;
        long lastSaved = data.getLastSaved();
        this._store.store(id, data);
        if (data.getLastSaved() != var3_3) {
            void var2_2;
            void var1_1;
            this._cache.store((String)var1_1, (SessionData)var2_2);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    @Override
    public boolean isPassivating() {
        return this._store.isPassivating();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean exists(String id) throws Exception {
        void var1_1;
        try {
            SessionData sessionData = this._cache.load(id);
            if (sessionData != null) {
                return true;
            }
        }
        catch (Exception e) {
            void var2_3;
            LOG.warn((Throwable)var2_3);
        }
        return this._store.exists((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize(SessionContext context) throws Exception {
        void var1_1;
        this._store.initialize(context);
        this._cache.initialize((SessionContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SessionData newSessionData(String id, long created, long accessed, long lastAccessed, long maxInactiveMs) {
        void var2_3;
        void var1_2;
        return this._store.newSessionData((String)var1_2, (long)var2_3, accessed, lastAccessed, maxInactiveMs);
    }
}

