/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.server.session.SessionContext;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.server.session.SessionDataStore;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject
public abstract class AbstractSessionDataStore
extends ContainerLifeCycle
implements SessionDataStore {
    static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.server.session");
    protected SessionContext _context;
    protected int _gracePeriodSec = 3600;
    protected long _lastExpiryCheckTime = 0L;
    protected int _savePeriodSec = 0;

    public abstract void doStore(String var1, SessionData var2, long var3) throws Exception;

    public abstract SessionData doLoad(String var1) throws Exception;

    public abstract Set<String> doGetExpired(Set<String> var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize(SessionContext context) throws Exception {
        void var1_1;
        if (this.isStarted()) {
            throw new IllegalStateException("Context set after SessionDataStore started");
        }
        this._context = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SessionData load(String id) throws Exception {
        void var2_2;
        void var1_1;
        if (!this.isStarted()) {
            throw new IllegalStateException("Not started");
        }
        AtomicReference reference = new AtomicReference();
        AtomicReference exception = new AtomicReference();
        Runnable r = () -> {
            try {
                void var2_3;
                reference.set(this.doLoad((String)var2_3));
                return;
            }
            catch (Exception e) {
                void var1_2;
                void var3_4;
                var3_4.set(var1_2);
                return;
            }
        };
        this._context.run((Runnable)var1_1);
        if (exception.get() != null) {
            void var3_3;
            throw (Exception)var3_3.get();
        }
        return (SessionData)var2_2.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void store(String id, SessionData data) throws Exception {
        void var1_1;
        void var2_2;
        if (!this.isStarted()) {
            throw new IllegalStateException("Not started");
        }
        if (data == null) {
            return;
        }
        AtomicReference exception = new AtomicReference();
        Runnable r = new Runnable(this, (SessionData)var2_2, id, exception){
            final /* synthetic */ SessionData val$data;
            final /* synthetic */ String val$id;
            final /* synthetic */ AtomicReference val$exception;
            final /* synthetic */ AbstractSessionDataStore this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$data = sessionData;
                this.val$id = string;
                this.val$exception = atomicReference;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void run() {
                long savePeriodMs;
                long lastSave = this.val$data.getLastSaved();
                long l = savePeriodMs = this.this$0._savePeriodSec <= 0 ? 0L : TimeUnit.SECONDS.toMillis(this.this$0._savePeriodSec);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Store: id={}, mdirty={}, dirty={}, lsave={}, period={}, elapsed={}", new Object[]{this.val$id, this.val$data.isMetaDataDirty(), this.val$data.isDirty(), this.val$data.getLastSaved(), savePeriodMs, System.currentTimeMillis() - lastSave});
                }
                if (this.val$data.isDirty() || lastSave <= 0L || this.val$data.isMetaDataDirty() && System.currentTimeMillis() - lastSave >= savePeriodMs) {
                    this.val$data.setLastSaved(System.currentTimeMillis());
                    try {
                        this.this$0.doStore(this.val$id, this.val$data, lastSave);
                        this.val$data.clean();
                        return;
                    }
                    catch (Exception e) {
                        void var3_3;
                        void var1_1;
                        this.val$data.setLastSaved((long)var1_1);
                        this.val$exception.set(var3_3);
                    }
                }
            }
        };
        this._context.run((Runnable)var1_1);
        if (exception.get() != null) {
            void var3_3;
            throw (Exception)var3_3.get();
        }
    }

    @Override
    public Set<String> getExpired(Set<String> candidates) {
        if (!this.isStarted()) {
            throw new IllegalStateException("Not started");
        }
        try {
            Set<String> set;
            set = this.doGetExpired(set);
            return set;
        }
        finally {
            this._lastExpiryCheckTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SessionData newSessionData(String id, long created, long accessed, long lastAccessed, long maxInactiveMs) {
        void var2_3;
        void var1_2;
        return new SessionData((String)var1_2, this._context.getCanonicalContextPath(), this._context.getVhost(), (long)var2_3, accessed, lastAccessed, maxInactiveMs);
    }

    protected void checkStarted() throws IllegalStateException {
        if (this.isStarted()) {
            throw new IllegalStateException("Already started");
        }
    }

    protected void doStart() throws Exception {
        if (this._context == null) {
            throw new IllegalStateException("No SessionContext");
        }
        super.doStart();
    }

    @ManagedAttribute(value="interval in secs to prevent too eager session scavenging", readonly=true)
    public int getGracePeriodSec() {
        return this._gracePeriodSec;
    }

    /*
     * WARNING - void declaration
     */
    public void setGracePeriodSec(int sec) {
        void var1_1;
        this._gracePeriodSec = var1_1;
    }

    @ManagedAttribute(value="min secs between saves", readonly=true)
    public int getSavePeriodSec() {
        return this._savePeriodSec;
    }

    /*
     * WARNING - void declaration
     */
    public void setSavePeriodSec(int savePeriodSec) {
        void var1_1;
        this._savePeriodSec = var1_1;
    }

    public String toString() {
        return String.format("%s@%x[passivating=%b,graceSec=%d]", this.getClass().getName(), this.hashCode(), this.isPassivating(), this.getGracePeriodSec());
    }
}

