/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.session.Session;
import org.eclipse.jetty.server.session.SessionCache;
import org.eclipse.jetty.server.session.SessionContext;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.server.session.SessionDataStore;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.server.session.UnreadableSessionDataException;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Locker;

@ManagedObject
public abstract class AbstractSessionCache
extends ContainerLifeCycle
implements SessionCache {
    static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.server.session");
    protected SessionDataStore _sessionDataStore;
    protected final SessionHandler _handler;
    protected SessionContext _context;
    protected int _evictionPolicy = -1;
    protected boolean _saveOnCreate = false;
    protected boolean _saveOnInactiveEviction;
    protected boolean _removeUnloadableSessions;
    protected boolean _flushOnResponseCommit;
    protected boolean _invalidateOnShutdown;

    @Override
    public abstract Session newSession(SessionData var1);

    public abstract Session newSession(HttpServletRequest var1, SessionData var2);

    protected abstract Session doGet(String var1);

    protected abstract Session doPutIfAbsent(String var1, Session var2);

    protected abstract Session doComputeIfAbsent(String var1, Function<String, Session> var2);

    protected abstract boolean doReplace(String var1, Session var2, Session var3);

    public abstract Session doDelete(String var1);

    /*
     * WARNING - void declaration
     */
    public AbstractSessionCache(SessionHandler handler) {
        void var1_1;
        this._handler = var1_1;
    }

    @Override
    public SessionHandler getSessionHandler() {
        return this._handler;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize(SessionContext context) {
        void var1_1;
        if (this.isStarted()) {
            throw new IllegalStateException("Context set after session store started");
        }
        this._context = var1_1;
    }

    protected void doStart() throws Exception {
        if (this._sessionDataStore == null) {
            throw new IllegalStateException("No session data store configured");
        }
        if (this._handler == null) {
            throw new IllegalStateException("No session manager");
        }
        if (this._context == null) {
            throw new IllegalStateException("No ContextId");
        }
        this._sessionDataStore.initialize(this._context);
        super.doStart();
    }

    protected void doStop() throws Exception {
        this._sessionDataStore.stop();
        super.doStop();
    }

    @Override
    public SessionDataStore getSessionDataStore() {
        return this._sessionDataStore;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setSessionDataStore(SessionDataStore sessionStore) {
        void var1_1;
        AbstractSessionCache abstractSessionCache = this;
        abstractSessionCache.updateBean(abstractSessionCache._sessionDataStore, sessionStore);
        this._sessionDataStore = var1_1;
    }

    @Override
    @ManagedAttribute(value="session eviction policy", readonly=true)
    public int getEvictionPolicy() {
        return this._evictionPolicy;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setEvictionPolicy(int evictionTimeout) {
        void var1_1;
        this._evictionPolicy = var1_1;
    }

    @Override
    @ManagedAttribute(value="immediately save new sessions", readonly=true)
    public boolean isSaveOnCreate() {
        return this._saveOnCreate;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setSaveOnCreate(boolean saveOnCreate) {
        void var1_1;
        this._saveOnCreate = var1_1;
    }

    @Override
    @ManagedAttribute(value="delete unreadable stored sessions", readonly=true)
    public boolean isRemoveUnloadableSessions() {
        return this._removeUnloadableSessions;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setRemoveUnloadableSessions(boolean removeUnloadableSessions) {
        void var1_1;
        this._removeUnloadableSessions = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setFlushOnResponseCommit(boolean flushOnResponseCommit) {
        void var1_1;
        this._flushOnResponseCommit = var1_1;
    }

    @Override
    public boolean isFlushOnResponseCommit() {
        return this._flushOnResponseCommit;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Session get(String id) throws Exception {
        void var1_1;
        return this.getAndEnter((String)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    protected Session getAndEnter(String id, boolean enter) throws Exception {
        void var3_6;
        AtomicReference exception = new AtomicReference();
        Session session = this.doComputeIfAbsent(id, k -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Session {} not found locally in {}, attempting to load", new Object[]{id, this});
            }
            try {
                void var1_1;
                Session s2 = this.loadSession((String)k);
                if (s2 != null) {
                    Locker.Lock lock = s2.lock();
                    try {
                        s2.setResident(true);
                        if (lock == null) return s2;
                    }
                    catch (Throwable s2) {
                        if (lock == null) throw s2;
                        try {
                            var1_1.close();
                            throw s2;
                        }
                        catch (Throwable throwable) {
                            s2.addSuppressed(throwable);
                        }
                        throw s2;
                    }
                    lock.close();
                    return s2;
                }
                if (!LOG.isDebugEnabled()) return s2;
                LOG.debug("Session {} not loaded by store", new Object[]{var1_1});
                return s2;
            }
            catch (Exception e) {
                void var3_6;
                void var2_3;
                var2_3.set(var3_6);
                return null;
            }
        });
        Exception ex = (Exception)exception.get();
        if (ex != null) {
            throw ex;
        }
        if (session != null) {
            try (Locker.Lock lock = session.lock();){
                void var2_3;
                if (!session.isResident()) {
                    if (LOG.isDebugEnabled()) {
                        void var1_1;
                        LOG.debug("Non-resident session {} in cache", new Object[]{var1_1});
                    }
                    return null;
                }
                if (var2_3 != false) {
                    session.use();
                }
            }
        }
        return var3_6;
    }

    /*
     * WARNING - void declaration
     */
    private Session loadSession(String id) throws Exception {
        if (this._sessionDataStore == null) {
            return null;
        }
        try {
            Object data = this._sessionDataStore.load(id);
            if (data == null) {
                return null;
            }
            ((SessionData)data).setLastNode(this._context.getWorkerName());
            data = this.newSession((SessionData)data);
            return data;
        }
        catch (UnreadableSessionDataException e) {
            void var2_3;
            if (this.isRemoveUnloadableSessions()) {
                void var1_1;
                this._sessionDataStore.delete((String)var1_1);
            }
            throw var2_3;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void add(String id, Session session) throws Exception {
        if (id == null || session == null) {
            throw new IllegalArgumentException("Add key=" + id + " session=" + (session == null ? "null" : session.getId()));
        }
        Locker.Lock lock = session.lock();
        try {
            void var2_3;
            if (session.getSessionHandler() == null) {
                throw new IllegalStateException("Session " + id + " is not managed");
            }
            if (!session.isValid()) {
                throw new IllegalStateException("Session " + id + " is not valid");
            }
            if (this.doPutIfAbsent(id, session) != null) {
                void var1_1;
                throw new IllegalStateException("Session " + (String)var1_1 + " already in cache");
            }
            session.setResident(true);
            var2_3.use();
            if (lock == null) return;
        }
        catch (Throwable throwable) {
            if (lock == null) throw throwable;
            try {
                void var3_5;
                var3_5.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        lock.close();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void commit(Session session) throws Exception {
        if (session == null) {
            return;
        }
        Locker.Lock lock = session.lock();
        try {
            if (session.isValid() && session.getSessionData().isDirty() && this._flushOnResponseCommit) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Flush session {} on response commit", new Object[]{session});
                }
                if (!this._sessionDataStore.isPassivating()) {
                    this._sessionDataStore.store(session.getId(), session.getSessionData());
                } else {
                    void var1_1;
                    session.willPassivate();
                    this._sessionDataStore.store(session.getId(), session.getSessionData());
                    var1_1.didActivate();
                }
            }
            if (lock == null) return;
        }
        catch (Throwable throwable) {
            if (lock == null) throw throwable;
            try {
                void var2_3;
                var2_3.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        lock.close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public void put(String id, Session session) throws Exception {
        void var2_2;
        void var1_1;
        this.release((String)var1_1, (Session)var2_2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void release(String id, Session session) throws Exception {
        Locker.Lock lock;
        block21: {
            if (id == null || session == null) {
                throw new IllegalArgumentException("Put key=" + id + " session=" + (session == null ? "null" : session.getId()));
            }
            lock = session.lock();
            try {
                if (session.getSessionHandler() == null) {
                    throw new IllegalStateException("Session " + id + " is not managed");
                }
                if (!session.isInvalid()) break block21;
                if (lock == null) return;
            }
            catch (Throwable throwable) {
                if (lock == null) throw throwable;
                try {
                    void var3_5;
                    var3_5.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            lock.close();
            return;
        }
        session.complete();
        if (session.getRequests() <= 0L) {
            session.setIdChanged(false);
            if (!this._sessionDataStore.isPassivating()) {
                this._sessionDataStore.store(id, session.getSessionData());
                if (this.getEvictionPolicy() == 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Eviction on request exit id={}", new Object[]{id});
                    }
                    this.doDelete(session.getId());
                    session.setResident(false);
                } else {
                    session.setResident(true);
                    this.doPutIfAbsent(id, session);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Non passivating SessionDataStore, session in SessionCache only id={}", new Object[]{id});
                    }
                }
            } else {
                session.willPassivate();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Session passivating id={}", new Object[]{id});
                }
                this._sessionDataStore.store(id, session.getSessionData());
                if (this.getEvictionPolicy() == 0) {
                    this.doDelete(id);
                    session.setResident(false);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Evicted on request exit id={}", new Object[]{id});
                    }
                } else {
                    session.didActivate();
                    session.setResident(true);
                    this.doPutIfAbsent(id, session);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Session reactivated id={}", new Object[]{id});
                    }
                }
            }
        } else {
            void var2_3;
            void var1_1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Req count={} for id={}", new Object[]{session.getRequests(), id});
            }
            session.setResident(true);
            this.doPutIfAbsent((String)var1_1, (Session)var2_3);
        }
        if (lock == null) return;
        lock.close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean exists(String id) throws Exception {
        void var1_1;
        Session s = this.doGet(id);
        if (s != null) {
            boolean bl;
            block6: {
                Locker.Lock lock = s.lock();
                try {
                    void var2_3;
                    bl = var2_3.isValid();
                    if (lock == null) break block6;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            var1_1.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                lock.close();
            }
            return bl;
        }
        return this._sessionDataStore.exists((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(String id) throws Exception {
        void var1_1;
        return this.doGet((String)var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Session delete(String id) throws Exception {
        void var1_1;
        Session session = this.getAndEnter(id, false);
        if (this._sessionDataStore != null) {
            boolean dsdel = this._sessionDataStore.delete(id);
            if (LOG.isDebugEnabled()) {
                void var3_3;
                LOG.debug("Session {} deleted in session data store {}", new Object[]{id, (boolean)var3_3});
            }
        }
        if (session != null) {
            void var2_2;
            var2_2.setResident(false);
        }
        return this.doDelete((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<String> checkExpiration(Set<String> candidates) {
        void var1_1;
        if (!this.isStarted()) {
            return Collections.emptySet();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} checking expiration on {}", new Object[]{this, candidates});
        }
        Set<String> allCandidates = this._sessionDataStore.getExpired(candidates);
        HashSet<String> sessionsInUse = new HashSet<String>();
        if (allCandidates != null) {
            for (String c : allCandidates) {
                Session s = this.doGet(c);
                if (s == null || s.getRequests() <= 0L) continue;
                sessionsInUse.add(c);
            }
            try {
                allCandidates.removeAll(sessionsInUse);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                void var2_2;
                HashSet<String> tmp = new HashSet<String>(allCandidates);
                tmp.removeAll((Collection<?>)var2_2);
                allCandidates = tmp;
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void checkInactiveSession(Session session) {
        if (session == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking for idle {}", new Object[]{session.getId()});
        }
        Locker.Lock s = session.lock();
        try {
            if (this.getEvictionPolicy() > 0 && session.isIdleLongerThan(this.getEvictionPolicy()) && session.isValid() && session.isResident() && session.getRequests() <= 0L) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Evicting idle session {}", new Object[]{session.getId()});
                    }
                    if (this.isSaveOnInactiveEviction() && this._sessionDataStore != null) {
                        if (this._sessionDataStore.isPassivating()) {
                            session.willPassivate();
                        }
                        session.getSessionData().setDirty(true);
                        this._sessionDataStore.store(session.getId(), session.getSessionData());
                    }
                    this.doDelete(session.getId());
                    session.setResident(false);
                }
                catch (Exception e) {
                    void var3_4;
                    void var1_1;
                    LOG.warn("Passivation of idle session {} failed", new Object[]{var1_1.getId()});
                    LOG.warn((Throwable)var3_4);
                }
            }
            if (s == null) return;
        }
        catch (Throwable throwable) {
            if (s == null) throw throwable;
            try {
                void var2_3;
                var2_3.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        s.close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Session renewSessionId(String oldId, String newId, String oldExtendedId, String newExtendedId) throws Exception {
        void var1_1;
        void var2_2;
        if (StringUtil.isBlank((String)oldId)) {
            throw new IllegalArgumentException("Old session id is null");
        }
        if (StringUtil.isBlank((String)newId)) {
            throw new IllegalArgumentException("New session id is null");
        }
        Session session = this.getAndEnter(oldId, true);
        this.renewSessionId(session, (String)var2_2, newExtendedId);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void renewSessionId(Session session, String newId, String newExtendedId) throws Exception {
        if (session == null) {
            return;
        }
        try (Locker.Lock lock = session.lock();){
            void var3_4;
            String oldId = session.getId();
            session.checkValidForWrite();
            session.getSessionData().setId(newId);
            session.getSessionData().setLastSaved(0L);
            session.getSessionData().setDirty(true);
            session.setExtendedId((String)var3_4);
            session.setIdChanged(true);
            this.doPutIfAbsent(newId, session);
            this.doDelete(oldId);
            if (this._sessionDataStore != null) {
                void var1_1;
                this._sessionDataStore.delete(oldId);
                this._sessionDataStore.store(newId, var1_1.getSessionData());
            }
            if (LOG.isDebugEnabled()) {
                void var2_3;
                LOG.debug("Session id {} swapped for new id {}", new Object[]{oldId, var2_3});
            }
            if (lock == null) return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setSaveOnInactiveEviction(boolean saveOnEvict) {
        void var1_1;
        this._saveOnInactiveEviction = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setInvalidateOnShutdown(boolean invalidateOnShutdown) {
        void var1_1;
        this._invalidateOnShutdown = var1_1;
    }

    @Override
    public boolean isInvalidateOnShutdown() {
        return this._invalidateOnShutdown;
    }

    @Override
    @ManagedAttribute(value="save sessions before evicting from cache", readonly=true)
    public boolean isSaveOnInactiveEviction() {
        return this._saveOnInactiveEviction;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Session newSession(HttpServletRequest request, String id, long time, long maxInactiveMs) {
        void var1_1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating new session id=" + id, new Object[0]);
        }
        long l = time;
        Session session = this.newSession(request, this._sessionDataStore.newSessionData(id, l, l, time, maxInactiveMs));
        session.getSessionData().setLastNode(this._context.getWorkerName());
        try {
            if (this.isSaveOnCreate() && this._sessionDataStore != null) {
                this._sessionDataStore.store(id, session.getSessionData());
            }
        }
        catch (Exception e) {
            void var3_4;
            void var2_2;
            LOG.warn("Save of new session {} failed", new Object[]{var2_2});
            LOG.warn((Throwable)var3_4);
        }
        return var1_1;
    }

    public String toString() {
        return String.format("%s@%x[evict=%d,removeUnloadable=%b,saveOnCreate=%b,saveOnInactiveEvict=%b]", this.getClass().getName(), this.hashCode(), this._evictionPolicy, this._removeUnloadableSessions, this._saveOnCreate, this._saveOnInactiveEviction);
    }
}

